C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       PLYCK                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      PLYCK  (KOUNT,XX,YY,A,B,C,N,X1,Y1,IQUE,IER)                     *
C  ARGUMENTS:                                                          *
C      KOUNT   INTEGER  ??IOU*      -                                  *
C      XX      REAL     ??IOU*  (2) -                                  *
C      YY      REAL     ??IOU*  (2) -                                  *
C      A       REAL     ??IOU*  (2) -                                  *
C      B       REAL     ??IOU*  (2) -                                  *
C      C       REAL     ??IOU*  (2) -                                  *
C      N       INTEGER  ??IOU*      -                                  *
C      X1      REAL     ??IOU*      -                                  *
C      Y1      REAL     ??IOU*      -                                  *
C      IQUE    INTEGER  ??IOU*      -                                  *
C      IER     INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/12/07  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 92/12/07  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
cdeck plyck
c***********************************************************************
      subroutine  plyck(kount,xx,yy,a,b,c,n,x1,y1,ique,ier)
c     ******************************************************************
c     *note                                                            *
c     *  this routine can be used for only one polygon. if more than   *
c     *    one polygon is involved in the users program, an identical  *
c     *    routine with a different call name and different argument   *
c     *    names may be implemented for each polygon.                  *
c     ******************************************************************
      dimension xx(2),yy(2),a(2),b(2),c(2)
      save
      ier=0
      if (n.ge.3) go to 1000
      ier=1
      go to 9000
 1000 do 1200 j=1,n
          do 1100 k=1,n
              if (j.eq.k) go to 1100
              if (xx(j).ne.xx(k)) go to 1100
              if (yy(j).ne.yy(k)) go to 1100
              ier=2
              go to 9000
 1100     continue
 1200 continue
      if(kount)2000,2000,2300
 2000 do 2200 i=1,n
          l=i+1
          if (i.eq.n) l=1
          anum=yy(i)-yy(l)
          denom=xx(i)-xx(l)
          if(denom.ne.0) go to 2100
          a(i)=0.
          b(i)=1.0
          c(i)=-xx(i)
          go to 2200
 2100     a(i)=1.0
          b(i)=-anum/denom
          c(i)=-yy(i)-b(i)*xx(i)
 2200 continue
 2300 itrac =0
      do 7000 i=1,n
          l=i+1
          if(y1-yy(i).ne.0) go to 3000
          if(x1-xx(i).eq.0) go to 8000
 3000     if (i.eq.n) l=1
          if(y1-yy(l).ne.0) go to 3100
          if(x1-xx(l).eq.0) go to 8000
 3100     if(y1-yy(i).ge.0) go to 3200
          if(y1-yy(l).lt.0) go to 7000
 3200     if(a(i).ne.0) go to 3500
          if(x1+c(i).ne.0) go to 7000
          if(y1-yy(i))3300,8000,3400
 3300     if(y1-yy(l).ge.0) go to 8000
          go to 7000
 3400     if(y1-yy(l).le.0) go to 8000
          go to 7000
 3500     yint=-c(i)-b(i)*x1
          if(yint-y1)3900,3600,7000
 3600     if(x1-xx(i))3700,8000,3800
 3700     if(x1-xx(l).ge.0) go to 8000
          go to 7000
 3800     if(x1-xx(l).le.0) go to 8000
          go to 7000
 3900     if(x1-xx(i))4000,4200,4100
 4000     if(x1-xx(l))7000,4300,6000
 4100     if(x1-xx(l))6000,4300,7000
 4200     if(xx(i)-xx(l).ge.0) go to 6000
          go to 7000
 4300     if(xx(i)-xx(l).gt.0) go to 7000
 6000     itrac=itrac+1
 7000 continue
      itry=itrac/2
      itry=itrac-2*itry
      if(itry)8200,8200,8100
 8000 ique=1
      go to 9000
 8100 ique=2
      go to 9000
 8200 ique=0
 9000 return
      end
