C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine InterpHeader( nlive, ntrco, spline_IZ, spline_ZZ, Type,  
     :     num_mnemonics, HdrWrd, 
     :     ifmt_HdrWrd, l_HdrWrd, ln_HdrWrd, 
     :     ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :     Header_In, Header_Out, 
     :     Dist_In, Dist_Out, DistBuffer, Amp_In, Amp_Out )

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c declare variables passed from calling routine

      integer nlive, ntrco, num_mnemonics
      integer ifmt_DstSgn, l_DstSgn, ln_DstSgn 
      integer Header_In(ITRWRD,nlive), Header_Out(ITRWRD,ntrco)
      integer ifmt_HdrWrd(num_mnemonics), l_HdrWrd(num_mnemonics)
      integer ln_HdrWrd(num_mnemonics), spline_IZ(ntrco)

      real Dist_In(nlive), Dist_Out(ntrco), DistBuffer(nlive)
      real Amp_In(nlive), Amp_Out(ntrco), spline_ZZ(ntrco,4)

      character Type*6

c declare local variables

      integer i, j, k, ivalue, distance, spline_init

c initialize variables

      do i = 1, ITRWRD
         do j = 1, ntrco
            Header_Out(i,j) = 0
         enddo
      enddo

      spline_init = 1

      do i = 1, num_mnemonics

         call vclr ( Amp_In, 1, nlive )
         call vclr ( Amp_Out, 1, ntrco )

c load input header values for this mnemonic

         do j = 1, nlive

            DistBuffer(j) = Dist_In(j)

            if ( ifmt_HdrWrd(i) .eq. SAVE_FLOAT_DEF ) then

c read in floating point entry

               call saver2(Header_In(1,j),ifmt_HdrWrd(i),l_HdrWrd(i),
     :              ln_HdrWrd(i), Amp_In(j), TRACEHEADER)
                  
            elseif ( ( ifmt_HdrWrd(i) .eq. SAVE_SHORT_DEF ) .or. 
     :              ( ifmt_HdrWrd(i) .eq. SAVE_LONG_DEF ) ) then

c load integer entry [short or long]

               call saver2(Header_In(1,j),ifmt_HdrWrd(i),l_HdrWrd(i),
     :              ln_HdrWrd(i), ivalue, TRACEHEADER)

               Amp_In(j) = float(ivalue)
            endif
         enddo

c sort based on increasing distance

         call hsort2 ( nlive, DistBuffer, Amp_In )

c interpolate output values

         if ( Type .eq. 'linear' ) then

            call Linear(Amp_In, DistBuffer, Amp_Out, Dist_Out, nlive,
     :           ntrco)

         else

c cubic spline interpolation, spline_init is unity for first pass to build
c intermediate tables IZ and ZZ.  subsequent calls will use these tables so
c that spline_init is then set to zero to bypass table construction.
            
            call fcuint ( DistBuffer, Amp_In, nlive, Dist_Out, Amp_Out, 
     :           ntrco, spline_IZ, spline_ZZ, spline_init)
            spline_init = 0

         endif

c load output values to output Header array

         do k = 1, ntrco

            if ( ifmt_HdrWrd(i) .eq. SAVE_FLOAT_DEF ) then

c load out floating point entry

               call savew2(Header_Out(1,k), ifmt_HdrWrd(i), l_HdrWrd(i),
     :              ln_HdrWrd(i), Amp_Out(k), TRACEHEADER)

            elseif ( ( ifmt_HdrWrd(i) .eq. SAVE_SHORT_DEF ) .or. 
     :              ( ifmt_HdrWrd(i) .eq. SAVE_LONG_DEF) ) then

c load out integer entry [short or long]

               ivalue = nint( Amp_Out(k) )
               call savew2(Header_Out(1,k), ifmt_HdrWrd(i), l_HdrWrd(i),
     :              ln_HdrWrd(i), ivalue, TRACEHEADER)
            endif
         enddo
      enddo

c load output trace distances which have been precalculated in main

      do i = 1, ntrco
         distance = nint( Dist_Out(i) )
         call savew2 ( Header_Out(1,i), ifmt_DstSgn, l_DstSgn, 
     ;        ln_DstSgn, distance , TRACEHEADER)
      enddo

      return
      end
