C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Linear (Amp_In, Dist_In, Amp_Out, Dist_Out, ntrc_in,
     :     ntrco)

c declare variables passed from calling routine

      integer ntrc_in, ntrco

      real Amp_In(ntrc_in), Dist_In(ntrc_in)
      real Amp_Out(ntrco), Dist_Out(ntrco)

c declare local variables

      integer i, j

c simple linear interpolation scheme to test program

      do 10 i = 1, ntrco

         if ( Dist_Out(i) .le. Dist_In(1) ) then
            Amp_Out(i) = Amp_In(1)
         elseif ( Dist_Out(i) .ge. Dist_In(ntrc_in) ) then
            Amp_Out(i) = Amp_In(ntrc_in)
         else
            do j = 2, ntrc_in
               if ( Dist_Out(i) .eq. Dist_In(j) ) then
                  Amp_Out(i) = Amp_In(j)
                  goto 10
               elseif ( Dist_Out(i) .lt. Dist_In(j) ) then
                  Amp_Out(i) = Amp_In(j-1) + 
     :                 (Dist_Out(i) - Dist_In(j-1)) / 
     :                 (Dist_In(j) - Dist_In(j-1)) * 
     :                 (Amp_In(j) - Amp_In(j-1))
                  goto 10
               endif
            enddo
         endif
 10   continue
      return
      end
