C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c reads in common group records (windowed to include the first breaks)
c puts together several in one vertically oriented record and
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include  <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c-----
      integer     itr ( SZLNHD )
      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     nblock, jtr, nsampo, itwd, iwd, pad
 
c------
c  dynamic memory allocation for big arrays, eg whole records
      real        bigar1
      pointer     (wkadr1, bigar1(1))
c------
 
c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      integer     static
c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      real        tri ( SZLNHD )
      character   ntap * 256, otap * 256, name*4
      logical     verbos, query, heap1
      integer     argis
 
c-----
c    we acces the floating point data through an equivalence statement
c    that starts the reals at 1/2-word 129
c-----
c     equivalence ( itr(129), tri (1) )
      equivalence ( itr(  1), lhed(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'FARR'/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,ist,iend,pad,verbos)
 
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
 
c-----
c     read line header of inputa DSN (rtape reads data into vector "itr"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'FARR: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     save certain parameters
 
c     to get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
 
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif


      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
 
      itwd = iend - ist
      iwd  = itwd/nsi
      nblock = nsi * nsamp / (itwd + pad)
 
      if (nblock .lt. 2) then
         write(LERR,*)'Window time must be < 1/2 input trace length'
         write(LERR,*)'Check input GIs to estimate window around 1st'
         write(LERR,*)'breaks which will accomplish this'
         write(LERR,*)'Re-run with new cmd line args'
         stop
      endif
 
      ist  = ist/nsi
      iend = iend/nsi
      pad  = pad/nsi
      if (ist .lt. 1) ist = 1
      nsampo = (iwd + pad) * nblock
 
c------
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 4, LERR)
 
 
c---------------------------------------------------
c  malloc only space we're going to use
      heap1 = .true.
 
c--------------------------
c  note: these don't
c  have to be the same size
 
      item1 = ntrc * nsampo * SZSMPD
 
c  note also SZSMPD is the native
c  size of a float or int in bytes
c--------------------------
 
c--------
c  galloc - general allocation (machine independent since it uses C
c  malloc internally
c  inputs to galloc are pointer, number of bytes to allocate
c  outputs are error codes:
c     errcod = 1  (allocation succeeded)
c     errcod = 0  (allocation failed)
c--------
 
      call galloc (wkadr1, item1, errcd1, abort1)
 
      if (errcd1 .ne. 0.) heap1 = .false.
 
      if (.not. heap1) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------
 
 
c-----
c     modify line header to reflect actual number of traces/rec output
c-----
      xtr = nrec/nblock
      jtr = nint (xtr)
      call savew(itr, 'NumRec', jtr  , LINHED)
      call savew(itr, 'NumSmp',nsampo, LINHED)
 
c----------------------
c  number output bytes
      obytes = SZTRHD + nsampo * SZSMPD
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      call wrtape ( luout, itr, lbyout                 )
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  pad,nblock,ist,iend,ntap,otap)
      end if
 
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
 
         dt = real (nsi) * unitsc
 
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
 
c-----
c     process desired trace records
c-----
      do 1000 jj = 1, nrec, nblock
 
            call vclr (bigar1, 1, ntrc * nsampo)

            do  1005 ib = 1, nblock
 
                   do 1001  kk = 1, ntrc
 
                      nbytes = 0
                      call rtape( luin, itr, nbytes)
                      if(nbytes .eq. 0) then
                         write(LERR,*)'End of file on input:'
                         write(LERR,*)'  rec= ',jj,'  trace= ',kk
                         go to 1005
                      endif
                      call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
 
                      call saver2(itr,ifmt_StaCor,l_StaCor,
     1                            ln_StaCor, static , TRACEHEADER)
                      if (static .eq. 30000) then
                         call vclr (tri,1,nsamp)
                         itr(125) = 0
                      endif
 
c----------------------
c  pack data into array
                      istrc = (kk-1) * nsampo + (ib-1) * (iwd+pad)
                      call vmov (tri(ist),1, bigar1(istrc+1),1,iwd)
 
1001              continue
 
1005        continue
 
 
 
c---------------------
c  extract traces from
c  output array and
c  write output data
            do 1002 kk = 1, ntrc
 
                  istrc = (kk-1) * nsampo
                  call vmov (bigar1(istrc+1),1,tri,1,nsampo)
                  call wrtape (luout, itr, obytes)
 
 
 1002             continue
 
 
            if(verbos)write(LERR,*)'Sequential GI ',jj,' output'
 1000       continue
 
  999 continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )
 
            write(LERR,*)'end of farr, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'farr does dark and terrible things to seismic data:'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute farr by typing farr and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)        : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)        : output data file name'
        write(LER,*)
     :' -s[ist]      (default = none)    : start window time (ms)'
        write(LER,*)
     :' -e[iend]     (default = none)    : end window time (ms)'
        write(LER,*)
     :' -p[pad]      (default = 40ms)    : zero pad for window'
        write(LER,*) ' '
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   farr -N[ntap] -O[otap] -s[ist] -e[iend] -p[pad] -V'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,ist, iend, pad, verbos)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     ist   - I*4      starting time
c     iend  - I*4      ending time
c     pad   - I*4      zero pad time
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer     ist, iend, pad
      logical     verbos
      integer     argis
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program farr might be invoked in the following way:
 
c     farr  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into farr and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-s', ist ,    0  ,  0    )
            call argi4 ( '-e', iend ,   0  ,  0    )
            call argi4 ( '-p', pad  ,  40  , 40    )
            verbos =   (argis('-V') .gt. 0)
 
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  pad,nblock,ist,iend,ntap,otap)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     ist   - I*4      starting time
c     iend  - I*4      ending time
c   nblock  - I*4      number of recs stacked into 1
c     pad   - I*4      zero pad time
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec, ist, iend, nblock, pad
      character   ntap*(*), otap*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' start window (smps)=  ',ist
            write(LERR,*) ' end window (smps)  =  ',iend
            write(LERR,*) ' number vert recs   =  ',nblock
            write(LERR,*) ' Farr window 0-pad  =  ',pad
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
 
