/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* PROGRAM TO CALCULATE TRAVEL TIMES IN 2D MEDIA	*/
/*	AUTHORS: John E. Vidale and Robert W. Clayton */
/*     Revamped by RWC, 2-14-88  */
/*     Edges ordered in relative chronological order by JEV, 3-11-88 */
/*     Source not restricted to fall on a node, JEV, 10-28-88 */
/*     Bug near corners removed, JEV, 10-29-88 */
/*     Floating source parameter input bug fixed J. Louie 1-24-89 */
/*     Self-documentation added J. Louie 1-24-89 */
/*     Floating source initialization bug fixed J. Louie 2-1-89 */
/*     Pathological corner cases altered J. Louie 2-15-89 */
#include <stdio.h>
#include <localsys.h>
#include <math.h>
#include <fcntl.h>
#include <fidif.h>

          
/* ( velocity(ix,iz) = v[ ix + iz* *nx ] in 1D array ) */
/* ( slowness(ix,iz) = h * slowness averaged between ix, ix+1, iz, and iz+1) */
/* same order as velfile */

#define time(x,z)	timing[(x) + (z)* *nx]
#define slowness(x,z)	 vel[(x) + (z)* *nx]
#define velocity(x,z)	 vel[(x) + (z)* *nx]
void F_FIDIF(nx,nz,izbeg,izend,ixbeg,ixend,h,fs0,fzs,vel,timing)
int *nx,*nz ;
int *izbeg, *izend, *ixbeg, *ixend;
float *h, *fs0, *fzs;
float vel[],timing[];
{
	int zup, zdn, xlt, xrt, nbox, k, ix, iz;
/* 	register float *vel, *timing; */
	float smm, smp, spm, spp, guess, corn(), edge();
	int j, vfint;
        int s0, zs;

        s0 = (int)((*fs0) + 0.5);
	zs = (int)((*fzs) + 0.5);

                fprintf (stderr,"nx = %d nz = %d ", *nx, *nz);
                fprintf (stderr,"s0 = %d zs = %d ", s0, zs);
                fprintf (stderr,"fs0 = %f fzs = %f ", *fs0, *fzs);
	if(s0 >  *nx-1){
		fprintf(stderr,"Source off grid to the right, try again.\n");
		exit(-1);
	}
	if(zs > *izend-1){
		fprintf(stderr,"Source off bottom of grid, try again.\n");
		exit(-1);
	}

	for(j=0;j< *nx* *nz;j++) timing[j] = -1.0;

	/* CONVERT VELOCITIES TO SLOWNESSES */
	for(iz=0; iz< *nz-1; iz++)
		for(ix=0; ix< *nx-1; ix++)
			slowness(ix,iz) = *h*0.25*(1.0/velocity(ix,iz)
				+1.0/velocity(ix+1,iz) +1.0/velocity(ix,iz+1)
				+1.0/velocity(ix+1,iz+1));

	/* INITIALIZE SOURCE POINT */
	if(zs-1 <    0 || s0-1 <    0) smm = slowness(s0,zs);
	else smm = slowness(s0-1,zs-1);
	if(zs+1 >  *izend-1 || s0-1 <    0) smp = slowness(s0,zs-1);
	else smp = slowness(s0-1,zs);
	if(zs-1 <    0 || s0+1 >  *ixend-1) spm = slowness(s0-1,zs);
	else spm = slowness(s0,zs-1);
	if(zs+1 >  *izend-1 || s0+1 > *ixend-1) spp = slowness(s0-1,zs-1);
	else spp = slowness(s0,zs);
	time(s0,zs)=0.25*(smm +spm +smp +spp)
		*sqrt((*fs0- s0)*(*fs0- s0)+(*fzs- zs)*(*fzs- zs));
	if(zs-1 >=    0)
		time( s0,zs-1)=0.5*(smm + spm)
		*sqrt((*fs0- s0)*(*fs0- s0)+(*fzs-(zs-1))*(*fzs-(zs-1)));
	if(zs+1 <=  *izend-1)
		time( s0,zs+1)=0.5*(smp + spp)
		*sqrt((*fs0- s0)*(*fs0- s0)+(*fzs-(zs+1))*(*fzs-(zs+1)));
	if( s0-1 >=    0)
		time( s0-1,zs)=0.5*(smm + smp)
		*sqrt((*fs0-( s0-1))*(*fs0-( s0-1))+(*fzs-zs)*(*fzs-zs));
	if( s0+1 <= *ixend-1)
		time( s0+1,zs)=0.5*(spm + spp)
		*sqrt((*fs0-( s0+1))*(*fs0-( s0+1))+(*fzs- zs)*(*fzs- zs));
	if( s0-1 >=    0 && zs-1 >=    0)
		time( s0-1,zs-1) = smm * sqrt((*fs0-( s0-1))*(*fs0-( s0-1))
				+(*fzs-(zs-1))*(*fzs-(zs-1)));
	if( s0-1 >=    0 && zs+1 <=  *izend-1)
		time( s0-1,zs+1) = smp * sqrt((*fs0-( s0-1))*(*fs0-( s0-1))
				+(*fzs-(zs+1))*(*fzs-(zs+1)));
	if( s0+1 <= *ixend-1 && zs-1 >=    0)
		time( s0+1,zs-1) = spm * sqrt((*fs0-( s0+1))*(*fs0-( s0+1))
				+(*fzs-(zs-1))*(*fzs-(zs-1)));
	if( s0+1 <= *ixend-1 && zs+1 <=  *izend-1)
		time( s0+1,zs+1) = spp * sqrt((*fs0-( s0+1))*(*fs0-( s0+1))
				+(*fzs-(zs+1))*(*fzs-(zs+1)));

	/* SET POINTERS TO NEXT CONCENTRIC BOX, AND # OF BOXES */
	zup= (zs-2 >=   0  ? zs-2 : -1 );
	zdn= (zs+2 <=  *izend-1 ? zs+2 :  *izend );
	xlt= ( s0-2 >=    0 ?  s0-2 : -1 );
	xrt= ( s0+2 <= *ixend-1 ?  s0+2 : *ixend );
	nbox= 0;
	if( s0-2 > nbox) nbox=  s0-2;
	if(zs-2 > nbox) nbox= zs-2;
	if(*ixend- s0-2 > nbox) nbox= *ixend- s0-2;
	if( *izend- zs-2 > nbox) nbox=  *izend- zs-2;

	/* LOOP OVER BOXES */
	for(k=0; k<=nbox; k++)
	{
		if( k%100 == 0)
		fprintf(stderr,"box=%2d xlt=%3d xrt=%3d zup=%3d zdn=%3d\n",
			k, xlt, xrt, zup, zdn);
		/* TOP EDGE, Z=zup */
		if(zup >= 0)
		{
			register int x;
			/* CHECK WHETHER POINTS NEAR EDGES ARE FIRST */
			if(time(xlt+1,zup+1) <= time(xlt+2,zup+1))
				time(xlt+1,zup)= time(xlt+1,zup+1)+slowness(xlt+1,zup);
			if(time(xrt-1,zup+1) <= time(xrt-2,zup+1))
				time(xrt-1,zup)= time(xrt-1,zup+1)+slowness(xrt-1,zup-1);
			for(x=xlt+2; x <= xrt-2; x++) {

				/* FIND CASES WHERE EDGE IS NECESSARY */
				if(time(x,zup+1) <= time(x-1,zup+1) &&
					time(x,zup+1) <= time(x+1,zup+1)){
					time(x,zup)= edge(time(x,zup+1),time(x-1,zup+1),
			   			time(x+1,zup+1),0.5*(slowness(x-1,zup)+slowness(x,zup)));
				}
			/* SOLVE FOR WAVEFRONTS TRAVELING UP AND RIGHT */
				else if(time(x,zup+1) > time(x-1,zup+1)){
				time(x,zup)= corn(time(x-1,zup+1),time(x-1,zup),
				    time(x,zup+1),slowness(x-1,zup));
				}
			}
			/* SOLVE FOR WAVEFRONTS TRAVELING UP AND LEFT */
			for(x=xrt-2; x > xlt+1; x--)
				if(time(x,zup+1) > time(x+1,zup+1)){
					guess = corn(time(x+1,zup+1),time(x+1,zup),
				    		time(x,zup+1),slowness(x,zup));
					/* CHECK FIRST ARRIVAL FOR CASE WITH */
					/* ESTIMATES FROM BOTH SIDES */
					if(guess < time(x,zup) || time(x,zup) < 0.0){
						time(x,zup) = guess;
					}
				}
			/* SOLVE POINTS ON EDGES IF NOT DONE ALREADY */
			if(time(xrt-1,zup) < 0.0)
			time(xrt-1,zup)= corn(time(xrt-2,zup+1),time(xrt-2,zup),
			    time(xrt-1,zup+1),slowness(xrt-2,zup));
			if(time(xlt+1,zup) < 0.0)
			time(xlt+1,zup)= corn(time(xlt+2,zup+1),time(xlt+2,zup),
			    time(xlt+1,zup+1),slowness(xlt+1,zup));
		}
		/* BOTTOM EDGE, z=zdn */
		if(zdn <  *izend)
		{
			register int x;
			if(time(xlt+1,zdn-1) <= time(xlt+2,zdn-1))
				time(xlt+1,zdn)= time(xlt+1,zdn-1)+slowness(xlt+1,zdn-1);
			if(time(xrt-1,zdn-1) <= time(xrt-2,zdn-1))
				time(xrt-1,zdn)= time(xrt-1,zdn-1)+slowness(xrt-2,zdn-1);
			for(x=xlt+2; x <= xrt-2; x++) {
				if(time(x,zdn-1) <= time(x-1,zdn-1) &&
					time(x,zdn-1) <= time(x+1,zdn-1)){
					time(x,zdn)= edge(time(x,zdn-1),time(x-1,zdn-1),
			   			time(x+1,zdn-1),0.5*(slowness(x-1,zdn-1)+slowness(x,zdn-1)));
				}
				else if(time(x,zdn-1) > time(x-1,zdn-1)){
				time(x,zdn)= corn(time(x-1,zdn-1),time(x-1,zdn),
				    time(x,zdn-1),slowness(x-1,zdn-1));
				}
			}
			for(x=xrt-2; x > xlt+1; x--)
				if(time(x,zdn-1) > time(x+1,zdn-1)){
					guess = corn(time(x+1,zdn-1),time(x+1,zdn),
				    		time(x,zdn-1),slowness(x,zdn-1));
					if(guess < time(x,zdn) || time(x,zdn) < 0.0){
						time(x,zdn) = guess;
					}
				}
			if(time(xrt-1,zdn) < 0.0)
			time(xrt-1,zdn)= corn(time(xrt-2,zdn-1),time(xrt-2,zdn),
			    time(xrt-1,zdn-1),slowness(xrt-2,zdn-1));
			if(time(xlt+1,zdn) < 0.0)
			time(xlt+1,zdn)= corn(time(xlt+2,zdn-1),time(xlt+2,zdn),
			    time(xlt+1,zdn-1),slowness(xlt+1,zdn-1));
		}
		/* LEFT EDGE, x=xlt */
		if(xlt >= *ixbeg)
		{
			register int z;
			if(time(xlt+1,zup+1) <= time(xlt+1,zup+2))
				time(xlt,zup+1)= time(xlt+1,zup+1)+slowness(xlt,zup+1);
			if(time(xlt+1,zdn-1) <= time(xlt+1,zdn-2))
				time(xlt,zdn-1)= time(xlt+1,zdn-1)+slowness(xlt-1,zdn-1);
			for(z=zup+2; z <= zdn-2; z++) {
				if(time(xlt+1,z) <= time(xlt+1,z-1) &&
					time(xlt+1,z) <= time(xlt+1,z+1)){
					time(xlt,z)= edge(time(xlt+1,z),time(xlt+1,z-1),
			   			time(xlt+1,z+1),0.5*(slowness(xlt,z-1)+slowness(xlt,z)));
				}
				else if(time(xlt+1,z) > time(xlt+1,z-1)){
				time(xlt,z)= corn(time(xlt+1,z-1),time(xlt,z-1),
				    time(xlt+1,z),slowness(xlt,z-1));
				}
			}
			for(z=zdn-2; z > zup; z--)
				if(time(xlt+1,z) > time(xlt+1,z+1)){
					guess = corn(time(xlt+1,z+1),time(xlt,z+1),
				    		time(xlt+1,z),slowness(xlt,z));
					if(guess < time(xlt,z) || time(xlt,z) < 0.0){
						time(xlt,z) = guess;
					}
				}
			if(time(xlt,zdn-1) < 0.0)
			time(xlt,zdn-1)= corn(time(xlt+1,zdn-2),time(xlt,zdn-2),
			    time(xlt+1,zdn-1),slowness(xlt,zdn-2));
			if(time(xlt,zup+1) < 0.0)
			time(xlt,zup+1)= corn(time(xlt+1,zup+2),time(xlt,zup+2),
			    time(xlt+1,zup+1),slowness(xlt,zup+1));
		}
		/* RIGHT EDGE, x=xrt */
		if(xrt < *ixend)
		{
			register int z;
			if(time(xrt-1,zup+1) <= time(xrt-1,zup+2))
				time(xrt,zup+1)= time(xrt-1,zup+1)+slowness(xrt-1,zup+1);
			if(time(xrt-1,zdn-1) <= time(xrt-1,zdn-2))
				time(xrt,zdn-1)= time(xrt-1,zdn-1)+slowness(xrt-1,zdn-2);
			for(z=zup+2; z <= zdn-2; z++) {
				if(time(xrt-1,z) <= time(xrt-1,z-1) &&
					time(xrt-1,z) <= time(xrt-1,z+1)){
					time(xrt,z)= edge(time(xrt-1,z),time(xrt-1,z-1),
			   			time(xrt-1,z+1),0.5*(slowness(xrt-1,z-1)+slowness(xrt-1,z)));
				}
				else if(time(xrt-1,z) > time(xrt-1,z-1)){
				time(xrt,z)= corn(time(xrt-1,z-1),time(xrt,z-1),
				    time(xrt-1,z),slowness(xrt-1,z-1));
				}
			}
			for(z=zdn-2; z > zup+1; z--)
				if(time(xrt-1,z) > time(xrt-1,z+1)){
					guess = corn(time(xrt-1,z+1),time(xrt,z+1),
				    		time(xrt-1,z),slowness(xrt-1,z));
					if(guess < time(xrt,z) || time(xrt,z) < 0.0){
						time(xrt,z) = guess;
					}
				}
			if(time(xrt,zdn-1) < 0.0)
			time(xrt,zdn-1)= corn(time(xrt-1,zdn-2),time(xrt,zdn-2),
			    time(xrt-1,zdn-1),slowness(xrt-1,zdn-2));
			if(time(xrt,zup+1) < 0.0)
			time(xrt,zup+1)= corn(time(xrt-1,zup+2),time(xrt,zup+2),
			    time(xrt-1,zup+1),slowness(xrt-1,zup+1));
		}
		/* now the corners */
		if(xlt >= 0 && zup >= 0){
			time(xlt,zup)= corn(time(xlt+1,zup+1),time(xlt,zup+1),
			    time(xlt+1,zup),slowness(xlt,zup));
		}
		if(xlt >= 0 && zdn <  *izend){
			time(xlt,zdn)= corn(time(xlt+1,zdn-1),time(xlt,zdn-1),
			    time(xlt+1,zdn),slowness(xlt,zdn-1));
		}
		if(xrt < *ixend && zup >= 0){
			time(xrt,zup)= corn(time(xrt-1,zup+1),time(xrt,zup+1),
			    time(xrt-1,zup),slowness(xrt-1,zup));
		}
		if(xrt < *ixend && zdn <  *izend){
			time(xrt,zdn)= corn(time(xrt-1,zdn-1),time(xrt,zdn-1),
			    time(xrt-1,zdn),slowness(xrt-1,zdn-1));
		}

		/* expand the box */
		if(xlt >= *ixbeg) xlt--;
		if(zup >= 0) zup--;
		if(xrt < *ixend) xrt++;
		if(zdn <  *izend) zdn++;
	}
}

float corn(ta,tb,tc,hs)
float ta, tb, tc, hs;
{
	float x, diff, arg;
/*
#ifndef CONVEXSYSTEM
	double sqrt();
#endif
*/

	diff= tc - tb;
	arg= 2.0*hs*hs - diff*diff;
	/* IF arg < 0, WAVEFRONT IS GOING FROM CORNER TO CORNER, RETURN ta */
	if(arg < 0)
		{
		x = ta;
		if (x < tb)
			x = tb;
		if (x < tc)
			x = tc;
		return(x);
		}
	x = ta + sqrt(arg);
	if (x < tb)
		x = tb;
	if (x < tc)
		x = tc;
	return(x);
}

float edge(ta,tb,tc,hs)
float ta, tb, tc, hs;
{
	float td, diff, arg;
/*
#ifndef CONVEXSYSTEM
	double sqrt();
#endif
*/
	diff= 0.5*(tc- tb);
	arg= hs*hs - diff*diff;
	/* PATHOLOGICAL CASE, ASSUME SOMETHING SIMPLE */
	if(arg < 0.0)
	{
		td = ta + hs;
		return(td);
	}
	td= ta + sqrt( (double)(arg));
	return(td);
}
