C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c  shell routine to call prony
 
c  but it is an example of rearranging a vector in main
c  into a matrix
 
      subroutine subs ( ntrc, ip, nt, n2, nsamp, array1, array2,
     :     tri, ctri, X, XP, H, Z, cfour, nx, method)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c variables passed from calling routine

      integer ntrc, ip, nt, n2, nsamp, nx, method
 
      real array1 (n2, nx), tri (4*SZLNHD)

      complex X(ntrc), XP(ntrc), H(ntrc), Z(ntrc), cfour(ntrc)
      complex array2( nt, nx ), ctri( 4 * SZLNHD ) 

c local variables

      integer istat, ordfft, n21, ntrc2, ntrc3, ntrc32, j, i, kk

      complex  x5( 2 * SZLNHD )

c initialize variables

      n21 = n2 / 2
      ntrc2 = ntrc / 2
      nu=ordfft(ntrc)+1
      nx=2**nu

      if(method.eq.1)     ntrc3=nx

      if(method.eq.2)     ntrc3=ntrc

       ntrc32=ntrc3/2

c---
c  build array2 of temporal FT
c---

      DO  J = 1, ntrc

          call vclr ( tri,  1, n2 )
          call vclr ( ctri, 1, n2 )
          call vmov ( array1(1,J), 1, tri, 1, nsamp )
          call rfftf ( tri, ctri, n2 )
          call rfftsc ( ctri, n2, 2, 1 )

          do  i = 1, nt
              array2 (i,J) = 1.0e+00 * ctri (i)
          enddo
          
      ENDDO

      DO  I = 1, n21

         do  j = 1, ntrc
            X (j) = array2 (I,j)
         enddo

         do kk=1,ntrc
            H(kk)=(0.,0.)
            Z(kk)=(0.,0.)
            cfour(kk)=(0.,0.)
            XP(kk)=(0.0,0.0)
         enddo

         istat=0

         call prony ( method, ntrc, ip, X, H, Z, XP, cfour, x5, istat )

         if ( method .eq. 1 ) then

            do  j = 1, ntrc32
               array1 (n21-I+1,j+ntrc32) = 1. / cabs( x5(j) )
               array1 (n21+I,  j+ntrc32) = 0.0
            enddo
            do  j = ntrc32+1, ntrc3
               array1 (n21-I+1,j-ntrc32) = 1./cabs(x5(j))
               array1 (n21+I,  j-ntrc32) = 0.0
            enddo
            
         else
            do j = 1, ntrc32
               array1 (n21-I+1,j+ntrc32) = cabs( cfour(j) )
               array1(n21+I, j+ntrc32) = 
     1              atan2( aimag(cfour(j)), real(cfour(j)))
            enddo
            
            do j = ntrc32+1, ntrc
               array1(n21-I+1,j-ntrc32) = cabs(cfour(j))
               array1(n21+I,  j-ntrc32) =
     1              atan2( aimag(cfour(j)), real(cfour(j)) )
            enddo
            
         endif
          
      ENDDO
 
      return
      end
