C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine bd_detmut (x, im, n, flag)

c  routine to detect the first live sample going down a trace
c  or up a trace depending on the flag

c  x  - input data
c  n  - length of x
c im  - last zero sample from top
c       or first zero sample at bottom
c       flag = 0 do top
c       flag = 1 do bottom

      real     x(*)
      integer  im, n, flag

      im = 0
      if ( flag .eq. 0 ) then

         do  i = 1, n
            if (abs(x(i)) .eq. 0.) then
               im = im + 1
            else
               return
            endif
         enddo

      elseif ( flag .eq. 1 ) then

         do  i = n,1,-1
            if (abs(x(i)) .eq. 0.) then
               im = im + 1
            else
               if ( i .eq. n )then
                  im = n
 1             else
                  im = n - im + 1
               endif
               return
            endif
         enddo

      endif

      return
      end
