C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c  routine to compute amplitude spectrum for trapezoidal filter and also
c  to compute the phase spectrum of the minimum delay trapezoidal filter

      subroutine fweight ( nsamp, nt, nf, dt, df, flolo, flohi, fhilo,
     1     fhihi, fwt, work, tri, phi, G, zerop, verbos, tmp,
     2     tdel, LG, conv, db, band, wt, lfmax, ish, prew )

      implicit none

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare variables passed from calling routine      

      integer  nsamp, nt, nf, LG, lfmax, ish

      real dt, df, flolo, flohi, fhilo, fhihi, tdel, db, band, wt, prew
      real fwt(nt), tri (nt), phi (nt), G (nt), work (2*nt)

      complex  tmp(nt)

      logical  verbos, zerop, conv

c declare local variables

      integer  i, if1, if2, if3, if4, nf12, nf34, indx

      real fnyq, pi2, gmax, xr, xi

c initialize variables

      pi2 = 2. * 3.14159265
      fnyq = 1. / (2. * dt)
      df = fnyq/float(nf-1)

      do  i = 1, nt
          fwt  (i) = 0.0
          phi  (i) = 0.0
          tri  (i) = 0.0
          work (i) = 0.0
          G    (i) = 0.0
      enddo

      IF (conv) THEN

         tdel = dt
         call filti (lfmax, 2, tdel, db, flolo, flohi, fhilo, fhihi,
     1        phi, LG, G)
         write(LERR,*)' Ormsby convolution filter length  = ',LG
         write(LERR,*)' '
         write(LERR,*)'Ormsby filter response'
         do i = 1, LG
            write(LERR,*)i,G(i)
         enddo
         write(LERR,*)' '
         ish = LG / 2
         if (.not. zerop) then

c---
c  compute minimum phase time domain response using hilbert freq
c  domain method; restore proper scale factor.
c---
            call mphase (LG, G, SZSMPD)

c---
c  compute minimum phase time domain response using double wiener
c  least squares method; restore proper scale factor.
c---

            write(LERR,*)'Minimum delay filter response'
            do i = 1, LG
               write(LERR,*)i,G(i)
            enddo
            write(LERR,*)' '
            ish = 1
         endif

         return
      ENDIF

c---
c  compute frequency integers correponding to the 4 corner freqs; run
c  checks for defaults
c---
      if1 = nint ( flolo / df )
      if2 = nint ( flohi / df )
      if3 = nint ( fhilo / df )
      if4 = nint ( fhihi / df )

      if (if1 .le. 0 .and. if2 .gt. 1) if1 = 1

      if (if1 .le. 0 .and. if2 .le. 0) then
         if1 = 1
         if2 = 1
         fwt (1) = 1.0
      endif

      if (if3 .le. 0 .and. if4 .le. 0) then
         if3 = nf
         if4 = nf
         fwt (nf) = 1.0
      endif

c---
c  compute ramps F1 -> F2 and F3 -> F4
c---
      nf12 = if2 - if1
      if (nf12 .gt. 0) then
         do  i = if1, if2
            fwt (i) = float (i - if1) / float (nf12)
         enddo
      endif

      nf34 = if4 - if3
      if (nf34 .gt. 0) then
         do  i = if3, if4
            fwt (i) = float (if4 - i) / float (nf34)
         enddo
      endif

c---
c  top of trapezoid is flat
c---
      do  i = if2+1, if3-1
         fwt (i) = 1.0
      enddo

c---
c  compute phase spectrum for use in application of trapezoidal filter
c  in freq domain
c---

      IF (zerop) THEN

c---
c  zero phase response
c---
         do  i = 1, nf
            phi (i) = 0.
         enddo

      ELSE

c---
c  minimum phase response. First compute the zero phase time domain
c  filter; compute unit scaled version of this and save scaler
c---
         call filti (lfmax, 2, tdel, db, flolo, flohi, fhilo, fhihi,
     1        phi, lg, G)

         call maxmgv (G, 1, gmax, indx, LG)
         call vsdiv  (G, 1, gmax, G, 1, LG)
         call vclr   (phi , 1, lfmax)
         call vclr   (tri , 1, lfmax)
         tri(1) = 1.0
         call vclr   (work, 1, lfmax)
         
c---
c  compute minimum phase time domain response using hilbert freq
c  domain method; restore proper scale factor.
c---

         call mphase (LG, G, SZSMPD)

c---
c  At this point we could use this response in the time domain
c  by convolving this with the input data but we really want to
c  utilize the ideal trapezoidal amplitude spectrum and do things
c  in the freq domain (for one thing it's faster...
c  So, compute the phase spectrum.
c---

         call rfftf  (G, tmp, nt)

c ---
c rfftf() is a mathadv routine that performs the same operation 
c         as rfft() except it stores the output in tmp().  G()
c         will be modified during execution as this routine actually
c         calls rfft() to perform its transform.  The output need scaling
c         with rfftsc()
c ---

         call rfftsc (tmp, nt, 3, 1)

         do  i = 1, nf
            xr = real  ( tmp (i) )
            xi = aimag ( tmp (i) )
            if (xr .eq. 0.) then
               phi (i) = 0.
            else
               phi (i) = atan2 ( xi , xr ) + pi2 * float(i-1)*tdel*df
            endif
         enddo

      ENDIF

      if (verbos) then

         write(LERR,*)' '
         write(LERR,*)'Trapezoid (',nf,') weights:'
         write(LERR,*)(fwt(i),i=1,nf)
         write(LERR,*)' '
         if (.not. zerop) then

            write(LERR,*)' '
            write(LERR,*)'Trapezoid Filter (',lg,') Min Delay Time Respo
     :nse :'
            write(LERR,*)(G(i),i=1,lg)
            write(LERR,*)' '

         endif

      endif

      return
      end
