C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE IDEF2(FMAX,TDEL,WC,LF,F)
C                            FORTRAN BY KEN PEACOCK  10-6-76
C     SUBROUTINE IDEF CONSTRUCTS THE OPERATOR FOR THE IDEAL HIGHCUT
C     (LOWPASS) FILTER.  WEIGHTING IS AVAILABLE ON OPTION.
C        INPUTS ARE...
C             FMAX, LIMITING FREQUENCY TO PASS.
C             TDEL, SAMPLE INCREMENT IN SECONDS.
C             WC, .LT. 0 MEANS TO OUTPUT RAW OPERATOR, .GE.0 MEANS TO
C                  USE A KAISER WEIGHT FUNCTION WITH EXPONENT WC.
C             LF, LENGTH OF FILTER IN SAMPLES, LF MUST BE ODD.
C        OUTPUT IS...
C             F, THE LF-LENGTH OUTPUT ARRAY.
C     CODED FOR THE IBM 370/158 COMPUTER.
C     VERSION AS OF 11-30 78
C
      DIMENSION W(2001)
      DIMENSION F(1)
      FACT1 = 2.*3.1415927*FMAX*TDEL
      FACT2 = 3.1415927*TDEL
      N = LF/2
      ISTA = N+2
      KFACT = 1-ISTA
      JFACT = LF+1
      DO 1 I=ISTA,LF
      AK = I+KFACT
      F(I) = SIN(FACT1*AK)/(FACT2*AK)
      J = JFACT-I
    1 F(J) = F(I)
      F(ISTA-1) = 2.*FMAX
C
      DO 20 I=ISTA,LF
      J = JFACT-I
   20 F(J) = F(I)
C
      IF(WC.LE.0.) GO TO 3
C
      CALL KAISER(WC,LF,W)
      DO 10 I=1,LF
   10 F(I) = F(I)*W(I)
    3 RETURN
      END
