C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE VNWT(WC,A,NC,W)                                        
C        A CONFIDENTIAL AMOCO SUBROUTINE                                
C           FORTRAN BY KEN PEACOCK  2-6-86                              
C     VNWT COMPUTES THE WEIGHTS FOR A VELOCITY-TYPE NARROW-BAND FILTER. 
C     THE EDGES ARE PARALLEL RATHER THAN WEDGE.  COMBINATION WITH A 2-D 
C     DELTA FUNCTUONAL CONSTRUCTS A VELOCITY NOTCH FILTER.              
C     INPUTS ARE...                                                     
C        WC, EXPONENT FOR BESSEL WEIGHTING.                             
C        A, INTERCEPT OF CUT ON SPATIAL FREQUENCY AXIS.                 
C        NC, NUMBER OF CHANNELS (FILTER LENGTH).                        
C     OUTPUT IS...                                                      
C        W, THE OUTPUT ARRAY.                                           
C     CODED FOR THE IBM 3090.                                           
C     VERSION AS OF 2-6-86.                                             
C                                                                       
      DIMENSION W(1),BUF(201)                                           
      IF(A.NE.0.)GO TO 2                                                
      DO 1 I=1,NC                                                       
    1 W(I) = 1./NC                                                      
      GO TO 4                                                           
    2 PI = 3.1415927                                                    
      FACT = 2.*PI*A                                                    
      LI = NC/2                                                         
      DO 3 I=1,LI                                                       
      J = LI+I+1                                                        
      K = LI-I+1                                                        
      W(J) = SIN(FACT*I)/(PI*I)                                         
    3 W(K) = W(J)                                                       
      W(NC/2+1) = 2.*A                                                  
    4 IF(WC.EQ.0)GO TO 6                                                
      CALL KAISER(WC,NC,BUF)                                            
      DO 5 I=1,NC                                                       
    5 W(I) = W(I)*BUF(I)                                                
    6 RETURN                                                            
      END                                                               
