C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ddot(l,x,y,p)

c*******************************************************************************
c     This subroutine computes the dot product of two vectors, x and y
c
c     See: Robinson "Multichannel Time Series Analysis", page 19
c
c     This is the double precision version of subroutine "dot" in
c     Robinson.
c
c**** Subroutine input
c
c     l = Length of vectors x and y
c     x = First vector
c     y = Second vector
c
c**** Subroutine output
c
c     p = The dot product of x and y
c
c*******************************************************************************

      integer l
      real*8 x(l),y(l),p
      integer i

      p = 0.0d0
      if(l.le.0) return

      do i = 1,l

        p = p + x(i) * y(i)

      enddo

      return
      end
