C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine pack(uc,ur,nrhs,ntfft,hbegin)
c
      integer    hbegin
      complex    uc(ntfft/2,nrhs)
      real       ur(hbegin:ntfft,nrhs)
c___________________________________________________________________
c     pack complex data into amplitude and phase subarrays.
c     copy data in upside down.
c     pack amplitude in positions (1:ntfft/2)
c     pack phase     in positions (ntfft/2+1:ntfft)
c___________________________________________________________________
      write(90,*) 'in pack'
      write(90,'(2i5,2e12.3)') ((jf,k,uc(jf,k),jf=1,ntfft/2,100),
     1                           k=1,nrhs,10)
      do 80000 k=1,nrhs
       jamp=ntfft/2+1
       jphase=ntfft+1
       do 70000 jf=1,ntfft/2
        jamp=jamp-1
        jphase=jphase-1
        ur(jamp,k)=abs(uc(jf,k))
        if(ur(jamp,k) .eq. 0.) then
           ur(jphase,k)=0.
        else
           ur(jphase,k)=atan2(aimag(uc(jf,k)),real(uc(jf,k)))
        endif
70000  continue
80000 continue
c
      return
      end

