C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdgather(rbuffer,ibuffer,hbegin,maxsamp,
     1                    lentr2,ntr,luin,lerr,eod,itr,irec, 
     2                    dist,live,xwgt,interpolate,
     3                    xtemp,iorder,liverec,
     4                    l_StaCor,l_RecNum,l_DstSgn,l_MulSkw,
     5               ifmt_StaCor,ifmt_RecNum,ifmt_DstSgn,ifmt_MulSkw,
     6               ln_StaCor,ln_RecNum,ln_DstSgn,ln_MulSkw,
     7                    spread,irecnum,revers,forward,nsamporig)

      integer   hbegin
c___________________________________________________________________________
c     ibuffer and rbuffer are equivalenced by the calling arguments.
c___________________________________________________________________________
      integer   ibuffer(lentr2,ntr)
      real      rbuffer(hbegin:maxsamp,ntr)
      real      dist(ntr) 
      real      xwgt(ntr)
      real      xtemp(ntr)
      integer   iorder(ntr)
      logical   eod,revers,interpolate,forward 
      logical   live(ntr),liverec
      data      undefined/999999./
c
      nlive = 0
      do 10000 itr=1,ntr
       nbytes = 0
       call rtape(luin,rbuffer(hbegin,itr),nbytes)
       if(nbytes .eq. 0) then
          write(LERR,*)'End of file on input:'
          write(LERR,*)' rec= ',irec,' trace= ',itr
          eod=.true.
          return
       endif

c      istatic=ibuffer(l_StaCor,itr)
c      idist=ibuffer(l_DstSgn,itr)
       call saver2(ibuffer(1,itr),ifmt_StaCor,l_StaCor,
     1             ln_StaCor, istatic, 1)
       call saver2(ibuffer(1,itr),ifmt_DstSgn,l_DstSgn,
     1             ln_DstSgn, idist  , 1)

       dist(itr)=idist
       if(istatic .ge. 30000) then
c___________________________________________________________________________
c         dead trace in (x,t) domain.                                
c___________________________________________________________________________
          if(revers) then
             if(interpolate) then 
c___________________________________________________________________________
c               interpolate dead traces during (f-k) to (x-t) transform.
c___________________________________________________________________________
c               ibuffer(l_StaCor,itr)=0
                call savew2(ibuffer(1,itr),ifmt_StaCor,l_StaCor,
     1                      ln_StaCor, 0      , 1)
                live(itr)=.true.
             else
c___________________________________________________________________________
c               don't interpolate dead traces during (f-k) to (x-t) transform.
c___________________________________________________________________________
c               ibuffer(l_StaCor,itr)=30000
                call savew2(ibuffer(1,itr),ifmt_StaCor,l_StaCor,
     1                      ln_StaCor, 30000  , 1)
                live(itr)=.false.
             endif
          else
c___________________________________________________________________________
c            forward transform. reset dead trace flag to 30001.               
c___________________________________________________________________________
             call vclr(rbuffer(1,itr),1,maxsamp)
c            ibuffer(l_StaCor,itr)=30001
             call savew2(ibuffer(1,itr),ifmt_StaCor,l_StaCor,
     1                   ln_StaCor, 30001  , 1)
             live(itr)=.false.
             dist(itr)=undefined
c            ibuffer(l_MulSkw,itr)=nsamporig
             call savew2(ibuffer(1,itr),ifmt_MulSkw,l_MulSkw,
     1                   ln_MulSkw,nsamporig, 1)
          endif
       else
c___________________________________________________________________________
c         live trace in (x,t) domain.
c___________________________________________________________________________
c         irecnum=ibuffer(l_RecNum,itr)
          call saver2(ibuffer(1,itr),ifmt_RecNum,l_RecNum,
     1                ln_RecNum, irecnum, 1)
          live(itr)=.true.  
          liverec=.true.
          if(forward) then
c___________________________________________________________________
c             mute preservation initialization.
c___________________________________________________________________
              do 4000 isamp=1,nsamporig
               if(rbuffer(isamp,itr) .ne. 0) then
c                 ibuffer(l_MulSkw,itr)=isamp-1
                  call savew2(ibuffer(1,itr),ifmt_MulSkw,l_MulSkw,
     1                        ln_MulSkw, isamp-1 , 1)
                  go to 4001
               endif
4000          continue
4001          continue
          endif
       endif
10000 continue
      if(revers) then
c___________________________________________________________________________
c        reverse transform. equally spaced wavenumbers.    
c___________________________________________________________________________
         call vfill(1.,xwgt,1,ntr)
      else
c___________________________________________________________________________
c        order to find delta-x.                               
c        initialize.
c___________________________________________________________________________
         do 60000 itr=1,ntr
          iorder(itr)=itr
          xwgt(itr)=0.
60000    continue
         call vmov(dist,1,xtemp,1,ntr)
         do 80000 itr=1,ntr-1
          do 70000 jtr=itr+1,ntr
           if(xtemp(jtr) .lt. xtemp(itr)) then
              xhold=xtemp(itr)
              ihold=iorder(itr)
              xtemp(itr)=xtemp(jtr)
              iorder(itr)=iorder(jtr)
              xtemp(jtr)=xhold
              iorder(jtr)=ihold       
           endif
70000     continue
80000    continue
c___________________________________________________________________________
c        calculate distance weights for integration over x.
c___________________________________________________________________________
         call vclr(xwgt(1),1,ntr)
         if(xtemp(2) .ne. undefined) then
            xwgt(iorder(1))=(xtemp(2)-xtemp(1))            
         endif
         do 90000 itr=2,ntr-1
          if(xtemp(itr+1) .ne. undefined) then
             xwgt(iorder(itr))=.5*(xtemp(itr+1)-xtemp(itr-1))
          else
             xwgt(iorder(itr))=(xtemp(itr)-xtemp(itr-1))
             go to 90001
          endif
90000    continue
90001    continue
c___________________________________________________________________________
c        check that current spread does not exceed that entered from the
c        command line
c___________________________________________________________________________
         do 95000 itr=ntr,1,-1
          if(xtemp(itr) .ne. undefined) then
             currentspread=xtemp(itr)-xtemp(1)
             go to 95001         
          endif
95000    continue
         currentspread=0.
95001    continue
         if(currentspread .gt. spread) then
            write(lerr,*) 'program terminated in routine rdgather!'
            write(lerr,*) ' spread calculated from trace '
     1                    //' distances = ',currentspread
            write(lerr,*) ' exceeds that from the command'	
     1                    //' line      = ',spread
            write(lerr,*) 'record number ',irec
            write(lerr,*) 'check command line arguments or'
     1                    //' trace headers!'
            write(lerr,*) 'sorted live traces'               
            write(lerr,'(a10,a15)') 'itr','dist(itr)'
            do 96000 jtr=1,ntr
             itr=iorder(jtr)
             if(live(itr)) then
                write(lerr,'(i10,f15.3)') itr,dist(itr)
             endif
96000       continue
            close(lerr)
            call exit(10001)
         endif
         do 97000 itr=1,ntr
          xwgt(itr)=xwgt(itr)/spread
97000    continue
      endif
c
      return
      end

