C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( ntap, otap, nrec, ntrc, nsamp, nsi, iform, 
     :     irs, ire, nreco, ntrco, nsampo, nsampAmp, dX, dY, dKX, dKY, 
     :     dKR, NyquistX, NyquistY, RadialNyquist, verbos ) 

c     verbose output of processing parameters

#include <f77/iounit.h>

c declare variables passed from calling routine
 
      integer  nrec, ntrc, nsamp, nsi, iform, irs, ire, nreco, ntrco
      integer  nsampo, nsampAmp

      real     dX, dY, dKX, dKY, dKR, NyquistX, NyquistY, RadialNyquist

      character   ntap*(*), otap*(*)

      logical verbos

c declare local variables

      integer length
 
      write(LERR,*)' '
      write(LERR,*)' Input line header values '
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' input data set name  =  ', ntap(1:length)
      else
        write(LERR,*) ' input data set       =  stdin'
      endif
      write(LERR,*) ' # of samples/trace   =  ', nsamp
      write(LERR,*) ' sample interval      =  ', nsi
      write(LERR,*) ' traces per record    =  ', ntrc
      write(LERR,*) ' records per line     =  ', nrec
      write(LERR,*) ' format of data       =  ', iform
      write(LERR,*)' '
      write(LERR,*)' Output line header values '
      length = lenth(otap)
      if (length .gt. 0) then
        write(LERR,*) ' output data set name =  ', otap(1:length)
      else
        write(LERR,*) ' output data set      =  stdout'
      endif
      write(LERR,*) ' # of samples/trace   =  ', nsampo
      write(LERR,*) ' sample interval      =  ', nsi
      write(LERR,*) ' traces per record    =  ', ntrco
      write(LERR,*) ' records per line     =  ', nreco
      write(LERR,*) ' format of data       =  ', iform
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters'
      write(LERR,*) ' X co-ordinate sample interval = ',dX
      write(LERR,*) ' Y co-ordinate sample interval = ',dY

      if ( verbos ) write(LERR,*)' Verbos printout requested'
      write(LERR,*)' '
      write(LERR,*)' Calculated Parameters'
      write(LERR,*) ' Number of samples in Amplitude Spectrum = ', 
     :     nsampAmp
      write(LERR,*) ' Spatial X Nyquist = ',NyquistX
      write(LERR,*) ' Spatial X sample interval = ',dKX
      write(LERR,*) ' Spatial Y Nyquist = ',NyquistY
      write(LERR,*) ' Spatial Y sample interval = ',dKY
      write(LERR,*) ' Spatial Radial Nyquist = ',RadialNyquist
      write(LERR,*) ' Spatial Radial sample interval = ',dKR

      return
      end
