C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine BuildExpMask(AmpMask, ntrc, nsampAmp, dKX, dKY, dKR, 
     :     Exponent, Bin1, Bin2, Bin3, Bin4, nbins ) 

#include <f77/lhdrsz.h>

c variables passed into subroutine

      integer nbins, ntrc, nsampAmp, Bin1, Bin2, Bin3, Bin4

      real    dKX, dKY, dKR, Exponent, AmpMask(nsampAmp,ntrc)

c local variables

      integer Xcenter, Ycenter

      real Kr, Kx, Ky, binAmp(SZLNHD)
      real Kr_min, Kr_max

c build radial filter mask

      if ( Bin2 .ne. 0 .and. Bin3 .ne. 0 .and. Bin4 .ne. 0 ) then

c band pass

         do j = 1, nbins
            if ( j .le. Bin1 ) then
               binAmp(j) = 0.0
            elseif ( j .gt. Bin1 .and. j .lt. Bin2 ) then
c taper
               if (abs(exponent) .gt. 1.e-32 ) then
                  binAmp(j) = ( float(j-Bin1) / float(Bin2 - Bin1) ) 
     :                 * float(j) ** Exponent
               else
                  binAmp(j) = ( float(j-Bin1) / float(Bin2 - Bin1) ) 
               endif

            elseif ( j .ge. Bin2 .and. j .le. Bin3 ) then
c pass
               if (abs(exponent) .gt. 1.e-32 ) then
                  binAmp(j) = float(j) ** Exponent
               else
                  binAmp(j) = 1.0
               endif

            elseif ( j .gt. Bin3 .and. j .lt. Bin4 ) then
c taper
               if (abs(exponent) .gt. 1.e-32 ) then
                  binAmp(j) = ( float(Bin4 - j) / float(Bin4 - Bin3) ) 
     :                 * float(j) ** Exponent
               else
                  binAmp(j) = ( float(Bin4 - j) / float(Bin4 - Bin3) ) 
               endif
            elseif ( j .ge. Bin4 ) then
               binAmp(j) = 0.0
            endif
         enddo

      elseif ( Bin2 .eq. 0 .and. Bin3 .ne. 0 .and. Bin4 .ne. 0 ) then

c low pass

         do j = 1, nbins

            if ( j .le. Bin3 ) then

c pass

               if (abs(exponent) .gt. 1.e-32 ) then
                  binAmp(j) = float(j) ** Exponent
               else
                  binAmp(j) = 1.0
               endif

            elseif ( j .gt. Bin3 .and. j .lt. Bin4 ) then
c taper
               if (abs(exponent) .gt. 1.e-32 ) then
                  binAmp(j) = ( float(Bin4 - j) / float(Bin4 - Bin3) ) 
     :                 * float(j) ** Exponent
               else
                  binAmp(j) = ( float(Bin4 - j) / float(Bin4 - Bin3) ) 
               endif

            elseif ( j .ge. Bin4 ) then
               binAmp(j) = 0.0
            endif
         enddo

      elseif ( Bin2 .ne. 0 .and. Bin3 .eq. 0 .and. Bin4 .eq. 0 ) then

c high pass

         do j = 1, nbins

            if ( j .le. Bin1 ) then
               binAmp(j) = 0.0
            elseif ( j .gt. Bin1 .and. j .lt. Bin2 ) then
c taper
               if (abs(exponent) .gt. 1.e-32 ) then
                  binAmp(j) = ( float(j-Bin1) / float(Bin2 - Bin1) ) 
     :                 * float(j) ** Exponent
               else
                  binAmp(j) = ( float(j-Bin1) / float(Bin2 - Bin1) ) 
               endif

            elseif ( j .ge. Bin2 ) then
c pass
               if (abs(exponent) .gt. 1.e-32 ) then
                  binAmp(j) = float(j) ** Exponent
               else
                  binAmp(j) = 1.0
               endif
            endif

         enddo

      endif

c determine 2d sample location of Kx = Ky = 0 position

      if ( mod(ntrc,2) .eq. 0 ) then
         Xcenter  = ( ntrc / 2 ) + 1
      else
         Xcenter = ( ntrc / 2 )
      endif

      if ( mod(nsampAmp,2) .gt. 0 ) then
         Ycenter = nsampAmp / 2 + 1
      else
         Ycenter = nsampAmp / 2 
      endif

c calculate weighting mask

      do iy = 1, nsampAmp

         Ky = float(iy - Ycenter) * dKY
            
         DO ix = 1, ntrc

            Kx = float(ix - Xcenter) * dKX
            Kr = ( Kx**2 + Ky**2 )**0.5
 
            do LL = 1, nbins

               Kr_max = float(LL) * dKR
               Kr_min = float(LL) * dKR - dKR
               
               if ( Kr .ge. Kr_min .and. Kr .lt. Kr_max ) then
               
                  if ( binAmp(LL) .gt. 0. ) then
                     AmpMask(iy,ix) = binAmp(LL)
                  else
                     AmpMask(iy,ix) = 0.0
                  endif
                  goto 100

               endif
            enddo
            
c if execution gets to here then the radius is greater than the last active bin
c if this is so then AmpMask for this value must be set to zero

            AmpMask(iy,ix) = 0.0
            
 100        CONTINUE

         enddo
            
      enddo

      return
      end
