C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ReadPick ( lu, index, traces, Samples, 
     :     nseg, PickType, ntrc, verbos ) 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>


      integer lu, index(2*SZSMPM,2), npicks, i, nseg, count
      integer pointer, ntrc

      real   recnum, traces(*), Samples(*), value

      character ajunk*1, key*10, name*20, PickType*(*)
 
      logical verbos

c determine type of pickfile in use
       
      IF ( PickType .ne. 'header' ) then

c using standard rec,trace,sample format pick file traces/record from pick file header 

         read(lu,'(51x,i5)') ntr

c initialize element and segmentcounters

         npicks = 0
         nseg = 1

c read segment header, need two reads to get past 1st header while still counting picks

         read(lu,'(a1)',end=20) ajunk

c for subsequent segments start at statement 1 

 1       read(lu,'(a1)',end=20) ajunk

c scan for next segment header while advancing counter
c record number of picks in segment in index(I,1)
c tag number of segments in variable nseg

         if(ajunk .ne. 'S') then
            npicks = npicks + 1
            goto 1
         else
            index(nseg,1) = npicks
            if (verbos) then
               write(LERR,*) ' segment number : ', nseg 
               write(LERR,*) ' number of picks : ', npicks 
            endif

c advance segment register and reset element counter 

            nseg = nseg + 1
            npicks = 0

c start next segment

            goto 1
         endif

c have reached end of pick file assign number of picks for last segment

 20      index(nseg,1) = npicks
      
         if (verbos) then
            write(LERR,*) ' segment number : ', nseg 
            write(LERR,*) ' number of picks : ', npicks 
         endif

c now know total number of segments and number of picks in each
	
         rewind lu

c read and quality control each segment

         read(lu,'(a1)') ajunk

c reset array total element counter

         count = 0

c SEGMENT LOOP 

         do 30 i = 1,nseg

c read past segment header

            read(lu,'(a1)') ajunk

c ELEMENT LOOP 

            do j = 1,index(i,1)

               count = count + 1
               read(lu,50)recnum, traces(count), Samples(count)
 50            format(f12.6,2f13.6)
               

            enddo

c determine trace order and sort if necessary 

            pointer = count - index(i,1) + 1

            if(traces(pointer).gt.traces(pointer+1))then
               call hsort2 (index(i,1),traces(pointer),Samples(pointer))
            endif

c load record number into index array

            index(i,2) = ifix(recnum)

c SEGMENT LOOP END 

 30      continue

c write out picks to printout file for QC

        pointer = 0
        do i = 1,nseg
           if ( ntrc .eq. 1 ) then
              write(LERR,*)' Segment ',i
           else
              write(LERR,*)' Segment ',i,' for record',index(i,2)
           endif
           write(LERR,*)' Trace           Sample'
           do j = 1,index(i,1)
              pointer = pointer + 1
              write(LERR,*)traces(pointer),Samples(pointer)
           enddo
        enddo

         return

      ELSE

c using new header key,value pickfile format 
c need to define count,nseg,traces,Samples,index
c index[a,b] where a is recnum b is npicks

         count = 0
         nseg = 0

         DO while(1.eq.1)
            
            read(lu,'(a10,1x,f17.6)',end=200)key,value

C Increment counter for segment and reset pick counter.
C Get segment name.
           if (key.EQ.'Segment') then
              nseg=nseg+1
              read(lu,'(a10,1x,a20)',end=200)key,name
           endif

C Increment counter for pick.
           if (key.EQ.'Pick') then
              count=count+1
           endif

C Store the number of picks for that segment.
           if (key.EQ.'Picks') then
              index(nseg,1)=nint(value)
              if (verbos) then
                 write(LERR,*) ' segment number : ',nseg 
                 write(LERR,*) ' number of picks : ',index(nseg,1)
              endif
           endif
           
C Store the trace identifier for trace.

           if (key.EQ.'TrcNum') then
              traces(count)=value
           endif
           
C Store the sample value for pick.
           if (key.EQ.'Sample') then
              Samples(count)=value
           endif

        ENDDO           

 200    continue

c go through digitization and qc for faults 

c initialize array pointer

        pointer = 0

c SEGMENT LOOP

        DO i = 1,nseg

c move pointer back to start of segment 

           pointer = pointer - index(i,1) + 1

c sort offsets into increasing order 

           call hsort2 (index(i,1),traces(pointer),Samples(pointer))

c END SEGMENT LOOP

        ENDDO           
        
c output picks to printfile for QC

        pointer = 0
        do i = 1,nseg
           if ( ntrc .eq. 1 ) then
              write(LERR,*)' Segment ',i
           else
              write(LERR,*)' Segment ',i,' for record',index(i,2)
           endif
           write(LERR,*)' Trace           Sample'
           do j = 1,index(i,1)
              pointer = pointer + 1
              write(LERR,*)traces(pointer),Samples(pointer)
           enddo
        enddo

        return

      ENDIF

      end
