C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ScanParameters ( NyquistX, NyquistY, ntrc, nsampAmp,
     :      dKX, dKY, dKR, nbins, exp_ntrco ) 

c this routine determines the relative scales in x and y.  x is along the
c trace axis while y is along the sample axis

      integer ntrc, exp_ntrco, nsampAmp, nbins

      real NyquistX, NyquistY, dKX, dKY, dKR

c declare local variables

      integer Xcenter, Ycenter

      if ( mod(ntrc,2) .eq. 0 ) then
         Xcenter  = ( ntrc / 2 ) + 1
      else
         Xcenter = ( ntrc / 2 )
      endif

      if ( mod(nsampAmp,2) .gt. 0 ) then
         Ycenter = nsampAmp / 2 + 1
      else
         Ycenter = nsampAmp / 2 
      endif

c determine wavenumber sample interval along both the KX and KY axes.      

      dKX = NyquistX / float(Xcenter)
      dKY = NyquistY / float(Ycenter)

c determine number of output traces and samples to use to keep a 
c relatively square looking radial power spectra plot.  This is required
c for the exponent only option of fkshape as we need to calculate the
c exponent over the number of bins used in the radial computation.

      if ( nbins .eq. 0 ) then
         if ( Xcenter .ge. Ycenter ) then
            exp_ntrco = Xcenter
         else
            exp_ntrco = Ycenter
         endif
      else
         exp_ntrco = nbins
      endif
      
c Since we want to sum ALL the input space, which is not radial by design,
c i.e. has corner spaces, then we must calculate the radial nyquist out past
c both KX and KY maxima and allow summation into the corners of the spectra.
c The output radial spacial interval will then be a function of the radial
c Nyquist and the number of output traces.


      RadialNyquist = sqrt( NyquistX**2 + NyquistY**2 )
      dKR = RadialNyquist / float(exp_ntrco)

      return
      end
