C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln(ntap, otap, vtap, ns, ne, irs, ire, verbos, vel,
     1                 n1w, n2w, n1_pad, n2_pad, nmo_f_req, nmo_i_req,
     2                 dxi, dxo, xi, xo, fl, fh, norder, filtr, mute)

#include <f77/iounit.h>

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c      ns   - I      start trace
c      ne   - I      stop end trace
c     irs   - I      start record
c     ire   - I      stop end record
c    verbos - L      verbose output or not
c-----
      integer     argis, ns, ne, irs, ire, norder
      character   ntap*(*), otap*(*), vtap*(*)
      real        vel, dxi, dxo, xi, xo, fl, fh
      logical     verbos, nmo_f_req, nmo_i_req, filtr, mute

c------------------------------------------------------------------------------
c        ARGXXX has parameters
c             ( flag, variable name, default value, format error value )
c------------------------------------------------------------------------------
      nmo_f_req  = ( argis ('-NMO') .gt. 0 )
      mute       = ( argis ('-RM') .gt. 0 )
c     nmo_i_req  = ( argis ('-NMO') .gt. 0 )
      call ARGSTR ('-N', ntap, ' ', ' ' )
      call ARGSTR ('-O', otap, ' ', ' ' )
      call argr4  ('-vel',vel, 0.0, 0.0)
      call argr4  ('-fl',fl, 0.0, 0.0)
      call argr4  ('-fh',fh, 0.0, 0.0)
      call argi4  ('-nor',norder, 4, 4)
      if (vel .eq. 0.0) then
         call ARGSTR ('-v', vtap, ' ', ' ' )
      endif
      call ARGI4  ('-ns', ns, 0, 0)
      call ARGI4  ('-ne', ne, 0, 0)
      call ARGI4  ('-rs', irs, 0, 0)
      call ARGI4  ('-re', ire, 0, 0)

c---
c  the "1" direction is time
c  the "2" direction is space
c  n1w gets divided into nsamp to determine the # windows in time
c  n2w gets divided into ntrc to determine the # windows in space
c---
      call argi4 ('-wpad',  n1_pad, 0, 0)
      call argi4 ('-lpad',  n2_pad, 0, 0)
      call argi4 ('-w',  n1w, 12, 12)
      call argi4 ('-l',  n2w, 6, 6)
      call argr4 ('-dxi', dxi, 0.0, 0.0)
      call argr4 ('-dxo', dxo, 0.0, 0.0)
      call argr4 ('-xi', xi, 0.0, 0.0)
      call argr4 ('-xo', xo, 0.0, 0.0)

      if (n1_pad .eq. 0) then
         n1_pad = n1w / 2
         write(LERR,*)'Temporal pad will default to ',n1_pad
      endif
      if (n2_pad .eq. 0) then
         n2_pad = n2w / 2
         write(LERR,*)'Spatial pad will default to ',n2_pad
      endif
      if (nmo_f_req) nmo_i_req = .true.

      verbos     = ( argis ('-V') .gt. 0 )

      return
      end

