C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c
c
c Subroutine to apply inverse-NMO to traces , spraying mode...
c
c
c
c
c
        subroutine cv_inmo(data,nt,n2,dt,t0,offset,v,data_nmo,hess)
c
        implicit none
c
        integer i2,it
        integer nt,n2
        integer itsamp
c
        real    t0,dt,v,vv,off2
        real    tzero,remt,tee
c
        real    data(nt,n2)
        real    data_nmo(nt+4,n2),hess(nt+4,n2)
        real    offset(n2)
c
	real	wate1,wate2,wate3,wate4

        vv = v * v
c
c initialize the tmp array
c
C$DOACROSS LOCAL(i2,it)
        do i2=1,n2
           do it=1,nt+4
              data_nmo(it,i2)=0.
              hess(it,i2)=0.
           end do
        end do
c
c Do the spraying
c
c
C$DOACROSS LOCAL(i2,it,tzero,remt,wate1,wate2,wate3,wate4,tee,itsamp)
          do i2=1,n2
c
             off2 = offset(i2) * offset(i2)
             do it=1,nt
c
                tzero=(it-1)*dt+t0
c
                tee=sqrt( tzero*tzero + off2/vv )
                itsamp=int((tee-t0)/dt)+1
                remt=(tee-((itsamp-1)*dt+t0))/dt
c
                 wate1=-remt*(remt-1)*(remt-2.)/6
                 wate2=(1.+remt)*(remt-1.)*(remt-2.)/2.
                 wate3=-(1.+remt)*(remt)*(remt-2.)/2.
                 wate4=(1.+remt)*(remt)*(remt-1.)/6.
c
                itsamp=max(min(itsamp,nt+2),2)
c
                data_nmo(itsamp-1,i2)=data_nmo(itsamp-1,i2)+
     1                      data(it,i2)*wate1
                data_nmo(itsamp,i2)=data_nmo(itsamp,i2)+
     1                      data(it,i2)*wate2
                data_nmo(itsamp+1,i2)=data_nmo(itsamp+1,i2)+
     1                      data(it,i2)*wate3
                data_nmo(itsamp+2,i2)=data_nmo(itsamp+2,i2)+
     1                      data(it,i2)*wate4
c
                hess(itsamp-1,i2)=hess(itsamp-1,i2)+
     1                      wate1
                hess(itsamp,i2)=hess(itsamp,i2)+
     1                      wate2
                hess(itsamp+1,i2)=hess(itsamp+1,i2)+
     1                      wate3
                hess(itsamp+2,i2)=hess(itsamp+2,i2)+
     1                      wate4

c
             end do
c
          end do
c
c copy the tmp array to the answer
c
C$DOACROSS LOCAL(i2,it)
        do i2=1,n2
           do it=1,nt
              data(it,i2)=data_nmo(it,i2)/max(1.0,hess(it,i2))
           end do
        end do
c
c all done
c
        return
        end
