C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c
c
c Subroutine to apply constant velocity NMO to a gather of traces 
c
c
c
c
c
        subroutine cv_nmo(data,nt,n2,dt,t0,offset,v,data_nmo)
c
        implicit none
c
        integer i2,it
        integer nt,n2
        integer itsamp
c
        real    t0,dt
        real    tzero,remt,tee
c
        real    v,vv,off2
c
        real    data(nt,n2)
        real    data_nmo(nt+4,n2)
        real    offset(n2)
	real	wate1,wate2,wate3,wate4

        vv = v * v
c
c initialize the tmp array
c
C$DOACROSS LOCAL(i2,it)
        do i2=1,n2
c
           do it=1,nt
              data_nmo(it,i2)=data(it,i2)
           end do
c
           do it=nt+1,nt+4
              data_nmo(it,i2)=0.
           end do
c
        end do
c
C$DOACROSS LOCAL(i2,it,tzero,tee,itsamp,remt,wate1,wate2,wate3,wate4)
          do i2=1,n2
c
             off2 = offset(i2) * offset(i2)
             do it=1,nt
c
                tzero=(it-1)*dt+t0
c
                tee=sqrt( tzero*tzero + off2/vv )
                itsamp=int((tee-t0)/dt)+1
                remt=(tee-((itsamp-1)*dt+t0))/dt
c
                itsamp=max(min(itsamp,nt+2),2)

                 wate1=-remt*(remt-1)*(remt-2.)/6
                 wate2=(1.+remt)*(remt-1.)*(remt-2.)/2.
                 wate3=-(1.+remt)*(remt)*(remt-2.)/2.
                 wate4=(1.+remt)*(remt)*(remt-1.)/6.
c
                data(it,i2)=data_nmo(itsamp-1,i2)*wate1+
     1                      data_nmo(itsamp,i2)*wate2+
     2                      data_nmo(itsamp+1,i2)*wate3+
     3                      data_nmo(itsamp+2,i2)*wate4
c
             end do
c
          end do
c
c all done
c
        return
        end
 

