C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c
c Program to do interpolation beyond aliasing using interpolation
c in the FK domain, according to the Chambers and Gulunay SEG
c abstract. Interpolates on the 2 axis

c Refernces:
c   Gulunay, N and Chambers, R, 1997, Generalized f-k domain trace interpolation:
c   67th Annual Int. Mtg., Soc Expl Geophys, Expanded Abstracts, 1100-1103

c   Gulunay, N and Chambers, R, 1996, Unaliased f-k domain trace interpolation
c   (UFKI): 66th Annual Int. Mtg., Soc Expl Geophys, Expanded Abstracts,1461-1464

c
c
c---------------------------------
c        declare variables
c---------------------------------
c        iounit defines all ascii i/o units used
c        sisdef defines the sis line & trace header structure
c        lhdrsz defines - trace header size (cray & sun)
c                       - max time dimension
c                       - max no. channels
c                       - sample size in bytes (cray & sun)
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
c________________________________
      integer     ITR (SZLNHD)
      integer     VTR (SZLNHD)
      integer     itrhd
      integer     ARGIS
      integer     lbyout
      integer     LUIN, LUOUT, NBYTES, LBYTES, NSAMP, NSI, NTRC, NREC
      integer     IRS, IRE, NS, NE, IFORM
      integer     ordfft
      integer     pipe, ierror
      character name * 6, ntap * 256, otap * 256, vtap * 256
c     pid defines all variables necessary to open printout files
#include <f77/pid.h>
c
      logical verbos, query, nmo_f_req, nmo_i_req, NMO, NMOV

	integer	n1,n2,nhigher
c
	integer	fd_in
c
	integer	n1w,n2w,n1_pad,n2_pad,n2wo,n2_out
	integer	n1wu,n2wu,n1we,n2we,n1wo
	integer	ncoeffs,ncoeffsi,dead
c       integer nrfft5
c
	real	d1,d2,o1,o2
c
	real	gather_in,gather_out,n1wu_tab,n2wu_tab,n1wo_tab,n2wo_tab
	real	gather_nmo,hess
	real	offset_in,offset_out
	real	K,F,K2
	real	taper,taperd
	complex	D,Dzo,Dze,A,Bo,Be,C,Oo,Oe,G,De,Atmp,Btmp
	complex coeffs,coeffsi
c
	pointer	(ptr_itrhd,itrhd(1))
	pointer	(ptr_gather_in,gather_in(1))
	pointer	(ptr_gather_out,gather_out(1))
	pointer	(ptr_gather_nmo,gather_nmo(1))
        pointer (ptr_hess,hess(1))
        pointer (ptr_offset_in,offset_in(1))
        pointer (ptr_offset_out,offset_out(1))
        pointer (ptr_coeffs,coeffs(1))
        pointer (ptr_coeffsi,coeffsi(1))
c
	pointer (ptr_n1wu_tab,n1wu_tab(1))
	pointer (ptr_n2wu_tab,n2wu_tab(1))
	pointer (ptr_n1wo_tab,n1wo_tab(1))
	pointer (ptr_n2wo_tab,n2wo_tab(1))
	pointer (ptr_D,D(1))
	pointer (ptr_De,De(1))
	pointer (ptr_Dze,Dze(1))
	pointer (ptr_Dzo,Dzo(1))
	pointer (ptr_A,A(1))
	pointer (ptr_Be,Be(1))
	pointer (ptr_Bo,Bo(1))
	pointer (ptr_Atmp,Atmp(1))
	pointer (ptr_Btmp,Btmp(1))
	pointer (ptr_C,C(1))
	pointer (ptr_G,G(1))
	pointer (ptr_Oo,Oo(1))
	pointer (ptr_Oe,Oe(1))
	pointer (ptr_K,K(1))
	pointer (ptr_K2,K2(1))
	pointer (ptr_F,F(1))
	pointer (ptr_taper,taper(1))
	pointer (ptr_taperd,taperd(1))
	pointer (ptr_dead,dead(1))

      real        tablh1, tablh2, zzh, mutei, muteo
      integer     izh
      pointer     (wktablh1, tablh1(1))
      pointer     (wktablh2, tablh2(1))
      pointer     (wkzzh   , zzh   (1))
      pointer     (wkizh   , izh   (1))
      pointer     (wkmutei ,mutei  (1))
      pointer     (wkmuteo ,muteo  (1))

      real  coefs(2,64), wrk1(3), wrk2(384)
      real  work1, work2
      pointer (ptr_work1, work1)
      pointer (ptr_work2, work2)
      logical filtr, mute

      data  name/'FKTERP'/
      data  pipe/3/
      data  NMOV/.false./
      data  NMO /.false./

c------------------------------------
c        initialize variables
c------------------------------------
      nbytes = 0
      lbytes = 0
c-------------------------------------------------------------------
c        If '-?' flag is used in command line, execute query
c        loop and end program.
c-------------------------------------------------------------------
      query = ( argis ( '-?' ) .gt. 0 .or. argis('-h') .gt. 0)
      if ( query ) then
         call help()
         stop
      end if

c---------------------------------------
c  open printout file
#include  <f77/open.h>
c---------------------------------------

      call cmdln(ntap, otap, vtap, ns, ne, irs, ire, verbos, vel,
     1           n1w, n2w, n1_pad, n2_pad, nmo_f_req, nmo_i_req,
     2           dxi, dxo, xi, xo, fl, fh, norder, filtr, mute)
c
c end of declarations
c 
c
c-------------------------------------------
c        Open input and output files
c-------------------------------------------
      call getln ( luin, ntap, 'r', 0)
      call getln (luout, otap, 'w', 1)

c
c ----- open velocity dataset -----
c
      NMO = .false.
      if (nmo_f_req .or. nmo_i_req) NMO = .true.

      IF (NMO) THEN
         if ( vel .eq. 0.0) then

            if (vtap .ne. ' ') then
               call getln(luvel,vtap,'r',-1)
            else
               write(LERR,*)'bdnmo assumed to be running inside IKP'
               call sisfdfit (luvel, pipe)
            endif
   
            if  (luvel .lt. 0)   then
               write(LERR,*)'Fatal: velocity file ',vtap,' not found.'
               write(LERR,*)' '
               stop
            endif
c read the velocity dataset line header

            call rtape(luvel,vtr,lvbytes)

            if(lvbytes .eq. 0) then
               write(LERR,*)'FATAL: no lineheader read on',vtap
               write(LERR,*)' '
               stop
            endif
            NMOV = .true.

            call saver(vtr, 'NumSmp', nsampv, LINHED)
            call saver(vtr, 'SmpInt', nsiv  , LINHED)
            call saver(vtr, 'NumTrc', ntrcv , LINHED)
            call saver(vtr, 'NumRec', nrecv , LINHED)
            call saver(vtr, 'Format', iformv, LINHED)
         endif


      ENDIF

c
c ----- read input lineheader -----
c

      call rtape(luin,itr,lbytes)

      if(lbytes .eq. 0) then
         write(LERR,*)'FATAL: no lineheader found on',ntap
         write(LERR,*)' '
         stop
      endif

c
c ----- save ususal lineheader values -----
c

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      call saver(itr, 'Dx1000', idx   , LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      samp = real (nsi) * unitsc

      filtr = .true.
      if (fl .eq. 0.0 .AND. fh .eq. 0.0) filtr = .false.
      if (filtr) then
         if (fl .eq. 0.) fl = 1.0
         fnyq = .5 / samp
         if (fh .eq. 0.0) fh = .8 * fnyq
         write(LERR,*)'low cut filter   = ',fl
         write(LERR,*)'high cut filter  = ',fh
         call bwcoef ( fl, fh, samp, coefs, xnorm, norder, ift)
      else
         write(LERR,*)'No bandpass filter'
      endif

c
c ----- print historical line header to printout file -----
c

c ----- check compatibility of command line entries -----
c

      call cmdchk(ns,ne,irs,ire,ntrc,nrec)


c----
c   the "1" direction is time
c   the "2" direction is space
c----


c       nhigher =fdds_axis_prod(3)
        nhigher = nrec

c       ier=fdds_scanf('size.axis(1)','%i\0',n1)
        n1 = nsamp
c       ier=fdds_scanf('size.axis(2)','%i\0',n2)
        n2 = ntrc

c       ier=fdds_scanf('delta.axis(1)','%f\0',d1)
        d1 = unitsc * nsi
c       ier=fdds_scanf('delta.axis(2)','%f\0',d2)
c       d2 = .001 * idx
        d2 = dxi

c       ier=fdds_scanf('origin.axis(1)','%f\0',o1)
c       ier=fdds_scanf('origin.axis(2)','%f\0',o2)
        o1 = 0.0
        o2 = xi

c       fd_in=fdds_open(in_hist,' ',' ','r')
c
c Now compute a bunch of things
c
	n1we=n1w+2*n1_pad
	n2we=n2w+2*n2_pad
c	n1we=nrfft5(n1we)
c	n2we=nrfft5(n2we)
	n1we=2**ordfft(n1we)
	n2we=2**ordfft(n2we)
	n1wu=n1we
	n2wu=n2we
	n2wo=2*n2wu
	n1wo=2*n1wu
	n2_out=2*n2
	ncoeffs=(n1wu+15)+(n2wu+15)
	ncoeffsi=(n1wu+15)+(n2wo+15)

      ntrco = n2_out - 1
      ntrco1= ntrco + 1
      call savew  (itr, 'NumTrc', ntrco , LINHED)
      call savhlh (itr, lbytes, lbyout)
      call wrtape (luout, itr, lbyout)

c
c allocate memory
c
      ierror = 0
      iabort = 0
      ner = 0
      ntot = ITRWRD + n1
      iget = SZSMPD * 2*ITRWRD*n2
      call galloc (ptr_itrhd, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * n1
      call galloc (ptr_work1, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * n1
      call galloc (ptr_work2, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * n1*n2
      call galloc (ptr_gather_in, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * n1*2*n2
      call galloc (ptr_gather_out, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1

      iget = SZSMPD * (n1+4)*n2_out
      call galloc (ptr_gather_nmo, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * (n1+4)*n2_out
      call galloc (ptr_hess, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1

c     iget = SZSMPD * (max(n1,n2) + 1)
      iget = SZSMPD * 2 * (max(n1wu,n2wu,n1wo,n2wo) + 1)
      call galloc (ptr_n1wu_tab, iget,ierror,iabort)
      call galloc (ptr_n2wu_tab, iget,ierror,iabort)
      call galloc (ptr_n1wo_tab, iget,ierror,iabort)
      call galloc (ptr_n2wo_tab, iget,ierror,iabort)
      iget = SZSMPD * n2
      call galloc (ptr_offset_in, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * n2_out
      call galloc (ptr_offset_out, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * 2*ncoeffs
      call galloc (ptr_coeffs, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD ** 2*ncoeffsi
      call galloc (ptr_coeffsi, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1

c
      iget = SZSMPD * 2*n1wu*n2wu
      call galloc (ptr_D, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * 2*n1we*n2we
      call galloc (ptr_De, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * 2*n1wu*n2wu
      call galloc (ptr_Dzo, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * 2*n1wu*n2wu
      call galloc (ptr_Dze, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1

      iget = SZSMPD * 2*n1wo*2*n2wo
      call galloc (ptr_A, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * 2*n1wo*2*n2wo
      call galloc (ptr_Bo, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * 2*n1wo*2*n2wo
      call galloc (ptr_Be, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * 2*n1wu*2*n2wo
      call galloc (ptr_Atmp, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1

      iget = SZSMPD * 2*n1wu*2*n2wo
      call galloc (ptr_Btmp, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * 2*n1wu*2*n2wo
      call galloc (ptr_C, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * 2*n1wu*2*n2wo
      call galloc (ptr_Oo, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * 2*n1wu*2*n2wo
      call galloc (ptr_Oe, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1

      iget = SZSMPD * 2*n1wu*2*n2wo
      call galloc (ptr_G, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * n2wu
      call galloc (ptr_K, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * n2wo
      call galloc (ptr_K2, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * n1wu
      call galloc (ptr_F, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * n1wu*n2wo
      call galloc (ptr_taper, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * n1wu*n2wu
      call galloc (ptr_taperd,iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * ntrco1
      call galloc (ptr_dead,iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * ntrc
      call galloc (wktablh1, iget, ierror, iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * ntrc
      call galloc (wkmutei, iget, ierror, iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * ntrco
      call galloc (wktablh2, iget, ierror, iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * ntrco
      call galloc (wkmuteo, iget, ierror, iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * 4 * ntrco1
      call galloc (wkzzh, iget, ierror, iabort)
      if(ierror.ne.0)ner=ner+1
      iget = SZSMPD * 4 * ntrco1
      call galloc (wkizh, iget, ierror, iabort)
      if(ierror.ne.0)ner=ner+1

      if (ner .eq. 0) then
         write(LERR,*)' '
         write(LERR,*)'Successfully allocated all arrays'
      else
         write(LERR,*)' '
         write(LERR,*)'FATAL ERROR in fkterp:'
         write(LERR,*)'Failed to allocate memory for main arrays'
         write(LER ,*)' '
         write(LER ,*)'FATAL ERROR in fkterp:'
         write(LER ,*)'Failed to allocate memory for main arrays'
         call ccexit (666)
      endif

c-----
c     build header word interpolation tables
c-----
      do  j = 1, ntrc
          tablh1(j) =  float( j-1 )
      enddo
      do  j = 1, ntrco1
          tablh2(j) =  float( j-1 ) * 0.5
      enddo

c
c Ok call the main subroutine that reads a "gather", an axis1,axis2 plane
c

	call gathermain(n1,n2,nhigher,fd_in,in_hist,gather_in,
     *            gather_out,
     *            gather_nmo,D,De,Dzo,Dze,A,Bo,Be,C,Oo,Oe,G,
     *            n1w,n2w,n1_pad,n2_pad,
     *            n1we,n2wo,F,K,K2,offset_in,offset_out,hess,
     *            coeffs,coeffsi,n2_out,ncoeffs,ncoeffsi,d1,
     *            d2,o1,o2,
     *            n2wu,n1wu,n2we,n1wo,Atmp,Btmp,taper,taperd,
     *            itr, vtr, SZLNHD, ITHWP1, ITRWRD, SZSMPD,
     *            lbytes, luin, luout, vel, luvel, ntot,
     *            itrhd,ierror,NMO,n1wu_tab,n2wu_tab,n1wo_tab,n2wo_tab,
     *            wrk1, wrk2, coefs, xnorm, norder, work1, work2,
     *            filtr, mute, nsi, tablh1, tablh2, zzh, izh,
     *            ntrc, ntrco1, mutei, muteo, dead)

c-------------------------------------------
c        Close files and end program
c-------------------------------------------
  999 continue
      call LBCLOS ( luin )
      call LBCLOS ( luout )
      if ( NMOV ) call LBCLOS ( luvel )
      write(LERR,*)'fkterp: normal end'
      write(LER ,*)'fkterp: normal end'

	stop
	end
c-------------------------------------------
c        online help
c-------------------------------------------
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     1 '***************************************************************'
         write(LER,*)
     1 'Run this program by typing: hode and the following arguments'
         write(LER,*)
     1 ' -N[ntap]    (no default)      : Input data file name'
         write(LER,*)
     1 ' -O[otap]    (no default)      : Output data file name'
         write(LER,*)' '
         write(LER,*)
     1 ' -vel[vel]        : optional constant velocity for internal NMO'
c        write(LER,*)
c    1 ' -v[vtap]         : optional velocity tape for internal NMO'
         write(LER,*)
     1 ' -NMO   do internal constant velocity NMO correction'
         write(LER,*)' '
         write(LER,*)
     1 ' -w[n1w] (def = 12)  : # time points in computational window'
         write(LER,*)
     1 ' -l[n2w] (def = 6)   : # spatial points in computational window'
         write(LER,*)
     1 ' -wpad[n1p] (def = 6): # time points in window pad'
         write(LER,*)
     1 ' -lpad[n2p] (def = 3): # spatial points in window pad'
c        write(LER,*)' '
c        write(LER,*)
c    1 ' -rs[irs] (default = 1)        : starting record'
c        write(LER,*)
c    1 ' -re[ire] (default=end)        : ending record'
c        write(LER,*)
c    1 ' -ns[ns] (default = 1)         : starting trace'
c        write(LER,*)
c    1 ' -ne[ne] (default=end of rec)  : ending trace'
c        write(LER,*)' '
         write(LER,*)' '
         write(LER,*)' '
         write(LER,*)
     1 ' -RM  restore mute using VPick1  (def = not used)'
         write(LER,*)
     1 ' -V  Verbose mode.  All command line and lineheader parameters'
         write(LER,*)
     1 '                    printed to output printout file'
         write(LER,*)' '
         write(LER,*)
     : 'USAGE:  '
         write(LER,*)
     : 'fkterp -N[] -O[] [ -vel[] -NMO -w[] -l[] -wpad[] -lpad[] -RM ]'
         write(LER,*)
     1 '***************************************************************'
      return
      end
