C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c 
c
c The main subroutine for processing a gather
c
c
c
	subroutine gathermain(n1,n2,nhigher,fd_in,in_hist,gather_in,
     1		gather_out,gather_nmo,D,De,Dzo,Dze,A,Bo,Be,C,Oo,Oe,G,
     2		n1w,n2w,n1_pad,n2_pad,
     2		n1we,n2wo,F,K,K2,offset_in,offset_out,hess,
     3		coeffs,coeffsi,n2_out,ncoeffs,ncoeffsi,d1,d2,o1,o2,
     4		n2wu,n1wu,n2we,n1wo,Atmp,Btmp,taper,taperd,
     5          itr, vtr, SZLNHD, ITHWP1, ITRWRD, SZSMPD,
     6          lbytes, luin, luout, v, luvel, ntot, itrhd,
     7          ierror,NMO,n1wu_tab,n2wu_tab,n1wo_tab,n2wo_tab,
     8          wrk1, wrk2, coefs, xnorm, norder, work1, work2,
     9          filtr, mute, nsi, tablh1, tablh2, zzh, izh,
     1          ntrc, ntrco, mutei, muteo, dead)
c
#include <f77/iounit.h>

	integer	n2_out
        integer SZLNHD, ITHWP1, ITRWRD, SZSMPD
        integer itr(ntot), vtr(ntot), dead(ntrco)
        integer itrhd(ITRWRD,n2_out)
        integer obytes, nbytes, ierror
	logical nmo_f_req,nmo_i_req, FIRST, NMO
c
	integer	sign
c
	integer	n1,n2,nhigher,n1_pad,n2_pad
	integer	n1w,n2w,n1we,n2wo,n2wu,n1wu,n2we,n1wo
	integer	ncoeffs,ncoeffsi
	integer	i,j,i3
	integer	nwin_1,nwin_2,iwin_1,iwin_2
	integer	i1,j1,i2,j2,ik,iw
	integer	f1,l1,f2,l2,f1_tru,f2_tru
	integer	q1,q2
	integer	nw_taper,nkx_taper	
	integer	nrem_1,nrem_2
	integer	n2w_use,n1w_use
c
	integer	fd_in
c
        real    tablh1(ntrc), tablh2(ntrco), zzh(4*ntrco)
        real    mutei(ntrc), muteo(ntrco)
        integer izh(4*ntrco)
        integer icinith

	real	v
	real	d1,d2,o1,o2
	real	pi
c	real	Ko2,Fo2
	real	maxBe,maxBo,epse,epso
c 	real	P1,P2,xj,rj,ti,ri
        real    xj,rj,ti,ri
	real	powero,poweri
c
	real	gather_in(n1,n2)
	real	gather_out(n1,n2_out)
	real	gather_nmo(n1+4,n2_out),hess(n1+4,n2_out)
        real    offset_in(n2)
        real    offset_out(n2_out)

	real	F(n1we)
	real	K(n2wo)
	real	K2(n2wo)
	real	n1wu_tab(*),n2wu_tab(*),n1wo_tab(*),n2wo_tab(*)
c
	real	taper(n1wu,n2wo)
	real	taperd(n1wu,n2wu)
c
	complex	De(n1we,n2we)
	complex	D(n1wu,n2wu)
	complex	Dzo(n1wu,n2wu)
	complex	Dze(n1wu,n2wu)
	complex	A(n1wo,n2wo)
	complex	Bo(n1wo,n2wo)
	complex	Be(n1wo,n2wo)
	complex	Atmp(n1wu,n2wo)
	complex	Btmp(n1wu,n2wo)
	complex	C(n1wu,n2wo)
	complex	Oo(n1wu,n2wo)
	complex	Oe(n1wu,n2wo)
	complex	G(n1wu,n2wo)
c
	complex	coeffs(ncoeffs)
	complex	coeffsi(ncoeffsi)

        real    coefs(2,64), wrk1(3), wrk2(384), work1(n1), work2(n1)
        logical filtr, mute

        icinith = 1

        ierror = 0
        FIRST = .true.
        if (NMO) nmo_f_req = .true.
        if (NMO) nmo_i_req = .true.

c
c end of declarations
c
	pi=3.1415926535

c     For trace header values we take mnemonics and build a
c     set of pointers
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,1)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,1)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,1)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,1)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,1)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,1)
      call savelu('SrcPnt',ifmt_SrcPnt,l_SrcPnt,ln_SrcPnt,1)
      call savelu('SoPtBi',ifmt_SoPtBi,l_SoPtBi,ln_SoPtBi,1)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,1)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,1)
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,1)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,1)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,1)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,1)
      call savelu('VPick1',ifmt_VPick1,l_VPick1,ln_VPick1,1)

c
c initialize the various fft's
c
c	call cfft2di(n1wu,n2wu,coeffs)
c	call cfft2di(n1wu,n2wo,coeffsi)

        call cfftx (coeffs, 2, n1wu, 0, 1, n1wu_tab, ierr)
        if (ierr .ne. 0) then
           write(LERR,*)'fkterp: Bad FFT initialization'
           call ccexit (666)
        endif
        call cfftx (coeffs, 2, n2wu, 0, 1, n2wu_tab, ierr)
        if (ierr .ne. 0) then
           write(LERR,*)'fkterp: Bad FFT initialization'
           call ccexit (666)
        endif
        call cfftx (coeffs, 2, n1wo, 0, 1, n1wo_tab, ierr)
        if (ierr .ne. 0) then
           write(LERR,*)'fkterp: Bad FFT initialization'
           call ccexit (666)
        endif
        call cfftx (coeffs, 2, n2wo, 0, 1, n2wo_tab, ierr)
        if (ierr .ne. 0) then
           write(LERR,*)'fkterp: Bad FFT initialization'
           call ccexit (666)
        endif
c
	nwin_1=n1/n1w
	nwin_2=n2/n2w
c
        nrem_1 = 0
        nrem_2 = 0
 	nrem_1=n1-n1w*nwin_1
 	nrem_2=n2-n2w*nwin_2
	if(nrem_1 .ne. 0)nwin_1=nwin_1+1
	if(nrem_2 .ne. 0)nwin_2=nwin_2+1

c
        if(nmo_f_req .and. v .eq. 0.)then
           write(LER,*)'Error, if you want to do NMO, you must supply'
           write(LER,*)'v. You can only do constant velocity NMO btw.'
           stop
        end if
        if(nmo_i_req .and. v .eq. 0.)then
           write(LER,*)'Error, if you want to do iNMO, you must supply'
           write(LER,*)'v. You can only do constant velocity NMO btw.'
           stop
        end if
c
c get the length of the taper of the operator
c
	nw_taper=n1wu/2
c
	nkx_taper=n2wo/2
c
        do  j = 1, ntrco
            dead(j) = 0
        enddo
        initf = 1
        DO  KK = 1, n2
            nbytes = 0
            call rtape (luin, itr, nbytes)
            if (nbytes .eq. 0) then
               write(LERR,*)'FATAL ERROR in fkinterp'
               write(LERR,*)'First gather appears too short, i.e.'
               write(LERR,*)'hit end of file before end of spread'
               ierror = 999
               return
            endif
            call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,istat,1)
            if (istat .eq. 30000) then
               dead(2*(KK-1) + 1) = 1
            endif
            call vmov (itr, 1, itrhd(1,KK), 1, ITRWRD)
            if (filtr) then
               call vmov (itr(ITHWP1), 1, work1, 1, n1)
               call bwfilt ( work1, work2, wrk1, wrk2, coefs,
     1                       xnorm, norder, n1, initf, 0)
               initf = 0
               call vrvrs  ( work2, 1, n1)
               call bwfilt ( work2, work1, wrk1, wrk2, coefs,
     1                       xnorm, norder, n1, initf, 0)
               call vrvrs  ( work1, 1, n1)
               call vmov (work1, 1, gather_in(1,KK), 1, n1)
            else
               call vmov (itr(ITHWP1), 1, gather_in(1,KK), 1, n1)
               if (mute) then
                  call mutdet (itr(ITHWP1), imon, imoff, n1)
                  mutei (KK) = float(imon)
               endif
            endif

            call saver2(itr,ifmt_DstSgn,l_DstSgn,ln_DstSgn,ioff,1)
            offset_in (KK) = ioff
        ENDDO

c---
c  interpolate mutes
c---
        if (mute) then
           call fcuint (tablh1,mutei,ntrc,tablh2,muteo,ntrco,
     1                  izh, zzh, icinith)
           icinith = 0
        endif

        if(d2 .ne. 0.0)then
c
          do i2=1,n2
            offset_in(i2)=o2+(i2-1)*d2
          end do
        end if
c
c compute the output offsets
c
        do i2=1,n2-1
           offset_out(i2)=(offset_in(i2)+offset_in(i2+1))/2.
        end do
        offset_out(n2)=offset_in(n2)+offset_in(n2)-offset_in(n2-1)
c
        obytes = (ITRWRD + n1) * SZSMPD
        ntrc = n2_out - 1
        nsamp = n1
        idx = 1000 * (d2/2)
c
c
c make the wavenumber arrays, and then the interpolation
c coefficients
c
	do ik=2,n2wu/2
		K(ik)=(ik-1)
		K(n2wu-ik+2)=-K(ik)
	end do
		K(1)=0.
		K(n2wu/2+1)=n2wu/2
c
	do ik=2,n2wo/2
		K2(ik)=(ik-1)
		K2(n2wo-ik+2)=-K2(ik)
	end do
		K2(1)=0.
		K2(n2wo/2+1)=n2wo/2
c
	do iw=2,n1wu/2
		F(iw)=(iw-1)
		F(n1wu-iw+2)=-F(iw)
	end do
		F(1)=0.
		F(n1wu/2+1)=n1wu/2
c
c Compute various taper functions, one for the operator,
c one for the various bits of data that come through
c
	do j=1,n2wo
	   do i=1,n1wu
		taper(i,j)=0.
	   end do
	end do
c
	taper(1,1)=1.
c 
	do j=2,nkx_taper
c
	    xj=float(j-1)
c
	    rj=float(nkx_taper+1)
c
	    do i=2,nw_taper
c
		 ti=float(i-1)
	         ri=float(nw_taper+1)
c
		 taper(i,j)=
     1            .5*(1.+cos(pi*xj/rj))*.5*(1.+cos(pi*ti/ri))
		 taper(n1wu-i+2,j)=
     1            .5*(1.+cos(pi*xj/rj))*.5*(1.+cos(pi*ti/ri))
		 taper(i,n2wo-j+2)=
     1            .5*(1.+cos(pi*xj/rj))*.5*(1.+cos(pi*ti/ri))
		 taper(n1wu-i+2,n2wo-j+2)=
     1            .5*(1.+cos(pi*xj/rj))*.5*(1.+cos(pi*ti/ri))
c
	    end do
	end do
c
	i=1
	do j=2,nkx_taper
	    xj=float(j-1)
	    rj=float(nkx_taper+1)
	    taper(i,j)=.5*(1.+cos(pi*xj/rj))
	    taper(i,n2wo-j+2)=.5*(1.+cos(pi*xj/rj))
	end do
c
	j=1
	do i=2,nw_taper
		 ti=float(i-1)
	         ri=float(nw_taper+1)
		 taper(i,j)=.5*(1.+cos(pi*ti/ri))
		 taper(n1wu-i+2,j)=.5*(1.+cos(pi*ti/ri))
	end do
c
c
c
c
	do j=1,n2wu
c
	    xj=float(j)-(float(n2wu/2)+.5)
	    rj=float(n2wu/2)-.5
c
	    do i=1,n1wu
c
		 ti=float(i)-(float(n1wu/2)+.5)
	         ri=float(n1wu/2)-.5
c
                 taperd(i,j)=
     1            (.5*(1.+cos(pi*xj/rj))*.5*(1.+cos(pi*ti/ri)))**.125
c
	    end do
	end do
c
c
c Outermost loop is over gathers
c
c
c
	do i3=1,nhigher
c
c read the gather
c
           initf = 1
           IF (.not. FIRST) THEN
              do  j = 1, ntrco
                  dead(j) = 0
              enddo
           DO  KK = 1, n2
               nbytes = 0
               call rtape (luin, itr, nbytes)
               if (nbytes .eq. 0) then
                  write(LERR,*)'FATAL ERROR in fkinterp'
                  write(LERR,*)'First gather appears too short, i.e.'
                  write(LERR,*)'hit end of file before end of spread'
                  ierror = 999
                  return
               endif
               call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,istat,1)
               if (istat .eq. 30000) then
                  dead(2*(KK-1) + 1) = 1
               endif
               if (filtr) then
                  call vmov (itr(ITHWP1), 1, work1, 1, n1)
                  call bwfilt ( work1, work2, wrk1, wrk2, coefs,
     1                          xnorm, norder, n1, initf, 0)
                  initf = 1
                  call vrvrs  ( work2, 1, n1)
                  call bwfilt ( work2, work1, wrk1, wrk2, coefs,
     1                          xnorm, norder, n1, initf, 0)
                  call vrvrs  ( work1, 1, n1)
                  call vmov (work1, 1, gather_in(1,KK), 1, n1)
               else
                  call vmov (itr(ITHWP1), 1, gather_in(1,KK), 1, n1)
                  if (mute) then
                     call mutdet (itr(ITHWP1), imon, imoff, n1)
                     mutei (KK) = float(imon)
                  endif
               endif
c              call vmov (itr(ITHWP1), 1, work1, 1, n1)
               call vmov (itr, 1, itrhd(1,KK), 1, ITRWRD)
               call saver2(itr,ifmt_DstSgn,l_DstSgn,ln_DstSgn,ioff,1)
               offset_in (KK) = ioff
           ENDDO

c---
c  interpolate mutes
c---
           if (mute) then
              call fcuint (tablh1,mutei,ntrc,tablh2,muteo,ntrco,
     1                     izh, zzh, icinith)
              icinith = 0
           endif

c
c compute the output offsets
c
           do i2=1,n2-1
              offset_out(i2)=(offset_in(i2)+offset_in(i2+1))/2.
           end do
           offset_out(n2)=offset_in(n2)+offset_in(n2)-offset_in(n2-1)

           ENDIF
           FIRST = .false.

c---
c  look for original dead traces. If found then make sure interpolated
c  places on either side are also marked dead
c---
      do  i = 1, n2
          iv = dead (2*(i-1)+1)
          if (iv .eq. 1) then
             id  = 2*(i-1) + 1
             id1 = id-1
             id2 = id+1
             if (id1 .gt. 1) dead (id1) = 1
              dead (id2) = 1
          endif
      enddo
c
           if(nmo_f_req)then
                call cv_nmo (gather_in,n1,n2,d1,o1,offset_in,v,
     1                      gather_nmo)
	   end if
c
c Now, loop over space windows and time windows (to increase stationarity)
c 
	   do iwin_2=1,nwin_2
		do iwin_1=1,nwin_1
c
c This is where the data actually start
c
		   f1_tru=(iwin_1-1)*n1w+1
		   f2_tru=(iwin_2-1)*n2w+1
c
c taking a first cut at where the padded window starts and ends
c
		   f1=f1_tru-n1_pad
		   f2=f2_tru-n2_pad
c
		   l1=f1+n1we-1
		   l2=f2+n2we-1
c
c Ok, first check to see if we are off the end on the high side, if so
c adjust everything down accordingly
c
		   if(l1 .gt. n1)then
		     l1=n1
		     f1=l1+1-n1we
		   end if
c
		   if(l2 .gt. n2)then
		     l2=n2
		     f2=l2+1-n2we
		   end if
c
c Ok, last adjustment which will override the previous if need be,
c see if we are off the low side
c
		   if(f1 .lt. 1)then
		     f1=1
		     l1=f1-1+n1we
		   end if
c
		   if(f2 .lt. 1)then
		     f2=1
		     l2=f2-1+n2we
		   end if
c
c extract the data for this window
c
                   call extractD(gather_in,De,n1,n2,n1we,n2we,f1,f2)
c
		   do i2=1,n2we
		      do i1=1,n1we
			 D(i1,i2)=De(i1,i2)
		      end do
		   end do
c
c Fill on odd and zero the even traces
c
		    do i2=1,n2wu,2
			do i1=1,n1wu
			   Dze(i1,i2)=D(i1,i2)
			end do
		    end do
c
		    do i2=2,n2wu,2
			do i1=1,n1wu
			   Dze(i1,i2)=cmplx(0.,0.)
			end do
		    end do
c
		    do i2=2,n2wu,2
			do i1=1,n1wu
			   Dzo(i1,i2)=D(i1,i2)
			end do
		    end do
c
		    do i2=1,n2wu,2
			do i1=1,n1wu
			   Dzo(i1,i2)=cmplx(0.,0.)
			end do
		    end do
c
c Fill in the zero trace interlace window
c
                    do i2=1,n2wo
                        do i1=1,n1wu
                           C(i1,i2)=cmplx(0.,0.)
                        end do
                    end do
 
                    do i2=1,n2wu
                        j2=2*i2-1
                        do i1=1,n1wu
                           C(i1,j2)=D(i1,i2)
                        end do
                    end do

c
c taper D and Dz
c
 		    do j=1,n2wu
 		       do i=1,n1wu
 			  D(i,j)=taperd(i,j)*D(i,j)
                          Dzo(i,j)=taperd(i,j)*Dzo(i,j)
                          Dze(i,j)=taperd(i,j)*Dze(i,j)
 		       end do
 		    end do
c
c Make the 2D fft of the "original" window
c
		    sign=1
		    call cfft2d (D,n1wu,n2wu,sign,n1wu,0,
     1                          n1wu_tab,n2wu_tab,ierr)
c		    call cfft2d(D,n1wu,n2wu,sign,n1wu)
c
c make the 2Dfft of the zeroed alternate trace version of the original
c
		    sign=1
                    call cfft2d (Dze,n1wu,n2wu,sign,n1wu,0,
     1                          n1wu_tab,n2wu_tab,ierr)
c		    call cfft2d(Dze,n1wu,n2wu,sign,n1wu)
c
		    sign=1
                    call cfft2d (Dzo,n1wu,n2wu,sign,n1wu,0,
     1                          n1wu_tab,n2wu_tab,ierr)
c		    call cfft2d(Dzo,n1wu,n2wu,sign,n1wu)
c
c make the 2Dfft of the zero-trace-interlaced double sample rate version
c
		    sign=1
                    call cfft2d (C,n1wu,n2wo,sign,n1wu,0,
     1                          n1wu_tab,n2wo_tab,ierr)
c		    call cfft2d(C,n1wu,n2wo,sign,n1wu)
c
c
		    call stretch(D,A,Atmp,n1wu,n2wu,n1wo,n2wo,
     1                           n1wu_tab,n2wu_tab,n1wo_tab,n2wo_tab)
		    call stretch(Dze,Be,Btmp,n1wu,n2wu,n1wo,n2wo,
     1                           n1wu_tab,n2wu_tab,n1wo_tab,n2wo_tab)
		    call stretch(Dzo,Bo,Btmp,n1wu,n2wu,n1wo,n2wo,
     1                           n1wu_tab,n2wu_tab,n1wo_tab,n2wo_tab)
c
c Find the max value of the "B" operators
c
		    maxBe=0.
		    maxBo=0.
c
		    do j=1,n2wo
			do i=1,n1wo
			   maxBe=max(maxBe,cabs(Be(i,j)))
			   maxBo=max(maxBo,cabs(Bo(i,j)))
			end do
		    end do
c
		    if(maxBe .ne. 0.)then
		      epse=.001*maxBe
		    else
		      epse=1.
		    end if
c
		    if(maxBo .ne. 0.)then
		      epso=.001*maxBo
		    else
		      epso=1.
		    end if
c
c Make the interpolation operators
c
		    do j=1,n2wo
			do i=1,n1wu/2+1
			   Oe(i,j)=A(i,j)/(Be(i,j)+epse)
			   Oo(i,j)=A(i,j)/(Bo(i,j)+epso)
			end do
c
			do i=2,n1wu/2
			   Oe(n1wu-i+2,j)=
     1                     A(n1wo-i+2,j)/(Be(n1wo-i+2,j)+epse)
			   Oo(n1wu-i+2,j)=
     1                     A(n1wo-i+2,j)/(Bo(n1wo-i+2,j)+epso)
			end do
c
		    end do
c
c adjust the magnitude of this operator, so that it is less than 2
c
		   do j=1,n2wo
		        do i=1,n1wu
				if(cabs(Oe(i,j)) .gt. 2. )
     1				   Oe(i,j)=2.*Oe(i,j)/cabs(Oe(i,j))
				if(cabs(Oo(i,j)) .gt. 2. )
     1				   Oo(i,j)=2.*Oo(i,j)/cabs(Oo(i,j))
			end do
		   end do
c
c Inverse 2Dfft that operator 
c
		    sign=-1
                    call cfft2d (Oe,n1wu,n2wo,sign,n1wu,0,
     1                          n1wu_tab,n2wo_tab,ierr)
                    call cfft2d (Oo,n1wu,n2wo,sign,n1wu,0,
     1                          n1wu_tab,n2wo_tab,ierr)
c		    call cfft2d(Oe,n1wu,n2wo,sign,n1wu)
c		    call cfft2d(Oo,n1wu,n2wo,sign,n1wu)
c
c apply a taper
c
		    do j=1,n2wo
			do i=1,n1wu
		           Oe(i,j)=Oe(i,j)*taper(i,j)
		           Oo(i,j)=Oo(i,j)*taper(i,j)
		        end do
		    end do
c
c 2Dfft that operator back to wavenumber
c
		    sign=1
                    call cfft2d (Oe,n1wu,n2wo,sign,n1wu,0,
     1                          n1wu_tab,n2wo_tab,ierr)
                    call cfft2d (Oo,n1wu,n2wo,sign,n1wu,0,
     1                          n1wu_tab,n2wo_tab,ierr)
c		    call cfft2d(sign,n1wu,n2wo,Oo,n1wu,coeffsi)
c		    call cfft2d(Oo,n1wu,n2wo,sign,n1wu)
c
c now use that to make the interpolated spectrum
c
		    do j=1,n2wo
		       do i=1,n1wu
			  G(i,j)=.5*(Oe(i,j)+Oo(i,j))*C(i,j)
		       end do
		    end do
c
c Inverse 2Dfft that 
c
		    sign=-1
                    call cfft2d (G,n1wu,n2wo,sign,n1wu,0,
     1                          n1wu_tab,n2wo_tab,ierr)
c		    call cfft2d(G,n1wu,n2wo,sign,n1wu)
c
c compute the energy in the version of the existing traces that
c we have here to make a global scale factor
c
		    powero=0.
		    poweri=0.
		    do i2=1,n2we
			j2=2*i2-1
			do i1=1,n1we
			   powero=powero+real(G(i1,j2))**2
			   poweri=poweri+real(De(i1,i2))**2
			end do
		    end do
c
		    if(powero .ne. 0.)then
		       powero=sqrt(poweri/powero)
		    else
		       powero=1.
		    end if
c
c Insert the correct things into the output, this involves filling in
c the new traces, applying inverse NMO if required
c
		    if(iwin_2 .eq. nwin_2 .and. nrem_2 .ne. 0)then
			n2w_use=nrem_2
		    else
			n2w_use=n2w
		    end if
c
		    if(iwin_1 .eq. nwin_1 .and. nrem_1 .ne. 0)then
			n1w_use=nrem_1
		    else
			n1w_use=n1w
		    end if
c
		    do i2=1,n2w_use
c
			j2=f2_tru+i2-1
			q2=2*(f2_tru-f2+i2)
c
			do i1=1,n1w_use
		           j1=f1_tru+i1-1
			   q1=f1_tru-f1+i1
c
			   gather_out(j1,j2)=real(G(q1,q2))*powero
c
			end do
		    end do
c
c all done for this little subwindow
c
	        end do
	   end do
c
	   if(nmo_i_req)then
                call cv_inmo(gather_in,n1,n2,d1,o1,offset_in,v,
     1                       gather_nmo,hess)
                call cv_inmo(gather_out,n1,n2,d1,o1,
     1                       offset_out,v,gather_nmo,hess)
	   endif
c
c Now we have a full output gather assembled
c Keep in mind our interped output will be n2_out-1 traces, i.e. we do
c not output trace n2_out since we are not extrapolating a trace outside
c the old spread boundaries.
c Also if asked we will do a restore mute on all output traces
c

           itrc = 0
           do i2=1,n2

             itrc = itrc + 1
             id  = dead (itrc)

             call vmov (itrhd(1,i2), 1, itr, 1, ITRWRD)
             call vmov (gather_in (1,i2), 1, itr(ITHWP1), 1, n1)
             if (mute) then
                im = nint (muteo(itrc))
                call mutres (itr(ITHWP1), im, n1, n1)
             endif
             call savew2(itr, ifmt_TrcNum,l_TrcNum,ln_TrcNum, itrc,1)
             if (id .eq. 1) then
                call vclr (itr(ITHWP1), 1, n1)
                call savew2(itr, ifmt_StaCor,l_StaCor,ln_StaCor, 
     1                      30000,1)
             endif
             call wrtape (luout, itr, obytes)

             if (i2 .ne. n2) then
                call vmov (gather_out(1,i2), 1, itr(ITHWP1), 1, n1)
                io = offset_out (i2)
                itrc = itrc + 1
                id  = dead (itrc)
                if (mute) then
                   im = nint (muteo(itrc))
                   call mutres (itr(ITHWP1), im, n1, n1)
                endif
                call savew2(itr, ifmt_TrcNum,l_TrcNum,ln_TrcNum, itrc,1)
                call savew2(itr, ifmt_DstSgn,l_DstSgn,ln_DstSgn, io, 1)
                if (id .eq. 1) then
                   call vclr (itr(ITHWP1), 1, n1)
                   call savew2(itr, ifmt_StaCor,l_StaCor,ln_StaCor, 
     1                         30000,1)
                endif
                call wrtape (luout, itr, obytes)
             endif

           end do
c
c All done with this gather
c
	end do
c
c all done with all gathers
c
        ierror = 0
	return
	end

