C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Irregular_Grid_Interpolation (irec, imaxv,
     :     N1start, N2start, N1picks, N2picks,
     :     Record_Picks, Trace_Picks, Time_Picks,
     :     Trace_int, Time_int, ntraces)
c
c========================================================================
c     Subroutine to peform an irregular grid interplation via a series
c     of linear interpolations
c     This is done because memory limits permits us from filling out
c     an unknown size grid so it has to do be done on the fly.
c     
c     James M. Gridley
c     Paul Gutowski
c     USP Team
c     May 1996
c     Amoco
c========================================================================
c      INPUT
c     _____________
c     Record_Picks:    array of Record values
c     Trace_Picks:     array of Trace Values
c     Time_Picks:      array of Time Values
c     N1start:         points to the start of the first array
c     N2start:         points to the start of the second array
c     N1picks:         number of picks in first array
c     N2picks:         number of picks in the second array
c    
c
c     OUTPUT
c     ------
c     Trace_int:       trace values of interpolated Time_int
c     Time_int:        time values of interpolated functions
c     ntrace:          number of traces which have been interpolated
c========================================================================
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      Real     Record_Picks(*), Trace_Picks(*)
      Real     Time_Picks(*)
      Real     Trace_int(SZLNHD),Time_int(SZLNHD)

      Integer  N1start,N2start,N1picks,N2picks
      integer  imaxv, ntraces

      
c     declare variables used in subroutine

      Integer  errcd1, errcd2,errcd3,errcd4,errcd5
      Integer  errcd6,errcd7
      Integer  errcd8, errcd9, errcd10, errcd11

      pointer  (memadr_work1_rec, work1_rec(200000))
      pointer  (memadr_work1_trc, work1_trc(200000))
      pointer  (memadr_work1_tim, work1_tim(200000))
      pointer  (memadr_work2_rec, work2_rec(200000))
      pointer  (memadr_work2_trc, work2_trc(200000))
      pointer  (memadr_work2_tim, work2_tim(200000))
      pointer  (memadr_space1, space1(200000))
      pointer  (memadr_space2, space2(200000))
      pointer  (memadr_space3, space3(200000))
      pointer  (memadr_time1, time1(200000))
      pointer  (memadr_time2, time2(200000))
      pointer  (memadr_Time_Output, Time_Output(200000))

c========================================================================
      call galloc (memadr_work1_rec, imaxv* SZSMPD, 
     :     errcd1, abort)
      call galloc (memadr_work1_trc, imaxv* SZSMPD, 
     :     errcd2, abort)
      call galloc (memadr_work1_tim, imaxv* SZSMPD, 
     :     errcd3, abort)
      call galloc (memadr_work2_rec, imaxv* SZSMPD, 
     :     errcd4, abort)
      call galloc (memadr_work2_trc, imaxv* SZSMPD, 
     :     errcd5, abort)
      call galloc (memadr_work2_tim, imaxv* SZSMPD, 
     :     errcd6, abort)
      call galloc (memadr_space1, imaxv* SZSMPD, 
     :     errcd7, abort)
      call galloc (memadr_space2, imaxv* SZSMPD, 
     :     errcd8, abort)
      call galloc (memadr_Time_Output, imaxv* SZSMPD, 
     :     errcd9, abort)
      call galloc (memadr_time1, imaxv* SZSMPD, 
     :     errcd10, abort)
      call galloc (memadr_time2, imaxv* SZSMPD, 
     :     errcd11, abort)
      
      if ( errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 .or.
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 .or.
     :     errcd6 .ne. 0 .or.
     :     errcd7 .ne. 0 .or.
     :     errcd8 .ne. 0 .or.
     :     errcd9 .ne. 0 .or.
     :     errcd10 .ne. 0 .or.
     :     errcd11 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) imaxv * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) imaxv * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      endif

c==========================================================
c     Write the two bounding arrays into work areas for use

      do i = N1Start,  N1Picks 
         
         work1_rec(i-N1Start+1) = Record_Picks(i)
         work1_trc(i-N1Start+1) = Trace_Picks(i) 
         work1_tim(i-N1Start+1) = Time_Picks(i)
         
      enddo
      
      do i = N2Start,  N2Picks
         work2_rec(i-N2Start+1) = Record_Picks(i)
         work2_trc(i-N2Start+1) = Trace_Picks(i)
         work2_tim(i-N2Start+1) = Time_Picks(i)
         
      enddo
c========================================================================
c     interpolate the trace/time arrays to one common the number of values,
c     the maximum of the two will be used.


     
      call Resample_Series(work1_trc,work1_tim,N1Picks-N1Start+1,imaxv,
     :     space1,time1, imaxv)


         
      call Resample_Series(work2_trc,work2_tim,N2Picks-N2Start+1,imaxv,
     :     space2,time2, imaxv)

      
c========================================================================
c     now work through each record producing an interpreted value for each 
c     Recored,Trace Position.
      
      do i = 1, imaxv
         call Pick_Interpolation(Record_Picks(N1Start),
     :        Record_Picks(N2Start),time1(i),
     :        time2(i),float(irec),Time_Output(i), imaxv)
        
      enddo
c========================================================================     
c     Find the trace endpoint for this record(irec)
c     
      call Pick_Interpolation(Record_Picks(N1Start),
     :     Record_Picks(N2Start),Trace_Picks(N1Start),
     :     Trace_Picks(N2start),float(irec),trace1, imaxv)
  
      
      call Pick_Interpolation(Record_Picks(N1Start),
     :     Record_Picks(N2Start),Trace_Picks(N1Picks),
     :     Trace_Picks(N2Picks),float(irec),trace2, imaxv)  
       

c     Now trace1 and trace2 are the endpoints at irec, these need to
c     be an integer, so round the value to the nearest integer then we
c     will be able to resample the trace values to these endpoints and
c     get on with life.
c     

      itrace1 = nint (trace1)
      itrace2 = nint (trace2)

c      write(6,*)'Trace Numbers ',itrace1,itrace2,irecq
c========
c     get the number of integer traces in the record
c========
      ntraces = itrace2 - itrace1 + 1    
c      write(6,*)'Number of Traces ',ntraces
c========================================================================

        call galloc (memadr_space3, imaxv * SZSMPD, 
     :       errcd11, abort)

c ########### here is the cockroach.....what is this supposed to be doing.   It
c does not calculate out to ntraces.  In this logic space3[imaxxv] is only
c 236 instead of 240 so that traces beyond that get loaded with rubbish

c looks like resample-series doesn't handle extrapolation.  Talk to James
c about this tomorrow and construct a fix.  Actually get him to do it 
c and get on with Cairo stuff.



c     imaxv = max number of actual picks

c        dt = float ((itrace2-itrace1)/(imaxv-1))
        dt =  (float(itrace2-itrace1)/float(imaxv-1))
       
        do i = 1, imaxv
           space3(i) = itrace1 + (i-1)*dt
c           write(6,*)i,space3(i)   
        enddo
        
        do i = 1, imaxv
c           write(6,*)i,space3(i),Time_Output(i),imaxv,ntraces,
c c    :          itrace1,itrace2,dt
        enddo
           
      call Resample_Series(space3,Time_Output,imaxv,ntraces,
     :    Trace_int,Time_int, imaxv)

      

c========================================================================
 999  return
      end
