C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine PickReader (lupick,SortFlag,NumPicks,NumSegs, 
     :     Record_Picks, Trace_Picks, Time_Picks, NumEntries,
     :     RecUnits, ra, rb, rc,
     :     TrcUnits, SmpUnits, RecOffset, TrcOffset, SmpOffset,
     :     icount )
      
c This routine will read in an XSD pickfile and return the following:
c
c Record()     : array of record entries
c Trace()      : array of trace entries
c Sample()     : array of sample entries
c NumPicks()   : number of picks in the segment
c NumSegments  : number of segments in pickfile  
c icount       : total number of picks in pickfile
c
c 1. determine number of segments and number of picks/segment
c 2. allocate appropriate memory
c 3. rewind pickfile
c 4. read picks
c 5. sort picks within segments based on either Record or Trace 
c    [whichever accumulates faster] if requested [SortFlag = 1]


#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer lupick,  NumSegs, SortFlag, count
      integer NumEntries
      
      integer  NumPicks(NumEntries*NumSegs)

c      real    Record_Picks(NumEntries*NumSegs)
c      real    Trace_Picks(NumEntries*NumSegs)
c      real    Time_Picks(NumEntries*NumSegs)
      real    Record_Picks(*)
      real    Trace_Picks(*)
      real    Time_Picks(*)     
      real    ra(NumEntries),rb(NumEntries),rc(NumEntries)
   
      logical RecordWise
      
c     subroutine specific variables
      
      integer nseg, ncolor, icount
      
      character iname*20
      
c     initialize variables
      
      RecordWise = .true.

c read picks

      count = 0

      DO i = 1, NumSegs

         read ( lupick, 101, end = 920, err = 910 ) nseg, iname, ncolor, 
     :        NumPicks(i)
 101     format (10x,i5,6x,a20,10x,i5,9x,i5) 

        
         do j = 1, NumPicks(i)
            
            count = count + 1
            read ( lupick, 102, end = 920, err = 910 ) 
     :           Record_Picks(count), 
     :           Trace_Picks(count), 
     :           Time_Picks(count)

	Time_Picks(count)=Time_Picks(count)-SmpOffset

 102        format (f12.6,1x,f12.6,1x,f12.6)
            
c	write(6,*)count,Record_Picks(count)
         enddo

      ENDDO
      icount = count
c 3 way sorting
      


c	goto 444


c      ib = 0
c      ia = 1
c      do i = 1, NumSegs
c         inum = (ib+NumPicks(i)) - ia + 1
         
c         do k = ia, ib+NumPicks(i)

c            ra(k-ia+1)=Record(k)
c            rb(k-ia+1)=Trace(k)
c            rc(k-ia+1)=Sample(k)
c         enddo
c=======================================================================       
c     Record Sort         
c         do jj = 2,inum
c            do ii = 1, jj
c               if (ra(ii) .lt. ra(ii-1)) then
c                  tmpra=ra(ii)
c                  tmprb=rb(ii)
c                  tmprc=rc(ii)
c                  ra(ii) = ra(ii-1)
c                  rb(ii) = rb(ii-1)
c                  rc(ii) = rc(ii-1)
c                  ra(ii-1)=tmpra
c                  rb(ii-1)=tmprb
c                  rc(ii-1)=tmprc
c               endif
c            enddo
c         enddo
cc=======================================================================
cc     Trace Sort
c         do jj = 2,inum
c            do ii = 1, jj
c               if (rb(ii) .lt. rb(ii-1)) then
c                  tmpra=ra(ii)
c                  tmprb=rb(ii)
c                  tmprc=rc(ii)
c                  ra(ii) = ra(ii-1)
c                  rb(ii) = rb(ii-1)
c                  rc(ii) = rc(ii-1)
c                  ra(ii-1)=tmpra
c                  rb(ii-1)=tmprb
c                  rc(ii-1)=tmprc
c               endif
c            enddo
c         enddo
c=======================================================================
c         do k = ia, ib+NumPicks(i)
c            Record(k)= ra(k-ia+1)
c            Trace(k) = rb(k-ia+1)
c            Sample(k) = rc(k-ia+1)
c         enddo         
c         
c         ia = NumPicks(i) + ia
c         ib = ib + NumPicks(i)
c      enddo
c 
 444      icount=0
          do i = 1,NumSegs
         do k = 1,NumPicks(i)
            icount=icount+1
c            write(6,*)Record_Picks(icount),Trace_Picks(icount)	
c            write(6,*)icount,Record_Picks(icount),Trace_Picks(icount)
            enddo
         enddo
         return
     

 910  continue
       
      write(LERR,*)' '
      write(LERR,*)' ERROR reading XSD pickfile.'
      write(LERR,*)' FATAL '
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)' ERROR reading XSD pickfile.'
      write(LER,*)' FATAL '
      write(LER,*)' '
      stop

 920  continue

      write(LERR,*)' '
      write(LERR,*)' Premature EOF while reading XSD pickfile'
      write(LERR,*)' FATAL '
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)' Premature EOF while reading XSD pickfile'
      write(LER,*)' FATAL '
      write(LER,*)' '
      stop

      end
