C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  convert traces from program timfreq to seismic
C                     traces
C
C**********************************************************************C
C
C freqtim READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C does complex fft on each trace, and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR ( 2*SZLNHD )
      INTEGER     LHED( 2*SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LUOUT, LBYTES, NBYTES,obytes
      integer     argis
      real        degrad
      REAL        xtr ( 8*SZLNHD )
      REAL        amp ( 8*SZLNHD ), phz  ( 8*SZLNHD )
      COMPLEX     ctr ( 4*SZLNHD )
      CHARACTER   NAME * 7,  ntap * 256, otap * 256
#include <f77/pid.h>
      logical     verbos,query,pack,mute,RI
 
      EQUIVALENCE ( ITR(  1), LHED(1) )

      DATA     NAME /'FREQTIM'/
      DATA     LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      DATA     obytes / 0 /
      DATA     verbos /.false./
      DATA     degrad/.017453293/

c---------------------------------
c  get online help if necessary
c---------------------------------
      query = (argis('-?') .gt. 0 .or. argis('-h') .gt. 0)
      if( query ) then
          call help ()
          stop
      endif

c---------------------------------
c  open printout files
c---------------------------------
#include <f77/open.h>

c---------------------------------------------------------------
c  read program parameters from command line
c---------------------------------------------------------------
      call cmdln(ntap,otap,verbos,rot,pack,mute,RI)

C**********************************************************************C
C     open logical units
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C

      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)

      lbytes=0
      CALL RTAPE  ( LUIN, ITR, LBYTE           )
      if(lbyte .eq. 0) then
         write(LERR,*)'TIMFREQ: no header read on unit ',luin
         write(LERR,*)'for data set name ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'check existence of this file'
         stop
      endif

#include <f77/saveh.h>
      call savelu('MutVel',ifmt_MutVel,l_MutVel,ln_MutVel, LINEHEADER)
      call savelu('WatVel',ifmt_WatVel,l_WatVel,ln_WatVel, LINEHEADER)
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('VPick1',ifmt_VPick1,l_VPick1,ln_VPick1,TRACEHEADER)

      call saver( itr, 'IndAdj',  nsi , LINHED)
      call saver( itr, 'SmpInt',  ndf , LINHED)
      call saver( itr, 'OrNSMP',nsampr, LINHED)
      CALL HLHprt ( ITR , LBYTE, NAME, 7, LERR        )
      df = ndf / 1000.

c     if( verbos ) then
        write(LERR,*)
        write(LERR,*)' Line header values after default check '
        write(LERR,*)
        write(LERR,*) ' Input Samples/Trace =  ', nsamp
        write(LERR,*) ' Orig Sample Interval=  ', nsi  
        write(LERR,*) ' Sample Interval (Hz)=  ', ndf  
        write(LERR,*) ' Input traces/rec    =  ', ntrc
        write(LERR,*) ' Input Records/Line  =  ', nrec
        write(LERR,*) ' Format of Data      =  ', iform
        write(LERR,*) ' Rotate phase (deg)  =  ', rot
        write(LERR,*) ' Unpack Reals & Imag from each trace= ',pack
        if (mute)
     1  write(LERR,*) ' Apply onset mute time from hdr word VPick1'
c     endif

c------------------------------
c  restore original # trcs/rec
c  save historical line header
c------------------------------
       if (pack) then
           nsampo = nsamp
           n2   = nsamp - 2
           ntr2 = ntrc
           nap  = nsamp / 2
       else
           nsampo = nsamp * 2
           n2   = 2*nsamp - 2
           ntr2 = ntrc/2
       endif
       obytes = SZTRHD + nsampr * SZSMPD
       call savew ( itr, 'NumSmp',nsampr, LINHED)
       call savew ( itr, 'NumTrc', ntr2 , LINHED)
       call savew ( itr, 'SmpInt', nsi  , LINHED)
       call savhlh( itr, lbyte, lbyout)

      CALL WRTAPE ( LUOUT, ITR, LBYout )

C**********************************************************************C
C     read complex data; do inverse fft, output data
C**********************************************************************C

      DO 100 JJ = 1, nrec


             DO 99 KK = 1, ntr2
 
                   nbytes = 0
                 IF (pack) THEN

                     CALL RTAPE  ( LUIN ,LHED, NBYTES         )
                     if(nbytes .eq. 0) then
                        write(LERR,*)'End of file on input:'
                        write(LERR,*)'  rec= ',jj,'  trace= ',kk
                        go to 999
                     endif

                     call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                           istatic, TRACEHEADER)

                     call vmov (lhed(ITHWP1), 1, xtr, 1, nsamp)
                     do  i = 1, nap
                         amp (i) = xtr (nap-i+1)
                         phz (i) = xtr (nap+i)
                     enddo

                 ELSE

                     CALL RTAPE  ( LUIN , ITR, NBYTES         )
                     if(nbytes .eq. 0) then
                        write(LERR,*)'End of file on input:'
                        write(LERR,*)'  rec= ',jj,'  trace= ',kk
                        go to 999
                     endif
                     call vmov (lhed(ITHWP1), 1, amp, 1, nsamp)

                     CALL RTAPE  ( LUIN , ITR, NBYTES         )
                     if(nbytes .eq. 0) then
                        write(LERR,*)'End of file on input:'
                        write(LERR,*)'  rec= ',jj,'  trace= ',kk
                        go to 999
                     endif

                     call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                           istatic, TRACEHEADER)

                     call vmov (lhed(ITHWP1), 1, phz, 1, nsamp)

                 ENDIF

                 call cvfill (0.0, ctr, 2, nsampo)
c-------------------
c  xtr is input trc2
c  work is trc1
c-------------------
                 IF (istatic .ne. 30000) THEN

                    if (RI) then
                       do  i = 1, nsamp
                           ctr (i) = cmplx (amp(i), phz(i))
                       enddo
                    else
                       call vsadd  (phz,  1,    rot, phz, 1, nsamp)
                       call vsmul  (phz , 1, degrad, phz ,1, nsamp)
                       call cvmexp (phz , 1, amp, 1, ctr, 2, nsamp)
                    endif

                    call rfftsc (ctr, n2, -3, 0)
                    call rffti  (ctr,xtr,n2)

                    if (mute) then
                       call saver2(lhed,ifmt_VPick1,l_VPick1,
     1                             ln_VPick1, imute, TRACEHEADER)
                       call resmut (xtr, imute, nsampr)
                    endif

                    call vmov (xtr, 1, lhed(ITHWP1), 1, nsampr)

                    call wrtape(luout,itr,obytes)

                 ELSE

                    call wrtape(luout,itr,obytes)

                 ENDIF


   99        CONTINUE


  100 CONTINUE
                        if(verbos) then
                           write(LERR,*)'Output Record ',JJ
                        endif

  999 continue
        call lbclos(luin)
        call lbclos(luout)
      END

c--------------------------------
c  online help routine
c--------------------------------
      subroutine help
#include <f77/iounit.h>
        write(LER,*)' '
        write(LER,*)'Command Line Arguments for FREQTIM: '
        write(LER,*)'convert output of timfreq to seismic traces'
        write(LER,*)' '
        write(LER,*)'Input...................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-r[rot]    -- rotate phase (degrees)          (0)'
        write(LER,*)'-P         -- input complex packed into each trc'
        write(LER,*)'-RI        -- input packed real & imagaries'
        write(LER,*)'           -- (def is input amp & phz)'
        write(LER,*)'-M         -- apply mute time from hdr word VPick1'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      freqtim -N[] -O[] [-P -RI -M -V]'
        write(LER,*)' '
      return
      end

      subroutine cmdln(ntap,otap,verbos,rot,pack,mute,RI)
c-----
c     get command arguments
c
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c      rot  - R         phase rotation (deg)
c     pack  - L         timfreq packed data real & imag in each trace
c     verbos- L         verbose output or not
c-----
#include <f77/iounit.h>
      character ntap*(*), otap*(*)
      integer   argis
      logical   verbos, pack, mute, RI

           call argstr('-N',ntap,' ',' ')
           call argstr('-O',otap,' ',' ')
           call argr4 ('-r',rot, 0., 0.)
           pack   = ( argis( '-P' ) .gt. 0 )
           RI     = ( argis( '-RI' ) .gt. 0 )
           mute   = ( argis( '-M' ) .gt. 0 )
           verbos = ( argis( '-V' ) .gt. 0 )


c-----
      return
      end

