C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      implicit none
#include <localsys.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
#include <f77/iounit.h>

      integer luin,luout,j,i,idezin,ixovlp,iwndw,iwnovlp,mode,lramp,irs
      integer xovlp,limit,lslide,ifour,tslide,tovlp,nwin,nmove,n2,ierr
      integer nit,mdx,irec,k,koknt,nin,istart,npanel
      integer nread,ipass,jloc,jx,jdx,m,iopt,nout
      integer ipntr,iopntr,izro,il
      integer ire,jerr
      integer mbytes,iby,ierror,ner,iget
      integer lbytes,nsamp,nsr,ntrc,nrcd
      integer nx,istat,ndx,kdx,hdx,hstrt,mm
      integer jp,ndo,nwrite
      integer itr(SZLNHD), argis
      integer aper
      integer itrhd(1),zero(1),htrhd(1),hzero(1)
      integer first, last, rin
      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum
      integer ifmt_RecNum,l_RecNum,ln_RecNum
      integer ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc
      integer ifmt_RecInd,l_RecInd,ln_RecInd
      integer ifmt_DphInd,l_DphInd,ln_DphInd
      integer ifmt_DstSgn,l_DstSgn,ln_DstSgn
      integer ifmt_DstUsg,l_DstUsg,ln_DstUsg
      integer ifmt_StaCor,l_StaCor,ln_StaCor
      integer io,mix
C
      real    Ritr(SZLNHD),ramp(SZLNHD)
      real    unitsc,tsr,xslide,rx,xa
      real    sr,work(1),wtaper,stack(1),xLive(1)
      real    sum(1),opratr(1),taper(1)
      real    Dhold(1),winwork(1),data(1),hdata(1)
      real    hilbert(1),wdata(1),w1,w2
C
      character parr*43,name*4,title(66)*1,ntap*256, otap*256
C
      logical open, there,rec_seq,scale,verbos,SE,pad
      logical eof,error,dead(1),eor,hdead(1)
      logical even,odd
C
      POINTER       (pdhold, dhold),(pdata,data)
      POINTER       (pwinwork,winwork),(popratr, opratr),(pwork,work)
      POINTER       (psum,sum),(ptaper,taper)
      POINTER       (pth,itrhd),(phthd,htrhd)
      POINTER       (pzro,zero),(phdata,hdata),(pdead,dead)
      POINTER       (phdead,hdead),(phzero,hzero)
      pointer       (philbert,hilbert),(pwdat,wdata)
      pointer       (pstak,stack),(plive,xLive)
C
      data name/'FXBL'/,open/.FALSE./
      data parr/'Frequency-Space(X) Spectral Balancing      '/
      data TITLE/66*' '/, error/.false./, eof/.false./
      data rec_seq/.false./
C
      equivalence (itr(1),Ritr(1))

C +=========================+
* | Check for the HELP flag |
C +=========================+
      if (argis ('-?').gt.0 .OR. (argis('-H').gt.0) .OR.
     : argis('-h').gt.0 ) then
         call help(LER)
         stop
      endif
      J=11
      DO I=1,43
         J=J+1
         TITLE(J)=parr(I:I)
      END DO
#include <f77/open.h>
C +===============================+
* | Get the processing parameters |
C +===============================+
      pad = .true.
      SE = .false.
      scale = .false.
      call gcmdln(ntap,otap, idezin,ixovlp,iwndw,iwnovlp,mode,
     1            lramp,scale,irs,ire,wtaper,mix,pad)
      verbos=.true.
      if(scale)then
       SE = .true.
       scale = .false.
       SE = .false.
       scale = .true.
      endif
      if(ixovlp.eq.0)ixovlp=50
      if(iwnovlp.eq.0)iwnovlp=50
      wtaper=wtaper*0.01

      if(mode.ne.1)mode=0

      if(ixovlp.gt.90)then
       write(LERR,*)'Spatial overlap cannot exceed 90%'
       error = .true.
      endif

      if(iwnovlp.gt.50)then
       write(LERR,*)'Temporal overlap cannot exceed 50%'
       error=.true.
      endif

      if(mode.eq.1)rec_seq=.true.

      aper = idezin
      if(aper/2*2.eq.aper)then
       even=.true.
       odd =.false.
      else
       even=.false.
       odd =.true.
      endif
      if(aper.le.5)aper= 7
      xovlp = float(aper)*float(ixovlp)*.01
      if(xovlp.eq.aper)xovlp=aper-1

      if(ntap.ne.' ')then
       there = .false.
       inquire(file = ntap, exist = there)
       if(.not.there) then
        write(LER,*)'Requested input data set does not exist.',
     &'  Try again.'
        stop
       endif
      endif
      call gamoco(title,1,LERR)
C +====================+
C |Open input data set |
C +====================+
      ierror = 0
      if(ntap.ne.' ')then
       call getln(luin,  ntap,'r', 0)
      else
       luin=0
      endif
      if(luin.lt.0)then
       write(LER,*)' Unable to open input. Abort'
       stop
      endif
      if(luout.ne.' ')then
       call getln(luout, otap,'w', 1)
      else
       luout=1
      endif
      if(luout.lt.0)then
       write(LER,*)' Unable to open output. Abort'
       call lbclos(luin)
       stop 100
      endif
      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
       write(LER,*)' Error reading lineheader from input. Abort'
       call lbclos(luin)
       stop 100
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsr  , LINHED)
      call saver(itr, 'NumRec', nrcd , LINHED)
      call saver(itr, 'NumTrc', ntrc,  LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
      if(irs.eq.0)irs = 1
      if(ire.eq.0)ire = nrcd
      if(ntrc.le.1.and.aper.eq.0)then
       write(LER,*)' -d parameter must be specified for stack data'
       write(LER,*)' Also, use mode 0, not mode 1'
       call lbclos(luin)
       stop 100
      endif
      if(rec_seq.and.ntrc.le.1)then
       write(LER,*)' Must use mode 0 for stack data. Fatal!'
       call lbclos(luin)
       stop 100
      endif
      if(rec_seq.and.aper.gt.ntrc)then
       write(LER,*)' aper too large for record sequential mode. Fatal!'
       call lbclos(luin)
       stop 100
      endif

      sr=float(nsr)*unitsc
      tsr = nsr
      lramp = lramp / tsr
      do i=1,lramp
       rx=1./float(lramp-i+1)
       ramp(i)=rx
      end do
      limit = nsamp - lramp
      if(iwndw.eq.0)iwndw = tsr*nsamp
      if(iwndw.gt.tsr*nsamp)iwndw=tsr*nsamp
      lslide=iwndw
      ifour=4
      call hlhprt(itr,lbytes,name,ifour,LERR)
      xslide=float(lslide+nsr-1)
      tslide=xslide/tsr
      tovlp=float(tslide)*float(iwnovlp)*.01
      last = tslide+tovlp
      nwin = 1
      first = 1
      last = tslide+tovlp
      nmove = tslide+tovlp
      do while (last.lt.nsamp)
       first = last-tovlp+1
       last = first + nmove -1
       nwin = nwin+1
      end do
      if(nwin.eq.1)tovlp = 0

      if(error)then
       call lbclos(luin)
       stop 100
      endif


      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

C +=================================+
* | Compute the output trace length |
C +=================================+
      mbytes = nsamp + ITRWRD
      mbytes = mbytes*ISZBYT
C +=======================================+
* | Update the hlh, compute number of     |
* | output records and traces per record. |
C +=======================================+
      iby = lbytes
      call savhlh(itr,iby,lbytes)
C +===========================================+
* | Open the output and write the line header |
C +===========================================+
      call wrtape(luout,itr,lbytes)
C +==============================+
* | Allocate the required memory |
C +==============================+
      n2 = 128
      do while(n2.lt.nsamp)
       n2=n2+n2
      end do
      ierror =0
      ner=0
      iget = nsamp*ISZBYT
      call galloc(ptaper,   iget,ierror,0)
      ner=ner+ierror
      if(pad)then
       call galloc(pstak ,   iget,ierror,0)
       ner=ner+ierror
       call galloc(plive ,   iget,ierror,0)
       ner=ner+ierror
      endif
      iget=nsamp*ISZBYT*2
      call galloc(pwinwork, iget,ierror,0)
      ner=ner+ierror

      iget=(N2+N2+2)*ISZBYT
      call galloc(popratr,iget,ierror,0)
      ner=ner+ierror
      call galloc(psum ,iget,ierror,0)
      ner=ner+ierror

      if(rec_seq)then
       iget=(xovlp+xovlp+ntrc)*nsamp*ISZBYT
      else
       iget=(xovlp+xovlp+aper+aper)*nsamp*ISZBYT
      endif
      call galloc(pdhold,iget,ierror,0)
      ner=ner+ierror
      call galloc(phdata, iget,ierror,0)
      ner=ner+ierror
      call galloc(pdata,iget,ierror,0)
      ner=ner+ierror

      if(rec_seq)then
       iget=(xovlp+ntrc)*ITRWRD*ISZBYT
      else
       iget=(xovlp+xovlp+aper+aper)*ITRWRD*ISZBYT
      endif
      call galloc(pth,iget,ierror,0)
      ner=ner+ierror
      call galloc(phthd,iget,ierr,0)

      if(rec_seq)then
*      iget=(xovlp+ntrc+ntrc)*ISZBYT
       iget=(xovlp+ntrc)*ISZBYT
      else
*      iget=(xovlp+xovlp+aper+aper)*ISZBYT
       iget=(xovlp+aper)*ISZBYT
      endif
      call galloc(pzro ,iget,ierror,0)
      ner=ner+ierror
      call galloc(phzero ,iget,ierror,0)
      ner=ner+ierror
      iget = 2*ntrc*ISZBYT
      if(ntrc.eq.1.or.aper.gt.ntrc)then
       iget=(aper+aper+xovlp+xovlp)*ISZBYT
      endif
      call galloc(pdead,iget,ierror,0)
      ner = ner+ierror
      call galloc(phdead,iget,ierror,0)
      ner = ner+ierror
      if(SE)then
       iget = iget*nsamp
       call galloc(philbert,iget,ierror,0)
       ner = ner+ierror
       iget = nsamp*ISZBYT
       call galloc(pwork,iget,ierror,0)
       ner = ner+ierror
      endif
      iget = xovlp*nsamp*ISZBYT
      call galloc(pwdat,iget,ierror,0)
      ner = ner+ierror

      if(ner.ne.0)then
       write(LERR,*)' Unable to allocate memory.  Reduce data set',
     :       ' size and try again.'
       call lbclos(luin)
       call lbclos(luout)
       stop 100
      endif


      if(verbos)then
       write(LERR,*)' '
       write(LERR,*)'spatial aperature  = ',aper,' traces'
       write(LERR,*)'spatial overlap    = ',xovlp,' traces'
       write(LERR,*)'time window        = ',tslide,' samples'
       write(LERR,*)'temporal ovlp      = ',tovlp,' samples'
       if(rec_seq)then
        write(LERR,*)'mode               =  record sequential'
       else
        write(LERR,*)'mode               =  line sequential'
       endif
       write(LERR,*)' '
       write(LERR,*)'Window function'
      endif
C +================================================================+
C | If the process mode is offset-variant, process record_seq mode |
C +================================================================+
      if(rec_seq)then
      eof = .false.
      rin = 0
c +-----------------------+
c | Read a record of data |
c +-----------------------+
      do while(.not.eof)

       rin = rin + 1
       npanel = 0
       if(pad)then
        do i=1,nsamp
         stack(i)=0.
         xLive(i)=0.
        end do
       endif
       do i=1,ntrc

c----
c   initialize dead trace flag vector and mute time vector
c----
        hdead(i) = .false.
        hzero(i) = 0

        nit = 0
        call rtape(luin,itr,nit)
        if(nit.eq.0)then
         if(i.eq.1)then
          write(LERR,*)'FXBL Normal Completion'
          write(LER,*)'FXBL Normal Completion'
          call lbclos(luin)
          call lbclos(luout)
          stop
         else
          write(LERR,*)'EOF found reading data. Fatal!'
          write(LER ,*)'EOF found reading data. Fatal!'
          call lbclos(luin)
          call lbclos(luout)
          stop 100
         endif
        endif
        call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,
     :   istat,TRACEHEADER)
        call saver2(itr,ifmt_RecNum,l_RecNum,ln_RecNum,
     :   irec ,TRACEHEADER)
        mdx = (i-1)*ITRWRD
        call vmov(itr,1,htrhd(mdx+1),1,ITRWRD)
        ndx = (i-1)*nsamp
        if(istat.lt.30000)then
         do j=1,nsamp
          hdata(ndx+j)=Ritr(ITRWRD+j)
         end do
         if(SE)then
          call hilberte(Ritr(ITHWP1),nsamp,hilbert(ndx+1),ierr)
         endif
         if(pad)then
          do j=1,nsamp
           xa = Ritr(ITRWRD+j)
           stack(j)=stack(j)+xa
           if(xa.ne.0.0)xLive(j)=xLive(j)+1.
          end do
         endif
         hdead(i)=.false.
         j=1
         k=ITHWP1
         do while(Ritr(k).eq.0.and.j.le.nsamp)
          j=j+1
          k=k+1
          hzero(i)=j
         end do
         if(j.eq.nsamp)hdead(i)=.true.

        else

         do j=1,nsamp
          hdata(ndx+j)=0.
         end do
         if(SE)then
          do j=1,nsamp
           hilbert(ndx+j)=0.
          end do
         endif
         hdead(i)=.true.
         hzero(i)=nsamp
        endif

       end do   !  ***>>>  end read ensemble of data
      
       if(pad)then
        do i=1,nsamp
         if(xLive(i).ne.0.0)then
          stack(i)=stack(i)/xLive(i)
         endif
        end do
       endif
       koknt=0
       nin = 0
       koknt=0
       do i=1,aper+xovlp
        dead(i)=.false.
       end do
       istart=1
       nread=aper+xovlp
       ipass=0
       ndo = 0	
       nwrite = 0
       jloc = 0
       call vclr(Dhold,1,nsamp*(aper+xovlp))
c------>
       eor = .false.
       do while(.not.eor)

          npanel = npanel  + 1

        do nx = istart,nread
         jx=nx
c +--------------------------------+
c | On first pass, data is stored  |
c | in a position offset by        |
c | xovlp to make room for mirror |
c +--------------------------------+
         nin = nin+1
         if(nin.gt.ntrc)then
          eor=.true.
          nin=ntrc
          go to 102
         end if
         jloc=jloc+1
         dead(jloc)=hdead(nin)
         zero(jloc)=hzero(nin)
         ndo=ndo+1
C +============================================+
C | Save the data, saving a zero trace if dead |
C +============================================+
         ndx = (jx-1)*nsamp+1
         jdx = (nin-1)*nsamp+1
         do i=0,nsamp-1
          Dhold(ndx+i)=hdata(jdx+i)
         end do
        end do  
  102   continue
C +================+
C | Do the balance |
C +================+
        do i=1,n2+n2+2
         sum(i)=0.
         opratr(i)=0.
        end do
        call balance(Dhold, winwork,sum, opratr,data,tovlp,nsamp,nwin,
     :  tslide,ndo,iopt,scale,dead,taper,wtaper,pad,stack,ierr)

C +============================================+
C | Move the data to output positions in hdata |
C +============================================+
        ipntr = 1
C +===================================================+
c | ipntr is the offset into the Dhold buffer for the |
c | next output trace                                 |
C +===================================================+
        if(eor)then
         nout = ndo
        else
         nout = aper
        endif
c +------------------------------------+
c | save processed data in output matrix
c +------------------------------------+
        hstrt = 1
        mm = 0
        if(ipass.ge.1)then
         do jp=1,xovlp
          mm=mm+1
          koknt=koknt+1
          if(koknt.le.nin)then
           ndx=(ipntr-1)*nsamp
           hdx=(mm-1)*nsamp
           io=(npanel-1)*aper+jp
           iopntr=(io-1)*nsamp
           w2=float(jp-1)/float(xovlp-1)
           w2 = 0.
           w1=1.0 - w2
           do i=1,nsamp
            hdata(iopntr+i)=data(ndx+i)*w1+wdata(hdx+i)*w2
           end do
           if(SE)then
            call hilberte(hdata(iopntr+1),nsamp,work,ierr)
            call escale(hdata(iopntr+1),hilbert(ndx+1),work,nsamp)
           endif
           ipntr=ipntr+1
          endif
         end do
         hstrt=xovlp+1
        endif
        Do jp=hstrt,nout
         koknt=koknt+1
         if(koknt.le.nin)then
          ndx=(ipntr-1)*nsamp+1
          io = (npanel-1)*aper + jp
          iopntr = (io-1)*nsamp+1
          do  i = 0, nsamp-1
           hdata (iopntr + i) = data(ndx+i)
          end do
          if(SE)then
           call hilberte(hdata(iopntr),nsamp,work,ierr)
           call escale(hdata(iopntr),hilbert(ndx),work,nsamp)
          endif
          ipntr=ipntr+1
         endif
        End Do   
C +=======================================================+
C | if not at end of input file, save the overlap portion |
C | of the data matrix into the hold area.                |
C +=======================================================+
        if(.not.eor)then
         m = 1
         iget=aper+1
         nread = aper+xovlp
         do i=iget,nread
          kdx=(i-1)*nsamp
          jdx=(m-1)*nsamp
          do j=1,nsamp
           Dhold(jdx+j)=Dhold(kdx+j)
           wdata(jdx+j)=Dhold(kdx+j)
          end do
          dead(m)=dead(i)
          zero(m)=zero(i)
          m=m+1
         end do
        endif
        istart = xovlp+1
        nread = aper+xovlp
        ndo = xovlp
        ipass=ipass+1
        jloc = istart-1
       end do  !      >> end do nx = 
*
       if(mix.ne.0)then
        do i=1,nsamp
         call vmov(hdata(i),nsamp,opratr,1,ntrc)
         call rmix(opratr,ntrc,mix)
         call vmov(opratr,1,hdata(i),nsamp,ntrc)
        end do
       endif
       do  j = 1, ntrc
           ndx = (j - 1) * nsamp  + 1
           mdx = (j - 1) * ITRWRD + 1
           call vmov (htrhd(mdx), 1, itr, 1, ITRWRD)
           call vmov (hdata(ndx), 1, itr(ITHWP1), 1, nsamp)
           if (.not. hdead(j)) then
              do  i = 1, hzero(j)
                  itr (ITRWRD+i) = 0
              enddo
           endif
           call wrtape (luout, itr, mbytes)
       end do
      end do   ! >> end do while
      call lbclos(luin)
      call lbclos(luout)
      write(LER,*)'FXBL Normal Completion'
      stop
***
      ELSE    ! ***>>>  line_seq mode
***
C +====================================================+
C | If the process mode is not offset-variant, process |
C | process line_seq mode                              |
C +====================================================+
      koknt=0
      nin = 0
      do i=1,aper+xovlp
       dead(i)=.false.
      end do
      istart=1
      nread=aper+xovlp
      eof=.false.
      ipass=0
      ndo = 0	
      jloc=0
      eof = .false.
      do while(.not.eof)
       do nx = istart,nread
        jx=nx
c +--------------------------------+
c | On first pass, data is stored  |
c | in a position offset by        |
c | xovlp to make room for mirror |
c +--------------------------------+
        nit=0
        call rtape(luin,itr,nit)
        if(nit.eq.0)then
         eof=.true.
         go to 202
        end if
        jloc=jloc+1
        nin=nin+1
        call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1             istat  , TRACEHEADER)
        ndo=ndo+1
        if(istat.lt.30000)then
         i=ITHWP1
         j=1
         zero(jx)=0
         do while(Ritr(i).eq.0.0 .and. j.le.nsamp)
           j=j+1
           i=i+1
           zero(jx)=j
         end do
         if(j.ge.nsamp)istat=30000
        else
         zero(jx)=0
        endif
C +====================+
C | Save trace headers |
C +====================+
        ndx = (jx-1)*ITRWRD+1
        call vmov(itr,1,itrhd(ndx),1,ITRWRD)
        ndx = (jx-1)*nsamp+1
        if(SE)then
         call hilberte(Ritr(ITHWP1),nsamp,hilbert(ndx),ierr)
        endif
C +============================================+
C | Save the data, saving a zero trace if dead |
C +============================================+
        if(istat .ge. 30000)then
         dead(jx)=.true.
         do i=0,nsamp-1
          Dhold(ndx+i)=0.
         end do
        else 
         dead(jx)=.false.
         do i=0,nsamp-1
          Dhold(ndx+i)=Ritr(ITHWP1+i)
         end do
        endif
       end do  
  202  continue
       do i=1,n2+n2+2
        sum(i)=0.
        opratr(i)=0.
       end do
       call balance(Dhold, winwork,sum, opratr,data,tovlp,nsamp,nwin,
     : tslide,ndo,iopt,scale,dead,taper,wtaper,pad,stack,ierr)
C +====================================+
C | Output the data. Include loop to   |
c | preserve early mute on live traces |
C +====================================+
       ipntr = 1
       if(eof)then
        nout = ndo
       else
        nout = aper
       endif
       Do jp=1,nout
        ndx=(ipntr-1)*nsamp+1
        jdx=(ipntr-1)*ITRWRD+1
        call vmov(itrhd(jdx),1,itr,1,ITRWRD)
        if(dead(ipntr))then
         do i=0,nsamp-1
          Ritr(ITHWP1+i)=0.
         end do
        else
         do i=0,nsamp-1
          Ritr(ITHWP1+i)=data(ndx+i)
         end do
        endif
        if(zero(ipntr).ne.0.and..not.dead(ipntr))then
         izro = zero(ipntr)
         il = ITHWP1+izro
         do j=0,izro-1
          Ritr(ITHWP1+j)=0.
         end do
         call vmul(itr(il),1,ramp,1,itr(il),1,lramp)
        endif
        if(SE)then
         call hilberte(itr(ITHWP1),nsamp,work,ierr)
         call escale(itr(ITHWP1),hilbert(ndx),work,nsamp)
        endif
        call wrtape(luout,itr,mbytes)
        ipntr=ipntr+1
       End Do     ! ***>>> end nout loop
C +=======================================================+
C | if not at end of input file, save the overlap portion |
C | of the data matrix into the hold area.                |
C +=======================================================+
       if(.not.eof)then
        m = 1
        iget=aper+1
        nread = aper+xovlp
        do i=iget,nread
         kdx=(i-1)*nsamp
         mdx=(i-1)*ITRWRD+1
         jdx=(m-1)*nsamp
         ndx=(m-1)*ITRWRD
         call vmov(itrhd(mdx),1,itrhd(ndx+1),1,ITRWRD)
         do j=1,nsamp
          Dhold(jdx+j)=Dhold(kdx+j)
         end do
         dead(m)=dead(i)
         zero(m)=zero(i)
         m=m+1
        end do
       endif
       istart = xovlp+1
       nread = aper+xovlp
       ndo = xovlp
       ipass=ipass+1
       jloc = xovlp
      end do   ! ***>>>  end do while

      call lbclos(luin)
      call lbclos(luout)
      write(LER,*)'FXBL Normal Completion'
      write(LERR,*)'FXBL Normal Completion'
      stop

      END IF
      end
      subroutine gcmdln(ntap,otap, idezin,ixovlp,iwndw,iwnovlp,mode,
     1                  lramp,scale,irs,ire,wtaper,mix,pad)

      implicit none
      character ntap*(*), otap*(*)
      integer idezin,ixovlp,iwndw,iwnovlp,mode,lramp
      integer ire,irs,mix
      real wtaper
      logical scale,pad

      integer argis

	  ntap = ' '
      otap = ' '
      call argstr ('-N',ntap,' ',' ')          
      call argstr ('-O',otap,' ',' ')            
      call argi4('-d',idezin,0,0)
      call argi4('-sp',ixovlp,0,0)
      call argi4('-w',iwndw,0,0)
      call argi4('-tp',iwnovlp,0,0)
      call argi4('-md',mode,0,0)
      call argi4('-rs',irs,0,0)
      call argi4('-re',ire,0,0)
      call argi4('-rp',lramp,48,48)
      call argi4('-mix',mix,0,0)
      scale = (argis('-S').gt.0)
*     pad = .true.
*     nopad = (argis('-nopad').gt.0)
*     if(nopad)pad=.false.
      call argr4('-taper',wtaper,0.,0.)
      return                                                  
      end
      subroutine help(LER)

      integer ler
      write(LER,*)  
     :'****************************************************************'
      write(LER,*)'Program FXBL.....................Frequency-Space (X)'
      write(LER,*)'                                 Spectral Balancing'
      write(LER,*)' '                                             
      write(LER,*)                                               
     :' -N [ntap]      (may be pipe)     : Input data file name'   
      write(LER,*)                                             
     :' -O [otap]      (may be pipe)     : Output data file name'
*     write(LER,*)                                           
*    :' -rs [rs]     (default = first)   : First record to process'
*     write(LER,*)                                           
*    :' -re [re]     (default = last)    : Last record to process'
      write(LER,*)                                           
     :' -d [design]    (#trc/rec)        : Length, in traces, of '
      write(LER,*)                                           
     :'                                    spatial design and '
      write(LER,*)                                           
     :'                                    application gate.'
      write(LER,*)                                           
     :' -sp [xovlp]  (default = 50)      : Percent overlap in spatial'
      write(LER,*)                                           
     :'                                    direction'
      write(LER,*)                                           
     :' -w  [na]    (default = trace     : Length, in ms, of temporal'
      write(LER,*)                                           
     :'               length)              design and application gate.'
      write(LER,*)                                           
     :' -tp [tovlp]   (default=50)       : Operator temporal overlap(%)'
      write(LER,*)                                           
     :' -md [mode]   (default = 0)       : Process mode:'
      write(LER,*)                                           
     :'                                    0 = line sequential'
      write(LER,*)                                           
     :'                                    1 = Record sequential'
      write(LER,*)                                           
     :' -rp [lramp]   (default = 48)     : length (ms) of on-mute ramp'
      write(LER,*)                                           
     :' -mix [mix]    (default = 0)      : length of spatial smoother '
      write(LER,*)                                           
     :'                                    applied to output.'
*     write(LER,*)                                           
*    :' -taper [wtaper]  (default = 0)   : 1/2 length of windowing '
*     write(LER,*)                                           
*    :'                                    function as % of window     '
*     write(LER,*)                                           
*    :'                                    length.  Max 50%'
      write(LER,*)                                           
     :' -S            (default = No)     : If present, preserve scaling'
*     write(LER,*)                                           
*    :' -nopad        (default = pad)    : If present, turn off padding'
*     write(LER,*)                                           
*    :'                                    of mute zone with stack'
*     write(LER,*)                                           
*    :'                                    when mode = 1          '
      write(LER,*)
     :'***************************************************************'
      write(LER,*)'Usage: ',
     :'fxbl -N[] -O[] -d[] -sp[] -w[] -tp[] -md[] -rp[] -S '
*    :'fxbl -N[] -O[] -d[] -sp[] -w[] -tp[] -md[] -rp[] -taper[] -S '
*    :'fxbl -N[] -O[] -d[] -sp[] -w[] -tp[] -md[] -rp[] -taper[] -S '
*     write(LER,*)
*    :'-nopad'
      write(LER,*)                                     
     :'***************************************************************'
      return                                                          
      end                                                            
      subroutine escale(x,y,work,lx)
      real x(*),y(*),work(*)
      integer lx
      real sc
      integer i
      do i=1,lx
       if(work(i).ne.0.0)then
        sc = y(i)/work(i)
       else
        sc = 0.
       endif
       x(i)=x(i)*sc
      end do
      return
      end
      subroutine build_taper(ltaper, taper)
      implicit none
      real taper(*)
      integer ltaper
      real xtapr,pi,pii,x,xx
      integer i

      xtapr = ltaper-1
      pi = 4.*atan(1.0)
      pii = 1./pi
      do i=1,ltaper
       x = i-1
       xx = pi*x
       taper(i)=pii*abs(sin(xx/xtapr))+(1.-x/xtapr)*cos(xx/xtapr)
      end do
      return
      end
