/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
 
#include <stdio.h>
#include <stdlib.h>
#include <localsys.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#ifdef FTN_TO_C_UNDERSCORE_SUFFIX
#define DISK_IT  disk_it_
#define DISK_WR  disk_wr_
#define DISK_RD  disk_rd_
#define DISK_RWIN  disk_rwn_
#define DISK_WWIN  disk_wwn_
#define DISK_DL  disk_dl_
#endif

#ifdef FTN_TO_C_UPPERCASE
#define DISK_IT  DISK_IT
#define DISK_WR  DISK_WR
#define DISK_RD  DISK_RD
#define DISK_RWIN  DISK_RWN
#define DISK_WWIN  DISK_WWN
#define DISK_DL  DISK_DL
#endif

#ifdef FTN_TO_C_NAME_COMPATABILITY
#define DISK_IT  disk_it
#define DISK_WR  disk_wr
#define DISK_RD  disk_rd
#define DISK_RWIN  disk_rwn
#define DISK_WWIN  disk_wwn
#define DISK_DL  disk_dl
#endif

        static int ifdes;

#ifdef CRAYSYSTEM
#include <fortran.h>
int DISK_IT( int *nsamp,int *nbufsize,float *buf, int *nchars, _fcd *fdirct, int *ipid )
#else
int DISK_IT( int *nsamp,int *nbufsize,float *buf, int *nchars, char *dirct, int *ipid, int dirct_flen )
#endif
{
        int disk_it_c(int nsamp,int nbufsize,float *buf, int nchars, char *dirct, int ipid);
        int xnsamp;
        int xnchars;
        int xnbufsize;
	int xipid;
        int i;
#ifdef CRAYSYSTEM
	char *dirct = _fcdtocp(fdirct);
#endif

        xnsamp = *nsamp;
        xnchars = *nchars;
        xnbufsize = *nbufsize;
	xipid = *ipid;
        i = disk_it_c(xnsamp, xnbufsize, buf,xnchars, dirct, xipid );
 
        return i;
}

int DISK_WR( int *nsamp,int *index,float *buf )
{
        int  disk_wrte_c(int nsamp,int index,float *buf);
        int xnsamp;
        int xindex;
        int i;

        xnsamp = *nsamp;
        xindex = *index;

        i = disk_wrte_c(xnsamp, xindex, buf );
 
        return i;
}

int DISK_WWIN( int *nsamp,int *index, int *isamp, int *nsmp, float *buf )
{
        int  disk_wwin_c(int nsamp,int index,int isamp, int nsmp, float *buf);
        int xnsamp;
        int xindex;
	int xisamp;
	int xnsmp;
        int i;

        xnsamp = *nsamp;
        xindex = *index;
	xisamp = *isamp;
	xnsmp  = *nsmp;

        i = disk_wwin_c(xnsamp, xindex, xisamp, xnsmp, buf );
 
        return i;
}

int DISK_RD( int *nsamp,int *index,float *buf )
{
        int  disk_reed_c(int nsamp,int index,float *buf);
        int xnsamp;
        int xindex;
        int i;

        xnsamp = *nsamp;
        xindex = *index;

        i = disk_reed_c(xnsamp, xindex, buf );
 
        return i;
}

int DISK_RWIN( int *nsamp,int *index,int *isamp, int *nsmp, float *buf )
{
        int  disk_rwin_c(int nsamp,int index,int isamp, int nsmp, float *buf);
        int xnsamp;
        int xindex;
	int xisamp;
	int xnsmp;
        int i;

        xnsamp = *nsamp;
        xindex = *index;
	xisamp = *isamp;
	xnsmp  = *nsmp;

        i = disk_rwin_c(xnsamp, xindex, xisamp, xnsmp, buf );
 
        return i;
}

int DISK_DL( )
{
        int i;

        i = disk_dlte_c();
 
        return i;
}


static FILE *fout;
static char FileName[81];
static int FileOpen = 0; 

#include <time.h>
 
/* initialize the disk buffer  */
        int disk_it_c(int nsamp,int nbufsize,float *buf,int nchars, char *dirct, int ipid)
{

        int n;
        char cn[81];
        void itox( int n, char s[]);


	/*  use pid for a unique disk dataset name */
	n = ipid;
        /* printf(" ipid is %d\n ",ipid); */
        itox(n, cn);

        if ( nchars > 0) {
          strncpy(FileName,dirct,nchars);
        }
	else {
          strcpy(FileName,"/tmp");
        }
        strcat(FileName,"/fxydeconjunk");
        strcat(FileName,cn);

        fprintf(stderr,"Output work file is %s\n",FileName);

 
	/*        if((fout = fopen(FileName,"w+b"))==NULL) { */
	ifdes = open( FileName, O_RDWR | O_CREAT ) ;
	if (ifdes < 0) {
                fprintf(stderr,"Cannot open output file!\n");
		fprintf(stderr," ifdes is %d\n ",ifdes);
		perror("FXYDECON: ");
                exit(1);
                }
        FileOpen = -1;
	/*    printf(" Work unit number = %d \n", ifdes ); */



/* do not bother to format the disk --- not needed for unit ---
=================================================================
        nbytes = nsampl * sizeof(float);
        for(i=0;i<nbufsize;i++) {
                actual = fwrite(buf, nbytes, ST_ONE, fout);
                   if ( actual != ST_ONE) {
                     fprintf(stderr,"Error in fwrite during format\n");
                     fprintf(stderr,"Requested index=%d\n",i);
                     fprintf(stderr,"Requested Number of records=%d\n",ST_ONE);
                     fprintf(stderr,"Actual Number of records wrote=%d\n",actual);
    
                       if((remove(FileName))!= 0) {
                         fprintf(stderr,"Cannot remove output file!\n");
                         exit(1);
                         }
   
                     exit(1);
                   }
        }
=================================================================
*/

/*   WARNING   ---- DANGER   --- READ THIS ---
     warning   ---- danger   --- read this ---
     ok -  this is something I do not like--    
     to remove a file in the case of a job ending abnormally,
     I am taking the systems group's suggestion that I "unlink"
     the disk buffer so it will disappear at the end of the job.
     This seems dangerous, but it keeps the disks clean.      */
    
	/*    printf("Unlinking output file\n");  */
                       if((unlink(FileName))!= 0) {
                         fprintf(stderr,"Cannot unlink output file!\n");
                         exit(1);
                         }
        /*      printf("Unlinking of output file successful\n"); */
   

        return 0;
}

/* write to the disk buffer  */
        int  disk_wrte_c(int nsamp,int index,float *buf)
{
        unsigned int nbytes;
	int nby, ndone ;
        off_t ipos;
        off_t ierr;
	double indexf, nsamplf, tsizef, iposf;


	indexf = index-1;
	nsamplf = nsamp;
	tsizef = sizeof(float);
	iposf = indexf * nsamplf * tsizef ;
	ipos = (off_t) iposf;

	/* perror("LSEEK"); */

	ierr = lseek( ifdes, ipos, SEEK_SET);

	/* perror("LSEEK-a"); */

	if ( (double)ierr < (double) 0) {
	  fprintf(stderr,"Error in lseek a\n");
	  fprintf(stderr," ierr= %g\n", (double)ierr);
	  fprintf(stderr," ipos = %g \n", (double) ipos );
	  fprintf(stderr," nsamplf = %g \n",  nsamplf);
	  fprintf(stderr," indexf = %g \n",  indexf );
	  exit(1);
	}

        nbytes = nsamplf * tsizef;
        nby    =  nsamplf * tsizef;

        ndone = write( ifdes, buf, nbytes) ;
           if ( ndone != nby ) {
             fprintf(stderr,"Error in write a\n");
             fprintf(stderr,"Requested index=%d\n",index);
             fprintf(stderr,"Requested Number of bytes=%u\n",nbytes);
             fprintf(stderr,"Actual Number of bytes written=%d\n",ndone);
             fprintf(stderr,"Unit number = %d \n", ifdes );
	     fprintf(stderr," ipos = %g\n",(double)ipos);
	     fprintf(stderr," index = %d \n",index);
	     fprintf(stderr," nsamp= %d \n",nsamp);
             exit(1);
           }

	fsync(ifdes);

        return 0;
}



/* write to the disk buffer for a window  */
        int  disk_wwin_c(int nsamp,int index, int isamp, int nsmp ,float *buf)
{

        unsigned int nbytes;
	int nby, ndone ;
        off_t ipos;
        off_t ierr;
	double indexf, nsamplf, tsizef, iposf, isampf;

	indexf = index-1;
	nsamplf = nsamp ;
	isampf = isamp -1;
	tsizef = sizeof(float);
	iposf = indexf * nsamplf * tsizef ;
	iposf = iposf + isampf * tsizef ;
	ipos = (off_t) iposf;

	ierr = lseek( ifdes, ipos, SEEK_SET);

	if ( (double)ierr < (double) 0) {
	  fprintf(stderr,"Error in lseek b\n");
	  fprintf(stderr," ierr= %g\n", (double)ierr);
	  fprintf(stderr," ipos = %g \n", (double) ipos );
	  fprintf(stderr," nsamplf = %g \n",  nsamplf);
	  fprintf(stderr," indexf = %g \n",  indexf );
	  exit(1);
	}

        nbytes = nsmp * tsizef;
        nby    =  nsmp * tsizef;

        ndone = write( ifdes, buf, nbytes) ;
           if ( ndone != nby ) {
             fprintf(stderr,"Error in disk_wwin \n");
             fprintf(stderr,"Requested index=%d\n",index);
             fprintf(stderr,"Requested Number of bytes=%u\n",nbytes);
             fprintf(stderr,"Actual Number of bytes written=%d\n",ndone);
             fprintf(stderr,"Unit number = %d \n", ifdes );
	     fprintf(stderr," ipos = %g\n",(double)ipos);
	     fprintf(stderr," index = %d \n",index);
	     fprintf(stderr," nsamp= %d \n",nsamp);
             exit(1);
           }

	fsync(ifdes);

        return 0;
}


/* read from the disk buffer  */
        int  disk_reed_c(int nsamp,int index,float *buf)
{
        unsigned int nbytes;
	int nby, ndone ;
        off_t ipos;
        off_t ierr;
	double indexf, nsamplf, tsizef, iposf;

	indexf = index-1;
	nsamplf = nsamp;
	tsizef = sizeof(float);
	iposf = indexf * nsamplf * tsizef ;
	ipos = (off_t) iposf;

	ierr = lseek( ifdes, ipos, SEEK_SET);
	if ( (double)ierr < (double) 0) {
	  fprintf(stderr,"Error in lseek a\n");
	  fprintf(stderr," ierr= %g\n", (double)ierr);
	  fprintf(stderr," ipos = %g \n", (double) ipos );
	  fprintf(stderr," nsamplf = %g \n",  nsamplf);
	  fprintf(stderr," indexf = %g \n",  indexf );
	  exit(1);
	}


        nbytes = nsamplf * tsizef;
        nby    =  nsamplf * tsizef;

	ndone = read(ifdes, buf, nbytes);
           if ( ndone != nby ) {
             fprintf(stderr,"Error in read a\n");
             fprintf(stderr,"Requested index=%d\n",index);
             fprintf(stderr,"Requested Number of bytes=%u\n",nbytes);
             fprintf(stderr,"Actual Number of bytes read=%d\n",ndone);
             fprintf(stderr,"Unit number = %d \n", ifdes );
	     fprintf(stderr," ipos = %g\n",(double)ipos);
	     fprintf(stderr," index = %d \n",index);
	     fprintf(stderr," nsamp= %d \n",nsamp);
             exit(1);
           }


        return 0;
}
 


/* read from the disk buffer for a window  */
        int  disk_rwin_c(int nsamp,int index, int isamp, int nsmp, float *buf)
{
        unsigned int nbytes;
	int nby, ndone ;
        off_t ipos;
        off_t ierr;
	double indexf, nsamplf, tsizef, iposf, isampf;




	indexf = index-1;
	nsamplf = nsamp ;
	isampf = isamp -1;
	tsizef = sizeof(float);
	iposf = indexf * nsamplf * tsizef ;
	iposf = iposf + isampf * tsizef ;
	ipos = (off_t) iposf;


	ierr = lseek( ifdes, ipos, SEEK_SET);
	if ( (double)ierr < (double) 0) {
	  fprintf(stderr,"Error in lseek a\n");
	  fprintf(stderr," ierr= %g\n", (double)ierr);
	  fprintf(stderr," ipos = %g \n", (double) ipos );
	  fprintf(stderr," nsamplf = %g \n",  nsamplf);
	  fprintf(stderr," indexf = %g \n",  indexf );
	  exit(1);
	}

        nbytes =  nsmp * tsizef;
        nby    =  nsmp * tsizef;

	ndone = read(ifdes, buf, nbytes);
           if ( ndone != nby ) {
             fprintf(stderr,"Error in disk_rwin\n");
             fprintf(stderr,"Requested index=%d\n",index);
             fprintf(stderr,"Requested Number of bytes=%u\n",nbytes);
             fprintf(stderr,"Actual Number of bytes read=%d\n",ndone);
             fprintf(stderr,"Unit number = %d \n", ifdes );
	     fprintf(stderr," ipos = %g\n",(double)ipos);
	     fprintf(stderr," index = %d \n",index);
	     fprintf(stderr," nsamp= %d \n",nsamp);
             exit(1);
           }



        return 0;
}



/* remove he disk buffer  */
        int  disk_dlte_c(void)
{

        if (FileOpen == 0) {
         return 0;
        }

        if((fclose(fout))==EOF) {
                fprintf(stderr,"Cannot close output file!\n");
                exit(1);
                }
 
/*
------------------------------------------------------------------
   I has previously unlinked this input file, so I can no longer
   remove it.  It should disappear automatically.
        if((remove(FileName))!= 0) {
                fprintf(stderr,"Cannot remove output file!\n");
                exit(1);
                }
------------------------------------------------------------------
*/
   

        return 0;
}
/* itox ; convert n to characters in s */
void itox( int n, char s[])
{
  int i,sign;
  void reverse( char s[]);
 
  if ((sign = n) < 0)  /* record sign */
    n = -n ;
  i=0;
  do {   /* generate digits in reverse order */
    s[i++] = n % 10 + '0';  /* get next digit */
  } while ((n /= 10) > 0); /* delete it */
  if (sign < 0)
    s[i++] = '-';
    s[i] = '\0';
    reverse(s);
}
 
/* reverse: reverse string s in place */
void reverse( char s[])
{
  int c,i,j;
 
  for (i=0,j=strlen(s)-1; i<j; i++,j--)
    c=s[i],s[i]=s[j],s[j]=c;
}
