C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE GASP
C
C**********************************************************************C
c
c Changes:

c Nov 18, 2002: fixed cockroach in -threshold implimentation.  Seems that
c               the makefile did not contain svemg.F required for this 
c               option to work.  Worked on my workbench but I neglected to
c               update the Makefile in the USP directory.  While I was at 
c               it I put in a check to NOT do thresholding if -999999.9 
c               is present [the default] in the threshold variable.
c Garossino
c
c Oct 21, 2002: added -threshold[] to allow magnitudes above this value
c               to be ignored during calculation of the data scalar.
c Garossino
c
c Oct 14, 2002:  As usual I fooked up.  I did not take the absolute
c                value of the true median computed.  Sometimes it could
c                be a little bit to the left of zero which results in a 
c                negative scalar and an unwanted polarity flip on the 
c                data.  This has been fixed.
c Garossino
c
c Apr/2002:  added -median option to yield true median of input record
c            as opposed to the median of the tracewise max values which 
c            was the default for -med.  I left -med alone to allow for
c            backwards compatibility.  I also took out the 4,000,000 sample
c            limitation on memory allocation.  The program now will allow
c            piping for -rec runs if memory for such a run can 
c            be acquired.  It will crash out with a warning to the user
c            to run from a disk file if not.  I also changed abort from 
c            a default value of 1 to zero to prevent galloc from killing
c            the routine without a warning to the user.  Finally I added
c            implicit none to catch any unallocated variables of which there
c            were many.  I did install Mike Bushs rmdian routine which 
c            is 5 or 6 x faster than the old stuff that was in here.
c Garossino
c
c Sept/97:  added -hw option to allow storage of gasp scalar tracewise
c           which allows later removal...requested by Joel Greer [GUPCO]
c Garossino
c
c
c July/95   fixed average record constant scaling option to account for
c           dead traces
c Garossino
c
c Feb/02   changed to dynamic allocation of trace data area to accomodate
c           longer traces
c Wade
c
C
C GASP READS SEISMIC TRACE DATA FROM AN INPUT FILE;
C APPLIES JOB, record OR TRACE CONSTANT SCALING BASED
C ON AVERAGE ABSOLUTE AMPLITUDES WITH MEAN SCALING,
C OR ON MAXIMUM ABSOLUTE AMPLITUDES; AND
C WRITES THE RESULTS TO AN OUTPUT FILE

c - if record constant scaling the scaling coefficient is recorded 
c   in an attached coefficients file for later removal/reapplication

c - window start and end time for scaler derivation may be supplied 
c   on the command line or come with the data in user defined trace
c   header locations
C**********************************************************************C
C
C     DECLARE VARIABLES
C

      implicit none

#include <save_defs.h> 
#include <localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare standard USP variables

      integer     irs, ire, nrec, nreco, ntrc, nsamp, nsi, iform
      integer     luin, luout, argis, JJ, KK, LL
      integer     lbytes, lbyout, nbytes, jerr

      real        UnitSc

      character   name*4, ntap*255, otap*255

      logical     verbos

c declare variables used with dynamic memory allocation
      
      integer     itr, itrhd
      integer     CoefRecord, errcdCR, errcdCS, errcod, abort
      integer     item, itemi, items, itemr, itemt

      real        tri
      real        sum, recmax, wrk
      real        recs, recs_live, CoefScalar

      pointer     (wkitrhd, itrhd(1))
      pointer     (wkwrk, wrk(1))
      pointer     (wksum, sum(1))
      pointer     (wkrec, recmax(1))
      pointer     (wkaddr, recs(1))
      pointer     (wkrecs_live, recs_live(1))
      pointer     (wkaddCR, CoefRecord(1))
      pointer     (wkaddCS, CoefScalar(1))
      pointer     (wktri, tri(1))
      pointer     (wkitr, itr(1))

      logical     heap, heaps

c declare program dependant static variables

      integer  msi, window, index, lucoef, NumLiveTraces, nwnd, ismp
      integer  startw, stopw, method, type, ii
      integer  istrc, ishdr
      integer  RecNum, l_RecNum, ln_RecNum, ifmt_RecNum
      integer  TrcNum, l_TrcNum, ln_TrcNum, ifmt_TrcNum
      integer  StaCor, l_StaCor, ln_StaCor, ifmt_StaCor
      integer  DstSgn, l_DstSgn, ln_DstSgn, ifmt_DstSgn
      integer  Wrd1, l_Wrd1, ln_Wrd1, ifmt_Wrd1
      integer  Wrd2, l_Wrd2, ln_Wrd2, ifmt_Wrd2
      integer  l_WrdScl, ln_WrdScl, ifmt_WrdScl
      integer ivel, lecoeftap, lenth, ncoef, i, ierr

      real  t0, atest, sum1, wndw, percnt
      real  maxval, scalar, amax, samp, fac, fact, recscl
      real e, tmute, alive, trii, threshold

      character  coeftap*255, c_Wrd1*6, c_Wrd2*6, c_WrdScl*6

      logical  meth, type1, type2, max, med, dead, remove, coef, spec

c initialize variables

      data name / 'GASP' /
      data amax/2047.0/
      data e/ 1.0e-30 /
      data dead/.false./
      data remove/.false./
      data coef/.false./
      data type2/.false./
      data abort /0/
      data ierr/0/

c get online help if requested

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 )then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c read command line parameters

      call cmdln ( ntap, otap, percnt, startw, stopw, irs, ire, type1, 
     :     type2, meth, verbos, med, ivel, coeftap, remove, coef,  
     :     c_Wrd1, c_Wrd2, c_WrdScl, spec, threshold )

C Type scaling (0=TRACE,1=JOB,2=RECORD)

      type = 0

c if using application from coefficients file then force gasp to run in
c record constant mode
      
      if ( coef ) type2 = .true.

      if ( type1 )  then
         type = 1
      elseif( type2 ) then 
         type = 2
      endif


      if ( meth ) then

c MAA
         method = 0

      elseif ( med ) then

c Classic gasp -med
         method = 2

      elseif ( spec ) then

c true median
         method = 3

      else

c AAA
         method = 1
      endif

c---------------------------
c  bomb off for job
c  constant scale with pipes
c---------------------------

      if (ntap(1:1) .eq. ' ' .and. type1) then
         write(LERR,*)'Cannot pipe into gasp using job constant'
         write(LERR,*)'option (you can with rec or trc const).'
         write(LERR,*)'Write data to a disk file and use -N[]'
         write(LERR,*)'command line entry for input data set name'
         write(LER,*)'GASP'
         write(LER,*)' Cannot pipe into gasp using job constant'
         write(LER,*)' option (you can with rec or trc const).'
         write(LER,*)' Write data to a disk file and use -N[]'
         write(LER,*)' command line entry for input data set name'
         write(LER,*)'FATAL'
         stop
      endif

c echo parameters to printout file

      write(LERR,*) ' '
      write(LERR,*) 'Command Line Parameters'
      write(LERR,*) '-----------------------'
      write(LERR,*) 'Input data = ', ntap
      write(LERR,*) 'Scale %                          =  ',percnt
      write(LERR,*) 'Threshold                        =  ',threshold
      write(LERR,*) 'Start time of window             =  ',startw
      write(LERR,*) 'Stop time of window              =  ',stopw
      write(LERR,*) 'Scaling type                   =  ',method
      write(LERR,*) ' (0 = MAA, 1=AAA, 2=gasp Med,3=true Med )' 
      write(LERR,*) 'Type scaling (0=TR,1=JOB,2=REC)  =  ',type
      if ( coef ) 
     :     write(LERR,*) 'Applying gain from coefficients file'
      if ( c_Wrd1 .ne. ' ' ) then
         write(LERR,*)'Window start time from header entry ',
     :        c_Wrd1
      endif
      if ( c_Wrd2 .ne. ' ' ) then
         write(LERR,*)'Window end time from header entry ',
     :        c_Wrd2
      endif
      if ( c_WrdScl .ne. ' ' ) then
         write(LERR,*)'Trace Scalar associated with header entry ',
     :        c_WrdScl
      endif

c open input and output datasets

      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)

c create pointers for required trace header variables

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)

      if ( c_Wrd1 .ne. ' ' )
     :     call savelu(c_Wrd1,ifmt_Wrd1,l_Wrd1,ln_Wrd1,TRACEHEADER)
      if ( c_Wrd2 .ne. ' ' )
     :     call savelu(c_Wrd2,ifmt_Wrd2,l_Wrd2,ln_Wrd2,TRACEHEADER)
      if ( c_WrdScl .ne. ' ' ) then
         call savelu(c_WrdScl,ifmt_WrdScl,l_WrdScl,ln_WrdScl,
     :        TRACEHEADER)
         if ( ifmt_WrdScl .ne. SAVE_FKFLT_DEF ) then
            write(LERR,*)' '
            write(LERR,*)' You have asked to store your scalar '
            write(LERR,*)' in a header value that is not '
            write(LERR,*)' appropriate.  Use a floating'
            write(LERR,*)' point assignment such as Horz01 or '
            write(LERR,*)' you may not be able to remove or reapply '
            write(LERR,*)' this scaling '
            write(LERR,*)'WARNING'
            write(LER,*)' '
            write(LER,*)'GASP: '
            write(LER,*)' You have asked to store your scalar '
            write(LER,*)' in a header value that is not '
            write(LER,*)' appropriate.  Use a floating'
            write(LER,*)' point assignment such as Horz01 or '
            write(LER,*)' you may not be able to remove or reapply '
            write(LER,*)' this scaling '
            write(LER,*)'WARNING'
            write(LER,*)' '
         endif
      endif

c open coefficients file if record constant option is requested

      if(type2)then
         call alloclun(lucoef)
         lecoeftap = lenth(coeftap)
         
         if ( remove .and. ( c_WrdScl .eq. ' ')  ) then
            open(unit=lucoef,file=coeftap(1:lecoeftap),status='old',
     :           err=990)
         else
            open(unit=lucoef,file=coeftap(1:lecoeftap),status='unknown',
     :           err=990)
         endif
      endif

c allocate space for line header - assume SZLNHD byte max

      errcod = 0
      call galloc (wkitr, SZLNHD, errcod, abort)
      if (errcod .ne. 0) then
        write(LERR,*)' '
        write(LERR,*)'Unable to allocate data record space:'
        write(LERR,*) SZLNHD,'  bytes'
        write(LERR,*)' '
        write(LER,*)'GASP: '
        write(LER,*)' Unable to allocate data record space:'
        write(LER,*)' ', SZLNHD,'  bytes'
        write(LER,*)'FATAL '
        go to 999
      endif

c read input line header

      lbytes = 0
      call rtape ( luin, itr, lbytes )
      if(lbytes .eq. 0) then
         write(LERR,*)' '
         write(LERR,*)'GASP: no line header on input file ',ntap
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'GASP: no line header on input file ',ntap
         write(LER,*)'FATAL'
         goto 999
      endif

      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)'              Historical Line Header '
      write(LERR,*)'              ---------------------- '
      write(LERR,*)' '

c print historical line header to printout file

      call hlhprt( itr , lbytes, name, 4, LERR )

c get global parameters from line header      

      call saver( itr, 'NumSmp', nsamp , LINHED)
      call saver( itr, 'SmpInt', nsi   , LINHED)
      call saver( itr, 'NumTrc', ntrc  , LINHED)
      call saver( itr, 'NumRec', nrec  , LINHED)
      call saver( itr, 'Format', iform , LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c echo to printout file

      write(LERR,*)
      write(LERR,*)'Values from Lineheader'
      write(LERR,*) 'No. of Records         =  ',nrec
      write(LERR,*) 'No. of Traces per Record =',ntrc
      write(LERR,*) 'No. of Samples per Trace =',nsamp
      write(LERR,*) 'Sample interval          =',nsi
      write(LERR,*) 'Format                   =',iform

      IF (type2) THEN
         
c-------------------------------------
c  if we choose -rec const scaling
c  we can handle pipes but that 
c  requires reading recs into an array
c  if so:
c  malloc only space we're going to use
c-------------------------------------
         heap  = .true.
         item  = ntrc * nsamp
         itemt = nsamp
         itemi = ntrc * ITRWRD
         
         call galloc (wkitrhd, itemi*SZSMPD, errcod, abort)
         if (errcod .ne. 0) heap = .false.
         call galloc (wkaddr, item*SZSMPD, errcod, abort)
         if (errcod .ne. 0) heap = .false.

         if (.not. heap) then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate memory:'
            write(LERR,*) (itemi + item) *SZSMPD,'  bytes'
            write(LER,*)' '
            write(LER,*)'GASP: Unable to allocate memory:'
            write(LER,*) (itemi + item) *SZSMPD,'  bytes'
            if ( method .ne. 3 .and. ntap(1:1) .ne. ' ' )  then

c i.e. you are not requiring the record in memory as you are using
c      something other than -median AND you are not piping into this
c      thing.  If you are piping in you will not be able to back up
c      on the pipe so we better end your data now....Garossino

               write(LERR,*)'Bypassing memory allocation step. Will'
               write(LERR,*)'rewind data set instead to apply scaling'
               write(LER,*)'Bypassing memory allocation step. Will'
               write(LER,*)'rewind data set instead to apply scaling'
               goto 11
            elseif ( method .eq. 3 )then

c you do need the record in memory but cannot get the memory
c so .... good bye...Garossino

               write(LERR,*)'better try -med or reduce the '
               write(LERR,*)'amount of data in a record'
               write(LERR,*)'FATAL'
               write(LER,*)'better try -med or reduce the '
               write(LER,*)'amount of data in a record'
               write(LER,*)'FATAL'
               write(LER,*)' '
               stop
            else
               write(LERR,*)'You will need to run this job from a'
               write(LERR,*)'disk file rather than a pipe'
               write(LERR,*)'FATAL'
               write(LER,*)'You will need to run this job from a'
               write(LER,*)'disk file rather than a pipe'
               write(LER,*)'FATAL'
               write(LER,*)' '
               stop
            endif
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating memory'
            write(LERR,*) (itemi + item) *SZSMPD,'  bytes'
            write(LERR,*)' '
         endif

         if ( method .eq. 3 ) then

            call galloc (wkrecs_live, item*SZSMPD, errcod, abort)
            if (errcod .ne. 0) heap = .false.
            if (.not. heap) then
               write(LERR,*)' '
               write(LERR,*)'Unable to allocate memory:'
               write(LERR,*) item *SZSMPD,'  bytes'
               write(LERR,*)'FATAL'
               write(LER,*)' '
               write(LER,*)'GASP: Unable to allocate memory:'
               write(LER,*) item *SZSMPD,'  bytes'
               write(LER,*)'FATAL'
               go to 999
            else
               write(LERR,*)' '
               write(LERR,*)'Allocating memory'
               write(LERR,*) item*SZSMPD,'  bytes'
               write(LERR,*)' '
            endif
         endif
      ENDIF

c initialize memory

      IF (type2) THEN
        call vclr (itrhd, 1, itemi)
        call vclr ( recs, 1, item )
      endif
      if ( method .eq. 3 ) call vclr ( recs_live, 1, item )

 11    continue

c-------------
c  malloc vectors for storing scale factors
c  size will depend on if we have piping or
c  not, or if we do trc, rec, or job const
c-------------

      if (type .eq. 0) then
c trace x trace
         items = 1
         itemr = 1
      elseif (type .eq. 1) then
c job
         items = ntrc * nrec
         itemr = 1
      elseif (type .eq. 2) then
c record
         items = ntrc
         itemr = nrec
      else
         write(LERR,*)'GASP: No scaling type given'
         write(LERR,*)'      Check command line arguments'
         write(LERR,*)'FATAL'
         goto 999
      endif

c determine windowing parameters

      t0 = startw
      msi = nsi

      samp = float(nsi) * unitsc
      startw = startw / nsi + 1 
      stopw = stopw/nsi + 1
      if ( stopw .le. 1 .or. stopw .gt. nsamp ) stopw = nsamp

      window = stopw -  startw +  1
      fac = amax *  percnt / 100.

      if ( ire .eq. 0 ) ire = nrec
      if ( irs .eq. 0 ) irs = 1
      if ( irs .gt. ire) then
         write(LERR,*)' '
         write(LERR,*)'GASP: Start record ', irs,' is greater than'
         write(LERR,*)'      end record ',ire
         write(LERR,*)'FATAL'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'GASP: Start record ', irs,' is greater than'
         write(LER,*)'      end record ',ire
         write(LER,*)'FATAL'
         write(LER,*)' '
         goto 999
      endif

c update and output line header 

      nreco = ire -irs + 1
      call savew( itr, 'NumRec', nreco , LINHED)
      call savhlh( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c do space allocations

      heaps = .true.
      itemt = nsamp

      call galloc (wkwrk, itemt * SZSMPD, errcod, abort)
      if (errcod .ne. 0) heaps = .false.
      call galloc (wksum, items * SZSMPD, errcod, abort)
      if (errcod .ne. 0) heaps = .false.
      call galloc (wkrec, itemr * SZSMPD, errcod, abort)
      if (errcod .ne. 0) heaps = .false.
c
c - added allocation for dynamic data space - joe m. wade - 2/13/2002
c
      call galloc (wktri, nsamp * SZSMPD, errcod, abort)
      if (errcod .ne. 0) heaps = .false.
      call grealloc (wkitr, SZTRHD + (nsamp * SZSMPD), errcod, abort)
      if (errcod .ne. 0) heaps = .false.

      if (.not. heaps) then
         write(LERR,*)' '
         write(LERR,*)'Gasp: Unable to allocate memory'
         write(LERR,*) itemt*SZSMPD,'  bytes'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) itemr*SZSMPD,'  bytes'
         write(LERR,*) nsamp*SZSMPD,'  bytes'
         write(LERR,*) SZTRHD+(nsamp*SZSMPD),'  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Gasp: Unable to allocate memory'
         write(LER,*) itemt*SZSMPD,'  bytes'
         write(LER,*) items*SZSMPD,'  bytes'
         write(LER,*) itemr*SZSMPD,'  bytes'
         write(LER,*) nsamp*SZSMPD,'  bytes'
         write(LER,*) SZTRHD+(nsamp*SZSMPD),'  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Gasp: Allocating memory'
         write(LERR,*) itemt*SZSMPD,'  bytes'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) itemr*SZSMPD,'  bytes'
         write(LERR,*) nsamp*SZSMPD,'  bytes'
         write(LERR,*) SZTRHD+(nsamp*SZSMPD),'  bytes'
         write(LERR,*)' '
      endif

c skip to start record

      call recskp( 1, irs-1, luin, ntrc, itr )

      IF ( remove .or. coef ) then

c Scaling using Coefficients File or from header entry if WrdScl .ne. ' '
c read and sort data from coefficients file and apply or remove 
c scaling as requested

         if ( c_WrdScl .eq. ' ' ) then

            call CoefCount ( lucoef, Ncoef )

c allocate dynamic memory for coefficients data

            call galloc ( wkaddCR, Ncoef * SZSMPD, errcdCR, abort)
            call galloc ( wkaddCS, Ncoef * SZSMPD, errcdCS, abort)

            if ( errcdCR .ne. 0 .or. errcdCS .ne. 0 ) then
               write(LERR,*)' '
               write(LERR,*)'Unable to allocate data record space:'
               write(LERR,*) item*SZSMPD,'  bytes'
               write(LERR,*)' '
               write(LER,*)' '
               write(LER,*)'Unable to allocate data record space:'
               write(LER,*) item*SZSMPD,'  bytes'
               write(LER,*)' '
               go to 999
            else
               write(LERR,*)' '
               write(LERR,*)'Allocating data record space:'
               write(LERR,*) item*SZSMPD,'  bytes'
               write(LERR,*)' '
            endif
          
            call ReadCoef ( lucoef, Ncoef, CoefRecord, CoefScalar )
            if ( Ncoef .gt. 1 ) call hsrti2 ( Ncoef, CoefRecord, 
     :           CoefScalar )

         endif

         DO JJ = 1, nreco
            DO KK = 1,ntrc

               nbytes = 0
               call rtape  ( luin, itr, nbytes )
               if(nbytes .eq. 0) then
                  write(LERR,*)'Premature EOF on input:'
                  write(LERR,*)'Sequential rec= ',jj,' trace= ',kk
                  go to 999
               endif

               call vmov (ITR(ITHWP1), 1, tri, 1, nsamp)

               call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :              StaCor, TRACEHEADER )
               call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :              RecNum, TRACEHEADER )

               if (StaCor .eq. 30000) then
                  call vclr (tri, 1, nsamp)
               else

c get scalar from coefficients file or header as required

                  if ( c_WrdScl .eq. ' ' ) then
                     call GetScalar ( RecNum, Ncoef, CoefRecord, 
     :                    CoefScalar, scalar )
                  else
                     call saver2 ( itr, ifmt_WrdScl, l_WrdScl, 
     :                    ln_WrdScl, scalar, TRACEHEADER )
                  endif

c scale data as required

                  if ( remove ) then 
                     do LL = 1,nsamp
                        tri(LL) = tri(LL)/scalar
                     enddo
                  else
                     do LL = 1,nsamp
                        tri(LL) = tri(LL) * scalar
                     enddo
                  endif
               endif
               
               call vmov (tri, 1, itr(ITHWP1), 1, nsamp)

c load scalar to trace header if requested

               if ( c_WrdScl .ne. ' ' )  
     :              call savew2 ( itr, ifmt_WrdScl, l_WrdScl, 
     :              ln_WrdScl, scalar, TRACEHEADER )

               call wrtape ( luout, itr, nbytes )
               
            ENDDO
         ENDDO

         call lbclos ( luin )
         call lbclos ( luout)
         if(type2) close(lucoef)
         write(LERR,*)'GASP: Normal Termination'
         write(LER,*)'GASP: Normal Termination'
         stop
         
      ENDIF

c Derive scalar from data

      IF ( type .eq. 0 ) then
         
c Trace Constant Scaling

         DO JJ = 1, nreco
            
            DO KK = 1, ntrc

               nbytes = 0
               call rtape  ( luin, itr, nbytes )
               if(nbytes .eq. 0) then
                  write(LERR,*)'GASP: Premature EOF on input:'
                  write(LERR,*)'Sequential rec= ',jj,' trace= ',kk
                  ierr = 1
                  go to 9100
               endif

               call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
               call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :              StaCor, TRACEHEADER )
               call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :              RecNum, TRACEHEADER )
               call saver2( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :              TrcNum, TRACEHEADER )
               if (StaCor .eq. 30000) then
                  call vclr (tri, 1, nsamp)
                  dead = .true.
               else
                  dead = .false.
               endif

               call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :              DstSgn, TRACEHEADER )
               DstSgn = iabs (DstSgn)
               if (ivel .ne. 99999) then
                  startw = 1 + tmute(int(t0),ivel,DstSgn,msi,unitsc)
               endif

c pick up window start and/or  end for this trace from the trace header
c if requested

               if ( c_Wrd1 .ne. ' ' ) then
                  call saver2 ( itr, ifmt_Wrd1, l_Wrd1, ln_Wrd1, Wrd1, 
     :                 TRACEHEADER )
                  startw = nint ( float(Wrd1) / float(nsi) ) + 1
               endif
               if ( c_Wrd2 .ne. ' ' ) then
                  call saver2 ( itr, ifmt_Wrd2, l_Wrd2, ln_Wrd2, Wrd2, 
     :                 TRACEHEADER )
                  stopw = nint ( float(Wrd2) / float(nsi) ) + 1
                  if ( stopw .le. 1 .or. stopw .gt. nsamp )stopw = nsamp
               endif

               if (startw .gt. nsamp) startw = nsamp
               window = stopw - startw + 1

               IF ( method .eq. 1 ) then

C Average Absolute Amplitude with mean scaling

                  call svemg (tri(startw), 1, maxval, window,threshold )
                  if ( abs (maxval) .lt. e ) maxval = 1.0
                  atest = alive(tri(startw),window,1.0e-20,threshold)
                  fact = fac * atest / ( maxval + e )
                  call vsmul (tri, 1, fact, itr(ITHWP1), 1, nsamp )

c if user has requested, place scalar in trace header for later use

                  if ( c_WrdScl .ne. ' ' ) 
     :                 call savew2 ( itr, ifmt_WrdScl, l_WrdScl, 
     :                 ln_WrdScl, fact, TRACEHEADER )

                  call wrtape ( luout, itr, nbytes )
                  
               ELSEIF ( METHOD .EQ. 0 )  THEN

C Maximum Absolute Amplitude scaling
                      
                  call maxmgv (tri(startw), 1, maxval, index, window)
                  if (  maxval .lt. e ) maxval  = 1.0
                  fact= fac / ( maxval + e )
                  call vsmul  (tri, 1, fact, itr(ITHWP1), 1, nsamp )
c if user has requested, place scalar in trace header for later use

                  if ( c_WrdScl .ne. ' ' ) 
     :                 call savew2 ( itr, ifmt_WrdScl, l_WrdScl, 
     :                 ln_WrdScl, fact, TRACEHEADER )

                  call wrtape ( luout, itr, nbytes )

               ELSEIF ( METHOD .eq. 2  )  THEN

C Median Amplitude scaling on nonzero samples (zprg03)

                  ii = 0
                  do  i = startw, stopw
                      trii = tri(i)
                      if (trii .ne. 0.0) then
                         ii = ii + 1
                         wrk(ii) = trii
                      endif
                  enddo
                  maxval = 0.
                  if (ii .gt. 2) then
                     call rmdian( ii, wrk, maxval )
                     maxval = abs(maxval)
                  endif
                  if (  maxval .lt. e ) maxval  = 1.0
                  fact= fac / ( maxval + e )

                  call vsmul  (tri, 1, fact, itr(ITHWP1), 1, nsamp )

c if user has requested, place scalar in trace header for later use

                  if ( c_WrdScl .ne. ' ' )
     :                 call savew2 ( itr, ifmt_WrdScl, l_WrdScl,
     :                 ln_WrdScl, fact, TRACEHEADER )

                  call wrtape ( luout, itr, nbytes )
                  
               ENDIF

               if(verbos) then
                  write(LERR,*)'Record= ',RecNum,'  Trace= ',
     1                 TrcNum,'  Scale factor= ',fact
               endif

            ENDDO
         ENDDO

 9100    continue

      ELSEIF ( TYPE .GE. 1 )  THEN

C**********************************************************************C
C
C     READ TRACES, COMPUTE JOB AND RECORD CONSTANT SCALE FACTORS
C     type = 1   --  job
C     type = 2   --  rec:  in this case if we're piping or if records
C                          are not too large we can deal with them
C                          without rewinding the disk file
C
C**********************************************************************C

         NumLiveTraces = 0
         recscl = 0.
         nwnd = 0

         DO 200 JJ = 1, nreco

            if (type .eq. 2) then

c record constant so reset variables for every record

               NumLiveTraces = 0
               recscl = 0.
               nwnd = 0
            endif

            DO 210 KK = 1, ntrc

               nbytes = 0
               call rtape  ( luin, itr, nbytes )
               if(nbytes .eq. 0) then
                  write(LERR,*)'GASP: Premature End of file on input'
                  write(LERR,*)'Sequential rec= ',jj,' trace= ',kk
                  ierr = 1
                  go to 9200
               endif
               call vmov (itr(ITHWP1), 1, tri, 1, nsamp)

               call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :              StaCor, TRACEHEADER )
               call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :              RecNum, TRACEHEADER )

               if (StaCor .eq. 30000) then
                  call vclr (tri, 1, nsamp)
                  dead = .true.
               else
                  dead = .false.
                  NumLiveTraces = NumLiveTraces + 1
               endif

               call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :              DstSgn, TRACEHEADER )
               DstSgn = iabs (DstSgn)
               if (ivel .ne. 99999) then
                  startw = 1 + tmute(int(t0),ivel,DstSgn,msi,unitsc)
               endif

c pick up window start and/or  end for this trace from the trace header
c if requested

               if ( c_Wrd1 .ne. ' ' ) then
                  call saver2 ( itr, ifmt_Wrd1, l_Wrd1, ln_Wrd1, Wrd1, 
     :                 TRACEHEADER )
                  startw = nint ( float(Wrd1) / float(nsi) ) + 1
               endif
               if ( c_Wrd2 .ne. ' ' ) then
                  call saver2 ( itr, ifmt_Wrd2, l_Wrd2, ln_Wrd2, Wrd2, 
     :                 TRACEHEADER )
                  stopw = nint ( float(Wrd2) / float(nsi) ) + 1
                  if ( stopw .le. 1 .or. stopw .gt. nsamp )stopw = nsamp
               endif

               if (startw .gt. nsamp) startw = nsamp
               window = stopw - startw + 1
               
               if (TYPE .eq. 2 .and. heap ) then

                  ishdr = (kk-1) * ITRWRD
                  call vmov (itr, 1, itrhd(ishdr+1), 1, ITRWRD)

                  istrc = (kk-1) * nsamp
                  call vmov (tri, 1, recs(istrc+1), 1, nsamp)

                  if ( method .eq. 3 ) then

c we will be doing a true record constant median calculation 
c using all live samples within the window.  Load all such samples 
c for this trace to the work array  recs_live[].  The total number 
c of such samples will be nwnd

                     ismp = 0

                     do ii = 1, window
                        if ( abs(tri(startw+ii-1) ).gt. 1.e-32 ) then
                           ismp = ismp + 1
                           recs_live(nwnd + ismp) = tri(startw+ii-1)
                        endif
                     enddo
                  endif
               endif

               if ( method .ne. 3 ) then

c find # live samps in window
                  ismp = 0

                  do ii = 1, window
                     if ( abs(tri(startw+ii-1) ).gt. 1.e-32 ) then
                        ismp = ismp + 1
                     endif
                  enddo
               endif

               nwnd = nwnd + ismp

               IF ( method .eq. 1 ) then

C Average Absolute Amplitude with mean scaling

                  call svemg   ( tri(startw), 1, sum1, window, 
     :                 threshold )
                  if (ismp .ne. 0) recscl = recscl + sum1 / float(ismp)

               ELSEIF ( method .eq. 2 .and. .not. dead ) then

C Backwards compatible traditional gasp Median Amplitude scaling

                  call svemg   ( tri(startw), 1, maxval, window, 
     :                 threshold  )

                  if ( ismp .ne. 0 ) then
                     sum(NumLiveTraces) = maxval / float(ismp)
                  else
                     write(LERR,*)'GASP: Unflagged dead trace found '
                     write(LERR,*)'      at record ',RecNum,' trace '
     :                    ,kk
                     write(LERR,*)'WARNING'
                     sum(NumLiveTraces) = 0.0
                  endif

               ELSEIF ( METHOD .EQ. 0   )  THEN

C Maximum Absolute Amplitude scaling

                  call maxmgv (tri(startw), 1, maxval, index, window)
                  recscl = MAX (recscl, maxval)
               ENDIF
 210        CONTINUE

c-----
c    for rec or trace constant scaling we've now read in a whole
c    record (trace). If it's all dead just output the dead object
c    and then skip to the end of the read record loop
c-----
            if ((NumLiveTraces .eq. 0) .AND. type .gt. 1 ) then

c write out dead record

               DO KK = 1, ntrc
                  istrc = (kk-1) * nsamp
                  ishdr = (kk-1) * ITRWRD
                  call vmov (recs(istrc+1),1,itr(ITHWP1),1,nsamp)
                  call vmov (itrhd(ishdr+1), 1, itr, 1, ITRWRD)
                  call wrtape (luout, itr, nbytes)
               ENDDO

c if we do last record we're finished

               if (JJ .eq. nreco) then
                  write(LERR,*)'GASP: processed ',nreco,' records'
                  call lbclos ( luin )
                  call lbclos ( luout)
                  if(type2) close(lucoef)
                  write(LERR,*)'GASP: Normal Termination'
                  write(LER,*)'GASP: Normal Termination'
                  stop
               endif

               goto 200

            endif
C**********************************************************************C
C
C For record constant (type = 2) scaling compute scaling factors
c
c method = 0 --  maximum
c          1 --  average 
c          2 --  classic gasp  median using median of trace averages
c          3 --  true median of record non-zero amplitudes
C
C**********************************************************************C

            IF (type .eq. 2 ) THEN
               
               if ( method .eq. 0 ) then
                  fact = fac / ( recscl + e )
               elseif (method .eq. 1) then
                  fact = fac * float(NumLiveTraces) / ( recscl + e)
               elseif ( method .eq. 2 ) then
                  call rmdian ( NumLiveTraces, sum, recscl )
                  fact = fac / ( recscl + e )
               elseif ( method .eq. 3 ) then
                  call rmdian ( nwnd, recs_live, recscl )
                  fact = fac / abs(recscl) + e
               endif
               
               recmax(JJ) = fact

            ENDIF

c-------------
c  apply current scale factor &  write out data
c-------------

            IF (type .eq. 2 .and. heap ) then

               if ( verbos ) then
                  if ( method .eq. 0 ) then
                     write(LERR,*)'Record= ',RecNum,' maa scaler= ',
     :                    fact,' live trcs= ',NumLiveTraces
                  elseif ( method .eq. 1 ) then
                     write(LERR,*)'Record= ',RecNum,' aaa scaler= ',
     :                    fact,' live trcs= ',NumLiveTraces
                  elseif ( method .eq. 2 ) then
                     write(LERR,*)'Record= ',RecNum,' med scaler= ',
     :                    fact,' live trcs= ',NumLiveTraces
                  endif
               endif

c write out scale factor for record

               write(lucoef,*) float(RecNum), fact

c scale record

               call vsmul (recs, 1, fact, recs, 1, nsamp*ntrc)

c write out scaled record

               DO KK = 1, ntrc
                  istrc = (kk-1) * nsamp
                  ishdr = (kk-1) * ITRWRD
                  call vmov (recs(istrc+1),1,itr(ITHWP1),1,nsamp)
                  call vmov (itrhd(ishdr+1), 1, itr, 1, ITRWRD)

c if user has requested, place scalar in trace header for later use

                  if ( c_WrdScl .ne. ' ' ) 
     :                 call savew2 ( itr, ifmt_WrdScl, l_WrdScl, 
     :                 ln_WrdScl, fact, TRACEHEADER )

                  call wrtape (luout, itr, nbytes)
               ENDDO

c if we do last record we're finished

               if (JJ .eq. nreco) then
                  write(LERR,*)'GASP: processed ',nreco,' records'
                  call lbclos ( luin )
                  call lbclos ( luout)
                  if(type2) close(lucoef)
                  write(LERR,*)'GASP: Normal Termination'
                  write(LER,*)'GASP: Normal Termination'
                  stop
               endif
            ENDIF

 200     continue
 9200    continue

      ENDIF

C Job Constant scaling

      IF ( type .eq. 1 )  then

         write(LERR,*)'Total live samples= ',nwnd,
     1        ' Total live trcs=- ',NumLiveTraces,' recscl= ',recscl
         wndw = float(nwnd) / float(NumLiveTraces)

         if ( method .eq. 0 ) then
            fact = fac / ( recscl + e )
            write(LERR,*)'Job constant maa scaler=  ',fact
         elseif ( method .eq. 1 ) then

c shouldn't this account for number of live traces instead of ntrc*nreco
            fact = fac * float( NumLiveTraces ) / ( recscl + e )

            write(LERR,*)'Job constant aaa scaler=  ',fact
         elseif ( method .eq. 2 ) then
            call rmdian ( NumLiveTraces, sum, recscl )
            fact = fac / ( recscl + e )
            write(LERR,*)'Job constant med scaler=  ',fact
         endif
        
c rewind dataset for application of scalar
 
         call rwd (luin)

         nbytes = 0
         call rtape  ( luin, itr, nbytes )
         if(nbytes .eq. 0) then
            write(LERR,*)'GASP: Premature EOF on input', ntap
            go to 999
         endif

         DO JJ = 1, nreco
            DO KK = 1, NTRC
               nbytes = 0
               call rtape  ( luin, itr, nbytes )
               if(nbytes .eq. 0) then
                  write(LERR,*)'GASP: Premature EOF on input:'
                  write(LERR,*)'Sequential rec= ',jj,' trace= ',kk
                  ierr = 1
                  go to 9300
               endif
               call vmov (itr(ITHWP1), 1, tri, 1, nsamp)

               call vsmul  ( tri, 1, fact, itr(ITHWP1), 1, nsamp )

c if user has requested, place scalar in trace header for later use

               if ( c_WrdScl .ne. ' ' ) 
     :              call savew2 ( itr, ifmt_WrdScl, l_WrdScl, 
     :              ln_WrdScl, fact, TRACEHEADER )

               call wrtape ( luout, itr, nbytes )
            ENDDO
         ENDDO
 9300    continue

C**********************************************************************C
C
C APPLY RECORD CONSTANT SCALING BASED ON above schemes
C TO TRACES, WRITE TO OUTPUT DISK
C
C**********************************************************************C

      ELSEIF ( type .eq. 2 .and. .not.heap )  then

         call rwd (luin)
         nbytes = 0
         call rtape  ( luin, itr, nbytes )
         if(nbytes .eq. 0) then
            write(LERR,*)'GASP: Premature EOF on input', ntap
            go to 999
         endif


         DO JJ = 1, nreco

            fact = recmax(JJ)
            if(verbos) then
               if     (method .eq. 0) then
                  write(LERR,*)'Record= ',RecNum,'  maa scaler= ',fact
               elseif (method .eq. 1) then
                  write(LERR,*)'Record= ',RecNum,'  aaa scaler= ',fact
               elseif (method .eq. 2) then
                  write(LERR,*)'Record= ',RecNum,'  med scaler= ',fact
               endif
            endif
c write out scale factor for record
            
            write(lucoef,*)float(RecNum),fact
            
            DO KK = 1, ntrc
               nbytes = 0
               call rtape  ( luin, itr, nbytes )
               if(nbytes .eq. 0) then
                  write(LERR,*)'GASP: Premature EOF on input ', ntap
                  write(LERR,*)'  rec= ',RecNum,'  trace= ',kk
                  ierr = 1
                  go to 9500
               endif
               call vmov (itr(ITHWP1), 1, tri, 1, nsamp)

               call vsmul  ( tri, 1, fact, itr(ITHWP1), 1, nsamp )

c if user has requested, place scalar in trace header for later use

               if ( c_WrdScl .ne. ' ' ) 
     :              call savew2 ( itr, ifmt_WrdScl, l_WrdScl, 
     :              ln_WrdScl, fact, TRACEHEADER )

               call wrtape ( luout, itr, nbytes )
            ENDDO
         ENDDO
 9500    continue

      ENDIF

      if ( ierr .ne. 0 ) goto 999

      call lbclos ( luin )
      call lbclos ( luout)
      if(type2) close(lucoef)
      write(LERR,*)'GASP: Normal Termination'
      write(LER,*)'GASP: Normal Termination'
      stop
      
 990  continue
       
      write(LERR,*)'LASTGASP: cannot open coefficents file',coeftap
      write(LERR,*)'          Check existance and/or permissions'
      write(LERR,*)' '
      write(LERR,*)'FATAL'
      stop
      
 999  continue
      call lbclos ( luin )
      call lbclos ( luout)
      if(type2) close(lucoef)
      write(LERR,*)'GASP: Abnormal Termination'
      write(LER,*)'GASP: Abnormal Termination'
      stop
      end

c-------------------------------------------
c  online help section
c-------------------------------------------
      subroutine help
#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for gasp:  '
      write(LER,*)'                         General Amp Scaling Program'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input......................................... (def)'
      write(LER,*)' '
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                     (stdin)'
      write(LER,*)'-O[]   -- output data set                   (stdout)'
      write(LER,*)'-C[]   -- Coefficient file                (GaspCoef)'
      write(LER,*)'-coef  enter on command line if coef file to be used'
      write(LER,*)'       on application.  Not required on removal'
      write(LER,*)' '
      write(LER,*)'-rs[]  -- 1st record to process                  (1)'
      write(LER,*)'-re[]  -- Last record to process       (last record)'
      write(LER,*)'-s[]   -- percent scalar (% of 2047)            (15)'
      write(LER,*)'-t0[]  -- Window start time in units of data     (0)'
      write(LER,*)'-tmax[]-- Window stop time in units of data    (end)'
      write(LER,*)'-v[]   -- mute velocity in ft(m)/s         (999999) '
      write(LER,*)'-hw1[] -- header mnemonic for window start  (unused)'
      write(LER,*)'-hw2[] -- header mnemonic for window end    (unused)'
      write(LER,*)' '
      write(LER,*)'-hws[] -- header mnemonic for scalar        (unused)'
      write(LER,*)'          if used must be a floating point header   '
      write(LER,*)'          entry (i.e. Horz08) '
      write(LER,*)'-threshold[] -- max abs amp to use in      (use all)'
      write(LER,*)'                calculation of AAA scalar.          '
      write(LER,*)' '
      write(LER,*)'-rec   enter on command line to perform  Record '
      write(LER,*)'       constant scaling'
      write(LER,*)'-job   enter on command line to perform Job constant'
      write(LER,*)'       scaling'
      write(LER,*)' '
      write(LER,*)'NOTE: trace constant scaling is the default'
      write(LER,*)' '
      write(LER,*)'-max  Scale based on maximum absolute amplitude.'
      write(LER,*)' '
      write(LER,*)'-med  Scale based on absolute of median amplitude.'
      write(LER,*)' '
      write(LER,*)'       NOTE: The classic gasp -med, when used with'
      write(LER,*)'             -rec, has never used the true median of'
      write(LER,*)'             the record to scale the data.  It'
      write(LER,*)'             acutally uses the median of all trace'
      write(LER,*)'             average amplitudes within the record.'
      write(LER,*)'             To use the actual record median use '
      write(LER,*)'             -median below. See man page for details'
      write(LER,*)' '
      write(LER,*)'-median Scale based on absolute of median amplitude.'
      write(LER,*)'        IF chosen, will force -rec'
      write(LER,*)' '
      write(LER,*)'NOTE: scaling based on average absolute amplitude'
      write(LER,*)'      is the default '
      write(LER,*)' '
      write(LER,*)'-R    enter on the command line to remove previous'
      write(LER,*)'      scaling.  If you have stored the scaling in '
      write(LER,*)'      a trace header slot [see -hws above] then you'
      write(LER,*)'      may use this option independant of the type'
      write(LER,*)'      of scalar used [i.e. -job, -rec].  If you have'
      write(LER,*)'      stored your scalars in an attached coef file'
      write(LER,*)'      you may only use this option in -rec mode'
      write(LER,*)' '
      write(LER,*)'-V    enter on the command line for verbose printout'
      write(LER,*)' '
      write(LER,*)'Usage:   gasp -N[ntap] -O[otap] -C[ctap] -s100 -t0[]'
      write(LER,*)'              -tmax[] [-rec, -job, -max, -med, '
      write(LER,*)'              -median, -R, -hw1[] -hw2[] -hws[] '
      write(LER,*)'              -coef -threshold[] -V]'
      write(LER,*)' '
      write(LER,*)'===================================================='

      return
      end

      subroutine cmdln ( ntap, otap, percnt, startw, stopw, irs, ire, 
     :     type1, type2, meth, verbos, med, ivel, coeftap, remove, coef,
     :     c_Wrd1, c_Wrd2, c_WrdScl, spec, threshold  )

#include <f77/iounit.h>
      integer     argis, startw, stopw, irs, ire
      real        percnt

      character   ntap*(*), otap*(*), coeftap*(*) 
      character   c_Wrd1*6, c_Wrd2*6, c_WrdScl*6

      logical     type1, type2, meth, verbos, med, remove, coef, spec 

         coef = ( argis ( '-coef' ) .gt. 0 )
         call argstr ( '-C', coeftap, 'GaspCoef', 'GaspCoef' )

         call argstr ( '-hw1', c_Wrd1, ' ', ' ' )
         call argstr ( '-hw2', c_Wrd2, ' ', ' ' )
         call argstr ( '-hws', c_WrdScl, ' ', ' ' )

         type1 =  ( argis ( '-job' ) .gt. 0 )

         spec = ( argis ( '-median' ) .gt. 0 )
         med    = ( argis ( '-med' ) .gt. 0 )
         meth = ( argis ( '-max' ) .gt. 0 )

         call argstr ( '-N', ntap, ' ', ' ' )

         call argstr ( '-O', otap, ' ', ' ' )

         type2  = ( argis ( '-rec' ) .gt. 0 )
         call argi4  ( '-rs', irs  , 1 , 1 )
         call argi4  ( '-re', ire  , 0 , 0 )
         remove = ( argis ( '-R' ) .gt. 0 )

         call argr4  ( '-s', percnt, 15. , 15. )

         call argr4  ( '-threshold', threshold, -999999.9 , -999999.9 )
         call argi4  ( '-tmax', stopw, 0 , 0 )
         call argi4  ( '-t0',startw, 0  ,  0 )

         call argi4  ( '-v', ivel, 99999, 99999 )
         verbos = ( argis ( '-V' ) .gt. 0 )

c Policemen

         if (med .and. meth) then
            write(LERR,*)'FATAL - cannot use both -med & -max'
            write(LERR,*)'Use one or the other & rerun'
            write(LER,*)'GASP:'
            write(LER,*)' cannot use both -med & -max'
            write(LER,*)' Use one or the other & rerun'
            write(LER,*)'FATAL'
            stop
         endif
         if ( med .and. spec ) then
            write(LERR,*)'FATAL - cannot use both -med & -median'
            write(LERR,*)'Use one or the other & rerun'
            write(LER,*)'GASP:'
            write(LER,*)' cannot use both -med & -median'
            write(LER,*)' Use one or the other & rerun'
            write(LER,*)'FATAL'
            stop
         endif
         if (spec .and. meth) then
            write(LERR,*)'FATAL - cannot use both -median & -max'
            write(LERR,*)'Use one or the other & rerun'
            write(LER,*)'GASP:'
            write(LER,*)' cannot use both -median & -max'
            write(LER,*)' Use one or the other & rerun'
            write(LER,*)'FATAL'
            stop
         endif

         if ( spec .and. type1 ) then
            write(LERR,*)'FATAL - use of -median not compatible with'
            write(LERR,*)'-job.  Use -rec or -med and rerun. ' 
            write(LER,*)'GASP:'
            write(LER,*)' use of -median not compatible with'
            write(LER,*)' -job.  Use -rec or -med and rerun.'
            write(LER,*)'FATAL'
            stop
         endif

         if ( spec .and. .not. type2 ) then
            type2 = .true.

            write(LERR,*)'WARNING - use of -median forces use of'
            write(LERR,*)'-rec.  Processing continues in record'
            write(LERR,*)'constant mode.'
            write(LER,*)'GASP:'
            write(LER,*)' use of -median forces use of'
            write(LER,*)' -rec.  Processing continues in record'
            write(LER,*)' constant mode.'
            write(LER,*)'WARNING'
         endif


      return
      end

	real function tmute(t0,vmute,DstSgn,nsi,unitsc)
	integer t0, vmute, DstSgn, nsi
        real    unitsc
c	if(nsi .le. 32) then
		tzero = ( float(t0)/float(nsi) ) 
		time  = float(DstSgn)/float(vmute) / unitsc
		tmute = tzero  + time/(float(nsi))
c	else
c		tzero = 1000.0 * ( float(t0)/float(nsi) ) 
c		time  = 1000.0*float(DstSgn)/float(vmute)
c		tmute = tzero + 1000.0 * time/(float(nsi))
c	endif
	return
	end
	real    function alive(x,nx,tol,threshold)
	real x(*),tol,threshold
	integer nx
	if(nx .lt. 1) then
		alive = 1.0
		return
	end if
	ilive = 0
	do 10 i = 1, nx

           if ( threshold .eq. -999999.9 ) then
              if (( abs(x(i) ) .gt. tol) )
     :             ilive = ilive+1
           else

              if (( abs(x(i) ) .gt. tol) .and. 
     :             (abs(x(i) ) .lt. threshold))
     :             ilive = ilive+1
           endif

10 	continue
	alive = ilive
	return 
	end
