C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine frtmau(ls,a,b,x,r1,lerr,mode)
c-----
c In sis genf this was FRTIMA
c-----
      real    x(*),a(*),b(*),r1(*)
      complex rc1(16384)
      integer n1, n3, mode
      data    n1/1/,n3/3/

      n = ls
      n2 = ls/2
      pi = 4.0*atan(1.0)
      fac = pi/180.0
      do  i = 1, n2+1, ls
          a(i) = 0.
          b(i) = 0.
      enddo
c-----
c  same as    fac=1./57.29577
c-----

      do  i = 1, ls
          r1(i) = 0.
          x (i) = 0.
          rc1(i) = cmplx(0.,0.)
      enddo
 
      call vsmul  (b , 1, fac, b ,1, n2)
      call cvmexp (b , 1, a, 1, rc1, 2, n2)


c     call cfft(r1,n,n1)
c     call cfftsc(r1,n)
c  hiking "n" decreases the sample interval. in our example the original
c  time series input to timfreq was 103 samples. that got upped to next pwr
c  of 2 or 128 and resulted in two series, amp & phase, of 64 each. Below
c  taking those series and forming a complex series of length 64 and setting
c  n=128 gets you back to the original series.

      call rfftsc (rc1, ls, -2, 0)
      call rffti  (rc1, r1, ls)
      lw = ls/2
      
      do  i = 1, ls
          r1i = r1(i)
          if (i .ge. lw) then
             wt = .5 * (1 + cos( pi*(i-lw)/lw ))
          else
             wt = 1.
          endif
          x (i) = wt * r1i
          write(lerr,*)i,x(i)
      enddo

      return
      end
