C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gcmdln(lerr,ntap,otap,wtap,fname,verbos,dispgr,inverse,
     1                  mode,ns,ne,irs,ire,lagc,imut,iper,iws,
     2                  iwe,ifflg,weit,delf1,f1,cinv,isym,iph,npt,
     3                  apfile,phzo,prew,mindel,wweight,shp,scalout,
     4                  iord)

c-----
c     mode = 0 parms:
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     fname - C*100    path name to impulse reponse ascii file
c     ns    - INTEGER  starting trace index
c     ne    - INTEGER  ending trace index
c     irs   - INTEGER  starting record index
c     ire   - INTEGER  ending record index
c     mode  - INTEGER  = 0,1 or 2
c     weit  - REAL     ross-weighting exponent
c     lagc  - INTEGER  positive or negative lag (or filter delay) in ms
c     imut  - INTEGER  flag - restore early mute
c                      0 = yes (default)
c                      1 = no
c     ifflg - INTEGER  flag - integrate/differentiate
c                      0 = no (normal)
c                      1 = integrate output
c                      2 = differentiate output
C     For scaling:
c     iper  - INTEGER  percent of 2047
c     iws   - INTEGER  start time (ms)
c     iwe   - INTEGER  end time
c     verbos  L        verbose output or not
c     dispgr  L        if true, write printer graphs to file
c     inverse L        if true, apply inverse of filter to data
c
c     mode = 1 or 2 parms:  all of the above plus the following:
c     mode    INTEGER  1 or 2
c     delf1 - REAL     freq int of amp & phase arrays
c     f1      REAL       "   "   "  "      "   1st sample
c     cinv    REAL     thresh ratio in % of max ampl value
c     isym    INTEGER  filter symetrical ?  0-no, 1-yes
c     iph     INTEGER  phase type ? 0 - values are phase spec
c                                   1 -   "     "    "   lag
c
c-----
      character
     :ntap*(*), otap*(*), fname*(*), apfile*(*), wtap*(*)
 
      integer
     :argis,ifflg, imut, iper, iph, isym, iwe, iws,
     :lagc, mode, npt,
     :ns,ne,irs,ire,iord
 
      real
     :cinv, delf1, f1, weit
 
      logical
     :verbos,dispgr,inverse,phzo,mindel,wweight,shp,scalout
 
 
c-------
c     see manual pages on the argument handler routines
c     for the meanings of these functions
c-------
            call argstr( '-N' , ntap,  ' ', ' ' )
            call argstr( '-O' , otap,  ' ', ' ' )
            call argstr( '-G' , wtap,  ' ', ' ' )
            call argstr( '-F' , fname, ' ', ' ' )
            call argstr( '-AP' , apfile, ' ', ' ' )
            if (apfile(1:1) .ne. ' ') fname(1:1) = ' '
            call argi4 ( '-md', mode,   0 ,  0  )
            call argi4 ( '-ns', ns,     1 ,  1  )
            call argi4 ( '-ne',ne,      0 ,  0  )
            call argi4 ( '-rs',irs,     1 ,  1  )
            call argi4 ( '-re',ire,     0 ,  0  )
            call argi4 ( '-lg', lagc,   0 ,  0  )
            call argi4 ( '-im', imut,   0 ,  0  )
            call argi4 ( '-ip', iper,  15 , 15  )
            call argi4 ( '-is', iws,    0 ,  0  )
            call argi4 ( '-ie', iwe,    0 ,  0  )
            call argi4 ( '-if', ifflg,  0 ,  0  )
            call argr4 ( '-we', weit,   0.,  0. )
            call argr4 ( '-pw', prew,   0.1,  0.1 )
c following parms are also used when mode = 1 or 2:
            call argr4 ( '-df', delf1,  0.,  0. )
            call argr4 ( '-f1', f1,     0.,  0. )
            call argr4 ( '-th', cinv,   0.,  0. )
            call argi4 ( '-sy', isym,   0 ,  0  )
            call argi4 ( '-ph', iph,    0 ,  0  )
            call argi4 ( '-nf', npt,    0 ,  0  )
            call argi4 ( '-io', iord,    0 ,  0  )
            scalout =   (argis('-WS') .gt. 0)
            shp     =   (argis('-S') .gt. 0)
            wweight =   (argis('-W') .gt. 0)
            mindel  =   (argis('-MD') .gt. 0)
            phzo    =   (argis('-PO') .gt. 0)
            inverse =   (argis('-I') .gt. 0)
            verbos  =   (argis('-V') .gt. 0)
            dispgr  =   .false.

            if (cinv .eq. 0.0) then
                cinv = prew
            else
                prew = cinv
            endif

            if (mode .eq. 2) inverse = .false.
            if (mindel) then
               inverse = .false.
               phzo    = .false.
            endif
      return
      end
