C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c subroutine to oversample data with a sinc interpolator.
c Uses a raised-cosine tapered sinc function. The coeffcients
c are generated the first time you call it.
c This version doesn't know what to do with the edge effects, where
c the interpolator is running off the input data. This can be fixed
c any number of ways, maybe the easiest is to just 0 pad the input
c at the beginning and end by the 1/2 length of the interpolator.
c
c  nt is the size of the input
c  nover is the oversampling factor
c  nt_new=nt*nover
c  wsinc is the array of interpolator weights
c  iflag tells whether or not to make the weights
c  data is the input trace
c  data_o is the output oversampled trace
c  nsinc is the total length of the interpolator
c        It's a good question as to whether this should be even
c	 or odd. For samples near the original grid, it's probably
c        best to be odd, for samples nearly 1/2 way in between, even is
c        better. Probably the best thing to do is just make the 
c        length long enough that it doesn't really matter.
c
c
c
        subroutine oversampt(data_in,nt,data_o,nt_new,nover,
     1                        wsinc,nsinc,iflag)
c
        integer isinc,it,nt,nt_new,nsinc,nover
        integer iover,iflag
c
        real    zz,y,xx,pi
        real    wsinc(-nsinc/2+1:nsinc/2,nover)
c
        real    data_in(nt)
        real    data_o(nt_new)
c
c
c if we haven't generated the sinc weights, do that now

        if (iflag .eq. 1) then

          pi=3.14159265358979323846

          do iover = 2, nover

             xx = pi * float(iover-1) / nover

             do isinc = -nsinc/2+1, nsinc/2
               zz = pi * isinc
               y  = xx - zz
               wsinc (isinc,iover)= 1 / y*sin(y) *
     1                            .5*(cos((zz-.5*pi)/((nsinc+1.)/2))+1.)
             end do

          end do

          iflag = 0
        end if
c
c initialize the output
c
        do it=1,nt_new
              data_o(it)=0.
        end do
c
c The first set of samples is the same as the input, just copy.
c
        do it = nsinc/2, nt-nsinc/2
             data_o((it-1)*nover+1)=data_in(it)
        end do
c
c now the real meat, interpolate all the new values
c


        do iover=2,nover

           do isinc = -nsinc/2+1, nsinc/2

                 do it = nsinc/2, nt-nsinc/2
                    data_o( (it-1)*nover+iover ) =
     1                          data_o  ( (it-1)*nover+iover ) +
     2                          data_in (it+isinc) * wsinc(isinc,iover)
                 end do
           end do
        end do
c
c all done
c
        return
        end

c

