C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine subs (IR, ntrc, nsamp, idd,  record, kbin,
     1                 nbin, histt, histr, recmax, trace,
     2                 ist, iend, fix, verbos, ikill,
     3                 left, right)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer   ikill (*)
      real      record (nsamp, ntrc), histt(*), histr(*)
      integer   IR, ntrc, nsamp, idd,  nbin, ipct
      integer   ist, iend
      real      trcmax
      real      tabl1 (SZLNHD), tabl2(SZLNHD), zz(4*SZLNHD)
      real      tri (SZLNHD), xtr (SZLNHD)
      integer   iz(4*SZLNHD), jtrc(SZLNHD)
      integer   idead(SZLNHD)
      logical   trace, verbos, fix, left, right


         write(LERR,*)' '
         write(LERR,*)' '
         write(LERR,*)'Record ',IR
         write(LERR,*)' '

      nsampo = iend - ist + 1
      call vclr (tabl1, 1, nsamp)

      IF ( trace ) THEN

         DO  10  J = 1, ntrc

             ikill (J) = 0

             jtrc(J) = 0
             call maxmgv (record(ist,J), 1, trcmax, imax, nsampo)

             wbin = 2. * trcmax / float(nbin)

             call vclr (histt, 1, nbin)
             call hist (record(ist, J), 1, histt, nsampo, nbin,
     1                  trcmax, -trcmax)

             if     (left) then
                 ded = histt(1)
             elseif (right) then
                 ded = histt(nbin)
             else
                 ded = histt(1) + histt(nbin)
             endif
              
             ipct = 100. * ded / float(nsamp)
             if (ipct .ge. idd) then
                write(LERR,*)'%  dead samples ',ipct,' exceeds maximum'
                write(LERR,*)'allowable for trc ',J,' %= ',idd,'-Killed'
                call vclr (record(1,J), 1, nsamp)
                ikill (J) = 30000

                go to 10
             endif

             ampl = -trcmax + wbin * float(kbin)
             ampr =  trcmax - wbin * float(kbin)

         if (verbos) then
         write(LERR,*)'Trace ',J,'  Minimum ampl= ',-trcmax,
     1                ' Max ampl= ',trcmax
         write(LERR,*)' '
         write(LERR,*)'Bin width= ',wbin
         write(LERR,*)' '
         write(LERR,*)'Low ampl thresh= ',ampl,' High ampl thresh= ',
     1                ampr
         write(LERR,*)' '
         write(LERR,*)'Histogram:'
         write(LERR,*)(histt(i),i=1,nbin)
         write(LERR,*)' '
         endif


             ii = 0
             call vclr (tri, 1, nsamp)
             call vclr (xtr, 1, nsamp)

             do  20  i = ist, iend

                 idead(i) = 0
                 amp = record(i,J)
 
                 if    (left .AND. amp .le. ampl) then
                    if (verbos)
     1              write(LERR,*)'Setting sample ',i,' trace ',J,
     2                           ' to zero'
                    amp = 0.
                    idead(i) = i
                    jtrc(J) = jtrc(J) + 1
                 elseif (right .AND. amp .ge. ampr) then
                    if (verbos)
     1              write(LERR,*)'Setting sample ',i,' trace ',J,
     2                           ' to zero'
                    amp = 0.
                    idead(i) = i
                    jtrc(J) = jtrc(J) + 1
                 else
                    ii = ii + 1
                    tri(ii+ist-1) = amp
                 endif
 
                 record(i,J) = amp

20           continue

             if (fix .AND. jtrc(J) .gt. 0) then
 
                ii = 0
                do  30  i = ist, iend
                   if (idead(i) .eq. 0) then
                      ii = ii + 1
                      tabl1(ii+ist-1) = float( i )
                   endif
30              continue
 
                do  31  i = ist, iend
                   tabl2(i)  = float( i )
31              continue
 
                call fcuint (tabl1(ist), tri(ist), ii , tabl2(ist),
     1                       xtr(ist), nsampo, iz, zz, 1)
 
                do  32  i = ist, iend
                    if (idead(i) .ne. 0) then
                       record(i,J) = xtr(i)
                    endif
32              continue

             endif


10       CONTINUE

      ELSE

         wbin = 2. * recmax / float(nbin)

         call vclr (histr, 1, nbin)

         DO  100  J = 1, ntrc

             ikill (J) = 0

             call hist (record(ist, J), 1, histr, nsampo, nbin,
     1                  recmax, -recmax)

100      CONTINUE

         ampl = -recmax + wbin * float(kbin)
         ampr =  recmax - wbin * float(kbin)

         if (verbos) then
         write(LERR,*)'Minimum ampl= ',-recmax,' Max ampl= ',recmax
         write(LERR,*)' '
         write(LERR,*)'Bin width= ',wbin
         write(LERR,*)' '
         write(LERR,*)'Low ampl thresh= ',ampl,' High ampl thresh= ',
     1                ampr
         write(LERR,*)' '
         write(LERR,*)'Histogram:'
         write(LERR,*)(histr(i),i=1,nbin)
         write(LERR,*)' '
         write(LERR,*)' '
         endif


         DO  200  J = 1, ntrc

             do  199  i = 1, nsamp
                 idead(i) = 0
199          continue

             jtrc(J) = 0
             ii      = 0
             call vclr (tri, 1, nsamp)
             call vclr (xtr, 1, nsamp)

             do  201  i = ist, iend

                 amp = record(i,J)


                 if    (left .AND. amp .le. ampl) then
                    if (verbos)
     1              write(LERR,*)'Setting sample ',i,' trace ',J,
     2                           ' to zero: case left'
                    amp = 0.
                    idead(i) = i
                    jtrc (J) = jtrc(J) + 1
                 elseif (right .AND. amp .ge. ampr) then
                    if (verbos)
     1              write(LERR,*)'Setting sample ',i,' trace ',J,
     2                           ' to zero: case right'
                    amp = 0.
                    idead(i) = i
                    jtrc (J) = jtrc(J) + 1
                 else
                    ii = ii + 1
                    tri(ii+ist-1) = amp
                 endif

                 record(i,J) = amp

201          continue

             ipct = 100. * float(jtrc(J)) / float(nsamp)
             if (ipct .ge. idd) then
                write(LERR,*)'%  dead samples ',ipct,' exceeds maximum'
                write(LERR,*)'allowable for trc ',J,' %= ',idd,'-Killed'
                call vclr (record(1,J), 1, nsamp)
                ikill (J) = 30000
                go to 200
             endif


             if (fix .AND. jtrc(J) .gt. 0) then

                ii = 0
                do  300  i = ist, iend
                   if (idead(i) .eq. 0) then
                      ii = ii + 1
                      tabl1(ii+ist-1) = float( i )
                   endif
300             continue
 
                do  301  i = ist, iend
                   tabl2(i)  = float( i )
301             continue

                call fcuint (tabl1(ist), tri(ist), ii , tabl2(ist),
     1                       xtr(ist), nsampo, iz, zz, 1)

                do  302  i = ist, iend
                    if (idead(i) .ne. 0) then
                       record(i,J) = xtr(i)
                    endif
302             continue

             endif

200      CONTINUE

      ENDIF

      if (verbos) then
         write(LERR,*)' '
         write(LERR,*)' '
      endif

      return
      end
