C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine GridLoad(luhtap, NumLIs, NumDIs, NullValue,
     :     NullRepValue, GridValues )

      integer luhtap, NumLIs, NumDIs, RowsToRead, di, li, row

      real GridValues(NumLIs, NumDIs), NullValue, NullRepValue

c determine number of rows to read, including partial row to
c get DI[N] entries for all LIs


      RowsToRead = int ( float(NumLIs) / 8. )
      if ( mod(NumLIs,8) .ne. 0 ) RowsToRead = RowsToRead + 1

      do di = 1, NumDIs
         
         listart = 1

         do row = 1, RowsToRead

c Load Grid Values Array

            read(luhtap,'(1x,8e15.7)')
     :           ( GridValues(li,di) , li = listart,listart+7 )

            listart = listart + 8

         enddo

      enddo

C Replace Null Values if required 

      do di = 1,NumDIs

         do li = 1, NumLIs

            if ( (GridValues(li,di) - NullValue) .le. 1.e-32 ) 
     :           GridValues(li,di) = NullRepValue
         enddo
      enddo

      return
      end
