C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c     Routine to load default format GeoQuest Ascii Horizon information
c     to a user defined Trace Header entry.
c
c Algorithm:
c
c  get from command line the following:
c
c     Horizon or Grid file name
c     Seismic data file name
c     Trace Header Entry to use
c     Data subset information (rs,re,ns,ne,s,e)
c
c  assumption made that horizon/grid file and dataset are both either
c  inline or crossline sorted [doesn't matter which but must be same]
c
c  read entry from horizon file, if grid read whole grid into memory
c  read/write data down to this entry
c  store event time in user defined trace header word
c  output trace
c  
c  repeat the above loop until all horizon data is transfered
c
c  pass remaining data
c
c  Paul G. A. Garossino [APR:X3932:zpgg07@trc.amoco.com]
c
c -----
c    declare variables
c
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c  Standard USP variables

      integer     lhed ( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs,ire,ns,ne,argis,lehtap,luhtap,nreco,ntrco

      character   ntap*256, otap*256, htap*256, name*9

      logical     verbos, grid

c variables involved in dynamic memory allocation

      integer errcd1, abort, itemGrid

      real    GridValues

      pointer  (wkadr1,GridValues(200000)) 

c  Program specific variables

      integer     LIinit, DIinit, LI, DI
      integer     lehorword, leliword, lediword
      integer     LIhor, DIhor, Time, NumLIs, NumDIs 

      real        rLIhor, rDIhor, X, Y, rTime, LIinc, DIinc, pad
      real        ShotPoint, Cdp, SegID, dLI, dDI, NullValue
      real        NullRepValue

      character   HorWord*100, LIWord*100, DIWord*100, SurveyName*100
      character   LineType*1, TestEof*2, InputLine*200

      logical     HorizonReadFlag
 
c  we access the header values which can be shot or long integers
c  or real values.  The actual trace values start at position
c  ITRWRD1  (position 65 in the old SIS format).  This value is
c  set in lhdrsz.h but eventually could come in thru the line header
c  making the trace header format variable


      data lbytes / 0 /
      data nbytes / 0 /
      data name/'GQHORIZON'/
      data TestEof/'  '/
      HorizonReadFlag = .true.
      data grid/.false./
      data  abort / 0 /
 
c  read program parameters from command line card image file

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0  )then
         call help()
         stop
      endif
 
c  open printout files

#include <f77/open.h>
 
      call gcmdln(ntap, otap, htap, irs, ire, ns, ne, HorWord, LIWord, 
     :    DIWord, LIinit, DIinit, LIinc, DIinc, pad, grid, NullValue, 
     :     NullRepValue, verbos )
 
c  get logical unit numbers for input and output of seismic data

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
 
c  read line header of inputa DSN (rtape reads data into vector "lhed"
c  lbytes is the number of bytes actually read

      call rtape  ( luin, lhed, lbytes)

      if(lbytes .eq. 0) then
         write(LOT,*)'GQHORIZON: No lineheader found in ',ntap
         write(LOT,*)'FATAL'
         stop
      endif

c  Open GeoQuest Horizon/Grid file [must be pre-existing]

      call alloclun(luhtap)
      lehtap = lenth(htap)
      open(unit=luhtap,file=htap(1:lehtap),status='old',err=998)
 
c  save pointers to required traceheader entries

      lehorword = lenth(HorWord)
      call savelu(HorWord(1:lehorword),ifmt_HorWord,l_HorWord,ln_HorWord
     :     ,TRACEHEADER)

      leliword = lenth(LIWord)
      call savelu(LIWord(1:leliword),ifmt_LIWord,l_LIWord,ln_LIWord
     :     ,TRACEHEADER)

      lediword = lenth(DIWord)
      call savelu(DIWord(1:lediword),ifmt_DIWord,l_DIWord,ln_DIWord
     :     ,TRACEHEADER)

c  save required lineheader entries

      call saver(lhed, 'NumSmp', nsamp, LINHED)
      call saver(lhed, 'SmpInt', nsi  , LINHED)
      call saver(lhed, 'NumTrc', ntrc , LINHED)
      call saver(lhed, 'NumRec', nrec , LINHED)
      call saver(lhed, 'Format', iform, LINHED)
      call saver(lhed, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(lhed, 'UnitSc', unitsc, LINHED)
      endif
 
c  print Historical Line Header to printout file

      call hlhprt (lhed, lbytes, name, 9, LERR)
 
c  ensure that command line values are compatible with data set

      if(irs.lt.1)irs = 1
      if(ire.lt.1)ire = nrec
      if(ns.lt.1)ns = 1
      if(ne.lt.1)ne = ntrc

      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
 
c  modify line header to reflect actual number of traces output

      nreco = ire - irs + 1
      call savew(lhed, 'NumRec', nreco, LINHED)
      ntrco   = ne - ns + 1
      call savew(lhed, 'NumTrc', ntrco  , LINHED)
 
c  number output bytes

      obytes = SZTRHD + nsamp * SZSMPD
 
c  inject command line into  historical LH:
 
      call savhlh(lhed,lbytes,lbyout)

c  output updated lineheader
      
      call wrtape ( luout, lhed, lbyout )
 
c  verbose output of all pertinent information before processing begins

      if( verbos ) then
         call verbal(nsamp,nsi,ntrc,nrec,iform,
     :        ntap,otap,htap,irs,ire,ns,ne,HorWord,lehorword,
     :        LIWord,leliword,DIWord,lediword,LIinit,DIinit,
     :        LIinc, DIinc, pad, grid, NullValue, NullRepValue, verbos)
      endif

      if ( grid ) then

c determine memory requirements of grid input and allocate memory
c appropriately

         call GridInit(luhtap, NumLIs, NumDIs, dLI, dDI)

c compare with input parameters

         if ( (ntrco * nreco) .ne. (NumLIs * NumDIs) ) then
            write(LERR,*)' '
            write(LERR,*)'GQHORIZON, Grid does not match data'
            write(LERR,*)'          ', NumLIs*NumDIs,'Entries in grid'
            write(LERR,*)'          ', ntrco*nrec,'Entries in data'
            write(LERR,*)'FATAL' 
            stop
         endif

         itemGrid = NumLIs * NumDIs * SZSMPD

         call galloc ( wkadr1, itemGrid, errcd1, abort )
         if(errcd1 .ne. 0 ) then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) itemGrid,' bytes'
            write(LERR,*)' '
            go to 999
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) itemGrid,' bytes'
            write(LERR,*)' '
         endif

         call GridLoad ( luhtap, NumLIs, NumDIs, NullValue, 
     :        NullRepValue, GridValues )

      else

c read past 2 lines in geoquest header of horizon file

         read(luhtap,*,end=997)SurveyName
         read(luhtap,*,end=997)SurveyName

      endif

c  BEGIN PROCESSING

c  skip unwanted records

      call recskp(1,irs-1,luin,ntrc,lhed)
 
      do 1000 jj = irs, ire
 
c  skip unwanted traces

         call trcskp(jj,1,ns-1,luin,ntrc,lhed)

         do 1001  kk = ns, ne
 
            nbytes = 0
            call rtape( luin, lhed, nbytes)

c  if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif
            
c  get LI and DI indices from traceheader

            call saver2(lhed,ifmt_LIWord,l_LIWord,ln_LIWord,LI,
     :           TRACEHEADER)
            call saver2(lhed,ifmt_DIWord,l_DIWord,ln_DIWord,DI,
     :           TRACEHEADER)

            if ( Grid ) then
               
c if read entry from GridValues then expecting grid to fit data in
c a 1 to 1 fashion.  i.e. for every trace there is a corresponding
c node in the grid, this make look-up easy and means only having to
c store the equivalent of a time slice in memory


               call TimeLoad ( GridValues, NumLIs, NumDIs, JJ, KK, pad, 
     :              time )

c  Load Horizon time to user defined trace header word

               call savew2(lhed,ifmt_HorWord,l_HorWord,ln_HorWord,Time,
     :              TRACEHEADER)

            elseif(HorizonReadFlag)then

c  if flag read entry from horizon file.  If current trace index occurs
c  prior to horizon entry then pass trace and get another.  
c the following is the default output that Doug Whitman supplied

 10            read(luhtap,'(a2)')TestEof
               if (TestEof .ne. 'EO') then
                  backspace(luhtap)
               else
                  TestEof = '  '
                  goto 20
               endif

               read(luhtap,'(a150)',end=20,err=997)InputLine
               call fsscnf(InputLine,' %f %f %f %f %f %f %f %s %f %s ',
     :              X, Y, SegID, rtime, ShotPoint, Cdp, rDIhor, LineType
     :              , rLIhor, SurveyName)

               LIhor = nint(rLIhor/LIinc) - nint(float(LIinit)/LIinc) +1
               DIhor = nint(rDIhor/DIinc) - nint(float(DIinit)/DIinc) +1
               Time = nint(rTime) + pad

c  if horizon file is bigger than dataset then read into file until
c  first [LI,DI] is found

               if(LIhor.lt.LI)then
                  goto 10
               else
                  if(LIhor.eq.LI.and.DIhor.lt.DI)goto 10
               endif

 20            HorizonReadFlag = .false.
            endif

c  if required trace then continue else pass this trace and read next

            if( LI.eq.LIhor .and. DI.eq.DIhor .and. .not. Grid ) then

c  Load Horizon time to user defined trace header word

               call savew2(lhed,ifmt_HorWord,l_HorWord,ln_HorWord,Time,
     :              TRACEHEADER)

c  Reset horizon read flag

               HorizonReadFlag = .true.

            endif

c  Output Trace

            call wrtape (luout, lhed, obytes)
                     
 1001    continue
 
c  skip unwanted traces

         call trcskp(jj,ne+1,ntrc,luin,ntrc,lhed)

 1000 continue

      goto 999
 997  continue

      write(LERR,*)' '
      write(LERR,*)'GQHORIZON: Error reading Horizon file ',
     :     htap(1:lehtap)
      write(LERR,*)'          Quality control file contents and'
      write(LERR,*)'          try again.'
      write(LERR,*)' FATAL'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)'GQHORIZON: Error reading Horizon file ',
     :     htap(1:lehtap)
      write(LER,*)'          Quality control file contents and'
      write(LER,*)'          try again.'
      write(LER,*)' FATAL'
      write(LER,*)' '
      stop

 998  continue

      write(LERR,*)' '
      write(LERR,*)' GQHORIZON:Cannot open Horizon file ',htap(1:lehtap)
      write(LERR,*)'           Check existance and/or permissions and'
      write(LERR,*)'           try again.'
      write(LERR,*)' FATAL'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)' GQHORIZON: Cannot open Horizon file ',htap(1:lehtap)
      write(LER,*)'           Check existance and/or permissions and'
      write(LER,*)'           try again.'
      write(LER,*)' FATAL'
      write(LER,*)' '
      stop
 
 999  continue
 
c     close data files
c     flush data left in output buffer

      call lbclos ( luin )
      call lbclos ( luout )
 
      write(LERR,*)'processed ',nreco,' record(s) of ',ntrc,' traces'
      stop      
      end

