C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln ( ntap, otap, ist, iend, name,  
c output dataset limits
     :     Xmin, Xmax, DeltaX, Ymin, Ymax, DeltaY, 
c grid reduction operator limits
     :     Limit_weighting, 
     :     Limit_NumAdjZeroSegs, 
     :     Limit_nsegs, 
     :     Limit_radius, 
     :     Limit_MinNumElems,
     :     Limit_Amp, 
c header word to grid reduce
     :     Wrd,
c flags
     :     ThreeD, verbos )

#include <f77/iounit.h>

      integer    ist, iend, argis

      real Xmin, Xmax, DeltaX, Ymin, Ymax, DeltaY
      real Limit_NumAdjZeroSegs, Limit_nsegs
      real Limit_radius, Limit_MinNumElems, Limit_Amp

      character  ntap*(*), otap*(*), name*(*), Limit_weighting*10
      character  Wrd*6 

      logical    ThreeD, verbos

c local variables

      logical test

c initialize variables

      test = .false.

c parse command line entries

      call argr4 ( '-amp', Limit_Amp, 0., 0. )

      test = (argis('-C') .gt. 0)
      Limit_weighting = 'linear'	
      if ( test ) Limit_weighting = 'cosine'

      call argr4 ( '-dx', DeltaX, 100., 100. )
      call argr4 ( '-dy', DeltaY, 100., 100. )

      call argi4 ( '-e', iend, 0, 0 )

      call argstr ( '-hw', Wrd, ' ', ' ' ) 

      call argstr ( '-N', ntap, ' ', ' ' ) 
      call argr4 ( '-nsegs', Limit_nsegs, 6., 6. )
      call argr4 ( '-nzero', Limit_NumAdjZeroSegs, 4., 4. )
      call argr4 ( '-np', Limit_MinNumElems, 1., 1. )

      call argstr ( '-O', otap, ' ', ' ' ) 

      call argr4 ( '-radius', Limit_radius, 1000., 1000. )

      call argi4 ( '-s', ist, 1, 1 )

      call argr4 ( '-xmax', Xmax, 999999., 999999. )
      call argr4 ( '-xmin', Xmin, 0., 0. )

      call argr4 ( '-ymax', Ymax, 999999., 999999. )
      call argr4 ( '-ymin', Ymin, 0., 0. )

      verbos = (argis('-V') .gt. 0)

      ThreeD = (argis('-3d') .gt. 0)
      

c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )
           
      return
      end
