C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine vg_segments ( HeaderSize, Headers, JJ, ifmt_hw, l_hw, 
     :     ln_hw, hw, r_hw, num_horizons,ntrco,  null, Trace, luout )

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 


c declare variables passed from calling routine
      
      integer HeaderSize, num_horizons, JJ, ntrco
      integer Headers (HeaderSize), ifmt_hw (num_horizons)
      integer l_hw(num_horizons), ln_hw(num_horizons), hw(ntrco)
      integer luout(num_horizons)

      real r_hw(ntrco), Trace(ntrco), null

c declare local variables

      integer i, j, hdr_index, npicks, pick, digitized
      integer itr(SZLNHD)

c initialize variables

      call vclr ( itr, 1, SZLNHD )
      digitized = 1

      DO i = 1, num_horizons

         call vclr ( r_hw, 1, ntrco )
         call vclr ( Trace, 1, ntrco )

         hdr_index = 1 - ITRWRD
         npicks = 0
         pick = 1

         DO j = 1, ntrco

            hdr_index = hdr_index + ITRWRD

c extract horizon data from Headers[] independant of format

            if ( ifmt_hw(i) .eq. SAVE_FKFLT_DEF .or.
     :           ifmt_hw(i) .eq. SAVE_FLOAT_DEF ) then

               call saver2 ( Headers(hdr_index), ifmt_hw(i), l_hw(i), 
     :              ln_hw(i), r_hw(pick), TRACEHEADER )

            else

               call saver2 ( Headers(hdr_index), ifmt_hw(i), l_hw(i), 
     :              ln_hw(i), hw(pick), TRACEHEADER )
               r_hw(pick) = float( hw(pick) )

            endif

            if ( abs ( r_hw(pick) - null) .le. 1.e-32  ) then
               r_hw(pick) = 0.0
            else
               npicks = npicks + 1
               Trace(pick) = j
               pick = pick + 1
            endif

         ENDDO

         if ( npicks .gt. 0 ) then

c write out picks for this horizon to the correct output file

            do k = 1, npicks

               write(luout(i),'(f12.3,1x,f12.3,1x,f12.3,1x,i5)')
     :              float(JJ), Trace(k), r_hw(k), digitized
            enddo
         endif

      ENDDO

      return
      end
