C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine xsd_segments ( HeaderSize, Headers, JJ, labels, 
     :     ifmt_hw, l_hw, ln_hw, hw, r_hw, num_horizons, c_hwc, hwc, 
     :     c_hw, ntrco, nskip, segment, null, Trace, luout )

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 


c declare variables passed from calling routine
      
      integer HeaderSize, num_horizons, nskip, luout, JJ
      integer segment, ntrco
      integer Headers (HeaderSize), ifmt_hw (num_horizons)
      integer l_hw(num_horizons), ln_hw(num_horizons), hw(ntrco)
      integer hwc(num_horizons)

      real r_hw(ntrco), Trace(ntrco), null

      character*10 c_hwc(num_horizons)
      character*6 c_hw(num_horizons)

      logical labels

c declare local variables

      integer i, j, hdr_index, npicks
      integer itr(SZLNHD)

      character c_segment*10, c_color*10, c_picks*9, c_name*6
      character c_no_pick_name*17

c initialize variables

      call vclr ( itr, 1, SZLNHD )
      c_segment = 'Segment = '
      c_name = ' Name '
      c_color = '  color = '
      c_picks = ' picks = '
      c_no_pick_name = 'NO_PICK_NAME_HERE'
      
      DO i = 1, num_horizons

         call vclr ( r_hw, 1, ntrco )
         call vclr ( Trace, 1, ntrco )

         hdr_index = 1 - ITRWRD
         npicks = 0
         pick = 1

         DO j = 1, ntrco, nskip

            hdr_index = hdr_index + ITRWRD

c extract horizon data from Headers[] independant of format

            if ( ifmt_hw(i) .eq. SAVE_FKFLT_DEF .or.
     :           ifmt_hw(i) .eq. SAVE_FLOAT_DEF ) then

               call saver2 ( Headers(hdr_index), ifmt_hw(i), l_hw(i), 
     :              ln_hw(i), r_hw(pick), TRACEHEADER )

            else

               call saver2 ( Headers(hdr_index), ifmt_hw(i), l_hw(i), 
     :              ln_hw(i), hw(pick), TRACEHEADER )
               r_hw(pick) = float( hw(pick) )

            endif

            if ( abs ( r_hw(pick) - null) .le. 1.e-32  ) then
               r_hw(pick) = 0.0
            else
               npicks = npicks + 1
               Trace(pick) = j
               pick = pick + 1
            endif


         ENDDO

c write out segment header if we have any picks for this segment        

         if ( npicks .gt. 0 ) then
            if ( labels ) then
               write(luout,10) c_segment, segment, c_name, c_hw(i),
     :              c_color, hwc(i), c_picks, npicks
            else
               write(luout,10) c_segment, segment, c_name, 
     :              c_no_pick_name, c_color, hwc(i), c_picks, npicks
            endif
 10         format ( a10, i5, a6, a20, a10, i5, a9, i5 )

c write out picks for this segment
            do k = 1, npicks

               write(luout,'(f12.6,1x,f12.6,1x,f12.6)')
     :           float(JJ), Trace(k), r_hw(k)
            enddo
         endif

         segment = segment + 1
      ENDDO

      return
      end
