/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <localsys.h>
#include <string.h>
#include <eventnames.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/errno.h>
#include <unistd.h>
#include <termio.h>
#include <stropts.h>
#include <sys/time.h>
#ifdef HAVE_LIMITS_H
#include <limits.h>
#else
#include <sys/limits.h>
#endif
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/keysym.h>
#include <X11/cursorfont.h>
#include <Xm/Xm.h>
#include <Xm/Separator.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/List.h>
#include <Xm/Label.h>
#include <Xm/FileSB.h>
#include <Xm/PushB.h>
#include <Xm/CascadeB.h>
#include <Xm/MessageB.h>
#include <Xm/RowColumn.h>
#include <Xm/Protocols.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <cu_defs.h>
#include <io_defs.h>
#include <size_defs.h>
#include <save_defs.h>
#include <resources.h>
#include <help_defs.h>
#include <arrow.xbm>

XtCallbackProc query_data();
XtCallbackProc update_stats();
XtCallbackProc modify_entry_size();
XtCallbackProc hlh_text_edit();
XtCallbackProc get_original_entry_length();
XtCallbackProc draw_button();
XtCallbackProc new_line_mapped();

short deleted_entries;
short hlh_entry_count;
short hlh_bytes;
short orig_hlh_bytes;
Widget *toggle;
Widget hlh_sum,hlh_entries;
Widget *hlh_text;
Widget *size_text;
Widget *add_line;
Pixmap arrow_pixmap;
int luin,luout,nbytes;
char *buffer;
Dimension max_height,height1,height2;
Dimension max_width,width1,width2;

#if ( BYTE_ORDER == LITTLE_ENDIAN )
#define CONVERT2(word) (short)(((long)word<<8)&0x0000ff00)|(((long)word>>8)&0x000000ff)
#define CONVERT4(word) (((word<<24)&0xff000000)|((word<<8)&0x00ff0000)|((word>>8)&0x0000ff00)|((word>>24)&0x000000ff))
#endif

void pop_dialog(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	XtManageChild((Widget)client_data);
}
void drop_dialog(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	XtUnmanageChild((Widget)client_data);
}
void open_file(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	XmString file;
	String file_text;
	fprintf(stderr,"opening file: ");
	XtVaGetValues(widget,XmNtextString,&file,NULL);
        if (XmStringGetLtoR(file,XmSTRING_DEFAULT_CHARSET,
	  &file_text )) {
		fprintf(stderr,"%s\n",file_text);
		}
	else {
	  fprintf(stderr,"unknown\n");
	  }
}
void terminate(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	exit(0);
}
void write_data(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	char *hlh_entry;
	int i,nbytes;
	int offset;
	int num_output_entries = 0;
	int total_entry_size = 2*HLHINT;
	short hlh_entry_length;
	int trace_size,number_of_samples;

/* used when overwriting an existing dataset.
        if ( hlh_bytes > orig_hlh_bytes ) {
	  system ( "xalert OK \"HLH has increased in size, new output dataset must be specified\" ");
	  return;
	  }
*/

	for (i=0; i<hlh_entry_count; i++) {
	  if (XmToggleButtonGetState(*(toggle+i))) {
	    num_output_entries++;
	    XtVaGetValues(*(hlh_text+i),XmNvalue,&hlh_entry,NULL);
	    total_entry_size += strlen(hlh_entry) + HLHINT;
	    XtFree(hlh_entry);
	    }
	  }
	
	put_hw_val(buffer,"HlhEnt",LINEHEADER,num_output_entries);
	put_hw_val(buffer,"HlhByt",LINEHEADER,total_entry_size);
	
	offset = HSTOFF;

	for (i=0; i<hlh_entry_count; i++) {
	  if (XmToggleButtonGetState(*(toggle+i))) {
	  	num_output_entries++;

		XtVaGetValues(*(hlh_text+i),XmNvalue,&hlh_entry,NULL);
		hlh_entry_length = (short) strlen(hlh_entry);
		put_indexed_hw_val((buffer+offset),SAVE_SHORT_DEF,
			0,1,LINEHEADER,hlh_entry_length);
		offset += HLHINT;
		strncpy(buffer+offset,hlh_entry,hlh_entry_length);
		offset += hlh_entry_length;
		XtFree(hlh_entry);
		}
	  }

	nbytes = offset;

	get_hw_val(buffer,"NumSmp",LINEHEADER,&number_of_samples);
	trace_size = number_of_samples * SZSMPD + SZTRHD;

	do {
             C_WRTAPE(luout,buffer,nbytes);
/* 
   really only need to do this on the first pass
*/
	     buffer = XtRealloc(buffer,trace_size);
	     nbytes = 0;
	     C_RTAPE(luin,buffer,&nbytes);
	     } while (nbytes != 0);

	C_LBCLOS(luin);
	C_LBCLOS(luout);
	
	exit(0);
}
void hlh_add_line(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	int i,index;
	XtPointer userdata;
	XmString label;
	Widget form,scroll;
	Widget list_form = (Widget)client_data;
	Widget vertical_scroll;
	Widget clip_window;
	char hlhname[8] = "text";
	int entry_length;
	char *text_string;

/*
	index = (int) client_data;
*/
	XtVaGetValues(widget, XmNuserData, &userdata, NULL);
	index = (int) userdata;

	form = XtParent(*(toggle+index));

	hlh_entry_count++;
	text_string = (char *) XtMalloc(6*sizeof(char));
	sprintf(text_string,"%d",hlh_entry_count);
	XtVaSetValues(hlh_entries, XmNvalue, text_string, NULL);
	hlh_bytes += 2;
	sprintf(text_string,"%d",hlh_bytes);
	XtVaSetValues(hlh_sum, XmNvalue, text_string, NULL);
/*
	XtFree(text_string);
*/
	toggle = (Widget *) XtRealloc(toggle,hlh_entry_count * sizeof(Widget));
	hlh_text = (Widget *) XtRealloc(hlh_text,
		hlh_entry_count * sizeof(Widget));
	size_text = (Widget *) XtRealloc(size_text,
			hlh_entry_count * sizeof(Widget));
	add_line = (Widget *) XtRealloc(add_line,
			hlh_entry_count * sizeof(Widget));

	index++;
	for (i=hlh_entry_count-1; i>index; i--) {
	  *(toggle+i) = *(toggle+i-1);
	  *(hlh_text+i) = *(hlh_text+i-1);
	  XtVaSetValues(*(hlh_text+i), XmNuserData, (XtPointer) i, NULL);
	  *(size_text+i) = *(size_text+i-1);
	  *(add_line+i) = *(add_line+i-1);
	  XtVaSetValues(*(add_line+i), XmNuserData, (XtPointer) i, NULL);
	  }

	sprintf(text_string,"%2d",index);
        label = XmStringCreateLtoR("",
				XmSTRING_DEFAULT_CHARSET);
	XtFree(text_string);
	*(toggle+index) = XtVaCreateManagedWidget("hlhtoggle",
		xmToggleButtonWidgetClass,form,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_NONE,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, *(toggle+index-1),
			XmNbottomAttachment, XmATTACH_NONE,
			XmNlabelString, label,
			XmNset, True,
			NULL);
	XmStringFree(label);

	for (i=index+1; i<hlh_entry_count; i++) {
	  XtVaSetValues(*(toggle+i),
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, *(toggle+i-1),
			XmNbottomAttachment, XmATTACH_NONE,
			NULL);
	  }

	entry_length = 0;
	XtAddCallback(*(toggle+index), XmNvalueChangedCallback, 
		update_stats, (XtPointer) entry_length);

	*(size_text+index) = XtVaCreateManagedWidget("sizetext",
		xmTextWidgetClass,form,
			XmNleftAttachment, XmATTACH_WIDGET,
			XmNleftWidget, *(toggle+index),
			XmNrightAttachment, XmATTACH_NONE,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, *(toggle+index-1),
			XmNbottomAttachment, XmATTACH_NONE,
			XmNeditable, FALSE,
			XmNvalue, "0",
			XmNcolumns, 5,
			XmNresizeWidth,TRUE,
			XmNuserData, (XtPointer) index,
			NULL);

/* - jmw - circular ?
	  XtVaSetValues(*(toggle+index),
			XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget, *(size_text+index),
			NULL);
*/

	for (i=index+1; i<hlh_entry_count; i++) {
	  XtVaSetValues(*(size_text+i),
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, *(toggle+i-1),
			XmNbottomAttachment, XmATTACH_NONE,
			NULL);
	  }
	XtVaSetValues(*(size_text+hlh_entry_count-1),
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, *(toggle+hlh_entry_count-2),
			XmNbottomAttachment, XmATTACH_NONE,
			NULL);

	sprintf(hlhname+4,"%03d",index);
	hlhname[7] = '\0';
	*(hlh_text+index) = XtVaCreateManagedWidget(hlhname,
		xmTextWidgetClass,form,
			XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET,
			XmNleftWidget, hlh_text[index-1],
			XmNrightAttachment, XmATTACH_NONE,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, toggle[index-1],
			XmNbottomAttachment, XmATTACH_NONE,
			XmNvalue,	"",
			XmNcolumns,	1,
			XmNresizeWidth,TRUE,
			XmNuserData, (XtPointer) index,
			NULL);

	XtAddCallback(*(hlh_text+index), XmNvalueChangedCallback,
		hlh_text_edit, 0);
	XtAddCallback(*(hlh_text+index), XmNvalueChangedCallback,
		modify_entry_size, NULL);
	XtAddCallback(*(hlh_text+index), XmNfocusCallback,
		get_original_entry_length, NULL);
	XtAddCallback(*(hlh_text+index), XmNactivateCallback,
		hlh_add_line, list_form);
/*
	XtAddCallback(*(hlh_text+index), XmNrealizeCallback,
		new_line_mapped, NULL);
*/

	for (i=index+1; i<hlh_entry_count; i++) {
	  XtVaSetValues(*(hlh_text+i),
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, *(toggle+i-1),
			NULL);
	  }
	XtVaSetValues(*(size_text+hlh_entry_count-1),
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, *(toggle+hlh_entry_count-2),
			XmNbottomAttachment, XmATTACH_NONE,
		        NULL);

        label = XmStringCreateLtoR("",
				XmSTRING_DEFAULT_CHARSET);

	*(add_line+index) = XtVaCreateManagedWidget("addline1",
		xmPushButtonWidgetClass,form,
			XmNleftAttachment, XmATTACH_WIDGET,
			XmNleftWidget, hlh_text[index],
			XmNrightAttachment, XmATTACH_NONE,
			XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget, hlh_text[index],
			XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget, hlh_text[index],
			XmNlabelType, XmPIXMAP,
			XmNlabelPixmap, arrow_pixmap,
			XmNuserData, (XtPointer) index,
			NULL);
	XmStringFree(label);

	XtAddCallback(*(add_line+index), XmNactivateCallback,
		hlh_add_line, list_form);

	for (i=index+1; i<hlh_entry_count; i++) {
	  XtVaSetValues(*(add_line+i),
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, *(hlh_text+i-1),
			NULL);
	  }
	XtVaSetValues(*(size_text+hlh_entry_count-1),
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget, *(toggle+hlh_entry_count-2),
			XmNbottomAttachment, XmATTACH_NONE,
		        NULL);
	XtVaSetValues(*(toggle+index),XmNuserData,
			(XtPointer)(*(hlh_text+index)),NULL);

	XtVaGetValues(form, XmNverticalSpacing, &height1, NULL);
	XtVaGetValues(*(hlh_text+index),XmNheight, &height2, NULL);
	max_height += height1 + height2;

	XtVaGetValues(*(hlh_text+index),XmNwidth, &width1, NULL);
	max_width = (width1 > max_width) ? width1 : max_width;
/*
  There's a container widget between the scrolled window and the form
*/
	scroll = XtParent(form);
	scroll = XtParent(scroll);
	XtVaGetValues(*toggle,XmNwidth, &width2, NULL);
	width1 = max_width + width2;
	XtVaGetValues(*size_text,XmNwidth, &width2, NULL);
	width1 +=  width2;
	XtVaGetValues(*add_line,XmNwidth, &width2, NULL);
	width1 += width2 + 20;   /* 20 is fudge factor for spacing */
	XtVaSetValues(scroll,
			XmNwidth, width1, 
			XmNheight, (max_height+75 > 600) ? 600 : max_height+75,
			NULL);

	XtVaGetValues(scroll, XmNverticalScrollBar, &vertical_scroll,
				XmNclipWindow, &clip_window, NULL);
/*
   - added this block to ensure that a line added at the bottom of the
     scrolled window is always visible.
*/
	  {
/* cant we just set the entry point always visible?
	  int value;
	  int size;
	  int incr;
	  int page_incr;
	  int minimum,maximum;
	  Dimension clip_minimum,clip_maximum;
	  Position x,y;
	  XtVaGetValues(*(hlh_text+index), XmNx, &x, XmNy, &y, NULL);
	  XtVaGetValues(vertical_scroll, XmNminimum, &minimum,
	                                 XmNmaximum, &maximum, NULL);
	  XtVaGetValues(vertical_scroll, XmNwidth, &clip_minimum,
	                                 XmNheight, &clip_maximum, NULL);
	  XmScrollBarGetValues(vertical_scroll,&value,&size,&incr,&page_incr);
fprintf(stderr,"vertical_scroll:\n");
fprintf(stderr,"maximum = %d, minimum = %d\n",maximum,minimum);
fprintf(stderr,"y = %d, value = %d\n",y,value);
fprintf(stderr,"width = %d, ",clip_minimum);
fprintf(stderr,"height = %d\n",clip_maximum);
	  incr = ( maximum - minimum ) /  hlh_entry_count;
	  if ((y-value) > (clip_maximum-incr)) {
	    value +=  incr;
	    XmScrollBarSetValues(vertical_scroll,value,size,incr,page_incr,TRUE);
	    }
*/

/*  move focus to the new entry  */

	  XmProcessTraversal(*(hlh_text+index),XmTRAVERSE_CURRENT);
	  XtManageChild(scroll);
	  }
	XmUpdateDisplay(list_form);
}
void main(argc,argv)
     int argc;
     char **argv;
{
	char ascii_entry_length[6];
	Display *dpy;
	XtAppContext app_con;
	Window top_window;
	int depth;
	unsigned int screen_number;
	Widget shell,list_form;
	Widget prev_widget,header;
        XmString label,toggle_label;
        XmString button_label,accel_label;
 	char *help_path;
	Widget apply_button,cancel_button;
 	Widget quit_button;
	Widget outer_form;
	Widget scroll_window,separator;
 	Widget hlh_sum_label,hlh_entry_label;
 	Widget menubar,open_but,quit_but,file_but,file_pulldown;
	Widget input_dialog;
	char ntap[256];
	char otap[256];
	char hlhname[8] = "text";
	char *text_string;
	int help;
	int verbose = 0;
	short hlh_entry_length;
	short blankhlh;
	short entry_length;
	int i,offset;
	char *hlh_entry;
	Arg Xarg[10]; int nargs = 0;
 	String version[] = {
	"   HLH Interactive Editing Utility",
	"Amoco Production Company Proprietary",
	"            Version 1.0",
	" ",
	"       Written by: Joe M. Wade",
	"BP/Amoco High Performance Computing",
	"       wadejm@bp.com - Socon 421 x3324",
	""};
	struct stat statbuf;
	int fd_count = 0;
	fd_set readfds;
	dev_t ttydev;
	struct timeval timeout;

	help = C_ARGIS("-h",&argc,argv);
	help += C_ARGIS("-?",&argc,argv);
	if (help > 0) {
	  fprintf(stderr,"****************************************");
	  fprintf(stderr,"***************************************\n");
	  fprintf(stderr,"Usage: hlhedit -N[ntap] -O[otap]\n");
	  fprintf(stderr," -N[ntap]\t\t : Input data set");
	  fprintf(stderr," file name (default=stdin)\n");
	  fprintf(stderr," -O[otap]\t\t : Output data set");
	  fprintf(stderr," file name (default=stdout)\n");
	  fprintf(stderr," [-?|-h]\t\t : print this help\n");
	  fprintf(stderr,"****************************************");
	  fprintf(stderr,"***************************************\n\n");
	  exit(0);
	  }

	buffer = (char *) malloc (40000);
	if (buffer == NULL) {
	  fprintf(stderr,"HLHEDIT: ERROR allocating buffer for header data\n");
	  exit(100);
	  }

	C_ARGSTR("-N",ntap," "," ",&argc,argv);
	if (strncmp(ntap," ",1) != 0) {
	  C_LBOPEN(&luin,ntap,"r");
	  if (luin <= 0) {
	    fprintf(stderr,"%s: unable to open input dataset %s\n",
		argv[0],ntap);
	    exit(1);
	    }
	  }
	else {
	  luin = 0;
	  }

	if (luin == 0) {
	  fstat(luin,&statbuf);
	  if ((statbuf.st_mode & S_IFMT ) != S_IFIFO ) { /* normal pipe */
/*
   Initialize file descriptor set to only contain descriptor 0 and set
   timeout for immediate return.
*/
	    FD_ZERO(&readfds);
	    FD_SET(luin,&readfds);
	    timeout.tv_sec = 0;
	    timeout.tv_usec = 0;

	    fd_count = select(FD_SETSIZE,&readfds,NULL,NULL,&timeout);
	    if (fd_count == 0) {
	      fprintf(stderr,"HLHEDIT: ");
	      fprintf(stderr," *ERROR* - no input data detected; exiting\n");
	      exit(1);
	      }
	    }
	  }

	C_ARGSTR("-O",otap," "," ",&argc,argv);
	if (strncmp(otap," ",1) != 0) {
	  C_LBOPEN(&luout,otap,"w");
	  if (luout <= 0) {
	    fprintf(stderr,"%s: unable to open output dataset %s\n",
		argv[0],otap);
	    exit(1);
	    }
	  }
	else {
	  int status;
	  status = is_a_pipe(stdout);
/*
	  fprintf(stderr,"status = %d\n");
	  if (is_a_pipe(stdout) <= 0) {
	   fprintf(stderr,"stdout is not connected\n");
	   exit(-99);
	   }
	  else
*/
	   luout = 1;

/* make sure we're not writing the output data to the terminal */

	   if (stat("/dev/tty",&statbuf) == -1) {
		fprintf(stderr,"HLHEDIT: stat of /dev/tty failed\n");
		exit(1);
		}
	   ttydev = statbuf.st_dev;
	   if (fstat(luout,&statbuf) == -1) {
		fprintf(stderr,"HLHEDIT: stat of stdout failed\n");
		exit(1);
		}
	   if (statbuf.st_dev == ttydev) {
	     fprintf(stderr,"HLHEDIT: ");
	     fprintf(stderr," *ERROR* - output destination to tty detected; aborting\n");
	     exit(1);
	     }

/* experiment in overwriting. Unfortunately, it doesn't truncate the file
   when it is closed, so subsequent program have problems with it..

	  if (luin == 0) {
	    fprintf(stderr,"input dataset is piped; output dataset must be specified via -O command line argument\n");
	    exit(99);
	    }

	  C_LBOPEN(&luout,ntap,"r+");
	  if (luout <= 0) {
	    fprintf(stderr,"%s: unable to open input dataset %s for update\n",
		argv[0],ntap);
	    exit(1);
	    }
*/
	  }

	shell = XtAppInitialize(&app_con,"Hlhedit",NULL,
		0,&argc,argv,app_defs,NULL,0);

	dpy   = XtDisplay(shell);
	screen_number = DefaultScreen(dpy);
	depth = DefaultDepth(dpy,screen_number);

	arrow_pixmap = XCreatePixmapFromBitmapData (XtDisplay (shell),
				RootWindowOfScreen (XtScreen (shell)),
				(char *) arrow_bits,
				arrow_width, arrow_height,
				BlackPixelOfScreen (XtScreen (shell)),
				WhitePixelOfScreen (XtScreen (shell)),
				depth);

	outer_form = XtVaCreateManagedWidget("oform",
		xmFormWidgetClass, shell,
			XmNallowOverlap,	FALSE,
			XmNresizable,		TRUE,
			XmNresizePolicy,	XmRESIZE_ANY,
			XmNverticalSpacing,	5,
			NULL);

        toggle_label = XmStringCreateLtoR("HLH Entries",
				XmSTRING_DEFAULT_CHARSET);
	header = XtVaCreateManagedWidget("Heading",
		xmLabelWidgetClass,outer_form,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNtopAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_NONE,
			XmNlabelString, toggle_label,
			XmNborderWidth, 3,
			XmNmarginWidth, 3,
			XmNshadowThickness, 3,
/*
			XmNborderPixmap, arrow_pixmap,
*/
			NULL);

	menubar = header; /* used later for attachment, and .. */

/*  - I decided to go without the menubar, but left the code in here 
      in case I change my mind...                  Joe M. Wade - 7/12/99

	menubar = XmCreateMenuBar(outer_form,"menuBar",Xarg,nargs);
	XtVaSetValues(menubar,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		header,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNleftOffset,		5,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNrightOffset,		5,
			NULL);

  	XtManageChild(menubar);
 	XuSet_Help(menubar,"MenuB_Dsc.help");
	XuCreateHelpPulldown(menubar);
	XuSet_Help_Shell(shell);
	help_path = getenv("HLHEDIT_HELPDIR");
	if (help_path == (char *)NULL) help_path = ".";
	XuSet_Help_Path(help_path);
	XuSet_Help_Index(help_items,(sizeof(help_items)/sizeof(char *))/2);
	XuSet_Help_Version(version);

  	file_pulldown = XmCreatePulldownMenu(menubar,"file_pd",NULL,0);
	XuSet_Help(  file_pulldown, "File_Dsc.help" );

  	file_but = XtVaCreateManagedWidget("File",
		xmCascadeButtonWidgetClass, menubar,
			XmNmnemonic,		'F',
			XmNsubMenuId,		file_pulldown,
			NULL);
	XuSet_Help(  file_but, "File_Dsc.help" );

	button_label = XmStringCreate("Open USP File",XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+O",XmSTRING_DEFAULT_CHARSET);
	open_but = XtVaCreateManagedWidget("open",
		xmPushButtonWidgetClass, file_pulldown,
			XmNmnemonic,		'O',
			XmNaccelerator, 	"Ctrl<Key>O",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			NULL);

	input_dialog = XmCreateFileSelectionDialog(open_but,"input_dialog",
			NULL,0);
	XtAddCallback(input_dialog, XmNokCallback, open_file, NULL);
	XtAddCallback(input_dialog, XmNokCallback,
				 drop_dialog, input_dialog);
	XtAddCallback(input_dialog, XmNcancelCallback,
				 drop_dialog, input_dialog);

	XtAddCallback(open_but, XmNactivateCallback,
			pop_dialog, (XtPointer)input_dialog);
	XmStringFree(button_label);
	XmStringFree(accel_label);

	button_label = XmStringCreate("Quit",XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+Q",XmSTRING_DEFAULT_CHARSET);
	quit_but = XtVaCreateManagedWidget("quit",
		xmPushButtonWidgetClass, file_pulldown,
			XmNmnemonic,		'Q',
			XmNaccelerator, 	"Ctrl<Key>Q",
			XmNacceleratorText,	accel_label,
			XmNlabelString,		button_label,
			NULL);
	XtAddCallback(quit_but, XmNactivateCallback, terminate, NULL );
*/

	apply_button = XtVaCreateManagedWidget("Apply",
		xmPushButtonWidgetClass,outer_form,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_POSITION,
			XmNrightPosition, 50,
			XmNtopAttachment, XmATTACH_NONE,
			XmNbottomAttachment, XmATTACH_FORM,
			NULL);

	cancel_button = XtVaCreateManagedWidget("Cancel",
		xmPushButtonWidgetClass,outer_form,
			XmNrightAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_POSITION,
			XmNleftPosition, 50,
			XmNtopAttachment, XmATTACH_NONE,
			XmNbottomAttachment, XmATTACH_FORM,
			NULL);

	separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass,outer_form,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_WIDGET,
			XmNbottomWidget,	apply_button,
			NULL);

	XtAddCallback(apply_button, XmNactivateCallback, write_data, NULL );
	XtAddCallback(cancel_button, XmNactivateCallback, terminate, NULL );

	hlh_entries = XtVaCreateManagedWidget("hlh_enties",
		xmTextWidgetClass,outer_form,
			XmNleftAttachment,	XmATTACH_NONE,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	50,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_WIDGET,
			XmNbottomWidget,	separator,
			XmNresizeWidth,		TRUE,
			XmNeditable,		FALSE,
			NULL);

        label = XmStringCreateLtoR("Number of HLH Entries:",
				XmSTRING_DEFAULT_CHARSET);
	hlh_entry_label = XtVaCreateManagedWidget("Finish",
		xmLabelWidgetClass,outer_form,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_WIDGET,
			XmNrightWidget, hlh_entries,
			XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget, hlh_entries,
			XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget, hlh_entries,
			XmNlabelString, label,
			NULL);

	hlh_sum = XtVaCreateManagedWidget("hlh_enties",
		xmTextWidgetClass,outer_form,
			XmNleftAttachment,	XmATTACH_NONE,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_WIDGET,
			XmNbottomWidget,	separator,
			XmNresizeWidth,		TRUE,
			XmNeditable,		FALSE,
			NULL);

        label = XmStringCreateLtoR("Total HLH Byte Count:",
				XmSTRING_DEFAULT_CHARSET);
	hlh_sum_label = XtVaCreateManagedWidget("Finish",
		xmLabelWidgetClass,outer_form,
			XmNleftAttachment, XmATTACH_POSITION,
			XmNleftPosition, 50,
			XmNrightAttachment, XmATTACH_WIDGET,
			XmNrightWidget, hlh_sum,
			XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget, hlh_sum,
			XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget, hlh_sum,
			XmNlabelString, label,
			NULL);

	separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass,outer_form,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNbottomAttachment,	XmATTACH_WIDGET,
			XmNbottomWidget,	hlh_sum_label,
			NULL);

	nargs = 0;
	XtSetArg(Xarg[nargs], XmNvisualPolicy, XmCONSTANT);	nargs++;
	XtSetArg(Xarg[nargs], XmNscrollingPolicy, XmAUTOMATIC);	nargs++;
	XtSetArg(Xarg[nargs], XmNautoShowCursorPosition, TRUE);	nargs++;
	scroll_window = XmCreateScrolledWindow(outer_form,"scroll",Xarg,nargs);

	XtVaSetValues(scroll_window,
			XmNtopAttachment, XmATTACH_WIDGET,
			XmNtopWidget,	  menubar,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNbottomAttachment, XmATTACH_WIDGET,
			XmNbottomWidget, separator,
			XmNmappedWhenManaged, True,
			XmNscrollBarDisplayPolicy, XmAS_NEEDED,
			XmNscrollBarPlacement, XmBOTTOM_RIGHT,
			NULL);

	list_form = XtVaCreateManagedWidget("lform",
		xmFormWidgetClass, scroll_window,
			XmNallowOverlap,	FALSE,
			XmNresizable,		TRUE,
			XmNresizePolicy,	XmRESIZE_ANY,
			XmNverticalSpacing,	2,
			NULL);

	prev_widget = NULL;
	max_width = 0;
	max_height = 0;

	nbytes = 0;
	C_RTAPE(luin,buffer,&nbytes);

	offset = HSTOFF;

	get_hw_val(buffer,"HlhEnt",LINEHEADER,&hlh_entry_count);
	get_hw_val(buffer,"HlhByt",LINEHEADER,&orig_hlh_bytes);
	hlh_bytes = orig_hlh_bytes;
	text_string = (char *) XtMalloc(5*sizeof(char));
	sprintf(text_string,"%d",hlh_entry_count);
	XtVaSetValues(hlh_entries, XmNvalue, text_string, NULL);
	text_string = (char *) XtMalloc(5*sizeof(char));
	sprintf(text_string,"%d",hlh_bytes);
	XtVaSetValues(hlh_sum, XmNvalue, text_string, NULL);

/*
 * if the HLH is entry, we still put one line out with the toggle unset
 */
	if (hlh_entry_count == 0) {
	  blankhlh = 1;
	  hlh_entry_count = 1;
	  deleted_entries = 1;
	  }
	else {
	  blankhlh = 0;
	  deleted_entries = 0;
	  }

	toggle   = (Widget *)XtMalloc(hlh_entry_count * sizeof(Widget));
	size_text = (Widget *)XtMalloc(hlh_entry_count * sizeof(Widget));
	hlh_text = (Widget *)XtMalloc(hlh_entry_count * sizeof(Widget));
	add_line = (Widget *)XtMalloc(hlh_entry_count * sizeof(Widget));

/* test only
	separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass,list_form,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_NONE,
			NULL);
	prev_widget = separator;
*/
	for (i=0;i<hlh_entry_count; i++) {
	  if (blankhlh == 1)
	    hlh_entry_length = 0;
	  else
            get_indexed_hw_val((buffer+offset),SAVE_SHORT_DEF,0,1,LINEHEADER,
			&hlh_entry_length);
	hlh_entry = (char *) XtMalloc(hlh_entry_length+1);
        offset += HLHINT;
	strncpy(hlh_entry,buffer+offset,hlh_entry_length);
	hlh_entry[hlh_entry_length] = '\0';
        offset += hlh_entry_length;
	sprintf(text_string,"%2d",i);
        toggle_label = XmStringCreateLtoR("",
				XmSTRING_DEFAULT_CHARSET);
	*(toggle+i) = XtVaCreateManagedWidget("hlhtoggle",
		xmToggleButtonWidgetClass,list_form,
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_NONE,
			XmNbottomAttachment, XmATTACH_NONE,
			XmNlabelString, toggle_label,
			XmNset, True,
			NULL);

	if (blankhlh == 1) 
	  XtVaSetValues(*(toggle+i),XmNset,False,NULL);

	entry_length = strlen(hlh_entry);
	XtAddCallback(*(toggle+i), XmNvalueChangedCallback, update_stats,
			(XtPointer) entry_length);
	sprintf(hlhname,"size%03d",i);
	hlhname[7] = '\0';
	sprintf(ascii_entry_length,"%d",entry_length);

	*(size_text+i) = XtVaCreateManagedWidget(hlhname,
		xmTextWidgetClass,list_form,
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_WIDGET,
			XmNleftWidget, *(toggle+i),
			XmNrightAttachment, XmATTACH_NONE,
			XmNbottomAttachment, XmATTACH_NONE,
			XmNeditable, FALSE,
			XmNvalue,	ascii_entry_length,
			XmNcolumns,	5,
			XmNresizeWidth,TRUE,
			XmNuserData, (XtPointer) entry_length,
			NULL);

	sprintf(hlhname,"text%03d",i);
	*(hlh_text+i) = XtVaCreateManagedWidget(hlhname,
		xmTextWidgetClass,list_form,
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_WIDGET,
			XmNleftWidget, *(size_text+i),
			XmNrightAttachment, XmATTACH_NONE,
			XmNbottomAttachment, XmATTACH_NONE,
			XmNvalue,	hlh_entry,
			XmNcolumns,	entry_length,
			XmNresizeWidth,TRUE,
			XmNuserData, (XtPointer) i,
			NULL);

	XtAddCallback(*(hlh_text+i), XmNvalueChangedCallback,
		hlh_text_edit, (XtPointer) entry_length);
	XtAddCallback(*(hlh_text+i), XmNvalueChangedCallback,
		modify_entry_size, NULL);
	XtAddCallback(*(hlh_text+i), XmNfocusCallback,
		get_original_entry_length, NULL);
	XtAddCallback(*(hlh_text+i), XmNactivateCallback,
		hlh_add_line, list_form);

	XtVaSetValues(*(toggle+i),XmNuserData,
		(XtPointer)(*(hlh_text+i)),NULL);
	XtVaGetValues(list_form, XmNverticalSpacing, &height1, NULL);
	XtVaGetValues(*(hlh_text+i),XmNheight, &height2, NULL);
	max_height += height1 + height2;

	XtVaGetValues(*(hlh_text+i),XmNwidth, &width1, NULL);
	max_width = (width1 > max_width) ? width1 : max_width;

	*(add_line+i) = XtVaCreateManagedWidget("addline2",
		xmPushButtonWidgetClass,list_form,
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_WIDGET,
			XmNleftWidget, *(hlh_text+i),
			XmNrightAttachment, XmATTACH_NONE,
			XmNbottomAttachment, XmATTACH_NONE,
			XmNwidth, 20,
			XmNhighlightThickness, 1,
			XmNshadowThickness, 1,
			XmNmarginHeight, 0,
			XmNmarginWidth, 0,
			XmNlabelType, XmPIXMAP,
			XmNlabelPixmap, arrow_pixmap,
			XmNuserData, (XtPointer) i,
			NULL);

	XtAddCallback(*(add_line+i), XmNactivateCallback,
		hlh_add_line, list_form);

	if (prev_widget != NULL) {
	  XtVaSetValues(*(size_text+i),
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopWidget, prev_widget,
	    NULL);
	  XtVaSetValues(*(hlh_text+i),
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopWidget, prev_widget,
	    NULL);
	  XtVaSetValues(*(toggle+i),
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopWidget, prev_widget,
/* jmw - circular?
	    XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
	    XmNbottomWidget, *(size_text+i),
*/
	    NULL);
	  XtVaSetValues(*(add_line+i),
	    XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
	    XmNtopWidget, *(hlh_text+i),
	    XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
	    XmNbottomWidget, *(hlh_text+i),
	    NULL);
	  }
	else {
	  XtVaSetValues(*(size_text+i),
	    XmNtopAttachment, XmATTACH_FORM,
	    NULL);
	  XtVaSetValues(*(hlh_text+i),
	    XmNtopAttachment, XmATTACH_FORM,
	    NULL);
	  XtVaSetValues(*(toggle+i),
	    XmNtopAttachment, XmATTACH_FORM,
/* jmw - circular ?
	    XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
	    XmNbottomWidget, *(size_text+i),
*/
	    NULL);
	  XtVaSetValues(*(add_line+i),
	    XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
	    XmNtopWidget, *(hlh_text+i),
	    XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
	    XmNbottomWidget, *(hlh_text+i),
	    NULL);
	  }
/*
	XtVaSetValues(*(toggle+i),
	    XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
	    XmNbottomWidget, *(size_text+i),
	    NULL);
*/

/* - changed this to using the text widget - on LesTif it's much bigger...
	prev_widget = *(toggle+i);
*/
	prev_widget = *(hlh_text+i);

	}

	XmUpdateDisplay(list_form);
	
/* test code 
	XtVaSetValues(*(toggle+hlh_entry_count-1),
		XmNbottomAttachment, XmATTACH_FORM,
		NULL);
	XtVaSetValues(*(size_text+hlh_entry_count-1),
		XmNbottomAttachment, XmATTACH_FORM,
		NULL);
	XtVaSetValues(*(hlh_text+hlh_entry_count-1),
		XmNbottomAttachment, XmATTACH_FORM,
		NULL);

*/
	XtVaGetValues(*toggle,XmNwidth, &width2, NULL);
	width1 = max_width + width2;
	XtVaGetValues(*size_text,XmNwidth, &width2, NULL);
	width1 += width2;
	XtVaGetValues(*add_line,XmNwidth, &width2, NULL);
	width1 += width2 + 20;   /* 20 is fudge factor for spacing */
/*
fprintf(stderr,"width1 = %d\n",width1);
fprintf(stderr,"max_height = %d\n",max_height);
*/
	XtVaSetValues(list_form,
			XmNwidth, width1,
			XmNheight, max_height,
			NULL);
	XtVaSetValues(scroll_window,
			XmNwidth, width1,
			XmNheight, (max_height+75 > 600) ? 600 : max_height+75,
			NULL);
	XtManageChild(scroll_window);
	XtRealizeWidget(shell);
	XtAppMainLoop(app_con);
}
XtCallbackProc update_stats(toggle,client_data,call_data)
Widget toggle;
XtPointer client_data;
XtPointer call_data;
{
	Widget text_widget;
	XtPointer userdata;
	char *text_value;
	short entry_length = (short)client_data;
	if (XmToggleButtonGetState(toggle)) {
	  XtVaGetValues(toggle,XmNuserData,&userdata,NULL);
	  text_widget = (Widget) userdata;
	  XtVaSetValues(text_widget,XmNsensitive,True,NULL);
	  XtVaGetValues(text_widget,XmNvalue,&text_value,NULL);
	  /* sscanf(text_value,"%d",&entry_length); */
	  entry_length = strlen(text_value);
	  deleted_entries--;
	  /* hlh_entry_count++; */
	  text_value = XtMalloc(6*sizeof(char));
	  sprintf(text_value,"%d",hlh_entry_count-deleted_entries);
	  XtVaSetValues(hlh_entries,XmNvalue,text_value,NULL);
	  hlh_bytes += entry_length + HLHINT;
	  sprintf(text_value,"%d",hlh_bytes);
	  XtVaSetValues(hlh_sum,XmNvalue,text_value,NULL);
	  XtFree(text_value);
	  }
	else {
	  XtVaGetValues(toggle,XmNuserData,&userdata,NULL);
	  text_widget = (Widget) userdata;
	  XtVaSetValues(text_widget,XmNsensitive,False,NULL);
	  XtVaGetValues(text_widget,XmNvalue,&text_value,NULL);
	  /* sscanf(text_value,"%d",&entry_length); */
	  entry_length = strlen(text_value);
	  deleted_entries++;
	  /* hlh_entry_count--; */
	  text_value = XtMalloc(6*sizeof(char));
	  sprintf(text_value,"%d",hlh_entry_count-deleted_entries);
	  XtVaSetValues(hlh_entries,XmNvalue,text_value,NULL);
	  hlh_bytes -= entry_length + HLHINT;
	  sprintf(text_value,"%d",hlh_bytes);
	  XtVaSetValues(hlh_sum,XmNvalue,text_value,NULL);
	  XtFree(text_value);
	  }
	return(0);
}
XtCallbackProc hlh_text_edit(header_entry,client_data,call_data)
Widget header_entry;
XtPointer client_data;
XtPointer call_data;
{
	int index;
	XtPointer userdata;
	char *text_value;
	int prev_entry_length = (int)client_data;
	int entry_length;
	XtVaGetValues(header_entry, XmNuserData, &userdata, NULL);
	index = (int) userdata;
	XtVaGetValues(header_entry,XmNvalue,&text_value,NULL);
	entry_length = strlen(text_value);
	XtVaSetValues(header_entry,
			XmNcolumns, (Dimension)entry_length,
			NULL);
	XmUpdateDisplay(header_entry);
	
	text_value = (char *) XtMalloc(5*sizeof(char *));
        if (XmToggleButtonGetState(*(toggle+index))) {
	  hlh_bytes -= prev_entry_length - entry_length;
	  sprintf(text_value,"%d",hlh_bytes);
	  XtVaSetValues(hlh_sum,XmNvalue,text_value,NULL);
	  }
	XtFree(text_value);
	XtRemoveCallback(header_entry, XmNvalueChangedCallback,
		hlh_text_edit, client_data);
	XtAddCallback(header_entry, XmNvalueChangedCallback,
		hlh_text_edit, (XtPointer) entry_length);
	return(0);
}
XtCallbackProc get_original_entry_length(header_entry,client_data,call_data)
Widget header_entry;
XtPointer client_data;
XtPointer call_data;
{
	int prev_entry_length;
	char *text_value;
	XtVaGetValues(header_entry,XmNvalue,&text_value,NULL);
	prev_entry_length = strlen(text_value);
	return(0);
}
XtCallbackProc modify_entry_size(header_entry,client_data,call_data)
Widget header_entry;
XtPointer client_data;
XtPointer call_data;
{
	int index;
	XtPointer userdata;
	char *text_value;
	int entry_length;

	XtVaGetValues(header_entry,XmNuserData,&userdata,NULL);
	index = (int) userdata;
	XtVaGetValues(header_entry,XmNvalue,&text_value,NULL);
	entry_length = strlen(text_value);
	sprintf(text_value,"%d",entry_length);
	XtVaSetValues(*(size_text+index), XmNvalue, text_value, NULL);
	return(0);
}
XtCallbackProc new_line_mapped(header_entry,client_data,call_data)
Widget header_entry;
XtPointer client_data;
XtPointer call_data;
{
	fprintf(stderr,"MAPPING CALLBACK\n");
/*
	    XWarpPointer(XtDisplay(scroll),None,XtWindow(*(hlh_text+index)),0,0,0,0,x+5,y+5);
*/
	    XSetInputFocus(XtDisplay(header_entry),XtWindow(header_entry),
		RevertToParent, 0);
	return(0);
}
XtCallbackProc query_data(widget, client_data, call_data)
     Widget widget;
     XtPointer client_data;
     XtPointer call_data;
{
	Widget list_form = (Widget) client_data;
	Dimension width,height;
	XtVaGetValues(list_form,
		XmNheight,&height,
		XmNwidth,&width,
		NULL);
	fprintf(stderr,"%s: %d x %d\n",(char *)XtName(list_form),width,height);
	XtVaGetValues(XtParent(list_form),
		XmNheight,&height,
		XmNwidth,&width,
		NULL);
	fprintf(stderr,"%s: %d x %d\n",(char *)XtName(XtParent(list_form)),width,height);
	return(0);
}
