C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c....................holdif.................................................
c
c 
c Feb 7, 2002 - add -live option to replace n1 by n2 only if n1 is dead trace.
c               [Sandy Rothe]
c Garossino
c
c Apr 27 2000 - added -3d option -hw3d and fixed ikp implimentation
c Garossino
c
c feb 4, 1998 - routine to output n1 unless there is a comparable record
c               in n2, in which case, output n2; then go on with n1.
c               [Harris:STAT/Gupco]
c
c programmer: Marilyn A. Miller, USP, EPTG
c
      implicit none

#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare USP variables

      integer itr(SZLNHD), itr2(SZLNHD)
      integer nsamp, nsi, ntrc, nrec, irs, ire, ns, ne, ist, iend
      integer nsamp2, nsi2, rec, trc, rec2, trc2, lbytes2
      integer luin, luin2, luout, lbytes, nbytes, obytes
      integer argis, nsampo, kbytes, jerr

      character name*6, ntap*255, ntap2*255, otap*255

      logical verbos

c variables used in dynamic memory allocation

      integer nbytalc, ier, abort

      real work

      pointer ( pwork, work(2) )

c declare program specific variables

      integer ifmt_RecNum, l_RecNum, ln_RecNum
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum
      integer ifmt_StaCor, l_StaCor, ln_StaCor, StaCor
      integer ifmt_HdrWrd, l_HdrWrd, ln_HdrWrd
      integer HdrWrd1, HdrWrd2, in_ikp, nrec2
      integer iform2, iform, nreco, ntrco,ii, jj
      integer  pipin

      real r_HdrWrd, unitsc, si, dt

      character c_HdrWrd*6

      logical wind, IKP, threed, OnDead

c initialize variables
 
      data name /'HOLDIF'/
      data lbytes /0/
      data nbytes /0/
      data pipin/3/
 
      data wind/.false./, abort/0/

C get online help if necessary
 
      if ( argis('-?') .gt. 0 .or.
     :     argis('-h') .gt. 0 .or.
     :     argis('-help') .gt. 0 ) then
          call help()
          stop
      endif
 
C open printout file
 
#include <f77/open.h>
 
C get command line parameters
 
      call cmdln ( ntap, ntap2, otap, ns, ne, irs, ire,
     :     ist, iend, threed, c_HdrWrd, OnDead, verbos )
 
C open I/O data sets & assign logical units
 
      call getln ( luin2, ntap2, 'r', 0)
      IKP = .false.

      
      if (in_ikp() .eq. 1) then
         IKP = .true.
      endif
 
      write(LERR,*)in_ikp()
      if ( IKP ) then
         write(LERR,*)' in IKP'
        call sisfdfit (luin, pipin)
      else
         call getln ( luin, ntap, 'r', 0 )
      endif

      call getln ( luout, otap, 'w', 1)


c read input line headers; save certain parameters; check for
c  compatability between input datasets; adjust output line header;
c  update historical line header; write output line header

      lbytes2 = 0
      call rtape (luin2, itr2, lbytes2)
      if (lbytes2.eq.0) then
         write(LERR,*)'HOLDIF: no header read on N2 =',ntap2
         write(LERR,*)'        check existence of file and rerun'
         write(LERR,*)'** FATAL **'
         go to 9000
      endif

      call saver(itr2, 'NumRec', nrec2, LINEHEADER)
      call saver(itr2, 'NumSmp', nsamp2, LINEHEADER)
      call saver(itr2, 'SmpInt', nsi2  , LINEHEADER)
      call saver(itr2, 'Format', iform2, LINEHEADER)

      write(lerr,*)' nsamp2, nsi2, nrec2 ', nsamp2, nsi2, nrec2

      lbytes = 0
      call rtape (luin, itr, lbytes)
      if (lbytes.eq.0) then
         write(LERR,*)'HOLDIF: no header read on N1 =',ntap
         write(LERR,*)'        check existence of file and rerun'
         write(LERR,*)'** FATAL **'
         go to 9000
      endif

      call saver(itr, 'NumSmp', nsamp, LINEHEADER)
      call saver(itr, 'SmpInt', nsi  , LINEHEADER)
      call saver(itr, 'NumTrc', ntrc , LINEHEADER)
      call saver(itr, 'NumRec', nrec , LINEHEADER)
      call saver(itr, 'Format', iform, LINEHEADER)
      call saver(itr, 'UnitSc', UnitSc, LINEHEADER)

      write(lerr,*)' nsamp, nsi, nrec ', nsamp, nsi, nrec

      if (nsamp.ne.nsamp2 .or. nsi.ne.nsi2) then
         write(LERR,*)'HOLDIF: incompatible input datasets N1 and N2.'
         write(LERR,*)'        number of samples and sample interval'
         write(LERR,*)'        must agree.'
         write(LERR,*)'  N1:nsamp=',nsamp,'  nsi=',nsi
         write(LERR,*)'  N2:nsamp=',nsamp2,'  nsi=',nsi2
         write(LERR,*)'** FATAL **'
         go to 9000
      endif

      if (irs.eq.0) irs = 1
      if (ire.eq.0) ire = nrec
      if (ns.eq.0) ns = 1
      if (ne.eq.0) ne = ntrc

      nreco = ire - irs + 1
      ntrco = ne - ns + 1

c check for selected sample output
      si = float(nsi)
      dt = si * unitsc
      iend = float(iend)/dt + .5
      ist = float(ist)/dt + .5
      if (ist.le.1) ist = 1
      if (iend.eq.0) iend = nsamp
      if (iend.gt.nsamp) iend = nsamp

c check for windowing of output
      if (ist.gt.1 .or. iend.lt.nsamp) then
          wind = .true.
          nsampo = iend - ist + 1
          nbytalc = nsamp * SZSMPD
          call galloc (pwork, nbytalc, ier, abort)
          if (ier.ne.0) then
             write(LERR,*)' '
             write(LERR,*)'FATAL ERROR in holdif:'
             write(LERR,*)'Unable to allocate workspace:'
             write(LERR,*) nbytalc,'  bytes'
             write(LERR,*)' '
             write(LER ,*)' '
             write(LER ,*)'FATAL ERROR in holdif:'
             write(LER ,*)'Unable to allocate workspace:'
             write(LER ,*) nbytalc,'  bytes'
             write(LER ,*)' '
             go to 9000
          endif

          obytes = SZTRHD + SZSMPD * nsampo
      else

          nsampo = nsamp
          obytes = SZTRHD + SZSMPD * nsamp
      endif

c update and output line header

      call savew(itr, 'NumTrc', ntrco , LINEHEADER)
      call savew(itr, 'NumRec', nreco , LINEHEADER)
      call savew(itr, 'NumSmp', nsampo , LINEHEADER)

      call savhlh (itr, lbytes, kbytes)
      call wrtape (luout, itr, kbytes)

c verbose printout of program parameters

      call verbal( ntap, ntap2, otap, ns, ne, irs, ire, ist, iend, 
     :     threed, c_HdrWrd, OnDead, ntrco, nreco, nsampo, nsi, 
     :     verbos )

c build pointers to required trace header entries

      call savelu ( 'RecNum', ifmt_RecNum, l_RecNum, ln_RecNum,
     :     TRACEHEADER )
      call savelu ( 'TrcNum', ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :     TRACEHEADER )
      call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor,
     :     TRACEHEADER )

      if ( threed ) call savelu ( c_HdrWrd, ifmt_HdrWrd, l_HdrWrd, 
     :     ln_HdrWrd, TRACEHEADER )

c read first trace from input dataset N2

      call rtape (luin2, itr2, lbytes2)

      if (lbytes2.eq.0) then
         write(LERR,*)'HOLDIF: no data on -N2 '
         write(LERR,*)'        check existence of file and rerun'
         write(LERR,*)'** FATAL **'
         go to 9000
      endif

      call saver2 ( itr2, ifmt_RecNum, l_RecNum, ln_RecNum,
     :             rec2, TRACEHEADER )
      call saver2 ( itr2, ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :             trc2, TRACEHEADER )

c debug
c      write(LERR,*)' reading first N2 trace ', rec2, trc2, luin2
c debug

      if ( threed ) then

c free format read of 3D header if used 

         if ( ifmt_HdrWrd .eq. SAVE_FLOAT_DEF .or.
     :        ifmt_HdrWrd .eq. SAVE_FKFLT_DEF ) then

            call saver2 (itr2,ifmt_HdrWrd,l_HdrWrd,ln_HdrWrd,
     :        r_HdrWrd, TRACEHEADER)
            HdrWrd2 = nint ( r_HdrWrd)

         else

            call saver2 (itr2,ifmt_HdrWrd,l_HdrWrd,ln_HdrWrd,
     :        HdrWrd2, TRACEHEADER)

         endif

c debug
c      write(LERR,*)' HdrWrd2 = ', HdrWrd2
c debug

      endif

c position input dataset N1 at requested location

      call recskp (1,irs-1,luin,ntrc,itr)

      DO ii = irs, ire

c position at first requested trace in each record

         call trcskp(ii,1,ns-1,luin,ntrc,itr)

     
         DO jj = ns, ne

c read in trace from N1

            call rtape (luin, itr, lbytes)
            call saver2 (itr,ifmt_RecNum,l_RecNum,ln_RecNum,
     :           rec, TRACEHEADER)
            call saver2 (itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     :           trc, TRACEHEADER)
            call saver2 (itr,ifmt_StaCor,l_StaCor,ln_StaCor,
     :           StaCor, TRACEHEADER)

            if ( threed ) then

c free format read of 3D header if used 

               if ( ifmt_HdrWrd .eq. SAVE_FLOAT_DEF .or.
     :              ifmt_HdrWrd .eq. SAVE_FKFLT_DEF ) then

                  call saver2 (itr,ifmt_HdrWrd,l_HdrWrd,ln_HdrWrd,
     :                 r_HdrWrd, TRACEHEADER)
                  HdrWrd1 = nint ( r_HdrWrd)
                    
               else

                  call saver2 (itr,ifmt_HdrWrd,l_HdrWrd,ln_HdrWrd,
     :                 HdrWrd1, TRACEHEADER)
                    
               endif
               
            endif


c check if we need to read next trace from N2

 100        continue

            if (rec .gt. rec2) then

           call rtape (luin2, itr2, lbytes2)

c debug
c      write(LERR,*)' reading N2 trace ', ii, jj
c debug

           if (lbytes2.eq.0) then
 
             write(LERR,*)'HOLDIF: EOF reached on N2'
              write(LERR,*)'will output N1 from here on'
              rec2 = 99999
              trc2 = 99999

           else

              call saver2 (itr2,ifmt_RecNum,l_RecNum,ln_RecNum,
     :                     rec2, TRACEHEADER)
              call saver2 (itr2,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     :                     trc2, TRACEHEADER)

c debug
c              write(LERR,*)' reading N2 trace ', rec2, trc2, ii, jj
c debug

              if ( threed ) then

c free format read of 3D header if used 

                 if ( ifmt_HdrWrd .eq. SAVE_FLOAT_DEF .or.
     :                ifmt_HdrWrd .eq. SAVE_FKFLT_DEF ) then

                    call saver2 (itr2,ifmt_HdrWrd,l_HdrWrd,ln_HdrWrd,
     :                   r_HdrWrd, TRACEHEADER)
                    HdrWrd2 = nint ( r_HdrWrd)
                    
                 else

                    call saver2 (itr2,ifmt_HdrWrd,l_HdrWrd,ln_HdrWrd,
     :                   HdrWrd2, TRACEHEADER)
                    
                 endif

              endif

              go to 100
           endif

        elseif (rec.eq.rec2 .and. trc.gt.trc2) then
 
           call rtape (luin2, itr2, lbytes2)
 
           if (lbytes2.eq.0) then
              write(LERR,*)'HOLDIF: EOF reached on N2'
              write(LERR,*)'will output N1 from here on'
              rec2 = 99999
              trc2 = 99999
 
           else
 
              call saver2 (itr2,ifmt_RecNum,l_RecNum,ln_RecNum,
     :                     rec2, TRACEHEADER)
              call saver2 (itr2,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     :                     trc2, TRACEHEADER)
              if ( threed ) then
c debug
c      write(LERR,*)' reading N2 trace ', rec2, trc2, ii, jj
c debug

c free format read of 3D header if used 

                 if ( ifmt_HdrWrd .eq. SAVE_FLOAT_DEF .or.
     :                ifmt_HdrWrd .eq. SAVE_FKFLT_DEF ) then

                    call saver2 (itr2,ifmt_HdrWrd,l_HdrWrd,ln_HdrWrd,
     :                   r_HdrWrd, TRACEHEADER)
                    HdrWrd2 = nint ( r_HdrWrd)

                 else

                    call saver2 (itr2,ifmt_HdrWrd,l_HdrWrd,ln_HdrWrd,
     :                   HdrWrd2, TRACEHEADER)

                 endif

              endif

              go to 100
              
           endif

        endif

c check for a match from N1 and N2

        if (rec.eq.rec2 .and. trc.eq.trc2) then

           if ( threed ) then

              if ( HdrWrd1 .eq. HdrWrd2 ) then

c output N2 trace
                 call vmov (itr2,1,itr,1,nsamp+ITRWRD)

c get next N2 trace
                 call rtape (luin2, itr2, lbytes2)
 
                 if (lbytes2.eq.0) then

                    write(LERR,*)'HOLDIF: EOF reached on N2'
                    write(LERR,*)'will output N1 from here on'
                    rec2 = 99999
                    trc2 = 99999
 
                 else
 
                    call saver2 (itr2,ifmt_RecNum,l_RecNum,ln_RecNum,
     :                   rec2, TRACEHEADER)
                    call saver2 (itr2,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     :                   trc2, TRACEHEADER)
c debug
c      write(LERR,*)' reading N2 trace ', rec2, trc2, ii, jj
c debug
                    if ( ifmt_HdrWrd .eq. SAVE_FLOAT_DEF .or.
     :                   ifmt_HdrWrd .eq. SAVE_FKFLT_DEF ) then
                       
                       call saver2 (itr2,ifmt_HdrWrd,l_HdrWrd,ln_HdrWrd,
     :                      r_HdrWrd, TRACEHEADER)
                       HdrWrd2 = nint ( r_HdrWrd)

                    else

                       call saver2 (itr2,ifmt_HdrWrd,l_HdrWrd,ln_HdrWrd,
     :                      HdrWrd2, TRACEHEADER)
                       
                    endif

                    go to 100
                 endif

              else

c in the right bin but not the right trace ... go get the next one
                 go to 100
              endif

           else

              if ( OnDead .and. StaCor .eq. 30000 ) then

c output N2 trace
                 call vmov (itr2,1,itr,1,nsamp+ITRWRD)

              elseif ( .not. OnDead ) then

c output N2 trace
                 call vmov (itr2,1,itr,1,nsamp+ITRWRD)

              endif


c get next N2 trace
              call rtape (luin2, itr2, lbytes2)
 
              if (lbytes2.eq.0) then

                 write(LERR,*)'HOLDIF: EOF reached on N2'
                 write(LERR,*)'will output N1 from here on'
                 rec2 = 99999
                 trc2 = 99999
 
              else
 
                 call saver2 (itr2,ifmt_RecNum,l_RecNum,ln_RecNum,
     :                rec2, TRACEHEADER)
                 call saver2 (itr2,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     :                trc2, TRACEHEADER)
                 go to 100
              endif

           endif


        endif

c check for windowing

        if (wind) then
           call vmov (itr(ITRWRD + ist - 1),1,work,1,nsampo)
           call vmov (work,1,itr,1,nsampo)
        endif

c write trace to output
        call wrtape (luout,itr,lbytes)

        ENDDO

      ENDDO

c end of processing, close datasets, end program

      call lbclos (luin)
      call lbclos (luin2)
      call lbclos (luout)

c debug 
c      write(LERR,*) ' at end' ,ii,jj
c debug

      write(LERR,*)'HOLDIF: Normal Termination'
      write(LERR,*)'        processed ',nreco,' records'
      stop

 9000 continue

      call lbclos (luin)
      call lbclos (luin2)
      call lbclos (luout)

      write(LERR,*)'HOLDIF: Abnormal Termination'
      write(LERR,*)'        processed ',nreco,' records'
      stop
      end
c
c
c
      subroutine help()
#include <f77/iounit.h>
        write(LER,*)' '
        write(LER,*)'Command Line Arguments for HOLDIF: this program'
        write(LER,*)'outputs N1 unless there is a comparable rec/tr'
        write(LER,*)'on N2---then it outputs N2'
        write(LER,*)' '
        write(LER,*)'Input...................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N1[ntap1] -- input data set name 1        (none)'
        write(LER,*)'-N2[ntap2] -- input data set name 2       (stdin)'
        write(LER,*)'              (replacement traces)'
        write(LER,*)'  WARNING: DO NOT RENUMBER these traces.  If they'
        write(LER,*)'           are renumbered, you lose the indexing'
        write(LER,*)'           into ntap1.'
        write(LER,*)'-O[otap]   -- output data set name       (stdout)'
        write(LER,*)'-s[ist]    -- start time                   (0 ms)'
        write(LER,*)'-e[iend]   -- end time                (last samp)'
        write(LER,*)'-ns[nst]   -- start trace number       (first tr)'
        write(LER,*)'-ne[ned]   -- end trace number          (last tr)'
        write(LER,*)'-rs[nrst]  -- start record            (first rec)'
        write(LER,*)'-re[nred]  -- end record               (last rec)'
        write(LER,*)'-3d        -- 3d indexing required   (2d assumed)'
        write(LER,*)'-hw3d[]    -- additional index mnemonic  (DstSgn)'
        write(LER,*)' '
        write(LER,*)'-live      -- outputs N2 in place of N1 only if'
        write(LER,*)'              N1 StaCor = 30000'
        write(LER,*)' '
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)' '
        write(LER,*)'holdif -N1[] -N2[] -O[] -s[] -e[] -ns[] -ne[]'
        write(LER,*)'       -rs[] -re[] -3d -hw3d[] -live -V]'
        write(LER,*)' '

      return
      end
c
c
c
      subroutine cmdln ( ntap, ntap2, otap, ns, ne, irs, ire,
     1     ist, iend, threed, c_HdrWrd,  OnDead, verbose)

      implicit none

#include <f77/iounit.h>

c variables passed from calling routine

      integer ns, ne, irs, ire, ist, iend
      character   ntap*(*), ntap2*(*), otap*(*), c_HdrWrd*6
      logical     verbose, threed, OnDead

c local variables

      integer     argis

c parse command line
      
      threed =   (argis('-3d') .gt. 0)


      call argi4 ( '-e', iend ,   0  ,  0    )

      call argstr( '-hw3d', c_HdrWrd, 'DstSgn', 'DstSgn' )

      OnDead = ( argis('-live') .gt. 0 )

      call argstr( '-N1', ntap, ' ', ' ' )
      call argstr( '-N2', ntap2, ' ', ' ' )
      call argi4 ( '-ne', ne ,   0  ,  0    )
      call argi4 ( '-ns', ns ,   0  ,  0    )

      call argstr( '-O', otap, ' ', ' ' )

      call argi4 ( '-re', ire ,   0  ,  0    )
      call argi4 ( '-rs', irs ,   0  ,  0    )

      call argi4 ( '-s', ist ,   0  ,  0    )

      verbose =   (argis('-V') .gt. 0)

      return
      end

