C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine hthresh_sub ( record, nsamp, ntrc, ist, iend, minv, 
     :     maxv, vmax_temp, vmin_temp, number_bins, bin_size, 
     :     histogram, lb, ub, threshold, r_HdrWrd, Headers,
     :     ifmt_StaCor, l_StaCor, ln_StaCor, verbos)

      implicit none

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c declare variables passed from calling routine

      integer nsamp, ntrc, ist, iend, number_bins
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      integer Headers(ITRWRD,ntrc)

      real record(nsamp, ntrc), histogram(number_bins)
      real lb(number_bins), ub(number_bins)
c     real sum(number_bins)
      real sum(*)
      real bin_size, minv, maxv, vmax_temp, vmin_temp, threshold
      real r_HdrWrd

      pointer(wk_sum,sum)

      logical verbos

c declare local variables

      integer ierr, iabort, ifirst
      integer i, j, bin_number, StaCor, num_dead

      save ifirst, wk_sum

      real running_sum, numerator, denominator, lb1, lb2

      data ierr / 0 /, iabort / 0 /, ifirst / 0 /
      
      call galloc(wk_sum, number_bins * SZSMPD, ierr, iabort)
      if (ierr .ne. 0) then
	write(LER,111)
	write(LERR,111)
  111 format(' HTHRESH FATAL ERROR: Unable to dynamically',
     :   ' allocate ',i,' bytes requested for processing;',
     :   ' aborting execution')
	call abort(100)
      endif
     
c initialize variables

      do i = 1, number_bins

         histogram(i) = 0.0

      enddo

      if ( vmax_temp .eq. -99999. .or. vmin_temp .eq. -99999. )  then

c if vmax_temp = -99999.0 then the user has NOT entered
c max and min information on the command line and we are
c to use the min and max infor found in the data

         DO i = ist, iend

            num_dead = 0

            DO j = 1, ntrc

               call saver2 ( Headers(1,j), ifmt_StaCor, l_StaCor, 
     :              ln_StaCor, StaCor, TRACEHEADER )
               
               if ( StaCor .ne. 30000) then

                  if (vmax_temp .eq. -99999.)
     :                 maxv = max(maxv,record(i,j))
                  if (vmin_temp .eq. -99999.)
     :                 minv = min(minv,record(i,j)) 

               else

                  num_dead = num_dead + 1

               endif
 
            ENDDO
         ENDDO

c watch out for a dead record as happened with tape2276 of Ellice3D
c project

         if ( num_dead .eq. ntrc ) then
            r_HdrWrd = 0.0
            return
         endif

c reform bin system based on new minv and maxv if required

         bin_size =  (maxv - minv) / float(number_bins)
         histogram(1) = 0.0
         lb(1) = minv - bin_size
         ub(1) = minv

         do i = 2, number_bins + 1
            histogram(i) = 0
            ub(i) = minv + (bin_size * float(i-1))
            lb(i) = ub(i-1)
         enddo
         
         histogram(number_bins+2) = 0
         lb(number_bins+2) = maxv
         ub(number_bins+2) = maxv + bin_size

      endif

      DO i = ist, iend

         DO j = 1, ntrc

            call saver2 ( Headers(1,j), ifmt_StaCor, l_StaCor, 
     :           ln_StaCor, StaCor, TRACEHEADER )

            if ( StaCor .ne. 30000 ) then

c work on live traces only

               if ( record(i,j) .lt. minv .and.
     :              abs(record(i,j) ) .gt. 1.e-32 ) then

c if amplitude is less than the minimum requested then bin assignment is 
c bin 1
                  bin_number = 1

               elseif ( record(i,j) .ge. maxv .and.
     :                 abs(record(i,j) ) .gt. 1.e-32 ) then

c if amplitude is greater than maximum allowed then bin assignment is
c max bin
                  bin_number = number_bins + 2

               elseif ( abs(record(i,j) ) .gt. 1.e-32) then 

c only allow non hard zero contributions, the assumption is that
c hard zeroes belong to the mute zone or unflagged dead traces
c and are not required

                  bin_number = int( (record(i,j) - minv) / bin_size) + 2

               endif
         
               if ( abs(record(i,j)) .gt. 1.e-32 ) 
     :              histogram(bin_number) = histogram(bin_number) + 1

            endif
            
         ENDDO
      ENDDO

c form sum and running sum 

      running_sum = 0.0

c fix this:  I want to look from zero up, this might 
c start somewhere in the positives already if the user
c happens to have used -min 0.0 for instance....PGAG

      do i = number_bins/2, number_bins+1
         running_sum = running_sum + histogram(i)
         sum(i) = running_sum
      enddo

c determine amplitude at requested threshold using linear interpolation for now

c I want to look from zero up for now, we may dream up a different algorithm
c later but for now this will do

      do i = 1, number_bins

         if ( ( float(i-1) * bin_size + minv ) .ge. 0.0 ) then
            
            if ( ( sum(i) / running_sum ) .gt. ( threshold / 100. ) ) 
     :           then

               numerator  = ( threshold / 100. ) - 
     :              ( sum(i-1) / running_sum )

               denominator = ( sum(i)/running_sum) - 
     :              ( sum(i-1)/running_sum )

               lb2 =  ( lb(i) + ub(i) ) / 2.
               lb1 =  ( lb(i-1) + ub(i-1) ) / 2.
               r_HdrWrd = ( numerator / denominator ) * (lb2 - lb1 ) 
     :              + lb1
               return
            endif
         endif

      enddo

c should never get here so stop and warn user if we do

      write(LERR,*)' Bug in program, look in hthresh_sub, last lines'
      write(LERR,*)' We should never have gotten to this point so '
      write(LERR,*)' Something has failed big time in the program'
      write(LERR,*)' logic'

      stop 
      end
