C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdpicks(segname,segnum,segcolor,npicks,
     1                   record,trace,sample,
     2                   recunit,trcunit,smpunit,recoff,trcoff,smpoff,
     3                   maxpicks,nsegments,lupicks,lerr,
     4                   nsamp,ntrace,nrec)  
c_______________________________________________________________________
C     Simple fortran program to read in the new format xsd picks.  
c_______________________________________________________________________
      character*(*) segname(nsegments)
      integer       segnum(nsegments)
      integer       segcolor(nsegments)
      integer       npicks(nsegments)
      real          record(maxpicks,nsegments)
      real          trace(maxpicks,nsegments)
      real          sample(maxpicks,nsegments)
c_______________________________________________________________________
C     loop over number of segments.                                          
c     note segment name will not be put into an array!
c_______________________________________________________________________
      do 300 iseg=1,nsegments
       read(lupicks,101,err=99991)segnum(iseg),segname(iseg),
     1                            segcolor(iseg),npicks(iseg)
101    format(10x,i5,6x,a20,10x,i5,9x,i5)
c_______________________________________________________________________
C      loop over number of picks                                              
c_______________________________________________________________________
       do 200 ipick=1,npicks(iseg)
        read(lupicks,102,err=99992)record(ipick,iseg),trace(ipick,iseg),
     1                             sample(ipick,iseg)
102     format(f12.6,1x,f12.6,1x,f12.6)
200    continue
300   continue

      close(lupicks)
c_____________________________________________________________________
c     add scales and offsets.
c_____________________________________________________________________
      do 20000 iseg=1,nsegments
       do 10000 ipick=1,npicks(iseg)
        record(ipick,iseg)=(record(ipick,iseg)-recoff)/recunit
        sample(ipick,iseg)=(sample(ipick,iseg)-smpoff)/smpunit
        trace(ipick,iseg)=(trace(ipick,iseg)-trcoff)/trcunit
10000  continue
20000 continue
c_____________________________________________________________________
c     check that all picks are valid.                         
c_____________________________________________________________________
      ipickerror=0
      do 50000 iseg=1,nsegments
       do 40000 ipick=1,npicks(iseg)
        if(record(ipick,iseg) .gt. nrec) then
           write(lerr,*) 'segment goes outside sequential '
     1                   //'  record limits!'
           write(lerr,*) 'segnum = ',segnum(iseg)
           write(lerr,*) 'segname= ',segname(iseg)
           write(lerr,*) 'segcolor= ',segcolor(iseg)
           write(lerr,*) 'ipick  = ',ipick
           write(lerr,*) 'record(1    ,iseg) = ',record(1    ,iseg)
           write(lerr,*) 'record(ipick,iseg) = ',record(ipick,iseg)
           ipickerror=ipickerror+1
        endif
        if(record(ipick,iseg) .lt. 0.)  then  
           write(lerr,*) 'segment less for record less than 0!'
           write(lerr,*) 'record must be positive!'                 
           write(lerr,*) 'segnum = ',segnum(iseg)
           write(lerr,*) 'segname= ',segname(iseg)
           write(lerr,*) 'segcolor= ',segcolor(iseg)
           write(lerr,*) 'ipick  = ',ipick
           write(lerr,*) 'record(ipick,iseg)  = ',record(ipick,iseg)
           ipickerror=ipickerror+1
        endif

        if(trace(ipick,iseg) .lt. 0. .or. 
     1             trace(ipick,iseg) .gt. ntrace) then
           write(lerr,*) 'segment goes outside sequential '
     1                   //'  trace limits!'
           write(lerr,*) 'trace must fall between 1 and ',ntrace       
           write(lerr,*) 'segnum = ',segnum(iseg)
           write(lerr,*) 'segname= ',segname(iseg)
           write(lerr,*) 'segcolor= ',segcolor(iseg)
           write(lerr,*) 'ipick  = ',ipick
           write(lerr,*) 'trace(ipick,iseg)  = ',trace(ipick,iseg)  
           ipickerror=ipickerror+1
        endif
        if(sample(ipick,iseg) .lt. 0. .or. 
     1             sample(ipick,iseg) .gt. nsamp) then
           write(lerr,*) 'segment goes outside physical sample limits!'
           write(lerr,*) 'trace must fall between 1 and ',nsamp           
           write(lerr,*) 'segnum = ',segnum(iseg)
           write(lerr,*) 'segname= ',segname(iseg)
           write(lerr,*) 'segcolor= ',segcolor(iseg)
           write(lerr,*) 'ipick  = ',ipick
           write(lerr,*) 'sample(ipick,iseg)  = ',sample(ipick,iseg)  
           ipickerror=ipickerror+1
        endif

40000  continue
50000 continue
      if(ipickerror .gt. 0) then
         write(lerr,*) 'program aborted due to ',ipickerror,
     1                 'in routine rdpicks'
         call exit(20001)
      endif
c
      return
c
99991 write(lerr,*) 'error in routine rdpicks!'
      write(lerr,*) 'read error in attempting to read segment header'
     1              //' card number ',iseg,' of ',nsegments
      write(lerr,*) 'Please check input pick file!'
      call exit(20002)
c
99992 write(lerr,*) 'error in routine rdpicks!'
      write(lerr,*) 'read error in attempting to read pick card ',   
     1              ipick,' of ',npicks(iseg) 
      write(lerr,*) 'segment = ',iseg,' segname = ',segname(iseg)
      write(lerr,*) 'Please check input pick file!'
      call exit(20003)
c
      end
