/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>

#include "ikp_defines.h"
#include "ikp_externs.h"
#include "globalE.h"


void error_ok_cancelCB(Widget w,
		XtPointer client_data,
		XtPointer *call_data)
{
  XtDestroyWidget(w);
}

void ikp_err(char *msg,int severity)
{
  static Widget error;
  int root_x,root_y;
  
  fprintf(stderr, "%s: %s\n", progname, msg);
  fflush(stderr);

  if (severity==FATAL)
    exit(-1);

  if (usage_mode==BATCH)
    return;
  
  if (init_complete) {
    locate_cursor(&root_x,&root_y);
    XBell(display,100);
    error=XmCreateErrorDialogVa(top_level,"error",
				XmNx,root_x,
				XmNy,root_y,
				XmNmessageString,XMstr(msg),
				XmNdefaultPosition,False,
				XmNdialogTitle,XMstr("Error Dialog"),
				XmNokCallback,CBl(error_ok_cancelCB,0),
				XmNcancelCallback,CBl(error_ok_cancelCB,0),
				NULL);
  }
  if (run_net==(Net *)NULL) {
    XDefineCursor(display,top_window,
		  get_cursor(LXC_CCURSOR));
  }
  return;
}

void ikp_childerr(char *msg,int exitcode)
{
  fprintf(stderr, "%s: %s\n", progname, msg);
  fflush(stderr);
  exit(exitcode);
}

void ikp_ioerr(char *msg,int severity)
{
  void ikp_err();
  
  sprintf(ikp_errbuf, "%s at line %1d.", msg, ikp_linenum);
  ikp_err(ikp_errbuf, severity);
}

void ikp_usage()
{
  fprintf(stderr, "usage: %s [ -d display ] [ -b ] [ -B ] [ netfile ] [ -n ] [ -l libfile ] [ -v level ]\n", progname);
  fflush(stderr);
  exit(-1);
}
