
/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>
#include <localsys.h>
#include <signal.h>
#include <sys/file.h>
#include <sys/param.h>
#include <netdb.h>
#include <arg.h>
#include <cu_defs.h>
#include "global.h"

#include "ikp_defines.h"
#include "ikp_externs.h"

FILE *errfp;			/* added 3/15/96 for debugging - joe m. wade */

main(argc, argv)
int argc;
char *argv[];
{
  XEvent event,event1;
  char *filenm;
  struct servent *sp;
  boolean rd_defsitelib;
  void init_windows();
  Bool ikp_anyevt();
  char *get_wkdir();
  struct servent *getservbyname();
  void ikp_usage(), net_monitor();
  char *pid_env;
  void sigint_hdlr();
  int C_ARGIS();

  errfp = stderr;
  pid_env=(char *) malloc(24*sizeof(char));
  if (pid_env == NULL) {
    (void) fprintf(stderr, "%s: pid_env error.\n", progname);
    exit(-1);
  }
#ifndef CONVEXSYSTEM
  sprintf(pid_env,"IKP_PID=%d",getpid());
  if (putenv(pid_env) != 0){
    (void) fprintf(stderr, "%s: putenv (%s) error.\n", progname,pid_env);
    exit(-1);
  }	
#endif

  init_complete= FALSE;
  nets= curr_net= run_net= (Net *) NULL;
  waitlist= (Waitproc *) NULL;
  cntlocks= (Cntlock *) NULL;
  libs= (Library *) NULL;
  net_op= MAIN_MENU;
  usage_mode= INTERACTIVE;
  verbose= 0;
  if ((progname= strrchr(*argv, (int) '/')) != (char *) NULL)
    progname++;
  else
    progname= *argv;

  filenm= (char *) NULL;
  rd_defsitelib= TRUE;
  
  if (C_ARGIS("-b",&argc,argv)||C_ARGIS("-B",&argc,argv)) {
    usage_mode= BATCH;
    ignore_batcherrs= FALSE;
  }

  filenm=C_ARGSTR("-N",NULL,"","",&argc,argv);
  C_ARGI4("-v",&verbose,1,0,&argc,argv);
  
  if (usage_mode == INTERACTIVE)
    top_level=XtAppInitialize(&app_context,"Ikp",NULL,0,
			      &argc,argv,app_defs,NULL,0);

  for (argc--, argv++; argc > 0; argc--, argv++) {
    if (!strcmp(*argv, "-l")) {
      argc--, argv++;
      if (argc <= 0)
	ikp_usage();
      ikp_lib_read(*argv);
    }
  }
  
  if (get_wkdir(dirname) == (char *) NULL)
    exit(-1);
  ikp_pid= getpid();
  if (gethostname(hostname, MAXHOSTNAMELEN) < 0) { 
    (void) fprintf(stderr, "%s: gethostname error.\n", progname);
    exit(-1);
  }
  if ((sp= getservbyname(progname, "tcp")) == (struct servent *) NULL) {
    fprintf(stderr, "%s: getservbyname error.\n", progname);
    fprintf(stderr,"%s: processing on remote machines is unavailable\n");
/* - commented out 4/01/99 to get by machines with no services entry.
    exit(-1);
*/
  }
  ikpd_port= sp->s_port;
  if ((dev_null= open("/dev/null", O_RDONLY)) < 0) {
    fprintf(stderr, "%s: cannot open /dev/null.\n", progname);
    exit(-1);
  }
  
  /* don't let a failed pipe or socket connection abort the program */
  signal(SIGPIPE, SIG_IGN);
  signal(SIGINT, sigint_hdlr);
  
  if (usage_mode == BATCH)
    exit(batch(filenm));

  display=XtDisplay(top_level);
  init_windows();
  
  if (strlen(filenm) != 0)
    net_read(NET_MARGIN, NET_MARGIN, filenm);
  
  init_complete= TRUE;
  
  for (;;) {
    /* if a net is running, intermittently check for both
       new user input and return status of child processes */
    if (run_net != (Net *) NULL) {
      if (poll_count > POLL_LIMIT) {
	sleep(1);
	poll_count= 0;
      }
      if (XCheckIfEvent(display, &event, ikp_anyevt, (char *) NULL) == True) {
	memcpy((char *)&event1,(char *)&event,sizeof(XEvent));
	XtDispatchEvent(&event1);
      }
      poll_count++;
      net_monitor();
    } else {
      XtAppNextEvent(app_context, &event);
      memcpy((char *)&event1,(char *)&event,sizeof(XEvent));
      XtDispatchEvent(&event1);
    }
  }
}
