/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>
#include <ctype.h>

#include "ikp_defines.h"
#include "ikp_externs.h"
#include "globalE.h"

extern void ikp_ioerr(char *,int);
extern Module *mdl_create(Library *,Process *,char *);
extern Library *lib_create(char *);

int ikp_lib_read(char *filename)
{
  Library *l,*l1;
  Module *m;
  int fd,error;
  char *end;
  char library[1024],old_l[1024],module[1024],executable[1024];
  char input_buf[1024],output_buf[1024],diag_buf[1024];
  FILE *fp;
  
  if (filename == (char *) NULL) {
    ikp_err("Null filename.", NONFATAL);
    return(IKP_FAILURE);
  }
  if ((fp= fopen(filename, "r")) == (FILE *) NULL) {
    sprintf(buf1,"Error open %s.",filename);
    ikp_err(buf1, NONFATAL);
    return(IKP_FAILURE);
  }
  
  strcpy(old_l,"");

  end=fgets(buf1,1024,fp);
  while (end!=NULL) {  
    if (strlen(buf1)>1)
      buf1[strlen(buf1)-1]=NULL;

    strcpy(library,buf1);
    strcpy(strstr(library,"****"),"");

    if (library[0]=='"') 
      strcpy(library,library+1);
    strcpy(strrchr(library,'"'),"");

    strcpy(buf1,strstr(buf1,"****")+5);
    strcpy(module,buf1);
    strcpy(strstr(module,"****"),"");
    if (module[0]=='"') 
      strcpy(module,module+1);
    strcpy(strrchr(module,'"'),"");

    strcpy(buf1,strstr(buf1,"****")+5);
    strcpy(executable,buf1);
    strcpy(strstr(executable,"****"),"");
    if (executable[0]=='"') 
      strcpy(executable,executable+1);
    strcpy(strrchr(executable,'"'),"");

    strcpy(buf1,strstr(buf1,"****")+5);
    strcpy(input_buf,buf1);
    strcpy(strstr(input_buf,"****"),"");
    if (input_buf[0]=='"') 
      strcpy(input_buf,input_buf+1);
    strcpy(strrchr(input_buf,'"'),"");

    strcpy(buf1,strstr(buf1,"****")+5);
    strcpy(output_buf,buf1);
    strcpy(strstr(output_buf,"****"),"");
    if (output_buf[0]=='"') 
      strcpy(output_buf,output_buf+1);
    strcpy(strrchr(output_buf,'"'),"");

    strcpy(buf1,strstr(buf1,"****")+5);
    strcpy(diag_buf,buf1);
   if (diag_buf[0]=='"') 
      strcpy(diag_buf,diag_buf+1);
    strcpy(strrchr(diag_buf,'"'),"");

    if (strcmp(old_l,library)!=0) {
      strcpy(old_l,library);
      if ((l= lib_create(library)) == (Library *) NULL)
	return(IKP_FAILURE);
      
      /* link into lib list */
      if (libs == (Library *) NULL)
	libs= l;
      else {
	for (l1= libs; l1->lib_next != (Library *) NULL; l1= l1->lib_next);
	l1->lib_next= l;
      }
      l->lib_next= (Library *) NULL;
    }
    if ((m= mdl_create(l,(Process *)NULL, module)) == (Module *) NULL)
      return(IKP_FAILURE);

    m->mdl_nitems=0;
    m->mdl_label=strdup(module);
    m->mdl_prog=strdup(executable);
    m->mdl_helpfile=NULL;

    strcpy(buf1,input_buf);
    error=sscanf(buf1,"%d",&fd);
    while (error==1) {
      if (mdl_addio(m, fd, MDLIO_INPUT) != IKP_SUCCESS)
	return(IKP_FAILURE);
      error=sscanf(buf1,"%s %s",buf2,buf3);
      if (error==2)
	strcpy(buf1,strstr(buf1+strlen(buf2),buf3));
      else 
	strcpy(buf1,"");
      error=sscanf(buf1,"%d",&fd);
    }

    strcpy(buf1,output_buf);
    error=sscanf(buf1,"%d",&fd);
    while (error==1) {
      if (mdl_addio(m, fd, MDLIO_OUTPUT) != IKP_SUCCESS)
	return(IKP_FAILURE);
      error=sscanf(buf1,"%s %s",buf2,buf3);
      if (error==2)
	strcpy(buf1,strstr(buf1+strlen(buf2),buf3));
      else 
	strcpy(buf1,"");
      error=sscanf(buf1,"%d",&fd);
    }

    strcpy(buf1,diag_buf);
    error=sscanf(buf1,"%d",&fd);
    while (error==1) {
      if (mdl_addio(m, fd, MDLIO_DIAG) != IKP_SUCCESS)
	return(IKP_FAILURE);
      error=sscanf(buf1,"%s %s",buf2,buf3);
      if (error==2)
	strcpy(buf1,strstr(buf1+strlen(buf2),buf3));
      else 
	strcpy(buf1,"");
      error=sscanf(buf1,"%d",&fd);
    }
    end=fgets(buf1,1024,fp);
  }

  fclose(fp);
  return(IKP_SUCCESS);
}

