/*
	lxt.h --
	Definitions and typedefs for LXT, the Lamont X
	Toolkit package, an X11 SunView imitation.
	Written by Roger Davis, May 1988.
*/

/*
	- upped LX_MAXFONTNMLEN	to 255 from 40	- j.m.wade 5/12/92
	- added some new cursors for easier use - j.m.wade 6/30/92
*/
#ifndef __LXT_DEFINES__
#define __LXT_DEFINES__

/* return codes */
#define LX_SUCCESS		(0)
#define LX_ERROR		(1)

#define LX_MAXFONTNMLEN		(255)	/* was 40 - jmw 5/12/92 */

/* canvas attributes */
#define LXC_CCURSOR		(8)
#define LXC_VSCURSOR		(9)
#define LXC_HSCURSOR		(10)
#define LXC_CHCURSOR		(24)
#define LXC_LCCURSOR		(25)
#define LXC_LMCURSOR		(26)
#define LXC_CMCURSOR		(27)
#define LXC_RMCURSOR		(28)
#define LXC_KLCURSOR		(29)

#define LXC_MVCURSOR		(30)
#define LXC_WATCHCURSOR		(31)
#define LXC_SELCURSOR		(32)
#define LXC_CPCURSOR		(33)

#define NET_WIDTH               2000
#define NET_HEIGHT              2000

typedef struct Xc_struct {
  Display *xc_dpy;		/* display */
  Window xc_win;		/* window ID of enclosing frame */
  Window xc_cwin;		/* window ID of actual canvas */
  Pixmap xc_cpm;		/* panel backing store pixmap */
  int xc_mode;			/* static or dynamic canvas size */
  Window xc_vswin, xc_hswin;	/* window ID of scrollbars */
  Pixmap xc_vspm, xc_hspm;	/* scrollbar backing store pixmaps */
  Pixmap xc_stipplepm;		/* stipple for scrollbars */
  Cursor xc_ccursor;		/* cursors */
  Cursor xc_vscursor, xc_hscursor;
  Cursor xc_chcursor;		/* cross-hair cursor */
  Cursor xc_lccursor;		/* left-hand corner cursor */
  Cursor xc_lmcursor;		/* left-mouse cursor */
  Cursor xc_cmcursor;		/* center-mouse cursor */
  Cursor xc_rmcursor;		/* right-mouse cursor */
  Cursor xc_klcursor;		/* kill cursor (skull & cross-bones) */
  int xc_x, xc_y;		/* position of xc_win vis-a-vis parent */
  int xc_w, xc_h;		/* size of xc_win */
  int xc_vch, xc_vcw;		/* virtual canvas size */
  int xc_ach, xc_acw;		/* actual size of xc_cwin */
  int xc_ibw;			/* internal border width inside xc_win */
  unsigned long xc_fg, xc_bg;	/* foreground and background */
  int xc_cx, xc_cy;		/* position of xc_pwin vis-a-vis xc_win */
  int xc_vx, xc_vy;		/* upper-leftmost visible pixel of xc_pwin */
  GC xc_gc, xc_cgc, xc_sgc;	/* normal, clear and stipple GCs */
  int xc_flags;
  struct Xc_struct *xc_next;
} Canvas;

#define LXT_MAXFILENM		(255)	/* maximum filename length */

#endif __LXT_DEFINES__
