/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>
#include <sys/param.h>
#include <X11/X.h>
#include <X11/cursorfont.h>

#include "ikp_defines.h"
#include "ikp_externs.h"
#include "globalE.h"

extern Cursor get_cursor();
extern char *get_wkdir(char *dir);
extern void net_stop(Net *);
extern void net_restart(Net *);

extern Widget scroll_window;
extern Widget module_list;
extern Net *net_sel;
extern Process *prc_sel;
extern Connector *cnt_sel1, *cnt_sel2;

void open_fileCB(Widget w,
		 XtPointer,
		 XmFileSelectionBoxCallbackStruct *);
void exit_okCB(Widget w,
	       XtPointer client_data,
	       XtPointer call_data);
void dir_okCB(Widget w,
	      XtPointer client_data,
	      XmSelectionBoxCallbackStruct *call_data);
void netstop_okCB(Widget w,
		  XtPointer client_data,
		  XtPointer call_data);
void netrestart_okCB(Widget w,
		     XtPointer client_data,
		     XtPointer call_data);
void netabort_okCB(Widget w,
		   XtPointer client_data,
		   XtPointer call_data);
void redisplayCB(Widget w,
		 XtPointer client_data,
		 XtPointer call_data);

Library *current_lib=NULL;

void dirCB(Widget w,
	   XtPointer client_data,
	   XtPointer call_data)
{
  int val;
  
  strncpy(buf1, dirname, MAXPATHLEN);
  XtVaSetValues(prompt,
		XmNselectionLabelString,XMstr("Directory:"),
		XmNtextString,XMstr(buf1),
		XmNokCallback,CBl(dir_okCB,0),
		NULL);
  XtManageChild(prompt);
}

void dir_okCB(Widget w,
	      XtPointer client_data,
	      XmSelectionBoxCallbackStruct *call_data)
{
  char *str;
  
  XmStringGetLtoR(call_data->value,XmSTRING_DEFAULT_CHARSET,&str);
  
  if (strlen(str) == 0) {
    ikp_err("No directory specified.", NONFATAL);
    return;
  }
  if (strlen(str) > MAXPATHLEN) {
    ikp_err("Maximum directory name length exceeded.", NONFATAL);
    return;
  }
  if (chdir(str) < 0) {
    ikp_err("Cannot change directory.", NONFATAL);
    return;
  }
  
  if (get_wkdir(dirname) == (char *) NULL) {
    ikp_err("Cannot get current working directory name.", NONFATAL);
    return;
  }
  return;
}


void net_scale_okCB(Widget w,
		    XtPointer client_data,
		    XmSelectionBoxCallbackStruct *call_data)
{
  char *str;
  float tmp;
  
  XmStringGetLtoR(call_data->value,XmSTRING_DEFAULT_CHARSET,&str);
  
  if (sscanf(str,"%f",&tmp)==1) {
    net_scale=tmp;
    change_font();
    redisplayCB(NULL,(XtPointer)1,NULL);
  }
}


void net_scaleCB(Widget w,
		 XtPointer client_data,
		 XtPointer call_data)
{
  sprintf(buf1,"%f",net_scale);
  
  
  XtVaSetValues(prompt,
                XmNselectionLabelString,XMstr("Net Scale:"),
                XmNtextString,XMstr(buf1),
                XmNokCallback,CBl(net_scale_okCB,0),
                NULL);
  XtManageChild(prompt);
}


void redisplayCB(Widget w,
		 XtPointer client_data,
		 XtPointer call_data)
{
  Net *n;
  Process *p;
  Connector *c;
  Segment *s;
  void net_draw();
  
  if ((int)client_data)
    draw_fill_rectangle(net_cgc,0, 0,
			NET_WIDTH, NET_HEIGHT);
  
  for (n= nets; n != (Net *) NULL; n= n->net_next) {
    for (p= n->net_prclist; p != (Process *) NULL; p= p->prc_next) {
      for (c= p->prc_input; c != (Connector *) NULL; c= c->cnt_next) {
	c->cnt_flags&= ~CNT_GRNDDRAWN;
	for (s= c->cnt_seglist; s != (Segment *) NULL; s= s->seg_next) {
	  s->seg_flags&= ~SEG_DRAWN;
	}
      }
      for (c= p->prc_output; c != (Connector *) NULL; c= c->cnt_next) {
	c->cnt_flags&= ~CNT_GRNDDRAWN;
	for (s= c->cnt_seglist; s != (Segment *) NULL; s= s->seg_next) {
	  s->seg_flags&= ~SEG_DRAWN;
	}
      }
      for (c= p->prc_diag; c != (Connector *) NULL; c= c->cnt_next) {
	c->cnt_flags&= ~CNT_GRNDDRAWN;
	for (s= c->cnt_seglist; s != (Segment *) NULL; s= s->seg_next) {
	  s->seg_flags&= ~SEG_DRAWN;
	}
      }
    }
    net_draw(n);
    
    /* highlight processes being edited */
    for (p= n->net_prclist; p != (Process *) NULL; p= p->prc_next) {
      if (p->prc_flags & PRC_EDITOPEN) {
	draw_fill_rectangle(net_igc, p->prc_x-CNT_LIP, p->prc_y-CNT_LIP, p->prc_w+(2*CNT_LIP), p->prc_h+(2*CNT_LIP));
      }
    }
  }
  
  return;
}

void exitCB(Widget w,
	    XtPointer client_data,
	    XtPointer call_data)
{
  int root_x,root_y;
  
  locate_cursor(&root_x,&root_y);
  XBell(display,100);
  XtUnmanageChild(XmMessageBoxGetChild(confirm,XmDIALOG_HELP_BUTTON));
  XtVaSetValues(confirm,
		XmNokLabelString,XMstr(" Yes "),
		XmNcancelLabelString,XMstr("No"),
		XmNdefaultButtonType,XmDIALOG_OK_BUTTON,
		XmNdefaultPosition,False,
		XmNdialogTitle,XMstr("Exit Dialog"),
		XmNmessageString,
		XMstr("Do you want to exit?"),
		XmNokCallback,CBl(exit_okCB,0),
		XmNx,root_x,
		XmNy,root_y,
		NULL);
  XtManageChild(confirm);
}


void exit_okCB(Widget w,
	       XtPointer client_data,
	       XtPointer call_data)
{
  exit(0);
}

void netselCB(Widget w,
	      XtPointer client_data,
	      XtPointer call_data)
{
  net_op= NET_SELECT;
  XDefineCursor(display,top_window,
		get_cursor(LXC_SELCURSOR));
  return;
}


void netnameCB(Widget w,
	       XtPointer client_data,
	       XtPointer call_data)
{
  net_op= NET_NAME;
  XDefineCursor(display,top_window,
		get_cursor(LXC_SELCURSOR));
  return;
}

void netrunCB(Widget w,
	      XtPointer client_data,
	      XtPointer call_data)
{
  net_op= NET_RUN;
  XDefineCursor(display,top_window,
		get_cursor(LXC_SELCURSOR));
  return;
}

void netrun()
{
  boolean net_editopen();
  
  if (curr_net == (Net *) NULL) {
    ikp_err("No net selected.", NONFATAL);
    return;
  }
  if (run_net != (Net *) NULL) {
    ikp_err("Net already running.", NONFATAL);
    return;
  }
  if (net_editopen(curr_net)) {
    ikp_err("Net is being edited.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  XDefineCursor(display,top_window,
		get_cursor(LXC_WATCHCURSOR));
  XFlush(display);

  net_fork(curr_net);
  return;
}

void openCB(Widget w,
	    XtPointer client_data,
	    XtPointer call_data)
{
  net_op= NET_READ;
  XDefineCursor(display,top_window,
		get_cursor(LXC_LCCURSOR));
  return;
}

void saveCB(Widget w,
	    XtPointer client_data,
	    XtPointer call_data)
{
  net_op= NET_WRITE;
  XDefineCursor(display,top_window,
		get_cursor(LXC_SELCURSOR));
  return;
}

void appendCB(Widget w,
	    XtPointer client_data,
	    XtPointer call_data)
{
  net_op= NET_APPEND;
  XDefineCursor(display,top_window,
		get_cursor(LXC_SELCURSOR));
  return;
}

void netcpCB(Widget w,
	     XtPointer client_data,
	     XtPointer call_data)
{
  net_sel= (Net *) NULL;
  net_op= NET_COPY;
  XDefineCursor(display,top_window,
		get_cursor(LXC_CPCURSOR));
  return;
}

void netstopCB(Widget w,
	       XtPointer client_data,
	       XtPointer call_data)
{
  int root_x,root_y;
  
  if (run_net == (Net *) NULL) {
    ikp_err("There is no running net.", NONFATAL);
    return;
  }
  
  locate_cursor(&root_x,&root_y);
  XBell(display,100);
  XtUnmanageChild(XmMessageBoxGetChild(confirm,XmDIALOG_HELP_BUTTON));
  XtVaSetValues(confirm,
		XmNokLabelString,XMstr(" Yes "),
		XmNcancelLabelString,XMstr("No"),
		XmNdefaultButtonType,XmDIALOG_OK_BUTTON,
		XmNdefaultPosition,False,
		XmNdialogTitle,XMstr("Stop Net"),
		XmNmessageString,
		XMstr("Do you want to suspend net execution?"),
		XmNokCallback,CBl(netstop_okCB,0),
		XmNx,root_x,
		XmNy,root_y,
		NULL);
  
  XtManageChild(confirm);
}

void netstop_okCB(Widget w,
		  XtPointer client_data,
		  XtPointer call_data)
{
  net_stop(run_net);
  
  return;
}

void netrestartCB(Widget w,
		  XtPointer client_data,
		  XtPointer call_data)
{
  int root_x,root_y;
  
  if (run_net == (Net *) NULL) {
    ikp_err("There is no running net.", NONFATAL);
    return;
  }
  
  
  locate_cursor(&root_x,&root_y);
  XBell(display,100);
  XtUnmanageChild(XmMessageBoxGetChild(confirm,XmDIALOG_HELP_BUTTON));
  XtVaSetValues(confirm,
		XmNokLabelString,XMstr(" Yes "),
		XmNcancelLabelString,XMstr("No"),
		XmNdefaultButtonType,XmDIALOG_OK_BUTTON,
		XmNdefaultPosition,False,
		XmNdialogTitle,XMstr("Restart Net"),
		XmNmessageString,
		XMstr("Do you want to resume net execution?"),
		XmNokCallback,CBl(netrestart_okCB,0),
		XmNx,root_x,
		XmNy,root_y,
		NULL);
  
  XtManageChild(confirm);
}

void netrestart_okCB(Widget w,
		     XtPointer client_data,
		     XtPointer call_data)
{
  net_restart(run_net);
  
  return;
}

void netabortCB(Widget w,
		XtPointer client_data,
		XtPointer call_data)
{
  int root_x,root_y;
  
  if (run_net == (Net *) NULL) {
    ikp_err("There is no running net.", NONFATAL);
    return;
  }
  
  
  locate_cursor(&root_x,&root_y);
  XBell(display,100);
  XtUnmanageChild(XmMessageBoxGetChild(confirm,XmDIALOG_HELP_BUTTON));
  XtVaSetValues(confirm,
		XmNokLabelString,XMstr(" Yes "),
		XmNcancelLabelString,XMstr("No"),
		XmNdefaultButtonType,XmDIALOG_OK_BUTTON,
		XmNdefaultPosition,False,
		XmNdialogTitle,XMstr("Abort Net"),
		XmNmessageString,
		XMstr("Do you want to abort net execution?"),
		XmNokCallback,CBl(netabort_okCB,0),
		XmNx,root_x,
		XmNy,root_y,
		NULL);
  
  XtManageChild(confirm);
}


void netabort_okCB(Widget w,
		   XtPointer client_data,
		   XtPointer call_data)
{
  net_abortfork(run_net);
  XDefineCursor(display,top_window,
		get_cursor(LXC_CCURSOR));
  
  return;
}

void netdstCB(Widget w,
	      XtPointer client_data,
	      XtPointer call_data)
{
  net_op= NET_DESTROY;
  XDefineCursor(display,top_window,
		get_cursor(LXC_KLCURSOR));
  return;
}

void sourceCB(Widget w,
	      XtPointer client_data,
	      XtPointer call_data)
{
  prccr_type= PRC_SOURCE;
  
  net_op= PRC_CREATE;
  XDefineCursor(display,top_window,
		get_cursor(LXC_LCCURSOR));
  return;
}


void sinkCB(Widget w,
	    XtPointer client_data,
	    XtPointer call_data)
{
  prccr_type= PRC_SINK;
  
  net_op= PRC_CREATE;
  XDefineCursor(display,top_window,
		get_cursor(LXC_LCCURSOR));
  return;
}

void scriptCB(Widget w,
	      XtPointer client_data,
	      XtPointer call_data)
{
  prccr_type= PRC_SCRIPT;
  
  net_op= PRC_CREATE;
  XDefineCursor(display,top_window,
		get_cursor(LXC_LCCURSOR));
  return;
}

void filterCB(Widget w,
	      XtPointer client_data,
	      XtPointer call_data)
{
  prccr_type= PRC_FILTER;
  
  net_op= PRC_CREATE;
  XDefineCursor(display,top_window,
		get_cursor(LXC_LCCURSOR));
  return;
}

void teeCB(Widget w,
	   XtPointer client_data,
	   XtPointer call_data)
{
  Library *l=NULL;
  Module *mdl=NULL;
  char *str="tee";
  
  if (libs!=NULL)
    for (l= libs; l != (Library *) NULL; l= l->lib_next) {
      for (mdl= l->lib_modules; mdl != (Module *) NULL; mdl= mdl->mdl_next) {
	if (strcmp(str,mdl->mdl_label)==0) {
	  prccr_type= PRC_LIBRARY;
	  prccr_module= mdl;
	  
	  XDefineCursor(display,top_window,
			get_cursor(LXC_LCCURSOR));
	  net_op= PRC_CREATE;
	  return;
	}
      }
    }
  net_op= PRC_CREATE;
  XDefineCursor(display,top_window,
		get_cursor(LXC_LCCURSOR));
  return;
}

void customCB(Widget w,
	      XtPointer client_data,
	      XtPointer call_data)
{
  prccr_type= PRC_CUSTOM;
  
  net_op= PRC_CREATE;
  XDefineCursor(display,top_window,
		get_cursor(LXC_LCCURSOR));
  return;
}

void prclibCB(Widget w,
	      XtPointer client_data,
	      XmListCallbackStruct *call_data)
{
  Module *mdl;
  int count;
  
  current_lib=libs;
  
  for (count=1; count<call_data->item_position; count++) {
    current_lib=current_lib->lib_next;
  }
  XmListDeleteAllItems(module_list);
  
  
  for (mdl= current_lib->lib_modules; mdl != (Module *) NULL; 
       mdl= mdl->mdl_next) {
    XmListAddItem(module_list,XMstr(mdl->mdl_label),0);
  }
}


void prclibcrCB(Widget w,
		XtPointer client_data,
		XmListCallbackStruct *call_data)
{
  int count;
  Module *mdl;
  
  if (current_lib==NULL)
    current_lib=libs;
  
  mdl=current_lib->lib_modules;
  
  for (count=1; count<call_data->item_position; count++) {
    mdl=mdl->mdl_next;
  }
  
  prccr_type= PRC_LIBRARY;
  prccr_module= mdl;
  
  XDefineCursor(display,top_window,
		get_cursor(LXC_LCCURSOR));
  net_op= PRC_CREATE;
  return;
}

void module_by_nameCB(Widget w,
		      XtPointer client_data,
		      XmSelectionBoxCallbackStruct *call_data)
{
  int count;
  Module *mdl;
  Library *l;
  char *str;
  
  XmStringGetLtoR(call_data->value,XmSTRING_DEFAULT_CHARSET,&str);
  
  if (libs!=NULL)
    for (l= libs; l != (Library *) NULL; l= l->lib_next) {
      for (mdl= l->lib_modules; mdl != (Module *) NULL; mdl= mdl->mdl_next) {
	if (strcmp(str,mdl->mdl_label)==0) {
	  prccr_type= PRC_LIBRARY;
	  prccr_module= mdl;
	  
	  XDefineCursor(display,top_window,
			get_cursor(LXC_LCCURSOR));
	  net_op= PRC_CREATE;
	  return;
	}
      }
    }
  
  XDefineCursor(display,top_window,
		get_cursor(LXC_CCURSOR));
  return;
}


void prclibcr_textCB(Widget w,
		     XtPointer client_data,
		     XtPointer call_data)
{
  XtVaSetValues(prompt,
		XmNselectionLabelString,XMstr("Module Name:"),
		XmNtextString,XMstr(""),
		XmNokCallback,CBl(module_by_nameCB,0),
		XmNcancelCallback,CBl(NULL,0),
		NULL);
  XtManageChild(prompt);
  
  return;
}

void prccpCB(Widget w,
	     XtPointer client_data,
	     XtPointer call_data)
{
  prc_sel= (Process *) NULL;
  net_op= PRC_COPY;
  XDefineCursor(display,top_window,
		get_cursor(LXC_CPCURSOR));
  return;
}

void prcmvCB(Widget w,
	     XtPointer client_data,
	     XtPointer call_data)
{
  prc_sel= (Process *) NULL;
  net_op= PRC_MOVE;
  XDefineCursor(display,top_window,
		get_cursor(LXC_MVCURSOR));
  return;
}

void prcdstCB(Widget w,
	      XtPointer client_data,
	      XtPointer call_data)
{
  net_op= PRC_DESTROY;
  XDefineCursor(display,top_window,
		get_cursor(LXC_KLCURSOR));
  return;
}

void cntgrndfileCB(Widget w,
		   XtPointer client_data,
		   XtPointer call_data)
{
  net_op= CNT_GRNDFILE;
  XDefineCursor(display,top_window,
		get_cursor(LXC_CHCURSOR));
  return;
}

void cntgrndnullCB(Widget w,
		   XtPointer client_data,
		   XtPointer call_data)
{
  net_op= CNT_GRNDNULL;
  XDefineCursor(display,top_window,
		get_cursor(LXC_CHCURSOR));
  return;
}

void cntunlnkCB(Widget w,
		XtPointer client_data,
		XtPointer call_data)
{
  net_op= CNT_UNLINK;
  XDefineCursor(display,top_window,
		get_cursor(LXC_CHCURSOR));
  return;
}

void cntmvCB(Widget w,
	     XtPointer client_data,
	     XtPointer call_data)
{
  cnt_sel1= (Connector *) NULL;
  net_op= CNT_MOVE;
  XDefineCursor(display,top_window, 
		get_cursor(LXC_MVCURSOR));
  return;
}




