/*
 *	Copyright (c) 1990 by Columbia University.
 */

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <X11/Xatom.h>

#include "ikp_defines.h"
#include "ikp_externs.h"
#include "globalE.h"

extern Cursor get_cursor();
extern void prc_draw(Process *p);
extern void prcedit_setup(Process *);
extern void prc_erase(Process *);
extern void prc_create_panel_lib(Process *);
extern void prc_create_panel(Process *);
extern void prc_get_panel(Process *,char **);
extern void prc_set_panel(Process *);

extern FILE *yyin,*yyout;

int custom_x,custom_y;

void prcdestroy_cancelCB(Widget w,XtPointer client_data,XtPointer call_data);
void prcdestroy_okCB(Widget w,XtPointer client_data,XtPointer call_data);

Process *prc_sel;
Process *p_dst;

prccr_select(XEvent *event)
{
  Process *new;
  XButtonPressedEvent *evt;
  Mdlitem *mi;
  
  if (event->type != ButtonPress)
    return;
  else
    evt= (XButtonPressedEvent *) event;
  
  XDefineCursor(display,top_window,get_cursor(LXC_CCURSOR));
  
  
  custom_x= (float)evt->x/net_scale;
  custom_y= (float)evt->y/net_scale;

  if (custom_x < NET_MARGIN)
    custom_x= NET_MARGIN;
  if (custom_y < NET_MARGIN)
    custom_y= NET_MARGIN;

  if ((new= prc_create(prccr_type)) == (Process *) NULL) {
    net_op= MAIN_MENU;
    return;
  }

  
  new->prc_x= (float)evt->x/net_scale;
  new->prc_y= (float)evt->y/net_scale;
  if (new->prc_x < NET_MARGIN)
    new->prc_x= NET_MARGIN;
  if (new->prc_y < NET_MARGIN)
    new->prc_y= NET_MARGIN;
  
  prc_draw(new);
  
  net_op= MAIN_MENU;
  return;
}

prcedit_select(XEvent *event)
{
  Process *p;
  XButtonPressedEvent *evt;
  int x, y;
  
  if (event->type != ButtonPress)
    return;
  else
    evt= (XButtonPressedEvent *) event;
  
  XDefineCursor(display,top_window,get_cursor(LXC_CCURSOR));
  
  x= evt->x;
  y= evt->y;
  if ((p= prc_locate(x, y)) == (Process *) NULL) {
    ikp_err("No process selected.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if ((run_net != (Net *) NULL) && ((Net *) p->prc_net == run_net)) {
    ikp_err("Cannot edit a process within a running net.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if (p->prc_flags & PRC_EDITOPEN) {
    ikp_err("Selected process is already being edited.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  
  prcedit_setup(p);
  
  net_op= MAIN_MENU;
  return;
}

ok_selection(Widget w,char **values,XtPointer data)
{
  Process *p=(Process *)data;

  if (values[0]==NULL)
    return 0;
 
  prc_get_panel(p,values);
 
  XtUnmanageChild(w);

  draw_fill_rectangle(net_igc, p->prc_x-CNT_LIP, p->prc_y-CNT_LIP, p->prc_w+(2*CNT_LIP), p->prc_h+(2*CNT_LIP));
  prc_erase(p);
  prc_draw(p);
  curr_net= (Net *) p->prc_net;
  p->prc_flags&= ~PRC_EDITOPEN;
}

cancel_selection(Widget w,XtPointer data)
{
  Process *p=(Process *)data;

  XtUnmanageChild(w);

  draw_fill_rectangle(net_igc, p->prc_x-CNT_LIP, p->prc_y-CNT_LIP, p->prc_w+(2*CNT_LIP), p->prc_h+(2*CNT_LIP));
  prc_erase(p);
  prc_draw(p);
  curr_net= (Net *) p->prc_net;
  p->prc_flags&= ~PRC_EDITOPEN;
}
 
 
int yyerror()
{
  return(1);
}
 
int yywrap()
{
  return(1);
}

void prcedit_setup(Process *p)
{
  char *c;
  char **values;
  Dimension max_width,max_height,border;
  Dimension width,height;
  Position x,y;
  Screen *screen_struct;
  Window virtualRoot;
  XWindowAttributes vRoot_attr;
  Widget wm_widget;
  XSizeHints hints;

  screen_struct=DefaultScreenOfDisplay(display);

  switch (p->prc_type) {
  case PRC_SOURCE:
  case PRC_SINK:
  case PRC_SCRIPT:
  case PRC_FILTER:
  case PRC_CUSTOM:
    if (p->prc_window==NULL) {
      prc_create_panel(p);
    }

    XtManageChild(p->prc_window);

    break;
    
  case PRC_LIBRARY:
    if (p->prc_window == NULL) {
      prc_create_panel_lib(p);
      prc_set_panel(p);
/*
   - added code so the defaults would get loaded into the process structure
     at creation time so were sure to have something - joe m. wade - 4/12/95
*/
      if (p->prc_comm == NULL) {
        values=get_panel_defaults(p->prc_panel);
        prc_get_panel(p,values);
	}
      }
    else
      prc_set_panel(p);

    XtVaSetValues (p->prc_window,
			XmNmappedWhenManaged,		FALSE,
			NULL);

    XtManageChild(p->prc_window);

    XtVaGetValues (p->prc_window,
			XmNx,		&x,
			XmNy,		&y,
			XmNwidth,	&width,
			XmNheight,	&height,
			NULL);

/* added this geometry stuff to ensure the window is not bigger than the
   display area. This also means that I had to add positioning stuff for
   virtual window managers		- joe m. wade - 3/29/95
*/

    screen_struct=DefaultScreenOfDisplay(display);
    max_width = WidthOfScreen(screen_struct) - 50;
    max_height = HeightOfScreen(screen_struct) - 50;

    if (width > max_width) width = max_width;
    if (height > max_height) height = max_height;
    if ( height == max_height || width == max_width) {
      wm_widget = p->prc_window;
      while ((wm_widget != (Widget)NULL) && ( ! XtIsWMShell(wm_widget) )) {
	wm_widget = XtParent(wm_widget);
	}

      if (wm_widget == (Widget) NULL) {
	wm_widget = p->prc_window;
	}

      virtualRoot = GetVRoot(XtDisplay(wm_widget),
		DefaultScreen(XtDisplay(wm_widget)));
      if (XGetWindowAttributes(XtDisplay(wm_widget),virtualRoot,
		&vRoot_attr)) {
	     x = x - vRoot_attr.x;
	     y = y - vRoot_attr.y;
	     }

      if (wm_widget != p->prc_window) {
        XtVaSetValues (p->prc_window,
			XmNx,		x,
			XmNy,		y,
			XmNwidth,	width,
			XmNheight,	height,
			NULL);

        XtManageChild(p->prc_window);
	}

      XtVaSetValues (wm_widget,
			XmNx,		x,
			XmNy,		y,
			XmNwidth,	width,
			XmNheight,	height,
			NULL);

      XtVaSetValues (p->prc_window,
			XmNmappedWhenManaged,		TRUE,
			NULL);


      hints.flags = USPosition;
      hints.x = x;
      hints.y = y;
      XSetWMNormalHints (XtDisplay(wm_widget), XtWindow(wm_widget), &hints);
      XSetWMSizeHints (XtDisplay(wm_widget), XtWindow(wm_widget),
		&hints, XA_WM_SIZE_HINTS);

      XtUnmanageChild(p->prc_window);
      XSync(XtDisplay(wm_widget), FALSE);
      XtManageChild(p->prc_window);
      XtMapWidget(wm_widget);
      }
    else {
      XtVaSetValues (p->prc_window,
			XmNmappedWhenManaged,		TRUE,
			NULL);
      }


    if (verbose) {
      fprintf(stderr,"Exec: %s \n",p->prc_module->mdl_prog);  
      fprintf(stderr,"command: %s\n",p->prc_comm);
      fprintf(stderr,"Widget: %x\n",p->prc_window);
    }
    break;

  default:
    break;
  }
  
  draw_fill_rectangle(net_igc, p->prc_x-CNT_LIP, p->prc_y-CNT_LIP, p->prc_w+(2*CNT_LIP), p->prc_h+(2*CNT_LIP));
  p->prc_flags|= PRC_EDITOPEN;
  return;
}

prccp_select(XEvent *event)
{
  XButtonPressedEvent *evt;
  int x, y;
  Process *p;
  Process *prc_copy();
  
  if (event->type != ButtonPress)
    return;
  else
    evt= (XButtonPressedEvent *) event;
  
  XDefineCursor(display,top_window,get_cursor(LXC_LCCURSOR));
  
  x= evt->x;
  y= evt->y;
  
  if (prc_sel == (Process *) NULL) {
    if ((prc_sel= prc_locate(x, y)) == (Process *) NULL) {
      XDefineCursor(display,top_window,get_cursor(LXC_CCURSOR));
      ikp_err("No process selected.", NONFATAL);
      net_op= MAIN_MENU;
      return;
    }
    if (prc_sel->prc_flags & PRC_EDITOPEN) {
      XDefineCursor(display,top_window,get_cursor(LXC_CCURSOR));
      ikp_err("Selected process is being edited.", NONFATAL);
      net_op= MAIN_MENU;
      return;
    }
    draw_fill_rectangle(net_igc, prc_sel->prc_x-CNT_LIP, prc_sel->prc_y-CNT_LIP, prc_sel->prc_w+(2*CNT_LIP), prc_sel->prc_h+(2*CNT_LIP));
    return;
  }

  x=(float)x/net_scale;
  y=(float)y/net_scale;
  
  if (x < NET_MARGIN)
    x= NET_MARGIN;
  if (y < NET_MARGIN)
    y= NET_MARGIN;
  if ((p= prc_copy(prc_sel, x, y, PRC_STANDALONE)) != (Process *) NULL)
    prc_draw(p);
  
  draw_fill_rectangle(net_igc, prc_sel->prc_x-CNT_LIP, prc_sel->prc_y-CNT_LIP, prc_sel->prc_w+(2*CNT_LIP), prc_sel->prc_h+(2*CNT_LIP));
  XDefineCursor(display,top_window,get_cursor(LXC_CCURSOR));
  net_op= MAIN_MENU;
  return;
}

prcmv_select(XEvent *event)
{
  XButtonEvent *b_evt;
  XMotionEvent *m_evt;
  int x, y;
  Connector *c;
  
  if ((prc_sel == (Process *) NULL) && (event->type != ButtonPress))
    return;
  
  switch (event->type) {
  case ButtonPress:
    b_evt= (XButtonEvent *) event;
    if (b_evt->button == Button3) {
      if (prc_sel != (Process *) NULL)
	return;
      else {
	net_op= MAIN_MENU;
				return;
      }
    }
    
    x= b_evt->x;
    y= b_evt->y;
    XDefineCursor(display,top_window,get_cursor(LXC_LCCURSOR));
    if (prc_sel == (Process *) NULL) {
      if ((prc_sel= prc_locate(x, y)) == (Process *) NULL) {
	ikp_err("No process selected.", NONFATAL);
	net_op= MAIN_MENU;
	return;
      }
      if ((run_net != (Net *) NULL) && ((Net *) prc_sel->prc_net == run_net)) {
	ikp_err("Cannot move a process within a running net.", NONFATAL);
				net_op= MAIN_MENU;
	return;
      }
      if (prc_sel->prc_flags & PRC_EDITOPEN) {
	ikp_err("Selected process is being edited.", NONFATAL);
	net_op= MAIN_MENU;
	return;
      }
    } else {
      if (x < NET_MARGIN)
	x= NET_MARGIN;
      if (y < NET_MARGIN)
	y= NET_MARGIN;
      prc_erase(prc_sel);
      for (c= prc_sel->prc_input; c != (Connector *) NULL; c= c->cnt_next) {
	if (c->cnt_conn != (Connector *) NULL)
	  seg_freepath(c);
      }
      for (c= prc_sel->prc_output; c != (Connector *) NULL; c= c->cnt_next) {
	if (c->cnt_conn != (Connector *) NULL)
	  seg_freepath(c);
      }
      for (c= prc_sel->prc_diag; c != (Connector *) NULL; c= c->cnt_next) {
	if (c->cnt_conn != (Connector *) NULL)
	  seg_freepath(c);
      }
      prc_sel->prc_x= x;
      prc_sel->prc_y= y;
      for (c= prc_sel->prc_input; c != (Connector *) NULL; c= c->cnt_next)
	if (c->cnt_conn != (Connector *) NULL)
					seg_bldpath(c, c->cnt_conn);
      for (c= prc_sel->prc_output; c != (Connector *) NULL; c= c->cnt_next)
	if (c->cnt_conn != (Connector *) NULL)
	  seg_bldpath(c, c->cnt_conn);
      for (c= prc_sel->prc_diag; c != (Connector *) NULL; c= c->cnt_next)
	if (c->cnt_conn != (Connector *) NULL)
	  seg_bldpath(c, c->cnt_conn);
      prc_draw(prc_sel);
    }
    break;
  case MotionNotify:
    m_evt= (XMotionEvent *) event;
    if (m_evt->state & Button3Mask)
      return;
    
    x= (float)m_evt->x/net_scale;
    y= (float)m_evt->y/net_scale;
    if (x < NET_MARGIN)
      x= NET_MARGIN;
    if (y < NET_MARGIN)
      y= NET_MARGIN;
    prc_erase(prc_sel);
    for (c= prc_sel->prc_input; c != (Connector *) NULL; c= c->cnt_next) {
      if (c->cnt_conn != (Connector *) NULL)
	seg_freepath(c);
    }
    for (c= prc_sel->prc_output; c != (Connector *) NULL; c= c->cnt_next) {
      if (c->cnt_conn != (Connector *) NULL)
	seg_freepath(c);
    }
    for (c= prc_sel->prc_diag; c != (Connector *) NULL; c= c->cnt_next) {
      if (c->cnt_conn != (Connector *) NULL)
	seg_freepath(c);
    }
    prc_sel->prc_x= x;
    prc_sel->prc_y= y;
    for (c= prc_sel->prc_input; c != (Connector *) NULL; c= c->cnt_next)
      if (c->cnt_conn != (Connector *) NULL)
	seg_bldpath(c, c->cnt_conn);
    for (c= prc_sel->prc_output; c != (Connector *) NULL; c= c->cnt_next)
      if (c->cnt_conn != (Connector *) NULL)
	seg_bldpath(c, c->cnt_conn);
    for (c= prc_sel->prc_diag; c != (Connector *) NULL; c= c->cnt_next)
      if (c->cnt_conn != (Connector *) NULL)
	seg_bldpath(c, c->cnt_conn);
    prc_draw(prc_sel);
    break;
  case ButtonRelease:
    b_evt= (XButtonEvent *) event;
    XDefineCursor(display,top_window,get_cursor(LXC_CCURSOR));
    curr_net= (Net *) prc_sel->prc_net;
    net_op= MAIN_MENU;
    redisplayCB(NULL,1,NULL);
    break;
  default:
    break;
  }
  return;
}

prcstop_select(XEvent *event)
{
  XButtonPressedEvent *evt;
  int x, y;
  char childnm[40];
  
  if (prc_sel != (Process *) NULL)
    return;
  if (event->type != ButtonPress)
    return;
  else
    evt= (XButtonPressedEvent *) event;
  
  XDefineCursor(display,top_window,get_cursor(LXC_CCURSOR));
  x= evt->x;
  y= evt->y;
  if ((prc_sel= prc_locate(x, y)) == (Process *) NULL) {
    ikp_err("No process selected.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if ((Net *) prc_sel->prc_net != run_net) {
    ikp_err("The selected process is not within a running net.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if (!(prc_sel->prc_flags & PRC_RUNNING)) {
    ikp_err("The selected process is not running.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  
  if (prc_sel->prc_flags & PRC_REMOTE) {
    if (rp_stop(prc_sel) != IKP_SUCCESS) {
      prc_bldlabel(prc_sel, childnm, 39);
      sprintf(ikp_errbuf, "Process '%s' (PID %s:%d) cannot be stopped.", childnm, prc_sel->prc_host, prc_sel->prc_pid);
      ikp_err(ikp_errbuf, NONFATAL);
			net_op= MAIN_MENU;
      return;
    }
    prc_showactive(prc_sel);
    prc_sel->prc_flags&= ~PRC_RUNNING;
    prc_sel->prc_flags|= PRC_STOPPED | PRC_IKPSTOPPED;
    prc_showactive(prc_sel);
  }
  else {
    if (kill(prc_sel->prc_pid, SIGSTOP) < 0) {
      prc_bldlabel(prc_sel, childnm, 39);
      sprintf(ikp_errbuf, "Process '%s' (PID %d) cannot be stopped.", childnm, prc_sel->prc_pid);
      ikp_err(ikp_errbuf, NONFATAL);
      net_op= MAIN_MENU;
      return;
    }
    
    /* don't change PRC_STOPPED or PRC_RUNNING
       flags -- this is done in net_chkchldprocs() */
    prc_sel->prc_flags|= PRC_IKPSTOPPED;
  }
  
  net_op= MAIN_MENU;
  return;
}

prcrestart_select(XEvent *event)
{
  XButtonPressedEvent *evt;
  int x, y;
  char childnm[40];
  
  if (prc_sel != (Process *) NULL)
    return;
  if (event->type != ButtonPress)
		return;
  else
    evt= (XButtonPressedEvent *) event;
  
  XDefineCursor(display,top_window,get_cursor(LXC_CCURSOR));
  x= evt->x;
  y= evt->y;
  if ((prc_sel= prc_locate(x, y)) == (Process *) NULL) {
    ikp_err("No process selected.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if ((Net *) prc_sel->prc_net != run_net) {
    ikp_err("The selected process is not within a running net.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if (!(prc_sel->prc_flags & PRC_STOPPED)) {
    ikp_err("The selected process is not stopped.", NONFATAL);
    net_op= MAIN_MENU;
		return;
  }
  
  if (prc_sel->prc_flags & PRC_REMOTE) {
    if (rp_cont(prc_sel) != IKP_SUCCESS) {
      prc_bldlabel(prc_sel, childnm, 39);
      sprintf(ikp_errbuf, "Process '%s' (PID %s:%d) cannot be restarted.", childnm, prc_sel->prc_host, prc_sel->prc_pid);
			ikp_err(ikp_errbuf, NONFATAL);
      net_op= MAIN_MENU;
      return;
    }
  }
  else {
    if (kill(prc_sel->prc_pid, SIGCONT) < 0) {
      prc_bldlabel(prc_sel, childnm, 39);
      sprintf(ikp_errbuf, "Process '%s' (PID %d) cannot be restarted.", childnm, prc_sel->prc_pid);
      ikp_err(ikp_errbuf, NONFATAL);
      net_op= MAIN_MENU;
      return;
    }
  }

  /* net_chk{chld, rem}procs() doesn't sense when a process is restarted,
     so change PRC_STOPPED and PRC_RUNNING flags here */
  prc_showactive(prc_sel);
  prc_sel->prc_flags&= ~PRC_STOPPED;
  prc_sel->prc_flags|= PRC_RUNNING;
  prc_sel->prc_flags&= ~PRC_IKPSTOPPED;
  prc_showactive(prc_sel);
  
  net_op= MAIN_MENU;
  return;
}

prcabort_select(XEvent *event)
{
  XButtonPressedEvent *evt;
  int x, y;
  char childnm[40];
  
  if (prc_sel != (Process *) NULL)
    return;
  if (event->type != ButtonPress)
    return;
  else
    evt= (XButtonPressedEvent *) event;
  
  XDefineCursor(display,top_window,get_cursor(LXC_CCURSOR));
  x= evt->x;
  y= evt->y;
  if ((prc_sel= prc_locate(x, y)) == (Process *) NULL) {
    ikp_err("No process selected.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if ((Net *) prc_sel->prc_net != run_net) {
    ikp_err("The selected process is not within a running net.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
	if (prc_sel->prc_flags & PRC_EXITED) {
	  ikp_err("The selected process is not running.", NONFATAL);
	  net_op= MAIN_MENU;
	  return;
	}
  
  if (prc_sel->prc_flags & PRC_REMOTE) {
    if (rp_kill(prc_sel) != IKP_SUCCESS) {
      prc_bldlabel(prc_sel, childnm, 39);
      sprintf(ikp_errbuf, "Process '%s' (PID %s:%d) cannot be killed.", childnm, prc_sel->prc_host, prc_sel->prc_pid);
      ikp_err(ikp_errbuf, NONFATAL);
      net_op= MAIN_MENU;
      return;
    }
    prc_showactive(prc_sel);
    prc_sel->prc_flags&= ~PRC_RUNNING;
    prc_sel->prc_flags&= ~PRC_STOPPED;
    prc_sel->prc_flags|= PRC_EXITED | PRC_IKPKILLED;
  }
  else {
    if (kill(prc_sel->prc_pid, SIGKILL) < 0) {
      prc_bldlabel(prc_sel, childnm, 39);
      sprintf(ikp_errbuf, "Process '%s' (PID %d) cannot be killed.", childnm, prc_sel->prc_pid);
      ikp_err(ikp_errbuf, NONFATAL);
			net_op= MAIN_MENU;
      return;
    }
    
    /* don't change PRC_STOPPED, PRC_RUNNING or PRC_EXITED
       flags -- this is done in net_chkchldprocs() */
    prc_sel->prc_flags&= ~PRC_IKPSTOPPED;
    prc_sel->prc_flags|= PRC_IKPKILLED;
  }
  
  net_op= MAIN_MENU;
  return;
}

prcdst_select(XEvent *event)
{
  Process *p;
  XButtonPressedEvent *evt;
  int x, y, val,root_x,root_y;
  
  if (event->type != ButtonPress)
    return;
  else
    evt= (XButtonPressedEvent *) event;
  
  XDefineCursor(display,top_window,get_cursor(LXC_CCURSOR));
  x= evt->x;
  y= evt->y;
  if ((p= prc_locate(x, y)) == (Process *) NULL) {
    ikp_err("No process selected.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  if ((run_net != (Net *) NULL) && ((Net *) p->prc_net == run_net)) {
    ikp_err("Cannot destroy a process within a running net.", NONFATAL);
    net_op= MAIN_MENU;
    return;
	}
  if (p->prc_flags & PRC_EDITOPEN) {
    ikp_err("Selected process is being edited.", NONFATAL);
    net_op= MAIN_MENU;
    return;
  }
  
  draw_fill_rectangle(net_igc, p->prc_x-CNT_LIP, p->prc_y-CNT_LIP, p->prc_w+(2*CNT_LIP), p->prc_h+(2*CNT_LIP));
  
  p_dst=p;
  
  locate_cursor(&root_x,&root_y);
  XBell(display,100);
  XtUnmanageChild(XmMessageBoxGetChild(confirm,XmDIALOG_HELP_BUTTON));
  XtVaSetValues(confirm,
		XmNokLabelString,XMstr(" Yes "),
		XmNcancelLabelString,XMstr("No"),
		XmNdefaultPosition,False,
		XmNdialogTitle,XMstr("Destroy Process"),
		XmNmessageString,
		XMstr("Do you want to destroy this process?"),
		XmNokCallback,CBl(prcdestroy_okCB,0),
		XmNcancelCallback,CBl(prcdestroy_cancelCB,0),
		XmNx,root_x,
		XmNy,root_y,
		NULL);

  XtManageChild(confirm);

}

void prcdestroy_okCB(Widget w,
		     XtPointer client_data,
		     XtPointer call_data)
{
  Net *n;

  draw_fill_rectangle(net_igc, p_dst->prc_x-CNT_LIP, p_dst->prc_y-CNT_LIP, p_dst->prc_w+(2*CNT_LIP), p_dst->prc_h+(2*CNT_LIP));
  n= (Net *) p_dst->prc_net;
  prc_erase(p_dst);
  prc_unlink(p_dst);
  if (n->net_prclist == (Process *) NULL)
    curr_net= (Net *) NULL;
  else if (net_split((Net *) p_dst->prc_net) > 0)
    curr_net= (Net *) NULL;
  else
    curr_net= n;
  prc_free(p_dst, PRC_FREENET);
  
  net_op= MAIN_MENU;
  return;
}


void prcdestroy_cancelCB(Widget w,
			 XtPointer client_data,
			 XtPointer call_data)
{
  Net *n;

  draw_fill_rectangle(net_igc, p_dst->prc_x-CNT_LIP, p_dst->prc_y-CNT_LIP, p_dst->prc_w+(2*CNT_LIP), p_dst->prc_h+(2*CNT_LIP));

  net_op= MAIN_MENU;
  return;
}
