C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine piwrap (x,n)
c  routine to limit phase spectrum to 0 - 2pi

c  input:
c         x  -  vector of phase values
c         n  -  number of samples in x

c output:
c         x  -  vector of phase limited values

      real    x(*)
      real    pi, twopi
      data    pi/3.14159265/

      twopi = 2. * pi

      do  1  i  = 1, n

          if    (x(i) .gt.    pi) then
                 x(i) = x(i) - twopi
          elseif(x(i) .lt.   -pi) then
                 x(i) = x(i) + twopi
          endif

1     continue

      return
      end
