C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
C     PROGRAM MODULE INTDG
C
C**********************************************************************C
C
C INTEGRATES TRACES USING A RUNNING SUM ALONG WITH A SPECIAL
C RESIDUAL OPERATOR. THIS PROGRAM IS A MODIFIED VERSION OF KEN PEACOCK'S
C INTD SUBROUTINE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     IXTR (SZLNHD)
      REAL        XTR(SZLNHD), YTR(SZLNHD), F(513)
      INTEGER     LHED( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LUOUT, LBYTES, NBYTES,  LBYOUT,LBYTE
c     INCLUDE 'PID.INC'
#include <f77/pid.h>
      CHARACTER   NTAP * 256, OTAP * 256, NAME*5, INT*4
      LOGICAL VERBOS, QUERY
      INTEGER ARGIS
C
      EQUIVALENCE ( IXTR(  1), LHED(1) )
c     EQUIVALENCE ( IXTR(129), XTR(1) )
      DATA LBYTES / 0 /, NBYTES / 0 /, NAME/'INTDG'/
C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE CARD IMAGE FILE
      QUERY = ( ARGIS ( '-?' ) .GT. 0 )
      IF ( QUERY )THEN
            CALL HELP()
      STOP
      ENDIF
C     OPEN PRINTOUT FILES
c     INCLUDE 'OPEN.INC'
#include <f77/open.h>
C
      CALL GCMDLN(NTAP,OTAP,NS,NE,IRS,IRE,
     :            VERBOS,ROSS,LF,INT)
C
C     GET LOGICAL UNIT NUMBERS FOR INPUT AND OUTPUT
      CALL GETLN(LUIN , NTAP,'r', 0)
      CALL GETLN(LUOUT, OTAP,'w', 1)
C
C     READ LINE HEADER OF INPUT
C     SAVE CERTAIN PARAMETERS
C-----
      LBYTES = 0
      CALL RTAPE  ( LUIN, IXTR, LBYTES)
      IF(LBYTES .EQ. 0) THEN
         WRITE(LOT,*)'INTDG'
         WRITE(LOT,*)'FATAL'
         STOP
      ENDIF
      CALL SAVER(IXTR, 'NumSmp', NSAMP, LINHED)
      CALL SAVER(IXTR, 'SmpInt', NSI  , LINHED)
      CALL SAVER(IXTR, 'NumTrc', NTRC , LINHED)
      CALL SAVER(IXTR, 'NumRec', NREC , LINHED)
      CALL SAVER(IXTR, 'Format', IFORM, LINHED)
      call saver(IXTR, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(IXTR, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call hlhprt (ixtr, lbytes, name, 5, LERR)
C
C     SAMPLE INTERVAL IN SECONDS
c	tdel = float(nsi) / 1000.

        tdel = real (nsi) * unitsc

C
C     MODIFY LINE HEADER TO REFLECT ACTUAL NUMBER OF TRACES OUTPUT
      CALL CMDCHK(NS,NE,IRS,IRE,NTRC,NREC)
      NRECC=IRE - IRS+1
      CALL SAVEW(IXTR, 'NumRec', NRECC, LINHED)
      JTR=NE-NS+1
      CALL SAVEW(IXTR, 'NumTrc', JTR  , LINHED)
      CALL SAVHLH(IXTR,LBYTEs,LBYOUT)
      CALL WRTAPE ( LUOUT, IXTR, LBYOUT                 )
C-----
C     VERBOSE OUTPUT OF ALL PERTINENT INFORMATION BEFORE
      IF( VERBOS ) THEN
                CALL VERBAL(NSAMP, NSI, NTRC, NREC, IFORM,
     :                  NTAP,OTAP,INT,LF,ROSS)
      END IF
C
      WRITE(LERR,*)'TRACE INTEGRATION BEGINS'
C
C     BEGIN PROCESSING
C     READ TRACE, DO INTEGRATION, WRITE TO OUTPUT FILE
      CALL recskp(1,IRS-1,LUIN,NTRC,IXTR)
C
C     CALCULATES SPECIAL RESIDUAL FILTER
      IF ( INT .EQ. 'SUMF' ) THEN
               IF (LF .GT. 511) LF=511
               CALL INTCRF (LF,ROSS,F)
      ENDIF
C
C     PROCESS DESIRED TRACE RECORDS
      DO 1000 JJ = IRS, IRE
            DO 1001 KK=1, NTRC
                  NBYTES = 0
                  CALL RTAPE ( LUIN, IXTR, NBYTES)
                  IF(NBYTES .EQ. 0) THEN
                     WRITE(LERR,*)'END OF FILE ON INPUT:'
                     WRITE(LERR,*)'  REC= ',JJ,'  TRACE= ',KK
                     GO TO 9999
                  ENDIF
                  if (KK .eq. 1)
     1            call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     2                        irec, TRACEHEADER)
                  call vmov (ixtr(ITHWP1), 1, xtr, 1, nsamp)
                  CALL INTD(NSAMP,XTR,TDEL,LF,F,YTR,INT)
                  call vmov (ytr, 1, ixtr(ITHWP1), 1, nsamp)
                  CALL WRTAPE( LUOUT, ixtr, NBYTES)
 1001       CONTINUE
             IF(VERBOS) WRITE(LERR,*)'PROCESSED RECORD',irec
 1000       CONTINUE
C
C     PROCESSING ENDS
C     CLOSE DATA FILES
 9999 CONTINUE
      CALL LBCLOS ( LUIN )
      CALL LBCLOS ( LUOUT )
      IF(VERBOS) THEN
            WRITE(LERR,*)'END OF INTDG , PROCESSED',NREC,' RECORD(S)',
     :               ' WITH ',NTRC, ' TRACES'
      ENDIF
      END
C*********************************************************************
C
      SUBROUTINE HELP
C
c     INCLUDE 'IOUNIT.INC'
#include <f77/iounit.h>
      WRITE(LER,*)
      WRITE(LER,*)
     :'***************************************************************'
      WRITE(LER,*)
     :'PROGRAM MODULE INTDG  ----  TRACE INTEGRATION'
      WRITE(LER,*)
      WRITE(LER,*)
     :'Program INTDG integrates trace data with an an ideal integration'
      WRITE(LER,*)
     :'operator. A special residual filter is applied to the data'
      WRITE(LER,*)
     :'before integration to yield a Nyquist limited operator.'
      WRITE(LER,*)
     :'Ross smoothing controls Gibb spectral ringing of the residual'
      WRITE(LER,*)
     :'operator. A simple running sum integration can also be applied.'
      WRITE(LER,*)
      WRITE(LER,*)
     :'Execute INTDG  by typing intdg followed by program parameters.'
      WRITE(LER,*)
     :'Note that each parameter is proceeded by -A where "A" is '
      WRITE(LER,*)
     :'a character(s) corresponding to some parameter.'	
      WRITE(LER,*)
     :'..............................................................'
      WRITE(LER,*)
      WRITE(LER,*)
     :'INPUT PARAMETERS and (DEFAULT VALUES)'
      WRITE(LER,*)
      WRITE(LER,*)
     :' -N [ntap]    (no default) : input data file name'
        WRITE(LER,*)
     :' -O [otap]    (no default) : output data file name'
        WRITE(LER,*)
     :' -rs [irs]    (1st rec)    : starting record number '
        WRITE(LER,*) 
     :' -re [ire]    (last rec)   : final record number '
      WRITE(LER,*)
     :' -int [int]   (SUMF)       : integration type     '
      WRITE(LER,*)
     :'                             SUMF = running sum with special'
      WRITE(LER,*)
     :'                                    residual operator' 
      WRITE(LER,*)
     :'                             SUMM = simple running sum'
      WRITE(LER,*)
     :' -lf [lf]     ( 127 )      : residual filter length'
      WRITE(LER,*)
     :'                           : maximum lf = 512 points'
      WRITE(LER,*)
     :' -ross [ross] ( 3 )        : ross wt for residual filter'
      WRITE(LER,*)
     :' -V [verbos]  ( no )       : print additional info'
      WRITE(LER,*)
      WRITE(LER,*)
     :' EXAMPLE'
      WRITE(LER,*)
     :' intdg -N/home/data/ntap -O/home/data/otap -intSUMF -lf64 -ross5'
      WRITE(LER,*)
      WRITE(LER,*)
     :'***************************************************************'
      RETURN
      END
C***********************************************************************
      SUBROUTINE GCMDLN(NTAP,OTAP,NS,NE,IRS,IRE,VERBOS,ROSS,LF,INT)
C
C     GET COMMAND ARGUMENTS
C
C     NTAP  - C*120     INPUT FILE NAME
C     OTAP  - C*120     OUTPUT FILE NAME
C     NS    - I*4 STARTING TRACE INDEX
C     NE    - I*4 ENDING TRACE INDEX
C     IRS   - I*4 STARTING RECORD INDEX
C     IRE   - I*4 ENDING RECORD INDEX
C     VERBOS      - L   VERBOSE OUTPUT OR NOT
C
C***********************************************************************
C
#include <f77/iounit.h>
c     INCLUDE 'IOUNIT.INC'
      CHARACTER NTAP*(*), OTAP*(*), INT*(*)

      LOGICAL VERBOS
      INTEGER *4 NS, NE, IRS, IRE
      INTEGER ARGIS
            CALL ARGSTR( '-N', NTAP, ' ', ' ' )
            CALL ARGSTR( '-O', OTAP, ' ', ' ' )
            CALL ARGSTR( '-int', INT, 'SUMF', 'SUMF' )
            CALL ARGI4 ( '-ns', NS ,   0  ,  0    )
            CALL ARGI4 ( '-ne', NE ,   0  ,  0    )
            CALL ARGI4 ( '-rs', IRS ,   0  ,  0    )
            CALL ARGI4 ( '-re', IRE ,   0  ,  0    )
            CALL ARGI4 ( '-lf', LF ,  127  ,  127   )
            CALL ARGR4 ( '-ross', ROSS ,  3.0  , 3.0    )
            VERBOS = ( ARGIS( '-V' ) .GT. 0 )
      RETURN
      END
C******************************************************************
      SUBROUTINE VERBAL(NSAMP, NSI, NTRC, NREC, IFORM,
     :                  NTAP,OTAP,INT,LF,ROSS)
C
C     VERBOSE OUTPUT OF PROCESSING PARAMETERS
C
C     NSAMP - I*4 NUMBER OF SAMPLES IN TRACE
C     NSI   - I*4 SAMPLE INTERVAL IN MS
C     NTRC  - I*4 TRACES PER RECORD
C     NREC  - I*4 NUMBER OF RECORDS PER LINE
C     IFORM - I*4 FORMAT OF DATA
C     NTAP  - C*120     INPUT FILE NAME
C     OTAP  - C*120     OUTPUT FILE NAME
C
C****************************************************************
C
#include <f77/iounit.h>
c     INCLUDE 'IOUNIT.INC'
      INTEGER NSAMP, NSI, NTRC, NREC, IFORM, LF
      CHARACTER NTAP*(*), OTAP*(*), INT*(*)
C
            WRITE(LERR,*)' '
            WRITE(LERR,*)' LINE HEADER VALUES AFTER DEFAULT CHECK '
            WRITE(LERR,*) ' # OF SAMPLES/TRACE........', NSAMP
            WRITE(LERR,*) ' SAMPLE INTERVAL...........', NSI
            WRITE(LERR,*) ' TRACES PER RECORD.........', NTRC
            WRITE(LERR,*) ' RECORDS PER LINE..........', NREC
            WRITE(LERR,*) ' FORMAT OF DATA............', IFORM
            WRITE(LERR,*) ' INTEGRATION TYPE..........', INT
            WRITE(LERR,*) ' RESIDUAL FILTER LENGTH ...', LF
            WRITE(LERR,*) ' ROSS WEIGH................', ROSS
            WRITE(LERR,*) ' INPUT FILE................', NTAP
            WRITE(LERR,*) ' OUTPUT FILE...............', OTAP
            WRITE(LERR,*)' '
C
      RETURN
      END
C**********************************************************************
      SUBROUTINE SICI(SI,CI,X)
C
C        PURPOSE
C           COMPUTES THE SINE AND COSINE INTEGRAL
C
C        USAGE
C           CALL SICI(SI,CI,X)
C
C        DESCRIPTION OF PARAMETERS
C           SI    - THE RESULTANT VALUE SI(X)
C           CI    - THE RESULTANT VALUE CI(X)
C           X     - THE ARGUMENT OF SI(X) AND CI(X)
C
C        REMARKS
C           THE ARGUMENT VALUE REMAINS UNCHANGED
C
C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED
C           NONE
C
C        METHOD
C           DEFINITION
C           SI(X)=INTEGRAL(SIN(T)/T)
C           CI(X)=INTEGRAL(COS(T)/T)
C           EVALUATION
C           REDUCTION OF RANGE USING SYMMETRY.
C           DIFFERENT APPROXIMATIONS ARE USED FOR ABS(X) GREATER
C           THAN 4 AND FOR ABS(X) LESS THAN 4.
C           REFERENCE
C           LUKE AND WIMP, 'POLYNOMIAL APPROXIMATIONS TO INTEGRAL
C           TRANSFORMS',  MATHEMATICAL TABLES AND OTHER AIDS TO
C           COMPUTATION, VOL. 15, 1961, ISSUE 74, PP. 174-178.
C
C***********************************************************************
C
      Z=ABS(X)
      IF(Z-4.)1,1,4
    1 Y=(4.-Z)*(4.+Z)
      SI=-1.570797E0
      IF(Z)3,2,3
c - j.m.wade - 8/26/92 too small for the hp compiler
c   2 CI=-1.E75
    2 CI=-1.0E20
      RETURN
    3 SI=X*(((((1.753141E-9*Y+1.568988E-7)*Y+1.374168E-5)*Y+6.939889E-4)
     1*Y+1.964882E-2)*Y+4.395509E-1+SI/X)
      CI=((5.772156E-1+ALOG(Z))/Z-Z*(((((1.386985E-10*Y+1.584996E-8)*Y
     1+1.725752E-6)*Y+1.185999E-4)*Y+4.990920E-3)*Y+1.315308E-1))*Z
      RETURN
    4 SI=SIN(Z)
      Y=COS(Z)
      Z=4./Z
      U=((((((((4.048069E-3*Z-2.279143E-2)*Z+5.515070E-2)*Z-7.261642E-2)
     1*Z+4.987716E-2)*Z-3.332519E-3)*Z-2.314617E-2)*Z-1.134958E-5)*Z
     2+6.250011E-2)*Z+2.583989E-10
      V=(((((((((-5.108699E-3*Z+2.819179E-2)*Z-6.537283E-2)*Z
     1+7.902034E-2)*Z-4.400416E-2)*Z-7.945556E-3)*Z+2.601293E-2)*Z
     2-3.764000E-4)*Z-3.122418E-2)*Z-6.646441E-7)*Z+2.500000E-1
      CI=Z*(SI*V-Y*U)
      SI=-Z*(SI*U+Y*V)
      IF(X)5,6,6
    5 SI=3.141593E0-SI
    6 RETURN
      END
C*******************************************************************
      SUBROUTINE INTD(LX,X,TDEL,LF,F,Y,INT)
C
C     SUBROUTINE INTD INTEGRATES THE INPUT ARRAY BY COMBINING THE
C     RUNNING SUM WITH A SPECIAL RESIDUAL OPERATOR.  NOTE THE SPECIAL
C     Y DIMENSION REQUIREMENT FOR THE OUTPUT VECTOR
C
C        INPUTS :
C
C           LX = LENGTH OF X.
C            X = THE INPUT ARRAY.
C         TDEL = SAMPLE INCREMENT IN SECONDS.
C           LF = LENGTH OF FILTER IN SAMPLES, LF MUST BE ODD.
C
C       OUTPUTS :
C
C            Y = THE LX-LENGTH OUTPUT.  Y MUST BE DIMENSIONED TO AT
C                  LEAST LX+LF-1.
C
C        REQUIRED SUBROUTINES:
C
C            FOLD
C
C**********************************************************************
C
      REAL X(1),F(1),Y(1)
      CHARACTER INT*(*)
      N=LF/2
C
      IF ( INT .EQ. 'SUMF' ) THEN
C
C         APPLIES ALREADY COMPUTED RESIDUAL FILTER AND
C         COMPUTES RUNNING SUM
          CALL FOLD(LX,X,LF,F,LO,Y)
C
C         RUNNING SUM INTEGRATION
          RUNSUM = 0.
          DO 10 I=1,LX
              RUNSUM = RUNSUM+X(I)
              J = I+N
              Y(I) = TDEL*(RUNSUM+Y(J))
10        CONTINUE
      ELSE
C
C         RUNNING SUM INTERGRATION ONLY
          RUNSUM = 0.
          DO 20 I=1,LX
              RUNSUM = RUNSUM+X(I)
              J = I+N
              Y(I) = TDEL*(RUNSUM+Y(J))
20        CONTINUE
      ENDIF
C
      RETURN
      END
C**********************************************************************
      SUBROUTINE INTCRF (LF,WC,F)
C
C     CALCULATES A SPECIAL RESIDUAL INTERGRATION  FILTER. THE
C     ORIGINAL CODE WAS WRITTEN BY K. PEACOCK. (SUBROUINE INTG, 1976)
C
C     INPUTS :
C
C       LF = LENGTH OF RESIDUAL FILTER TO BE CALCULATED
C       WC = EXPONENT IN ROSS SMOOTHING OPERATOR. IF WC EQUALS
C            ZERO, NO ROSS SMOOTHING OPERATOR WILL BE APPLIED.
C
C    OUTPUTS :
C
C        F = THE LF LENGTH RESIDUAL FILTER.
C
C    REQUIRED SUBROUTINES:
C
C        SICI
C
C**********************************************************************
C
      REAL F(1)
C
C     COMPUTES RESIDUAL FILTER
      N = LF/2
      ISTA = N+2
      KFACT = 1-ISTA
      JFACT = LF+1
      PID2 = ASIN(1.)
      DO 20 I=ISTA,LF
          AK = I+KFACT
          CALL SICI(F(I),CON,AK*3.1415927)
          F(I) = (F(I)+PID2)/3.1415927-.5
          J = JFACT-I
          F(J) = -F(I)
20    CONTINUE
      F(ISTA-1) = -.5
C
C     APPLIES ROSS SMOOTHING OPERATOR
      IF(WC.NE.0.) THEN
          DO 30 I=ISTA,LF
              AK = I+KFACT
              F(I) = F(I)*((1.-(AK/N)**2)**WC)
              J = JFACT-I
              F(J) = -F(I)
30        CONTINUE
      ENDIF
      RETURN
      END
