C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine filtsub(utime,tracebuf,buffer,trheader,
     1                   itabin,rtabin,itabout,rtabout,
     2                   initin,initout,lenhed,
     3                   nfcut,nf,lerr,luin,luout,l_stacor,ifmt_StaCor,
     4                   jt0,dt,ishot,nbytes_out,ln_StaCor,
     5                   nt,ntnew,ntnew4,ntcol,ntr,
     6                   urtemp,uitemp,fwgtr,fwgti,
     7                   work,twgt,mutemin,mutemax,cputim,waltim)
C
      real      tracebuf(-lenhed:*) 
      integer   buffer(1:*)
      integer   trheader(lenhed,ntr)
      real      utime(0:ntcol,ntr)
c
      integer   itabin(ntnew+34),itabout(ntnew4+34)
      real      rtabin(3*(ntnew/2)+13),rtabout(3*(ntnew4/2)+13)
      real      work(18*ntr)
      real      urtemp(ntr),uitemp(ntr)
c
      real      twgt (mutemin:mutemax)
      real      cputim(*),waltim(*)
C
      real      fwgtr(0:nf-1),fwgti(0:nf-1)
c
      integer   lerr
C_______________________________________________________________________
      ntm1=nt-1
      ntnew4m1=ntnew4-1
c
      call vclr(utime,1,ntr*(ntcol+1))
      call timstr(v1,w1)
      do 25000 itrace=1,ntr
C_______________________________________________________________________
C      read in the trace.
C_______________________________________________________________________
       nbytes_in=0
       call rtape(luin,tracebuf(-lenhed),nbytes_in)
       if(nbytes_in .le. 0) then
          write(lerr,*) 'read error in routine rdgather'
          write(lerr,*) 'ishot = ',ishot,' itrace = ',itrace
          write(lerr,*) 'shot gather unit number = ',luin
          write(lerr,*) 'number of bytes read in = ',nbytes_in
          stop 2666
       endif
       call vmov(tracebuf(-lenhed),1,trheader(1,itrace),1,lenhed)

       call saver2(buffer,ifmt_StaCor,l_StaCor, ln_StaCor,
     1             istatic, 1)
c      if(buffer(l_stacor) .eq. 30000) then

       if(istatic .eq. 30000) then
          call vclr(utime(0,itrace),1,ntnew)
       else
          do 15000 jt=0,ntm1-jt0
           utime(jt,itrace)=tracebuf(jt+jt0)
15000     continue
          do 16000 jt=ntm1-jt0+1,ntnew-1
           utime(jt,itrace)=0.
16000     continue
C______________________________________________________________________
c         tukey taper at end of time section.
C         reduces artifacts due to truncating the time section.
C______________________________________________________________________
          do 24000 itaper=mutemin,mutemax
           jt=ntm1+itaper
           utime(jt,itrace)=utime(jt,itrace)*(1.-twgt(itaper))
24000     continue
       endif
25000 continue
      call timend(cputim(1),v1,v2,waltim(1),w1,w2)
C***********************************************************************
C     filter:
C     fft each trace (t-->f), given input sampling rate of dt.
C     filter each trace with complex weights (fwgtr,fwgti)
C     zero pad corresponding to output sampling rate of dt/4.
C     inverse fft (f-->t).
C***********************************************************************
      call timstr(v1,w1)
      call mrfft(utime,work,itabin,itabout,rtabin,rtabout,
     1           urtemp,uitemp,fwgtr,fwgti,.true., 
     2           ntnew,ntnew4,ntr,ntcol,initin,initout,
     3           nfcut,lerr)
C
      call timend(cputim(2),v1,v2,waltim(2),w1,w2)
      call timstr(v1,w1)
      do 80000 itrace=1,ntr
       call vmov(trheader(1,itrace),1,tracebuf(-lenhed),1,lenhed)
       call vmov(utime(0,itrace),1,tracebuf(0),1,ntnew4)
       call wrtape(luout,tracebuf,nbytes_out)
80000 continue
      call timend(cputim(3),v1,v2,waltim(3),w1,w2)
C
      return
      end
